
/*
 * GLX Server Extension
 * Copyright (C) 1999 Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * STEVEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


/* What hardware are we running on?
 */
#define SOFTWARE_MODE       0
#define MGA_G200            1
#define MGA_G400            2	
#define NV_RIVATNT          3
#define I_810               4
#define ATI_RAGEPRO         5
#define S3_VIRGE            6
#define SIS_6326            7


/* What X server are we running against?
 */
#define XF_UNKNOWN          0
#define XF_SVGA             1
#define XF_MACH64           2
#define XF_FBDEV            3


extern unsigned int glx_chipset;
extern unsigned int glx_server;



GLboolean (*hwInitVisuals)(VisualPtr *, DepthPtr *, int *, int *, int *, 
			   VisualID *, unsigned long, int);

GLboolean mgaInitGLX(void);
GLboolean i810InitGLX(void);
GLboolean s3virgeInitGLX(void);
GLboolean sis6326InitGLX(void);
GLboolean mach64InitGLX(void);
GLboolean nvInitGLX(void);
GLboolean nvInitVisuals(VisualPtr *, DepthPtr *, int *, int *, int *, 
			VisualID *, unsigned long, int);
