###############################################################################
#
#	glxMesa.spec.in
#
#	SPEC file template to create RPM package of GLX/Mesa with Matrox G200
#	and G400 3-D acceleration and 3DNow! support and Mesa 3.1
#
###############################################################################

# Edit this section to reflect your build environment

%define name		glxMesa
%define glxver 		20000430
%define mesaver 	3.2cvs
%define pkgrel 		1
%define glxdir		glx
%define glxroot		$RPM_BUILD_DIR/glx
%define prefix		/usr/X11R6

###############################################################################
#
#	RPM tags
#
###############################################################################

Name:		%{name}
Summary:	A GLX-based version of the Mesa 3-D graphics library
Version:	%{glxver}
Release:	%{pkgrel}
Copyright:	BSD-like (XFree86)
Group:		X11/Libraries
Requires:	XFree86 >= 3.3.5
BuildRoot:	/var/tmp/%{name}-%{glxver}-%{pkgrel}-root
Source0:	glx-%{glxver}.tar.gz
Source1:	Mesa%{mesaver}-%{glxver}.tar.gz

%description
This is an implementation of the Mesa 3D library and GLX with support
for hardware acceleration. GLX was developed by SGI as an extension to
the X window system to integrate OpenGL rendering functions. 
This allows the Mesa 3D library to perform its 3D rendering functions
within the X server's process, rather than within the X client program.
This offers potential performance benefits, because the rendered image
does not have to be moved from the X client program to the X server.
(Only the commands required to render the image are sent.)
It also makes 3-D hardware acceleration much more practical (and fast).  This
package includes an accelerated driver for Matrox G200 and G400-based cards.

The Mesa 3D graphics library is a powerful and generic toolset for creating
hardware assisted computer graphics.  To the extent that Mesa utilizes the
OpenGL command syntax or state machine, it is being used with authorization
from Silicon Graphics, Inc.  However, the author (Brian Paul) makes no claim
that Mesa is in any way a compatible replacement for OpenGL or associated with
Silicon Graphics, Inc. Those who want a licensed implementation of OpenGL
should contact a licensed vendor.  However, Mesa is very similar to OpenGL, and
you might find Mesa to be a valid alternative to OpenGL.

This package is based on Mesa %{mesaver} and utah glx-%{glxver}.

please see http://glx.on.openprojects.net/ for more information.


###############################################################################
#
#	%prep section
#
#	Unpack the GLX and Mesa sources, putting the Mesa tree in the top-
#	level GLX directory.  Modify the GLX Config file to point to the Mesa
#	sources.
#
###############################################################################

%prep
%setup -q -n %{glxdir} -a 1
###############################################################################
#
#	%build section
#
###############################################################################

%build
if [ -x configure ]; then
        CFLAGS=$RPM_OPT_FLAGS \
        ./configure --prefix=%{prefix} --with-mesa=%{glxroot}/Mesa;
else
        CFLAGS=$RPM_OPT_FLAGS \
        ./autogen.sh --enable-extra --host=i586-pc-linux-gnu --prefix=%{prefix};
fi
make

###############################################################################
#
#	%install section
#
#	This section installs the files.  In order to build this package
#	without interfering with the installed system, we'll install into
#	temporary top-level directory.  This also allows us to dynamically
#	generate the file list.
#
###############################################################################

%install

# Install the files

rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/X11
make prefix=$RPM_BUILD_ROOT/%{prefix} sysconfdir=$RPM_BUILD_ROOT/etc install

# Create the file list

cd $RPM_BUILD_ROOT
# Directories
find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' \
  > $RPM_BUILD_DIR/glxMesa-%{glxver}-%{pkgrel}.files
# Files
find . -type f | grep -v glx.conf | sed 's,^\.,\%attr(-\,root\,root) ,' \
  >> $RPM_BUILD_DIR/glxMesa-%{glxver}-%{pkgrel}.files
# Symbolic links
find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' \
  >> $RPM_BUILD_DIR/glxMesa-%{glxver}-%{pkgrel}.files


###############################################################################
#
#	%files section
#
#	This would normally list all the files in the package.  Since we
#	generated the list dynamically, we'll just point it to the list.
#
###############################################################################

%files -f ../glxMesa-%{glxver}-%{pkgrel}.files
%config /etc/glx.conf

###############################################################################
#
#	%post & %preun sections
#
#	These scripts are executed during installation and removal of the
#	package, respectively.  They will search for the XF86Config file
#	and modify it to add/remove the glx module.
#
###############################################################################

%post
ldconfig
if [ -f /etc/X11/XF86Config ]; then
    XF86CONFIG="/etc/X11/XF86Config"
elif [ -f /etc/XF86Config ]; then
    XF86CONFIG="/etc/XF86Config"
elif [ -f /usr/X11R6/lib/X11/XF86Config ]; then
    XF86CONFIG="/usr/X11R6/lib/X11/XF86Config"
else
    XF86CONFIG="no"
fi

if [ "$XF86CONFIG" != "no" ]; then
    grep 'glx.so' $XF86CONFIG &> /dev/null
    if [ $? -eq 0 ]; then
        exit 0
    fi

    grep 'Section.*Module' $XF86CONFIG &> /dev/null
    if [ $? -eq 0 ]; then
        sed --silent '
:start
/^.*[Ss]ection.*[Mm]odule.*$/ {
	s/^#//
	a \
   Load "glx.so"
:n1
	p
	n
	/^.*[Ee]nd[Ss]ection.*$/ {
		s/^#//
		p
		b next
	}
	b n1
}
p
n
b start
:next
n
p
b next
        ' $XF86CONFIG > $XF86CONFIG.new
        if [ $? -eq 0 ]; then
            mv $XF86CONFIG $XF86CONFIG.old
            mv $XF86CONFIG.new $XF86CONFIG
        else
            rm -f $XF86CONFIG.new
        fi
    else
        (
            echo ''
            echo 'Section "Module"'
            echo '   Load "glx.so"'
            echo 'EndSection'
        ) >> $XF86CONFIG
    fi
else
    echo ''
    echo 'Now you need to edit your XF86Config file'
    echo 'to include the following:'
    echo ''
    echo '     Section "Module"'
    echo '        Load   "glx.so"'
    echo '     EndSection'
    echo ''
    echo '(The "Module" section can include other modules, along with glx.so.)'
    echo ''
fi

%preun
if [ -f /etc/X11/XF86Config ]; then
    XF86CONFIG="/etc/X11/XF86Config"
elif [ -f /etc/XF86Config ]; then
    XF86CONFIG="/etc/XF86Config"
elif [ -f /usr/X11R6/lib/X11/XF86Config ]; then
    XF86CONFIG="/usr/X11R6/lib/X11/XF86Config"
else
    XF86CONFIG="no"
fi

if [ "$XF86CONFIG" != "no" ]; then
    grep -v '^.*oad.*glx.so.*$' $XF86CONFIG > $XF86CONFIG.new
    if [ $? -eq 0 ]; then
        mv -f $XF86CONFIG $XF86CONFIG.old
        mv -f $XF86CONFIG.new $XF86CONFIG
    fi
else
    echo ''
    echo 'You should edit your XF86Config file to remove the `Load "glx.so"`'
    echo 'line from the "Module" section.  (If glx.so is the only module '
    echo 'being loaded, you can safely remove the entire section.)'
    echo ''
fi

%postun
ldconfig

###############################################################################
#
#	Other stuff
#
###############################################################################

%clean
rm -rf $RPM_BUILD_ROOT
rm -f $RPM_BUILD_DIR/glxMesa-%{glxver}-%{pkgrel}.files

%changelog
* Thu Dec  2 1999 Tarjei Skorgenes <tarjei.skorgenes@online.no>
- Modified %preun and %post to edit XF86Config automatically
- Added --sysconfdir=/etc to %build section
- Removed configur./autogen.sh --enable-extra --host=i586-pc-linux-gnu from %setup section
- Added ldconfig to %post
- Added %postun

* Wed Dec  1 1999 Ralph Giles <giles@ashlu.bc.ca>
- backported .spec.in from Ryan Drake's 19991123-1.src.rpm .spec
- fixed copyright (BSD-style not GPL)
- added %{name} %{prefix} variables
- try running configure if available to deal with release tarballs 
- updated the description some

* Sat Oct 23 1999 Ryan Drake <rdrake@matrox.com>
- Removed --without-mmx-asm

* Thu Jun 17 1999 Ryan Skadberg <skadz@mindstorm.com>
- Updated to Mesa3.1beta2
- Used configure script, so we get 3DNow support if available

* Mon May 31 1999 Ian Pilcher <pilcher@concentric.net>
- Added %post & %preun scripts, telling the user to edit XF86Config

* Mon May 24 1999 Ian Pilcher <pilcher@concentric.net>
- Created SPEC file template for scripted builds

* Mon May 24 1999 Ian Pilcher <pilcher@concentric.net>
- XFree86 headers now included in GLX tree; useful SRPM now possible
- package release no longer reflects Red Hat version

* Wed May 19 1999 Ian Pilcher <pilcher@concentric.net>
- fixed problem of sed reading & writing Config simultaneously

* Tue May 18 1999 Ian Pilcher <pilcher@concentric.net>
- initial SPEC file; doesn't do anything fancy

