
/*
 * GLX Server Extension
 * Copyright (C) 1998, 1999 Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __glx_log
#define __glx_log

#include <GL/gl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* various levels of logging */

#define LOG_ALWAYS 0
#define LOG_TRACE  1
#define LOG_ARGS   2
#define LOG_DATA   3

#ifdef GLX_LOG

extern GLint logging;

int glx_set_log_file(char *new_log);
void glx_log_initialize();
void glx_log_finish();
void glx_log_flush();
int glx_clear_log();
void glx_log_op_request(int op);
void glx_log_glx_request(int op);
void glx_log_print(const char *s, ...);
void glx_log_enum(GLenum the_enum);
void glx_log_mask(GLenum mask);

#define set_log_file(log)       glx_set_log_file(log)
#define log_initialize()	glx_log_initialize()
#define log_finish()		glx_log_finish()
#define log_flush()		glx_log_flush()
#define clear_log()             glx_clear_log()
#define log_op_request(op)      if (logging) glx_log_op_request(op)
#define log_glx_request(op)     if (logging) glx_log_glx_request(op)
#define log_print(log, s, a...) if (log <= logging) glx_log_print(s, ## a) 
#define log_enum(enum)          if (logging) glx_log_enum(enum)
#define log_mask(mask)          if (logging) glx_log_mask(mask)

#else    /** #ifdef GLX_LOG **/

#define set_log_file(log) 	0
#define log_initialize()
#define log_finish()
#define log_flush()
#define log_off()
#define clear_log()      
#define log_op_request(op) 
#define log_glx_request(op) 
#define log_print(log, s, a...)
#define log_enum(enum)     
#define log_mask(mask)

#endif   /** #ifdef GLX_LOG **/ 

#endif
