/*
 * GLX Hardware Device Driver for SiS 6326
 * Copyright (C) 1999 Jim Duchek
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *    Jim Duchek <jim@linuxpimps.com>
 */

#ifndef __SIS6326_REGS_H__
#define __SIS6326_REGS_H__

#define INREG( addr )		*((volatile CARD32 *)(sis6326glx.MMIOBase + (addr)))

//#define OUTREG( addr, val ) *((volatile CARD32 *)(sis6326glx.MMIOBase + (addr))) = (val)

#define OUTREG( addr, val ) \
	do { \
		*((volatile CARD32 *)(sis6326glx.MMIOBase + (addr))) = (val); \
		sis6326glx.c_numCmds++; \
	} while (0)

#define OUTREGW( addr, val )	*((volatile CARD16 *)(sis6326glx.MMIOBase + (addr))) = (val)
#define OUTREGB( addr, val )	*((volatile CARD8 *)(sis6326glx.MMIOBase + (addr))) = (val)

#define WAITFIFOEMPTY( num )  \
	do { \
		int time = 0; \
		int n2 = num << 3; \
		while( (INREG(SIS6326_TRI_FIRE) >> 16) < n2 ) { \
			time++;	\
			if (time > 0xFFFFF) { \
				hwMsg(0, "WAITFIFO timeout.\n"); \
				break; \
			} \
		} \
	} while (0)
			

		
#define SIS6326_BITBLT_SRC_ADDR		0x8280
#define SIS6326_BITBLT_DST_ADDR		0x8284
#define SIS6326_BITBLT_DST_SRC_PITCH	0x8288
#define SIS6326_BITBLT_HEIGHT_WIDTH	0x828C
#define SIS6326_BITBLT_FG_COLOR		0x8290
#define SIS6326_BITBLT_BG_COLOR		0x8294
#define SIS6326_BITBLT_MASK_3_0		0x8298
#define SIS6326_BITBLT_MASK_7_4		0x829C
#define SIS6326_BITBLT_T_L_CLIP		0x82A0
#define SIS6326_BITBLT_B_R_CLIP		0x82A4
#define SIS6326_BITBLT_CMD		0x82AA
#define SIS6326_PATTERN			0x82AC


#define SIS6326_TRI_FIRST		0x8800
#define SIS6326_TRI_DIFF		0x0020
#define SIS6326_TRI_TSFS		0x0000
#define SIS6326_TRI_TSZ			0x0004
#define SIS6326_TRI_TSX			0x0008
#define SIS6326_TRI_TSY			0x000C
#define SIS6326_TRI_TSARGB		0x0010
#define SIS6326_TRI_TSU			0x0014
#define SIS6326_TRI_TSV			0x0018
#define SIS6326_TRI_TSW			0x001C

#define SIS6326_TRI_PRIMSET		0x89F8
#define SIS6326_TRI_FIRE		0x89FC
#define SIS6326_TRI_ENABLEREG		0x8A00
#define SIS6326_TRI_ZSETTING		0x8A04
#define SIS6326_TRI_ZBASE		0x8A08
#define SIS6326_TRI_ASETTING		0x8A0C
#define SIS6326_TRI_ABASE		0x8A10
#define SIS6326_TRI_DSETTING		0x8A14
#define SIS6326_TRI_DBASE		0x8A18
#define SIS6326_TRI_LINESETTING		0x8A1C
#define SIS6326_TRI_FOGSETTING		0x8A20
#define SIS6326_TRI_MISCSETTING1	0x8A24
#define SIS6326_TRI_MISCSETTING2	0x8A28
#define SIS6326_TRI_MISCSETTING3	0x8A2C
#define SIS6326_TRI_CLIP_T_B		0x8A30
#define SIS6326_TRI_CLIP_L_R		0x8A34
#define SIS6326_TRI_TEXSETTING1		0x8A38
#define SIS6326_TRI_TEXSETTING2		0x8A3C
#define SIS6326_TRI_TEXSETTING3		0x8A40
#define SIS6326_TRI_TEXBASE0		0x8A44
#define SIS6326_TRI_TEXBASE1		0x8A48
#define SIS6326_TRI_TEXBASE2		0x8A4C
#define SIS6326_TRI_TEXBASE3		0x8A50
#define SIS6326_TRI_TEXBASE4		0x8A54
#define SIS6326_TRI_TEXBASE5		0x8A58
#define SIS6326_TRI_TEXBASE6		0x8A5C
#define SIS6326_TRI_TEXBASE7		0x8A60
#define SIS6326_TRI_TEXBASE8		0x8A64
#define SIS6326_TRI_TEXBASE9		0x8A68
#define SIS6326_TRI_TEXPITCH_0_1	0x8A6C
#define SIS6326_TRI_TEXPITCH_2_3	0x8A70
#define SIS6326_TRI_TEXPITCH_4_5	0x8A74
#define SIS6326_TRI_TEXPITCH_6_7	0x8A78
#define SIS6326_TRI_TEXPITCH_8_9	0x8A7C
#define SIS6326_TRI_TEX_W_H		0x8A80
#define SIS6326_TRI_TEX_BORDER_COLOR	0x8A90
#define SIS6326_TRI_TEND		0x8AFF

#define S_PRIM_SHADEMODE_FLATTOP	0x00040000
#define S_PRIM_SHADEMODE_FLATMID	0x00080000
#define S_PRIM_SHADEMODE_FLATBOT	0x000C0000
#define S_PRIM_SHADEMODE_GOURAUD	0x00100000
#define S_PRIM_ATOP			0x00000000
#define S_PRIM_BTOP			0x00010000
#define S_PRIM_CTOP			0x00020000
#define S_PRIM_AMID			0x00000000
#define S_PRIM_BMID			0x00004000
#define S_PRIM_CMID			0x00008000
#define S_PRIM_ABOT			0x00000000
#define S_PRIM_BBOT			0x00001000
#define S_PRIM_CBOT			0x00002000
#define S_PRIM_FIRE_FIRE		0x00000000
#define S_PRIM_FIRE_ARGBA		0x00000100
#define S_PRIM_FIRE_WA			0x00000200
#define S_PRIM_FIRE_ARGBB		0x00000300
#define S_PRIM_FIRE_WB			0x00000400
#define S_PRIM_FIRE_ARGBC		0x00000500
#define S_PRIM_FIRE_WC			0x00000600
#define S_PRIM_FIRE_VC			0x00000700
#define S_PRIM_TRI			0x00000002
#define S_PRIM_LINE			0x00000001
#define S_PRIM_POINT			0x00000000


#define S_ENABLE_ZWRITE			0x00200000
#define S_ENABLE_ZTEST			0x00100000
#define S_ENABLE_AWRITE			0x00040000
#define S_ENABLE_ATEST			0x00020000
#define S_ENABLE_ABUF			0x00010000
#define S_ENABLE_STIPPLE		0x00004000
#define S_ENABLE_STIP_ALPHA		0x00002000
#define S_ENABLE_LINEPAT		0x00001000
#define S_ENABLE_PRIMSET		0x00000800
#define S_ENABLE_TEXMAP			0x00000400
#define S_ENABLE_TEXPERSP		0x00000200
#define S_ENABLE_TEXTRANSP		0x00000100
#define S_ENABLE_TEXCACHE		0x00000080
#define S_ENABLE_LARGECACHE		0x00000020
#define S_ENABLE_SPECULAR		0x00000010
#define S_ENABLE_FOG			0x00000008
#define S_ENABLE_BLENDING		0x00000004
#define S_ENABLE_TRANSP			0x00000002
#define S_ENABLE_DITHER			0x00000001

#define S_ZSET_FORMAT_8			0x00000000
#define S_ZSET_FORMAT_16		0x00100000
#define S_ZSET_PASS_NEVER		0x00000000
#define S_ZSET_PASS_NLD			0x00010000
#define S_ZSET_PASS_NED			0x00020000
#define S_ZSET_PASS_NLED		0x00030000
#define S_ZSET_PASS_NGD			0x00040000
#define S_ZSET_PASS_NNED		0x00050000
#define S_ZSET_PASS_NGED		0x00060000
#define S_ZSET_PASS_ALWAYS		0x00070000


#define S_ASET_FORMAT_8			0x30000000
#define S_ASET_PASS_NEVER		0x00000000
#define S_ASET_PASS_NLD			0x01000000
#define S_ASET_PASS_NED			0x02000000
#define S_ASET_PASS_NLED		0x03000000
#define S_ASET_PASS_NGD			0x04000000
#define S_ASET_PASS_NNED		0x05000000
#define S_ASET_PASS_NGED		0x06000000
#define S_ASET_PASS_ALWAYS		0x07000000

#define S_DSET_ROP_NOP			0x0A000000
#define S_DSET_ROP_COPY_PEN		0x0C000000
#define S_DSET_ROP_WHITE		0x0F000000
#define S_DSET_16BPP			0x00100000
#define S_DSET_24BPP			0x00200000
#define S_DSET_32BPP			0x00300000
#define S_DSET_16_555			0x00000000
#define S_DSET_16_565			0x00010000
#define S_DSET_16_1555			0x00020000
#define S_DSET_16_4444			0x00030000
#define S_DSET_32_1888			0x00000000
#define S_DSET_32_2888			0x00010000
#define S_DSET_32_4888			0x00020000
#define S_DSET_32_8888			0x00030000
#define S_DSET_32_0888			0x00040000

#define S_MISC2_DBLEND_ZERO		0x00000000
#define S_MISC2_DBLEND_ONE		0x10000000
#define S_MISC2_DBLEND_SRC_COLOR	0x20000000
#define S_MISC2_DBLEND_INV_SRC_COLOR	0x30000000
#define S_MISC2_DBLEND_SRC_ALPHA	0x40000000
#define S_MISC2_DBLEND_INV_SRC_ALPHA	0x50000000
#define S_MISC2_DBLEND_DST_ALPHA	0x60000000
#define S_MISC2_DBLEND_INV_DST_ALPHA	0x70000000

#define S_MISC2_SBLEND_ZERO			0x00000000
#define S_MISC2_SBLEND_ONE			0x01000000
#define S_MISC2_SBLEND_SRC_ALPHA		0x04000000
#define S_MISC2_SBLEND_INV_SRC_ALPHA		0x05000000
#define S_MISC2_SBLEND_DST_ALPHA		0x06000000
#define S_MISC2_SBLEND_INV_DST_ALPHA		0x07000000
#define S_MISC2_SBLEND_DST_COLOR		0x08000000
#define S_MISC2_SBLEND_INV_DST_COLOR		0x09000000
#define S_MISC2_SBLEND_SRC_ALPHA_SAT		0x0A000000
#define S_MISC2_SBLEND_BOTH_SRC_ALPHA		0x0B000000
#define S_MISC2_SBLEND_BOTH_INV_SRC_ALPHA	0x0C000000


#define S_TSET1_FORMAT_LUM		0x30000000
#define S_TSET1_FORMAT_16		0x50000000
#define S_TSET1_FORMAT_24		0x60000000
#define S_TSET1_FORMAT_32		0x70000000

#define S_TSET1_LUM_L1			0x00000000
#define S_TSET1_LUM_L2			0x01000000
#define S_TSET1_LUM_L4			0x02000000
#define S_TSET1_LUM_L8			0x03000000
#define S_TSET1_LUM_AL22		0x05000000
#define S_TSET1_LUM_AL44		0x08000000
#define S_TSET1_LUM_AL88		0x0C000000


#define S_TSET1_16_RGB555			0x00000000
#define S_TSET1_16_RGB565			0x01000000
#define S_TSET1_16_ARGB1555			0x02000000
#define S_TSET1_16_ARGB4444			0x03000000
#define S_TSET1_16_ARGB8332			0x07000000
#define S_TSET1_16_ARGB8233			0x0B000000
#define S_TSET1_16_ARGB8232			0x0F000000

#define S_TSET1_TEX_SYSMEM			0x00000020
#define S_TSET1_TEX_CLRCACHE			0x00000010
#define S_TSET1_TEX_MAG_NEAREST			0x00000000
#define S_TSET1_TEX_MAG_LINEAR			0x00000008
#define S_TSET1_TEX_MIN_NEAREST			0x00000000
#define S_TSET1_TEX_MIN_LINEAR			0x00000001
#define S_TSET1_TEX_MIN_NEAREST_MIP_NEAREST	0x00000002
#define S_TSET1_TEX_MIN_NEAREST_MIP_LINEAR	0x00000003
#define S_TSET1_TEX_MIN_LINEAR_MIP_NEAREST	0x00000004
#define S_TSET1_TEX_MIN_LINEAR_MIP_LINEAR	0x00000005
#define S_TSET1_WRAP_U				0x00010000
#define S_TSET1_WRAP_V				0x00020000
#define S_TSET1_MIRROR_U			0x00040000
#define S_TSET1_MIRROR_V			0x00080000
#define S_TSET1_CLAMP_U				0x00100000
#define S_TSET1_CLAMP_V				0x00200000
#define S_TSET1_USE_CTB				0x00800000

#define S_TSET2_REPLACE				0x00000000
#define S_TSET2_BLEND				0x00000000
#define S_TSET2_NOTEX				0x04000000
#define S_TSET2_MODULATE			0x08000000
#define S_TSET2_DECAL				0x10000000
#define S_TSET2_ATEX				0x00000000
#define S_TSET2_APIX				0x01000000
#define S_TSET2_ATEXPIX				0x02000000


	
	

#endif /* __SIS6326_REGS_H__ */

