 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-1999 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-1999 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/

#ifndef MESA31
#error "The nv driver now requires Mesa 3.1 or higher"
#endif

/*
 * RIVA includes from X server.
 */
#include "riva_hw.h"
/*
 * Buffers.
 */
#define RIVA_FRONT_BUFFER       0
#define RIVA_BACK_BUFFER        1
#define RIVA_DEPTH_BUFFER       2
#define RIVA_TEXTURE_BUFFER     3
#define RIVA_CACHE_BUFFER       4
/*
 * !!! This is the same variable !!!
 */
#define rivaReload3D    GLXSYM(rivaRendered2D)
/*
 * Sync get/put pixel with HW.
 */
extern int rivaSyncPix;
/*
 * RIVA GLX enabled flag.
 */
extern int rivaGLXEnabled;
/*
 * Structures defining the texture buffer heap.
 */
typedef struct riva_tex_block
{
    struct   gl_texture_object *Owner;
    unsigned Priority;
    unsigned Format;
    unsigned maxLevel;
    unsigned baseWidthLog2;
    unsigned baseHeightLog2;
    float    sAdjust;
    float    tAdjust;
    int      Index;
    int      Size;
    int      Next;
    int      Prev;
    int      NextLRU;
    int      PrevLRU;
} RIVA_TEX_BLOCK;
typedef struct riva_tex_heap
{
    int             Total;
    int             Free;
    int             FreeBlocks;
    int             Head;
    int             Tail;
    int             HeadLRU;
    int             TailLRU;
    unsigned        DefaultOffset;
    unsigned        DefaultAAOffset;
    RIVA_TEX_BLOCK *Blocks;
} RIVA_TEX_HEAP;
extern RIVA_TEX_HEAP rivaTexHeap;
#define NULL_INDEX  0
/*
 * Current 3D state context.
 */
typedef struct riva_tri03_ctx
{
    unsigned                  texFormat;
    unsigned                  texFilter;
    unsigned                  triControl;
    unsigned                  triControlPass2;
    unsigned                  triFogColor;
    unsigned                  triAlphaTest;
} RIVA_TRI03_CTX;
typedef struct riva_tri05_ctx
{
    unsigned                  texColorKey;
    unsigned                  texFormat;
    unsigned                  texFilter;
    unsigned                  triBlend;
    unsigned                  triControl;
    unsigned                  triFogColor;
} RIVA_TRI05_CTX;
typedef struct riva_3d_ctx
{
    struct gl_texture_object *texObj;
    unsigned                  texOffset;
    union
    {
        RIVA_TRI03_CTX        tri03;
        RIVA_TRI05_CTX        tri05;
    } triContext;
    unsigned                  modeMask;
    float                     sAdjust;
    float                     tAdjust;
    int                       bufRender;
    unsigned short            VCache[16];
    int                       NumCtxs;
    int                       SimpleClip;
    float                     xyAdjust;
    unsigned                  BugFix;
    float                     InvWScale;
} RIVA_3D_CTX;
extern RIVA_3D_CTX rivaContext;
#define RIVA_VCACHE_MASK        0x07
#define NV4_Z_ENABLE_BUG        0x00000001
#define NV4_ALPHATEST_BUG       0x00000002
/*
 * Texture alignment/block sizes.
 */
#define RIVA_TEX_ALIGN          256
#define RIVA_TEX_BLOCK_SIZE     8192
#define RIVA_TEX_BLOCK_OFFSET(b)    (GLXSYM(rivaBufferOffset)[RIVA_TEXTURE_BUFFER] + (b)*RIVA_TEX_BLOCK_SIZE)
#define RIVA_TEX_BLOCK_ADDRESS(b)   ((char *)(GLXSYM(vgaLinearBase) + RIVA_TEX_BLOCK_OFFSET(b)))
/*
 * Priorities.
 */
#define TEX_MAX_PRIORITY    0x3F800000
#define TEX_MIN_PRIORITY    0x00000000
/*
 * Texel copy/conversion.
 */
#define TEX_FIX_SCALE           16
/*
 * Some cool macros for use during texture swizzling.
 */
#define RIVA_U_INC(uu)          (((uu) + 0xAAAAAAAB) & 0x55555555)
#define RIVA_U_INC2(uu)         (((uu) + 0xAAAAAAAC) & 0x55555555)
#define RIVA_V_INC(vv)          (((vv) + 0x55555556) & 0xAAAAAAAA)
#define RIVA_UV_OFFSET(vv,uu)   ((vv)|(uu))
/*
 * More cool texture swizzling macros for non-square texture support.
 */
#define RIVA_U_INC_MASK(i, m, lh)                           \
{                                                           \
    m = ((1 << (2 * lh)) - 1);                              \
    i = (0xAAAAAAAA & m) + 1;                               \
    m = (0x55555555 & m) | (~m);                            \
}
#define RIVA_U_INC2_MASK(i1, i2, m, lh)                     \
{                                                           \
    m = ((1 << (2 * lh)) - 1);                              \
    i1 = (0xAAAAAAAA & m) + 1;                              \
    i2 = (0xAAAAAAAA & m) + 2;                              \
    m = (0x55555555 & m) | (~m);                            \
}
#define RIVA_V_INC_MASK(i, m, lw)                           \
{                                                           \
    m = ((1 << (2 * lw)) - 1);                              \
    i = (0x55555555 & m) + 1;                               \
    m = (0xAAAAAAAA & m) | (~m);                            \
}
#define RIVA_UV_INC(uv,i,m)     (((uv) + i) & m)
/*
 * HW macros.
 */
#define RIVA_CLIP3D(xx1, yy1, xx2, yy2)                                             \
{                                                                                   \
rivaReload3D=1;                                                                     \
RIVA_FIFO_FREE(GLXSYM(riva),Clip,2);                                                        \
GLXSYM(riva).Clip->TopLeft     = ((yy1)     << 16) | (xx1);                                 \
GLXSYM(riva).Clip->WidthHeight = ((yy2-yy1) << 16) | (xx2-xx1);                            \
}
#define RIVA_STATE3D_03(t0, t1, t2, fc, cc, at)                                     \
{                                                                                   \
RIVA_FIFO_FREE(GLXSYM(riva),Tri03,6);                                                       \
GLXSYM(riva).Tri03->TextureOffset = t0;                                                     \
GLXSYM(riva).Tri03->TextureFormat = t1;                                                     \
GLXSYM(riva).Tri03->TextureFilter = t2;                                                     \
GLXSYM(riva).Tri03->FogColor      = fc;                                                     \
GLXSYM(riva).Tri03->Control       = cc;                                                     \
GLXSYM(riva).Tri03->AlphaTest     = at;                                                     \
if (rivaContext.BugFix & NV4_Z_ENABLE_BUG)                                          \
{                                                                                   \
    RivaSync();                                                                         \
    GLXSYM(riva).PGRAPH[0x00000818/4] |= 0x00004000;                                        \
}                                                                                   \
}
#define DEPTH_UNSCALE   (1.0F/(float)DEPTH_SCALE)
#define RIVA_VERTEX3D_03(fi, argb, xx, yy, zz, mm, ss, tt)                          \
{                                                                                   \
RIVA_FIFO_FREE(GLXSYM(riva),Tri03,8);                                                       \
GLXSYM(riva).Tri03->FogAndIndex = fi;                                                       \
GLXSYM(riva).Tri03->Color       = argb;                                                     \
GLXSYM(riva).Tri03->ScreenX     = xx;                                                       \
GLXSYM(riva).Tri03->ScreenY     = yy;                                                       \
GLXSYM(riva).Tri03->ScreenZ     = (zz)*DEPTH_UNSCALE;                                       \
GLXSYM(riva).Tri03->EyeM        = mm;                                                       \
GLXSYM(riva).Tri03->TextureS    = (ss) - rivaContext.sAdjust;                               \
GLXSYM(riva).Tri03->TextureT    = (tt) - rivaContext.tAdjust;                               \
}
#define RIVA_STATE3D_05(ck, t0, t1, t2, bb, cc, fc)                                 \
{                                                                                   \
RIVA_FIFO_FREE(GLXSYM(riva),Tri05,7);                                                       \
/*ErrorF("cc = %d, t0 = %d, t1 = %d, t2 = %d\n", cc, t0, t1, t2);*/ \
GLXSYM(riva).Tri05->ColorKey      = ck;                                                     \
GLXSYM(riva).Tri05->TextureOffset = t0;                                                     \
GLXSYM(riva).Tri05->TextureFormat = t1;                                                     \
GLXSYM(riva).Tri05->TextureFilter = t2;                                                     \
GLXSYM(riva).Tri05->Blend         = bb;                                                     \
GLXSYM(riva).Tri05->Control       = cc;                                                     \
GLXSYM(riva).Tri05->FogColor      = fc;                                                     \
}
#define RIVA_VERTEX3D_05(ii, xx, yy, zz, mm, argb, spec, ss, tt)                    \
{                                                                                   \
RIVA_FIFO_FREE(GLXSYM(riva),Tri05,8);                                                       \
/*ErrorF("vertex3d, ii = %d, xx = %g, yy = %g, zz = %g\n", ii, xx, yy, (zz)*DEPTH_UNSCALE);*/ \
GLXSYM(riva).Tri05->Vertex[ii].ScreenX  = xx;                                               \
GLXSYM(riva).Tri05->Vertex[ii].ScreenY  = yy;                                               \
GLXSYM(riva).Tri05->Vertex[ii].ScreenZ  = (zz)*DEPTH_UNSCALE;                               \
GLXSYM(riva).Tri05->Vertex[ii].EyeM     = mm;                                               \
GLXSYM(riva).Tri05->Vertex[ii].Color    = argb;                                             \
GLXSYM(riva).Tri05->Vertex[ii].Specular = spec;                                             \
GLXSYM(riva).Tri05->Vertex[ii].TextureS = ss;                                               \
GLXSYM(riva).Tri05->Vertex[ii].TextureT = tt;                                               \
}
#define RIVA_DRAWTRI3D_05(v0, v1, v2)                                               \
{                                                                                   \
RIVA_FIFO_FREE(GLXSYM(riva),Tri05,1);                                                       \
/*ErrorF("drawtri3d, v2 = %d, v1 = %d, v0 = %d\n", v2, v1, v0);*/ \
GLXSYM(riva).Tri05->DrawTriangle3D = (((v2)<<8)|((v1)<<4)|(v0));                            \
}
/*
 * Get 1.0/W out of win coordinatea.
 */
#define INV_W(vv)   VB->Win.data[vv][3] * rivaContext.InvWScale
/*
 * Fast float->int conversions.
 */
#define RivaFloatToInt(intbits, fp)                                                 \
{                                                                                   \
    GLfloat fpbits  = fp + 8388608.0F;                                              \
    intbits = (*(GLint *)&fpbits & 0x80000000)                                      \
            ? -(*(GLint *)&fpbits & 0x007FFFFF) : *(GLint *)&fpbits & 0x007FFFFF;   \
}
#define RivaFloatToUInt(intbits, fp)                                                \
{                                                                                   \
    GLfloat fpbits  = fp + 8388608.0F;                                              \
    intbits = *(GLint *)&fpbits & 0x007FFFFF;                                       \
}
/*
 * Link for hooking accelerated funcitons.
 */
void      RivaPointsNOP(GLcontext *, GLuint, GLuint);
void      RivaPoints3D03(GLcontext *, GLuint, GLuint);
void      RivaAAPoints3D03(GLcontext *, GLuint, GLuint);
void      Riva2PassPoints3D03(GLcontext *, GLuint, GLuint);
void      RivaPoints3D05(GLcontext *, GLuint, GLuint);
void      RivaAAPoints3D05(GLcontext *, GLuint, GLuint);
void      RivaLineNOP(GLcontext *, GLuint, GLuint, GLuint);
void      RivaLine3D03(GLcontext *, GLuint, GLuint, GLuint);
void      RivaAALine3D03(GLcontext *, GLuint, GLuint, GLuint);
void      Riva2PassLine3D03(GLcontext *, GLuint, GLuint, GLuint);
void      RivaLine3D05(GLcontext *, GLuint, GLuint, GLuint);
void      RivaAALine3D05(GLcontext *, GLuint, GLuint, GLuint);
void      RivaTriangleNOP(GLcontext *, GLuint, GLuint, GLuint, GLuint);
void      RivaTriangle3D03(GLcontext *, GLuint, GLuint, GLuint, GLuint);
void      Riva2PassTriangle3D03(GLcontext *, GLuint, GLuint, GLuint, GLuint);
void      RivaTriangle3D05(GLcontext *, GLuint, GLuint, GLuint, GLuint);
GLboolean RivaRenderVB(GLcontext *, GLboolean);
void      RivaUpdateState03(GLcontext *ctx);
void      RivaUpdateState05(GLcontext *ctx);
void      RivaReleaseTextures(void);
int       RivaInitTextureHeap(void);
void      RivaTexImage(GLcontext *,GLenum,struct gl_texture_object *,GLint,GLint,const struct gl_texture_image *);
void      RivaTexSubImage(GLcontext *,GLenum,struct gl_texture_object *,GLint,GLint,GLint,GLint,GLint,GLint,const struct gl_texture_image *);
void      RivaDeleteTexture(GLcontext *, struct gl_texture_object *);
void      RivaBindTexture(GLcontext *, GLenum, struct gl_texture_object *);
void      RivaSwapBuffers(XSMesaBuffer);
void      RivaSync();
GLboolean nvInitGLX(void);
GLboolean nvInitVisuals(VisualPtr *, DepthPtr *, int *, int *, int *, VisualID *, unsigned long, int);

