 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-1999 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-1999 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/

#include <stdlib.h>

/*
 * X includes.
 */
#include "X.h"
#include "Xproto.h"
#include "windowstr.h"
#include "servermd.h"
/*
 * Mesa includes.
 */
#include "context.h"
#include "depth.h"
#include "macros.h"
#include "texstate.h"
#include "triangle.h"
#include "vb.h"
#include "types.h"
/*
 * GLX includes.
 */
#include "glxvisual.h"
#include "xsmesaP.h"
#include "glx_log.h"
#include "glx_symbols.h"
#include "mesaglx/context.h"
#include "mesaglx/macros.h"
#include "mesaglx/matrix.h"
#include "mesaglx/types.h"
/*
 * Riva includes.
 */
#include "riva_glx.h"

/*
 * Current X/Mesa context pointer:
 */
extern XSMesaContext XSMesa;
/*
 * Hooks for mode switch.
 */
void * (*prevSaveFunc)(void *);
void   (*prevRestoreFunc)(void *);
/*
 * Special value to make buffer pointer checks happy.
 */
#define RIVA_MAGIC_NUM  0x69696969
/*
 * RIVA GLX enabled flag.
 */
int rivaGLXEnabled;
/*
 * Busy loop to synchronise with graphics engine. Don't return until the
 * engine is idle. Implements a timeout to avoid server lockups.
 */
void RivaSync(void)
{
    static int cnt;
    int i;

    for (i = 0; i < 0x100000; i++) {
        if (GLXSYM(riva).Busy(&GLXSYM(riva)) == 0) {
            cnt = 0;
            return;
        }
    }
    ErrorF("sync timeout, this has happened %d time(s) now\n", ++cnt);
}
/*
 * Create a new XSMesaContext.
 * Input:  v - XSMesaVisual
 *         share_list - another XSMesaContext with which to share display
 *                      lists or NULL if no sharing is wanted.
 * Return:  an XSMesaContext or NULL if error.
 */
static XSMesaContext RivaCreateContext
(
    XSMesaVisual  v,
    XSMesaContext share_list
)
{
    XSMesaContext c;

    ErrorF ( "### Creating new xsmesa context for Riva...\n" );
    if (!(c = (XSMesaContext) calloc( 1, sizeof(struct xsmesa_context))))
        return (NULL);
    if (!(c->gl_ctx = gl_create_context(v->gl_visual,
                                  share_list ? share_list->gl_ctx : NULL,
                                  (void *) c,
                                  GL_TRUE /* direct rendering */)))
    {
        free(c);
        return(NULL);
    }
    c->xsm_visual                    = v;
    c->xsm_buffer                    = NULL;            /* Set later by XSMesaMakeCurrent  */
    c->pixelformat                   = v->dithered_pf;  /* Dithering is enabled by default */
    rivaContext.NumCtxs++;
/*    RivaUpdateState03(c->gl_ctx);*/
    return(c);
}
static void RivaDestroyContext
(
    XSMesaContext c
)
{
    struct gl_texture_object *tObj;

    if (c == XSMesa) XSMesa = NULL;
    if (c->gl_ctx)
    {
        /*
         * Make sure all this contexts textures are deleted before freeing them up.
         */
        if (c->gl_ctx->Shared)
        {
            for (tObj = c->gl_ctx->Shared->TexObjectList; tObj; tObj = tObj->Next)
                RivaDeleteTexture(c->gl_ctx, tObj);
        }
        gl_destroy_context(c->gl_ctx);
    }
    rivaContext.NumCtxs--;
    free(c);
}
static GLboolean RivaMakeCurrent
(
    XSMesaContext c
)
{
    if (c == XSMesa) return (GL_TRUE);
    XSMesa = c;
    if (c)
        gl_make_current(c->gl_ctx, c->xsm_buffer ? c->xsm_buffer->gl_buffer : NULL);
    else
        gl_make_current(NULL, NULL);
    return(GL_TRUE);
}
/*
 * Bind buffer b to context c and make c the current rendering context.
 */
static GLboolean RivaBindBuffer
(
    XSMesaContext c,
    XSMesaBuffer  b
)
{
    if ((!c && b) || (c && !b))
    {
        return (GL_FALSE);
    }
    else if (c)
    {

        if ((c             == XSMesa)
         && (c->xsm_buffer == b)
         && (c->xsm_buffer->wasCurrent))
            /*
             * Same context and buffer, do nothing.
             */
            return(GL_TRUE);
        c->xsm_buffer = b;
        /*
         * Get XSMesa hooks for buffer access.
         */
        xsmesa_setup_DD_pointers(c->gl_ctx);
        if (!b->pixmap_flag)
        {
            /*
             * Only hook accelerated HW for non-pixmap buffers.
             */
            if (GLXSYM(riva).Architecture == NV_ARCH_03)
                RivaUpdateState03(c->gl_ctx);
            else
                RivaUpdateState05(c->gl_ctx);
        }
        /*
         * Make current and bind Mesa context and buffer.
         */
        gl_make_current(c->gl_ctx, c->xsm_buffer->gl_buffer);
        XSMesa = c;
        if (c->gl_ctx->Viewport.Width==0)
        {
            /*
             * Initialize viewport to window size.
             */
            gl_Viewport( c->gl_ctx, 0, 0, b->width, b->height );
            c->gl_ctx->Scissor.Width  = b->width;
            c->gl_ctx->Scissor.Height = b->height;
        }
        if (c->xsm_visual->gl_visual->RGBAflag)
        {
            /*
             * Must recompute and set these pixel values because colormap
             * can be different for different windows.
             */
            XID value;
            c->pixel = xsmesa_color_to_pixel( c, c->red, c->green, c->blue, c->alpha );
            value = (XID)c->pixel;
            DoChangeGC(c->xsm_buffer->gc1, GCForeground, &value, 0);
            c->clearpixel = xsmesa_color_to_pixel(c,
                                                  c->clearcolor[0],
                                                  c->clearcolor[1],
                                                  c->clearcolor[2],
                                                  c->clearcolor[3]);
            value = (XID)c->clearpixel;
            DoChangeGC(c->xsm_buffer->cleargc, GCForeground, &value, 0);
        }
        /*
         * Solution to Stephane Rehel's problem with glXReleaseBuffersMESA().
         */
        c->xsm_buffer->wasCurrent = GL_TRUE;
    }
    else 
    {
        XSMesa        = NULL;
        gl_make_current(NULL, NULL);
    }
    return(GL_TRUE);
}
/*
 * Return a pointer to the XSMesa backbuffer Pixmap or XImage.  This function
 * is a way to get "under the hood" of X/Mesa so one can manipulate the
 * back buffer directly.
 * Output:  pixmap - pointer to back buffer's Pixmap, or 0
 *          ximage - pointer to back buffer's XImage, or NULL
 * Return:  GL_TRUE = context is double buffered
 *          GL_FALSE = context is single buffered
 */
static GLboolean RivaGetBackBuffer
(
    XSMesaBuffer b,
    PixmapPtr   *pixmap,
    XImage     **ximage
)
{
    if (b->db_state)
    {
        if (pixmap)  *pixmap = b->backpixmap;
        if (ximage)  *ximage = (XImage *)b->backimage;
        return(GL_TRUE);
    }
    else
    {
        *pixmap = 0;
        *ximage = NULL;
        return(GL_FALSE);
    }
}
/*
 * Return the depth buffer associated with an XSMesaBuffer.
 * Input:  b - the XSMesa buffer handle
 * Output:  width, height - size of buffer in pixels
 *          bytesPerValue - bytes per depth value (2 or 4)
 *          buffer - pointer to depth buffer values
 * Return:  GL_TRUE or GL_FALSE to indicate success or failure.
 */
static GLboolean RivaGetDepthBuffer
(
    XSMesaBuffer b,
    GLint       *width,
    GLint       *height,
    GLint       *bytesPerValue,
    void       **buffer
)
{
    if ((!b->gl_buffer) || (!b->gl_buffer->Depth))
    {
        *width         = 0;
        *height        = 0;
        *bytesPerValue = 0;
        *buffer        = 0;
        return(GL_FALSE);
    }
    else
    {
        *width         = b->gl_buffer->Width;
        *height        = b->gl_buffer->Height;
        *bytesPerValue = sizeof(GLdepth);
        *buffer        = b->gl_buffer->Depth;
        return(GL_TRUE);
    }
}
/*
 * Deallocate an XSMesaBuffer structure and all related info.
 */
static void RivaDestroyBuffer
(
    XSMesaBuffer b
)
{
    /*
     * Do any special buffer management before calling the default
     * routine.
     */
    if (b->gl_buffer->Depth == (GLdepth *)RIVA_MAGIC_NUM)
        b->gl_buffer->Depth = NULL;
    XSMesaDestroyBuffer(b);
}
/*
 * XImage overrides to read and write offscreen image and
 * depth buffers.
 */
static unsigned long RivaGetPixelNOP
(
    GLXImage *image,
    int       x,
    int       y
)
{
    return (0);
}
static unsigned long RivaGetPixel16
(
    GLXImage *image,
    int       x,
    int       y
)
{
    CARD16 *ptr2;
    char   *rowaddr;

    x += image->pwin->drawable.x;
    y += image->pwin->drawable.y;
    if ((x >= image->pwin->clipList.extents.x1 || x < image->pwin->clipList.extents.x2)
     || (y >= image->pwin->clipList.extents.y1 || y < image->pwin->clipList.extents.y2))
    {
        rowaddr = (char *)GLXSYM(vgaLinearBase)
                + GLXSYM(rivaBufferOffset)[RIVA_BACK_BUFFER]
                + image->bytes_per_line * y;
        /*
         * Sync on HW if 3D rendering currently in progress.
         */
        if (!rivaReload3D || rivaSyncPix)
        {
            rivaReload3D = 1;
            rivaSyncPix  = 0;
            RivaSync();
        }
        ptr2    = (CARD16*)rowaddr;
        return (ptr2[x]);
    }
    return (0);
}
static unsigned long RivaGetPixel32
(
    GLXImage *image,
    int       x,
    int       y
)
{
    CARD32 *ptr2;
    char   *rowaddr;

    x += image->pwin->drawable.x;
    y += image->pwin->drawable.y;
    if ((x >= image->pwin->clipList.extents.x1 || x < image->pwin->clipList.extents.x2)
     || (y >= image->pwin->clipList.extents.y1 || y < image->pwin->clipList.extents.y2))
    {
        rowaddr = (char *)GLXSYM(vgaLinearBase)
                + GLXSYM(rivaBufferOffset)[RIVA_BACK_BUFFER]
                + image->bytes_per_line * y;
        /*
         * Sync on HW if 3D rendering currently in progress.
         */
        if (!rivaReload3D || rivaSyncPix)
        {
            rivaReload3D = 1;
            rivaSyncPix  = 0;
            RivaSync();
        }
        ptr2    = (CARD32*)rowaddr;
        return (ptr2[x]);
    }
    return (0);
}
static void RivaPutPixelNOP
(
    GLXImage     *image,
    int           x,
    int           y,
    unsigned long pixel
)
{
}
static void RivaPutPixel16
(
    GLXImage     *image,
    int           x,
    int           y,
    unsigned long pixel
)
{
    CARD16 *ptr2;
    char   *rowaddr;

    x += image->pwin->drawable.x;
    y += image->pwin->drawable.y;
    if ((x >= image->pwin->clipList.extents.x1 || x < image->pwin->clipList.extents.x2)
     || (y >= image->pwin->clipList.extents.y1 || y < image->pwin->clipList.extents.y2))
    {
        rowaddr = (char *)GLXSYM(vgaLinearBase)
                + GLXSYM(rivaBufferOffset)[RIVA_BACK_BUFFER]
                + image->bytes_per_line * y;
        ptr2    = (CARD16*)rowaddr;
        /*
         * Sync on HW if 3D rendering currently in progress.
         */
        if (!rivaReload3D || rivaSyncPix)
        {
            rivaReload3D = 1;
            rivaSyncPix  = 0;
            RivaSync();
        }
        ptr2[x] = pixel;
    }
}
static void RivaPutPixel32
(
    GLXImage     *image,
    int           x,
    int           y,
    unsigned long pixel
)
{
    CARD32 *ptr2;
    char   *rowaddr;

    x += image->pwin->drawable.x;
    y += image->pwin->drawable.y;
    if ((x >= image->pwin->clipList.extents.x1 || x < image->pwin->clipList.extents.x2)
     || (y >= image->pwin->clipList.extents.y1 || y < image->pwin->clipList.extents.y2))
    {
        rowaddr = (char *)GLXSYM(vgaLinearBase)
                + GLXSYM(rivaBufferOffset)[RIVA_BACK_BUFFER]
                + image->bytes_per_line * y;
        ptr2    = (CARD32*)rowaddr;
        /*
         * Sync on HW if 3D rendering currently in progress.
         */
        if (!rivaReload3D || rivaSyncPix)
        {
            rivaReload3D = 1;
            rivaSyncPix  = 0;
            RivaSync();
        }
        ptr2[x] = pixel;
    }
}
static GLXImage * RivaCreateImage
(
    WindowPtr pwindow,
    GLvisual *visual,
    int       width,
    int       height,
    GLXImage *old_image
)
{
    GLXImage *image;
    int depth;

    if (!pwindow) return (GLXCreateImage(pwindow, visual, width, height, old_image));
    if (old_image) GLXProcs.DestroyImage(old_image);

    image                 = (GLXImage *)xalloc(sizeof(GLXImage));
    image->pwin           = pwindow;
    image->width          = width;
    image->height         = height;
    image->bits_per_pixel = depth = visual->RedBits + visual->GreenBits + visual->BlueBits;
    image->data           = 0;

    switch (depth)
    {
        case 15:
        case 16:
            if (rivaGLXEnabled)
            {
                GLXProcs.GetPixel = RivaGetPixel16;
                GLXProcs.PutPixel = RivaPutPixel16;
            }
            else 
            {
                GLXProcs.GetPixel = RivaGetPixelNOP;
                GLXProcs.PutPixel = RivaPutPixelNOP;
            }
            break;
        case 24: /* in 32bpp we get 24 passed in as the depth! */
        case 32:
            if (rivaGLXEnabled)
            {
                GLXProcs.GetPixel = RivaGetPixel32;
                GLXProcs.PutPixel = RivaPutPixel32;
            }
            else 
            {
                GLXProcs.GetPixel = RivaGetPixelNOP;
                GLXProcs.PutPixel = RivaPutPixelNOP;
            }
            break;
        default:
            ErrorF("Bad depth (%d) in RivaCreateImage\n", depth);
            xfree(image);
            return (NULL);
            break;
    }
    image->bytes_per_line = GLXSYM(riva).CurrentState->pitch1;
    return (image);
}
static GLdepth RivaGetDepthNOP
(
    XSMesaContext xsmesa,
    int           x,
    int           y
)
{
    return (0);
}
static GLdepth RivaGetDepth
(
    XSMesaContext xsmesa,
    int           x,
    int           y
)
{
    CARD16   *ptr2;
    char     *rowaddr;
    WindowPtr pwin = (WindowPtr)(xsmesa->xsm_buffer->frontbuffer);
    
    x += pwin->drawable.x;
    y += pwin->drawable.y;
    if ((x >= pwin->clipList.extents.x1 || x < pwin->clipList.extents.x2)
     || (y >= pwin->clipList.extents.y1 || y < pwin->clipList.extents.y2))
    {
        rowaddr = (char *)GLXSYM(vgaLinearBase)
                + GLXSYM(rivaBufferOffset)[RIVA_DEPTH_BUFFER]
                + GLXSYM(riva).CurrentState->pitch3 * y;
        ptr2    = (CARD16*)rowaddr;
        return ((GLdepth)ptr2[x]);
    }
    return (0);
}
static void RivaPutDepthNOP
(
    XSMesaContext xsmesa,
    int           x,
    int           y,
    GLdepth       depth
)
{
}
static void RivaPutDepth
(
    XSMesaContext xsmesa,
    int           x,
    int           y,
    GLdepth       depth
)
{
    CARD16   *ptr2;
    char     *rowaddr;
    WindowPtr pwin = (WindowPtr)(xsmesa->xsm_buffer->frontbuffer);

    x += pwin->drawable.x;
    y += pwin->drawable.y;
    if ((x >= pwin->clipList.extents.x1 || x < pwin->clipList.extents.x2)
     || (y >= pwin->clipList.extents.y1 || y < pwin->clipList.extents.y2))
    {
        rowaddr = (char *)GLXSYM(vgaLinearBase)
                + GLXSYM(rivaBufferOffset)[RIVA_DEPTH_BUFFER]
                + GLXSYM(riva).CurrentState->pitch3 * y;
        ptr2    = (CARD16*)rowaddr;
        ptr2[x] = depth;
    }
}
static void RivaCreateDepthBuffer
(
    GLcontext *ctx
)
{
    /*
     * Use a magic # so other code doesn't think its NULL.
     */
    ctx->Buffer->Depth = (GLdepth *)RIVA_MAGIC_NUM;
}
/*
 * Mode switch hooks.
 */
static void * RivaGLXSaveFunc(void *data)
{
    /*
     * Disable all texture code and rendering code.
     */
    rivaGLXEnabled    = FALSE;
    GLXProcs.GetDepth = RivaGetDepthNOP;
    GLXProcs.PutDepth = RivaPutDepthNOP;
    GLXProcs.GetPixel = RivaGetPixelNOP;
    GLXProcs.PutPixel = RivaPutPixelNOP;
    RivaReleaseTextures();
    return (prevSaveFunc(data));
}
static void RivaGLXRestoreFunc(void *data)
{
    prevRestoreFunc(data);
    nvInitGLX();
}
/*
 * Test configuration for 3D accleration.
 */
static Bool RivaAccelerate3D()
{
    /*
     * Assume not enabled.
     */
    rivaGLXEnabled = FALSE;
    /*
     * If Riva version mismatch or not installed bail out.
     */
    if (GLXSYM(riva).Version != RIVA_SW_VERSION)
        return(GL_FALSE);
    /*
     * If wrong bit depth bail out.
     */
    if ((GLXSYM(riva).Architecture == NV_ARCH_03)
     && (GLXSYM(riva).CurrentState->bpp != 15 && GLXSYM(riva).CurrentState->bpp != 16))
        return(GL_FALSE);
    else if (GLXSYM(riva).CurrentState->bpp != 15 && GLXSYM(riva).CurrentState->bpp != 16 && GLXSYM(riva).CurrentState->bpp != 32)
        return(GL_FALSE);

    /*
     * If no available buffers bail out.
     */
    if (!GLXSYM(rivaBufferOffset)[RIVA_BACK_BUFFER] && !GLXSYM(rivaBufferOffset)[RIVA_DEPTH_BUFFER] && !GLXSYM(rivaBufferOffset)[RIVA_TEXTURE_BUFFER])
        return(GL_FALSE);
    /*
     * Looks OK.
     */
    rivaGLXEnabled = TRUE;
    return (GL_TRUE);
}
/*
 * Create visuals for RIVA.  Hacked from the XSMesaCreateVisuals.
 * For comments, look in glxvisual.c - I have no idea what this
 * is /really/ doing.
 */
GLboolean nvInitVisuals
(
    VisualPtr    *visualp,
    DepthPtr     *depthp,
    int          *nvisualp, 
    int          *ndepthp,
    int          *rootDepthp,
    VisualID     *defaultVisp,
    unsigned long sizes,
    int           bitsPerRGB
)
{
    int       i, numHwBufs;
    VisualPtr old_visual;
    VisualPtr visual        = *visualp;
    int       nvisual       = *nvisualp;
    DepthPtr  depths        = *depthp;
    int       ndepths       = *ndepthp;
    int       have_default  = 0;
    int       nongl_visuals = 0;
    int       gl_visuals    = 0;
    Vis      *vhead         = 0;
    Vis      *vtail         = 0;
    Vis      *v;
    Vis      *nextv;

    /*
     * Call default visual creation if no HW acceleration.
     */
    if (!RivaAccelerate3D())
        return (XSMesaInitVisuals(visualp, depthp, nvisualp, ndepthp, rootDepthp, defaultVisp, sizes, bitsPerRGB));
    /*
     * Count number of HW buffers.  Use to validate visuals.
     */
    numHwBufs = (GLXSYM(rivaBufferOffset)[RIVA_BACK_BUFFER] != 0) + (GLXSYM(rivaBufferOffset)[RIVA_DEPTH_BUFFER] != 0);
    if (numHwBufs)
        numHwBufs -= (GLXSYM(rivaBufferOffset)[RIVA_BACK_BUFFER] == GLXSYM(rivaBufferOffset)[RIVA_DEPTH_BUFFER]);
    /*
     * Make a list of visuals.  Only RGB supported.
     */
    for (i=0;i<nvisual;i++)
    {
        VisualPtr pVisual=(*visualp)+i;
        if (((pVisual->CLASS) == TrueColor) || ((pVisual->CLASS) == DirectColor))
        {
            int db, alpha, stencil, depth, accum;
            for (db=0;db<=1;db++)
            {
/*                for (alpha=0;alpha<=1;alpha++) No alpha buffer*/
                alpha = 0;
                {
                    for (stencil=0;stencil<=1;stencil++) /* Don't really have stencil, but is faked in SW.*/
                    {
                        for (depth=0;depth<=1;depth++)
                        {
                            for (accum=0;accum<=1;accum++) /* Don't really have accum, but is faked in SW.*/
                            {
                                Vis* v=(Vis*)xalloc(sizeof(Vis));
                                v->next        = 0;
                                v->orig_visual = pVisual;
                                v->usegl       = GL_TRUE;
                                v->rgb         = GL_TRUE;
                                v->stencil     = stencil;
                                v->alpha       = alpha;
                                v->accum       = accum;
                                /*
                                 * Validate this visual with the # of available video memory buffers.
                                 */
                                if (db + depth > numHwBufs)
                                {
                                    v->db      = 0;
                                    v->depthb  = 0;
                                }
                                else
                                {
                                    v->db      = db;
                                    v->depthb  = depth;
                                }
                                gl_visuals++;
                                if (vtail)
                                    vtail->next = v;
                                else
                                    vhead = v;
                                vtail = v;
                            }
                        }
                    }
                }
            }
        }
        else
        {
            Vis* v=(Vis*)xalloc(sizeof(Vis));
            v->orig_visual = pVisual;
            v->usegl       = GL_FALSE;
            v->next        = 0;
            if (vtail)
                vtail->next = v;
            else
                vhead = v;
            vtail = v;
            nongl_visuals++;
        }
    }
    old_visual = visual;
    nvisual    = gl_visuals + nongl_visuals;
    visual     = (VisualPtr) xalloc(nvisual * sizeof (VisualRec));
    if (!visual)
        return (FALSE);
    *visualp  = visual;
    *nvisualp = nvisual;
    for (v = vhead; v!=0; v=nextv)
    {
        nextv = v->next;
        for (i = 0; i < ndepths; i++)
        {
            int j;
            v->depth = 0;
            for (j = 0; j < depths[i].numVids; j++)
            {
                if (depths[i].vids[j] == v->orig_visual->vid)
                {
                    v->depth = &depths[i];
                    break;
                }
            }
        }
    }
    for (i=0;i<ndepths;i++)
    {
        xfree(depths[i].vids);
        depths[i].vids    = 0;
        depths[i].numVids = 0;
    }
    have_default = 0;
    for (v = vhead; v != 0; v = nextv)
    {
        VisualID* newdepth;
        nextv       = v->next;
        *visual     = *v->orig_visual;
        visual->vid = FakeClientID (0);
        if (v->orig_visual->vid == *defaultVisp && !have_default)
        {
            have_default = 1;
            *defaultVisp = visual->vid;
        }
        v->vid   = visual->vid;
        newdepth = (VisualID*)xalloc(sizeof(VisualID)*(v->depth->numVids+1));
        if (v->depth->vids)
        {
            for (i = 0; i < v->depth->numVids; i++)
                newdepth[i] = v->depth->vids[i];
            xfree(v->depth->vids);
        }
        v->depth->vids                    = newdepth;
        v->depth->vids[v->depth->numVids] = visual->vid;
        v->depth->numVids++;
        visual++;
    }
    xfree(old_visual);
    v = __vislist;
    if (v)
    {
        while (v->next)
            v = v->next;
        v->next = vhead;
    }
    else
    {
        __vislist = vhead;
    }
    return (TRUE);
}
/*
 * Inititalize GLX procs.
 */
GLboolean nvInitGLX
(
    void
)
{
    int i;

    if (!RivaAccelerate3D())
        return (GL_FALSE);
    /*
     * Cool, there is enough here to accelerate.
     */
    ErrorF("\nRIVA GLX Version = %d.%d\n",GLXSYM(riva).Version >> 16,GLXSYM(riva).Version & 0xFFFF);
    /*
     * Do some initializtion.
     */
    rivaContext.bufRender    = 0;
    rivaContext.texObj       = 0;
    rivaContext.texOffset    = 0;
    if (GLXSYM(riva).Architecture == NV_ARCH_03)
    {
        rivaContext.triContext.tri03.texFilter    = 0;
        rivaContext.triContext.tri03.texFormat    = 0;
        rivaContext.triContext.tri03.triAlphaTest = 0;
        rivaContext.triContext.tri03.triControl   = 0;
        rivaContext.triContext.tri03.triFogColor  = 0;
    }
    else
    {
        rivaContext.triContext.tri05.texColorKey = 0;
        rivaContext.triContext.tri05.texFormat   = 0;
        rivaContext.triContext.tri05.texFilter   = 0;
        rivaContext.triContext.tri05.triBlend    = 0;
        rivaContext.triContext.tri05.triControl  = 0;
        rivaContext.triContext.tri05.triFogColor = 0;
    }
    rivaContext.sAdjust      = 0.0F;
    rivaContext.tAdjust      = 0.0F;
    for (i = 0; i < 16; i++)
        rivaContext.VCache[i] = 0xFFFF;
    rivaContext.NumCtxs      = 0;
    if (GLXSYM(riva).Architecture == NV_ARCH_03)
        rivaContext.xyAdjust = -0.25F;
    else
        rivaContext.xyAdjust = 0.5F;
    if ((rivaGLXEnabled = RivaInitTextureHeap()))
    {
        /*
         * Hook vga256 mode switch.
         */
        if (GLXSYM(vgaSaveFunc) != RivaGLXSaveFunc)
        {
            prevSaveFunc            = GLXSYM(vgaSaveFunc);
            GLXSYM(vgaSaveFunc)     = RivaGLXSaveFunc;
        }
        if (GLXSYM(vgaRestoreFunc) != RivaGLXRestoreFunc)
        {
            prevRestoreFunc         = GLXSYM(vgaRestoreFunc);
            GLXSYM(vgaRestoreFunc)  = RivaGLXRestoreFunc;
        }
        /*
         * Hook the GLX procs needed to support Riva acceleration.
         */
        GLXProcs.CreateContext      = RivaCreateContext;
        GLXProcs.DestroyContext     = RivaDestroyContext;
        GLXProcs.MakeCurrent        = RivaMakeCurrent;
        GLXProcs.SwapBuffers        = RivaSwapBuffers;
        GLXProcs.BindBuffer         = RivaBindBuffer;
        GLXProcs.GetBackBuffer      = RivaGetBackBuffer;
        GLXProcs.GetDepthBuffer     = RivaGetDepthBuffer;
        GLXProcs.DestroyBuffer      = RivaDestroyBuffer;
        GLXProcs.CreateImage        = RivaCreateImage;
        GLXProcs.GetDepth           = RivaGetDepth;
        GLXProcs.PutDepth           = RivaPutDepth;
        GLXProcs.CreateDepthBuffer  = RivaCreateDepthBuffer;
        /*
         * Set 3D state reload flag.
         */
        rivaReload3D = rivaSyncPix = 1;
    }
    return (rivaGLXEnabled);
}
