#!/bin/sh
# autogen.sh
# Run this to generate all the initial makefiles, etc.

# some techniques borrowed from the Eterm distribution

# $Id: autogen.sh,v 1.3 1999/11/24 03:57:03 giles Exp $

echo "checking tools..."

(autoconf --version) < /dev/null > /dev/null 2>&1 || {
	echo
        echo "You must have autoconf installed to build the glx module."
        echo "Download the appropriate package for your distribution,"
        echo "or get the source tarball at ftp://ftp.gnu.org/pub/gnu/"
        exit 1
}

if test -z "$*"; then
	echo ""
	echo "I am going to run ./configure with no arguments - this will "
	echo "only work if you've symlinked your Mesa source into the top "
	echo "level directory. Otherwise, you need to pass the location, "
	echo "and any other options you want, to configure through the "
	echo "./autogen.sh commandline"
	echo ""
fi

echo "configuring glx docs..."
cd docs
autoconf
./configure
cd ..

echo "configuring glx..."
autoconf
./configure "$@"

if [ -f cvs.motd ]; then
  echo "ATTENTION CVS Users!"
  echo ""
  cat cvs.motd
  echo ""
fi
