 

/*
 * GLX Server Extension
 * Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
 * Copyright (C) 1998, 1999 Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * STEVEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR 
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


#include <stdio.h>
#include <stdlib.h>
#include "mesaglx/macros.h"
#include "mesaglx/types.h"
#include "xsmesaP.h"
#include "servermd.h"

#include "glx_symbols.h"

#ifdef XFree86LOADER
#include "xf86_libc.h"
#endif

/**********************************************************************/
/*****                      XImage Buffer                         *****/
/**********************************************************************/

unsigned long GLXGetPixel(GLXImage* image, int x, int y)
{
    char* rowaddr=image->data+image->bytes_per_line*y;
    CARD8* ptr1;
    CARD16* ptr2;
    CARD32* ptr4;
    switch (image->bits_per_pixel)
    {
        case 8:
            ptr1=(CARD8*)rowaddr;
            return (ptr1[(x)]);
            break;
        case 15:
        case 16:
            ptr2=(CARD16*)rowaddr;
            return (ptr2[(x)]);
            break;
        case 24:
            ptr1=(CARD8*)rowaddr;
            x *= 3;
            return(ptr1[(x)+0]<<16)|(ptr1[(x)+1]<<8)|(ptr1[(x)+2]<<0);
        case 32:
            ptr4=(CARD32*)rowaddr;
            return (ptr4[(x)]);
            break;
        default:
            ErrorF("GLX: unknown pixel size in GLXGetPixel\n");
            break;
    }
    return (0);
}

void GLXPutPixel(GLXImage* image, int x, int y, unsigned long pixel)
{
    char* rowaddr=(image)->data+(image)->bytes_per_line*(y);
    CARD8* ptr1;
    CARD16* ptr2;
    CARD32* ptr4;
    switch ((image)->bits_per_pixel)
    {
        case 8:
            ptr1=(CARD8*)rowaddr;
            ptr1[(x)]=pixel;
            break;
        case 15:
        case 16:
            ptr2=(CARD16*)rowaddr;
            ptr2[(x)]=pixel;
            break;
        case 24:
        case 32:
            ptr4=(CARD32*)rowaddr;
            ptr4[(x)]=pixel;
            break;
        default:
            ErrorF("Error putting pixel (bpp=%d)...\n", (image)->bits_per_pixel);
    }
}

void GLXDestroyImage(GLXImage* image)
{
    if (image->data)
        free(image->data);
    xfree(image);
}

GLXImage* GLXCreateImage(WindowPtr pwindow, GLvisual *visual, int width, int height, GLXImage* old_image)
{
	int	depth;
    GLXImage* image=(GLXImage*)xalloc(sizeof(GLXImage));
    if (old_image) GLXDestroyImage(old_image);  
    if (!image)
        return (NULL);
    depth = visual->RedBits + visual->GreenBits + visual->BlueBits;
        
    image->pwin = pwindow;
    image->width=width;
    image->height=height;
    image->bits_per_pixel=depth;
    image->data=0;
    switch ( depth )
    {
        case 8:
            break;
        case 15:
        case 16:
            break;
        case 24:
            break;
        case 32:
            break;
        default:
            ErrorF("Unknown depth in GLXCreateImage\n");
            break;
    }
    image->bytes_per_line=PixmapBytePad(width, depth);
    image->data = (char *) malloc( image->height * image->bytes_per_line );
    if (!image->data)
    {
        ErrorF("alloc_back_buffer: malloc failed.");
        xfree(image);
        image = NULL;
    }
    return (image);
}

/**********************************************************************/
/*****                      XDepth Buffer                         *****/
/**********************************************************************/

GLdepth GLXGetDepth(XSMesaContext xsmesa, int x, int y)
{
    GLdepth *ptr = xsmesa->gl_ctx->Buffer->Depth + y * xsmesa->gl_ctx->Buffer->Width;
    return (ptr[x]);
}

void GLXPutDepth(XSMesaContext xsmesa, int x, int y, GLdepth depth)
{
    GLdepth *ptr = xsmesa->gl_ctx->Buffer->Depth + y * xsmesa->gl_ctx->Buffer->Width;
    ptr[x] = depth;
}

void GLXCreateDepthBuffer(GLcontext* ctx)
{
    /* deallocate current depth buffer if present */
    if (ctx->Buffer->Depth)
    {
        free(ctx->Buffer->Depth);
        ctx->Buffer->Depth = NULL;
    }

    /* allocate new depth buffer, but don't initialize it */
    ctx->Buffer->Depth = (GLdepth *) malloc(ctx->Buffer->Width
                                            * ctx->Buffer->Height
                                            * sizeof(GLdepth));
    if (!ctx->Buffer->Depth)
    {
        /* out of memory */
        ctx->Depth.Test = GL_FALSE;
        ErrorF("GLX: Couldn't allocate depth buffer\n" );
    }
}
