/*
 * GLX Hardware Device Driver for SiS 6326
 * Copyright (C) 2000 Jim Duchek
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Jim Duchek <jim@linuxpimps.com> */

#include "sis6326glx.h"


void sis6326Line( GLcontext *ctx, GLuint e0, GLuint e1, GLuint pv )
{
	const struct vertex_buffer *VB;
	GLuint		*vertices;
	GLboolean	replace[3];
	GLfloat 	*w;
	GLfloat 	tmp;
	int i;
	int topbot;
	int addr;
	int color;
	int flatshade;
	GLfloat z, y;


	VB = ctx->VB;



	sis6326glx.setupVertices[0] =
		sis6326glx.setupVertices[1] =
		sis6326glx.setupVertices[2] = (GLuint)-1;

	topbot = S_PRIM_SHADEMODE_GOURAUD;


	if (abs(VB->Win.data[e0][1] - VB->Win.data[e1][1]) > 
		abs(VB->Win.data[e0][0] - VB->Win.data[e1][0])) {
		topbot |= 0x80;
		if (VB->Win.data[e0][1] > VB->Win.data[e1][1]) {
			topbot |= S_PRIM_ATOP | S_PRIM_BBOT;
		} else {
			topbot |= S_PRIM_BTOP | S_PRIM_ABOT;
		}
	} else {
		if (VB->Win.data[e0][0] > VB->Win.data[e1][0]) {
			topbot |= S_PRIM_BTOP | S_PRIM_ABOT;
		} else {
			topbot |= S_PRIM_ATOP | S_PRIM_BBOT;
		}
	}

	topbot |= S_PRIM_LINE | S_PRIM_FIRE_ARGBB;
	
	OUTREG( SIS6326_TRI_PRIMSET, (topbot));

	addr = SIS6326_TRI_FIRST;
	
	z = VB->Win.data[e0][2] / 65535.0;
	y = (GLfloat)sis6326DB->height - VB->Win.data[e0][1];

	OUTREG( (addr + SIS6326_TRI_TSZ), *(int*)&z);
	OUTREG( (addr + SIS6326_TRI_TSX), *(int*)&VB->Win.data[e0][0]);
	OUTREG( (addr + SIS6326_TRI_TSY), *(int*)&y);
		
	color = ((VB->Color[0]->data[e0][3] << 24) |
		(VB->Color[0]->data[e0][0] << 16) |
		(VB->Color[0]->data[e0][1] << 8) |
		(VB->Color[0]->data[e0][2]));
	OUTREG( (addr + SIS6326_TRI_TSARGB), color);
	
	addr += SIS6326_TRI_DIFF;

	z = VB->Win.data[e1][2] / 65535.0;
	y = (GLfloat)sis6326DB->height - VB->Win.data[e1][1];

	OUTREG( (addr + SIS6326_TRI_TSZ), *(int*)&z);
	OUTREG( (addr + SIS6326_TRI_TSX), *(int*)&VB->Win.data[e1][0]);
	OUTREG( (addr + SIS6326_TRI_TSY), *(int*)&y);
		
	color = ((VB->Color[0]->data[e1][3] << 24) |
		(VB->Color[0]->data[e1][0] << 16) |
		(VB->Color[0]->data[e1][1] << 8) |
		(VB->Color[0]->data[e1][2]));
	OUTREG( (addr + SIS6326_TRI_TSARGB), color);
	
	OUTREGB(SIS6326_TRI_TEND, 0xFF);
	
}	