/*
 * GLX Hardware Device Driver for S3 ViRGE DX/GX/GX2
 * Copyright (C) 1999 Jim Duchek
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *    Jim Duchek <jimduchek@ou.edu>
 */

#ifndef __S3VIRGE_REGS_H__
#define __S3VIRGE_REGS_H__

#define INREG( addr )		*((volatile CARD32 *)(s3virgeglx.MMIOBase + (addr)))
#define OUTREG( addr, val )	*((volatile CARD32 *)(s3virgeglx.MMIOBase + (addr))) = (val)

#define INSCREEN( addr )		*((volatile CARD32 *)(s3virgeglx.linearBase + (addr)))
#define OUTSCREEN( addr, val )		*((volatile CARD32 *)(s3virgeglx.linearBase + (addr))) = (val)


#define WAITACCELIDLE()		while((INREG(0x8504) & 0x3f00) < 0x3000) {}

/* To be 'safe', WAITFIFOEMPTY should have some sort of timeout on it.
 * In the X server, it increments a variable every time through the loop.
 * If the variable hits a certain point, the card is reset.  Well,
 * I'm just gonna hammer.  Lockups be damned.  ;)
 */
#define WAITFIFOEMPTY( n ) 	\
	do { \
        	while(((INREG(0x8504) >> 8) & 0x1f) < n) { } \
	} while (0)


#define VerticalRetraceWait() \
	do { \
		outb(0x3d4, 0x17); \
		if (inb(0x3d5) & 0x80) { \
			while((inb(0x3da) & 0x08) == 0x00) ; \
			while((inb(0x3da) & 0x08) == 0x08) ; \
			while((inb(0x3da) & 0x08) == 0x00) ; \
		} \
	} while (0)
	

#define s3virgeOn() \
	do { \
		unsigned char tmp; \
		s3virgeMsg(1, "Here\n"); \
		outw(0x3c4, 0x4838); \
		s3virgeMsg(1, "Here\n"); \
		outw(0x3c4, 0xA539); \
		s3virgeMsg(1, "Here\n"); \
		outb(0x3c4, 0x40); \
		s3virgeMsg(1, "Here\n"); \
		tmp = inb(0x3c5); \
		s3virgeMsg(1, "Here\n"); \
 		outb(0x3c5, tmp | 0x01); \
 		s3virgeMsg(1, "Here\n"); \
	} while (0)

#if 0
 		/*outb(0x3d4, 0x66);*/ \
 		/*outb(0x3d5, inb(0x3d5) | 0x88);*/ \
 		/* VerticalRetraceWait();*/ \
 		/*OUTREG(0x8208, 0x2727);*/ \
 		/*OUTREG(S3VIRGE_SUB_CTRL_REG, S3VIRGE_SUB_CTRL_S3DON);*/ \
#endif
	
#define s3vOff() \
	do { \
		outw(0x3d4, 0x3848); \
		outw(0x3d4, 0x39A5); \
		outb(0x3d4, 0x40); \
 		outb(0x3d5, inb(0x3d5) & 0xFE); \
 	} while (0)
					

/* 3D stuff */
#define S3VIRGE_PATTERN_REG			0xA000
#define S3VIRGE_BITBLT_REG			0xA400
#define S3VIRGE_LINE_REG			0xA800
#define S3VIRGE_POLY_REG			0xAC00
#define S3VIRGE_3DLINE_REG			0xB000
#define S3VIRGE_3DTRI_REG			0xB400
#define S3VIRGE_Z_BASE				0xD4
#define S3VIRGE_SRC_BASE			0xD4
#define S3VIRGE_DEST_BASE			0xD8
#define S3VIRGE_CLIP_L_R			0xDC
#define S3VIRGE_CLIP_T_B			0xE0
#define S3VIRGE_DEST_SRC_STRIDE			0xE4
#define S3VIRGE_Z_STRIDE			0xE8
#define S3VIRGE_MONO_PAT0			0xE8
#define S3VIRGE_MONO_PAT1			0xEC
#define S3VIRGE_TEX_BASE			0xEC
#define S3VIRGE_TEX_B_COLOR			0xF0
#define S3VIRGE_PAT_BG_COLOR			0xF0
#define S3VIRGE_FOG_COLOR			0xF4
#define S3VIRGE_PAT_FG_COLOR			0xF4
#define S3VIRGE_COLOR0				0xF8
#define S3VIRGE_COLOR1				0xFC
#define S3VIRGE_CMDSET				0x100
#define S3VIRGE_BITBLT_WIDTH_HEIGHT		0x104
#define S3VIRGE_BITBLT_SRC_X_Y			0x108
#define S3VIRGE_BITBLT_DEST_X_Y			0x10C

#define S3VIRGE_3DTRI_BASEV			0x104
#define S3VIRGE_3DTRI_BASEU			0x108
#define S3VIRGE_3DTRI_WXD			0x10C
#define S3VIRGE_3DTRI_WYD			0x110
#define S3VIRGE_3DTRI_WSTART			0x114
#define S3VIRGE_3DTRI_DXD			0x118
#define S3VIRGE_3DTRI_VXD			0x11C
#define S3VIRGE_3DTRI_UXD			0x120
#define S3VIRGE_3DTRI_DYD			0x124
#define S3VIRGE_3DTRI_VYD			0x128
#define S3VIRGE_3DTRI_UYD			0x12C
#define S3VIRGE_3DTRI_DSTART			0x130
#define S3VIRGE_3DTRI_VSTART			0x134
#define S3VIRGE_3DTRI_USTART			0x138
#define S3VIRGE_3DTRI_GBX			0x13C
#define S3VIRGE_3DTRI_ARX			0x140
#define S3VIRGE_3DTRI_GBY			0x144
#define S3VIRGE_3DTRI_ARY			0x148
#define S3VIRGE_3DTRI_GS_BS			0x14C
#define S3VIRGE_3DTRI_AS_RS			0x150
#define S3VIRGE_3DTRI_ZXD			0x154
#define S3VIRGE_3DTRI_ZYD			0x158
#define S3VIRGE_3DTRI_ZSTART			0x15C
#define S3VIRGE_3DTRI_TXDELTA12			0x160
#define S3VIRGE_3DTRI_TXEND12			0x164
#define S3VIRGE_3DTRI_TXDELTA01			0x168
#define S3VIRGE_3DTRI_TXEND01			0x16C
#define S3VIRGE_3DTRI_TXDELTA02			0x170
#define S3VIRGE_3DTRI_TXSTART02			0x174
#define S3VIRGE_3DTRI_TYS			0x178
#define S3VIRGE_3DTRI_TY01_Y12			0x17C

#define S3VIRGE_3DLINE_FOG			0x0F4
#define S3VIRGE_3DLINE_GBD			0x144
#define S3VIRGE_3DLINE_ARD			0x148
#define S3VIRGE_3DLINE_GS_BS			0x14C
#define S3VIRGE_3DLINE_AS_RS			0x150
#define S3VIRGE_3DLINE_DZ			0x158
#define S3VIRGE_3DLINE_ZSTART			0x15C
#define S3VIRGE_3DLINE_XEND0_END1		0x16C
#define S3VIRGE_3DLINE_DX			0x170
#define S3VIRGE_3DLINE_XSTART			0x174
#define S3VIRGE_3DLINE_YSTART			0x178
#define S3VIRGE_3DLINE_YCNT			0x17C

/* Command DMA buffer stuff */
#define S3VIRGE_CMD_DMA_BASEADDR_REG		0x8590
#define S3VIRGE_CMD_DMA_BUFFERSIZE_4K		0x0000
#define S3VIRGE_CMD_DMA_BUFFERSIZE_64K		0x0002
#define S3VIRGE_CMD_DMA_WRITEP_REG		0x8594
#define S3VIRGE_CMD_DMA_READP_REG		0x8598
#define S3VIRGE_CMD_DMA_RWP_MASK		0x00FC
#define S3VIRGE_CMD_DMA_WRITEP_UPDATE		0x010000
#define S3VIRGE_CMD_DMA_ENABLE_REG		0x859C
#define S3VIRGE_CMD_DMA_ENABLE			0x0001

/* Subsystem status register */
#define S3VIRGE_SUB_STAT_REG			0x8504
#define S3VIRGE_SUB_STAT_VSYNC_INT		0x0001
#define S3VIRGE_SUB_STAT_3D_DONE_INT		0x0002
#define S3VIRGE_SUB_STAT_FIFO_OVR_INT		0x0004
#define S3VIRGE_SUB_STAT_FIFO_EMPTY_INT		0x0008
#define S3VIRGE_SUB_STAT_HDMA_DONE_INT		0x0010
#define S3VIRGE_SUB_STAT_CDMA_DONE_INT		0x0020
#define S3VIRGE_SUB_STAT_S3D_FIFO_EMPTY_INT	0x0040
#define S3VIRGE_SUB_STAT_LPB_INT		0x0080
#define S3VIRGE_SUB_STAT_3DBUSY			0x0200

#define S3VIRGE_SUB_CTRL_REG 			0x8504
#define S3VIRGE_SUB_CTRL_S3DON			0x0040

#define S3VIRGE_ISBUSY()        ( INREG( S3VIRGE_SUB_STAT_REG ) & S3VIRGE_SUB_STAT_3DBUSY )
#define S3VIRGE_WAITFREE()	do { \
					while (S3VIRGE_ISBUSY()); \
				} while (0)


#define S3VIRGE_CMD_DMA_LASTREAD() \
	( ( ( INREG( S3VIRGE_CMD_DMA_READP_REG ) & 0xFF) >> 2)

static int __inline__ FloatToS1120( float f ) 
{
	if (f < 0)
		return -(((int)(-f) << 20) | (int)(0xFFFFF * (float)(f - (int)f)));
	else
		return (((int)f << 20) | (int)(0xFFFFF * (float)(f - (int)f)));
}		
		
						
		
	

#endif /* __S3VIRGE_REGS_H__ */

