#include <stdio.h>
#include <stdlib.h>

/* Compare offset to size of physical memory. */

#ifdef __linux__
int checkmemoffset(int offset)
{
  FILE *meminfo;
  int memtotal;
  char templine[160]; /* This should be enough for one line in
		       * /proc/meminfo unless you have LOTS of
		       * memory :) */

  meminfo=fopen("/proc/meminfo","r");
  if(!meminfo){
    return 0;
  }


  while(fgets(templine,160,meminfo)){
    if(sscanf(templine,"MemTotal: %d kB",&memtotal)==1){
      fclose(meminfo);
      if(memtotal*1024 < offset){
	return 1;
      }
      return 0;
    }
  }
  fclose(meminfo);
  return 0;
}
#else
/* Not good, but better than nothing */
int checkmemoffset(int offset)
{
  if(offset < 16*1024*1024){
    return 0;
  }
  return 1;
}

#endif
