#define GLX_SYM_NO_DEFINES
#include "glx_symbols.h"

#include <dlfcn.h>
#include <stdio.h>
#include <unistd.h>

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_MMAN_H
#include <sys/mman.h>
#endif

#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

int __glx_is_server = 1;
int __glx_first_visual = 0;	/* big hack */

GlxDriverSyms glxsym;

static xf86AccelInfoRecType xf86AccelInfoRec;
static PciProbeType xf86PCIFlags;
static ScrnInfoRec vga256InfoRec;
static int vgaBytesPerPixel;
static int vgaBitsPerPixel;
static int vgaLinearSize;
static pointer vgaLinearBase;
static int xf86VTSema;	

#ifdef __sun__
pointer AllocAddress[MAXSCREENS][NUM_REGIONS];
static char *apertureDevName = NULL;
static Bool xf86LinearVidMem()
{
	int	mmapFd;

	apertureDevName = "/dev/xsvc";
	if ((mmapFd = open(apertureDevName, O_RDWR)) < 0) 
	{
	    apertureDevName = "/dev/fbs/aperture";
	    if((mmapFd = open(apertureDevName, O_RDWR)) < 0)
	    {
		GLXSYM(FatalError)("xf86LinearVidMem: failed to open "
		       "%s (%s)\n", apertureDevName, strerror(errno));
		return FALSE;
	    } 
	}
	close(mmapFd);
	return TRUE;
}

static pointer xf86MapVidMem(int ScreenNum, int Region, pointer Base,
				unsigned long Size)
{
	pointer base;
	int fd;
	char solx86_vtname[20];

	/* 
	 * Solaris 2.1 x86 SVR4 (10/27/93)
	 *		The server must treat the virtual terminal device file 
	 *		as the standard SVR4 /dev/pmem. 
	 * 
	 * Uning the /dev/vtXX device as /dev/pmem only works for the
	 * A0000-FFFFF region - If we wish you mmap the linear aperture
 	 * it requires a device driver.
 	 * 
	 * So what we'll do is use /dev/vtXX for the A0000-FFFFF stuff, and
	 * try to use the /dev/fbs/aperture driver if the server
	 * tries to mmap anything > FFFFF, and HAS_APERTURE_DRV is
	 * defined. (its very very unlikely that the server will try to mmap
	 * anything below FFFFF that can't be handled by /dev/vtXX.
	 * If the server tries to mmap anything above FFFFF, and
	 * HAS_APERTURE_DRV the server will die.)
	 * 
	 * DWH - 2/23/94
	 */

	if(Base < (pointer)0xFFFFF)
/*		sprintf(solx86_vtname,"/dev/vt%02d",xf86Info.vtno);*/{}
	else

	{
		if (!apertureDevName)
			if (!xf86LinearVidMem())
				GLXSYM(FatalError)("xf86MapVidMem: Could not mmap "
					   "linear framebuffer [s=%x,a=%x]\n",
					   Size, Base);
		
		sprintf(solx86_vtname, apertureDevName);
	}

	if ((fd = open(solx86_vtname, O_RDWR,0)) < 0)
	{
		GLXSYM(FatalError)("xf86MapVidMem: failed to open %s (%s)\n",
			   solx86_vtname, strerror(errno));
	}
	base = (pointer)mmap((caddr_t)0, Size, PROT_READ|PROT_WRITE,
			     MAP_SHARED, fd, (off_t)Base);
	close(fd);
	if ((long)base == -1)
	{
		GLXSYM(FatalError)("%s: Could not mmap framebuffer [s=%x,a=%x] (%s)\n",
			   "xf86MapVidMem", Size, Base, strerror(errno));
	}
	return((pointer)base);
}

#else
static pointer xf86MapVidMem(int ScreenNum, int Region, pointer Base,
			     unsigned long Size )
{
   pointer base;
   int fd;

   if ((fd = open("/dev/mem", O_RDWR)) < 0)
      GLXSYM(FatalError)("xf86MapVidMem: failed to open /dev/mem (%s)\n",
			 strerror(errno));

   base = (pointer)mmap((caddr_t)0, Size, PROT_READ|PROT_WRITE,
			MAP_SHARED, fd, (off_t)Base);
   close(fd);

   if ((long)base == -1)
      GLXSYM(FatalError)("xf86MapVidMem: Could not mmap framebuffer (%s)\n",
			 strerror(errno));

   return base;
}

#endif
static void xf86UnMapVidMem(int ScreenNum, int Region, pointer Base, 
			    unsigned long Size)
{
    munmap((caddr_t)Base, Size);
}


int glxInstallLocalSVGASymbols( void )
{
   glxsym.vga256InfoRec = &vga256InfoRec;
   glxsym.vgaBytesPerPixel = &vgaBytesPerPixel;
   glxsym.vgaBitsPerPixel = &vgaBitsPerPixel;
   glxsym.vgaLinearSize = &vgaLinearSize;
   glxsym.vgaLinearBase = &vgaLinearBase;
   glxsym.xf86AccelInfoRec = &xf86AccelInfoRec;
   glxsym.xf86PCIFlags = &xf86PCIFlags;
   glxsym.xf86VTSema = &xf86VTSema;	
   glxsym.xf86MapVidMem = &xf86MapVidMem;
   glxsym.xf86UnMapVidMem = &xf86UnMapVidMem;
   glxsym.pcibusRead = 0;
   glxsym.pcibusWrite = 0;

   GLXSYM(vgaLinearBase) = (pointer) -1;
   GLXSYM(xf86VTSema) = 1;

   return glxHookX11ClientSymbols();
}


int glxInstallLocalMach64Symbols( void )
{
   glxsym.vga256InfoRec = 0;
   glxsym.vgaBytesPerPixel = 0;
   glxsym.vgaBitsPerPixel = 0;
   glxsym.vgaLinearSize = 0;
   glxsym.vgaLinearBase = 0;
   glxsym.xf86AccelInfoRec = 0;
   glxsym.xf86PCIFlags = 0;
   glxsym.xf86VTSema = 0;
   glxsym.xf86MapVidMem = &xf86MapVidMem;
   glxsym.xf86UnMapVidMem = &xf86UnMapVidMem;
   glxsym.pcibusRead = 0;
   glxsym.pcibusWrite = 0;


   return glxHookX11ClientSymbols();
}



static int any_error;
static void *my_dlsym(void *handle, const char *name)
{
   void *tmp = dlsym(handle, name);
   char *error;
   if ((error = dlerror()) != 0) {
      fprintf( stderr, "%s\n", error );
      any_error = 1;
      return 0;
   }
   return tmp;
}

/* Some of these symbols are also loaded by the mach64 driver 
 * when running against the XF86_mach64 server.
 */
int glxHookSVGAServerSymbols( void *handle )
{
    any_error = 0;
    
   glxsym.vga256InfoRec = my_dlsym(handle, "vga256InfoRec");
   glxsym.vgaBytesPerPixel = my_dlsym(handle, "vgaBytesPerPixel");
   glxsym.vgaBitsPerPixel = my_dlsym(handle, "vgaBitsPerPixel");
   glxsym.vgaLinearSize = my_dlsym(handle, "vgaLinearSize");
   glxsym.vgaLinearBase = my_dlsym(handle, "vgaLinearBase");
   glxsym.xf86VTSema = my_dlsym(handle, "xf86VTSema");	
   glxsym.xf86AccelInfoRec = my_dlsym(handle, "xf86AccelInfoRec");
   glxsym.xf86PCIFlags = my_dlsym(handle, "xf86PCIFlags");
   glxsym.xf86MapVidMem = my_dlsym(handle, "xf86MapVidMem");
   glxsym.xf86UnMapVidMem = my_dlsym(handle, "xf86UnMapVidMem");
   glxsym.pcibusRead = my_dlsym(handle, "pcibusRead");
   glxsym.pcibusWrite = my_dlsym(handle, "pcibusWrite");

   if (!any_error) 
      fprintf(stderr, "Sucessfully loaded XF86_SVGA server symbols\n");
   else
      fprintf(stderr, "XF86_SVGA server not detected (missing symbols)\n");

   return !any_error;
}


int glxHookMach64ServerSymbols( void *handle )
{
    any_error = 0;

   glxsym.mach64InfoRec = my_dlsym(handle, "mach64InfoRec");	
   glxsym.mach64MemRegMap = my_dlsym(handle, "mach64MemRegMap");
   glxsym.mach64VideoMem = my_dlsym(handle, "mach64VideoMem");
   glxsym.mach64ApertureAddr = my_dlsym(handle, "mach64ApertureAddr");	
   glxsym.mach64ApertureSize = my_dlsym(handle, "mach64ApertureSize");
   glxsym.pcibusRead = my_dlsym(handle, "pcibusRead");
   glxsym.pcibusWrite = my_dlsym(handle, "pcibusWrite");
   glxsym.xf86MapVidMem = my_dlsym(handle, "xf86MapVidMem");
   glxsym.xf86UnMapVidMem = my_dlsym(handle, "xf86UnMapVidMem");

   if (!any_error) 
      fprintf(stderr, "Sucessfully initialized Mach64 server symbols\n");
   else
      fprintf(stderr, "XF86_Mach64 server not detected (missing symbols)\n");

   return !any_error;
}


/* This one is a bit funny as I don't see any definitions in the
 * header files for some of these constants:
 */
int glxHookFbDevServerSymbols( void *handle )
{
    any_error = 0;

   glxsym.fbdevInfoRec = my_dlsym(handle, "fbdevInfoRec");		
   glxsym.fbdevVirtBase = my_dlsym(handle, "fbdevVirtBase");
   glxsym.fbdevRegBase = my_dlsym(handle, "fbdevRegBase");

   if (!any_error) 
      fprintf(stderr, 
	      "Successfully inited Mach64 driver symbols for XF86_FbDev\n");
   else
      fprintf(stderr, "XF86_FbDev server not detected (missing symbols)\n");

   return !any_error;
}


/* Hook in symbols common to all the XFree86 3.3 Servers.
 */
int glxHookXFree86Symbols( void *handle )
{
   glxsym.AddExtension = my_dlsym(handle, "AddExtension");
   glxsym.StandardMinorOpcode = my_dlsym(handle, "StandardMinorOpcode");
   glxsym.AddResource = my_dlsym(handle, "AddResource");
   glxsym.CreateNewResourceType = my_dlsym(handle, "CreateNewResourceType");
   glxsym.FreeResource = my_dlsym(handle, "FreeResource");
   glxsym.LookupIDByClass = my_dlsym(handle, "LookupIDByClass");
   glxsym.LookupIDByType = my_dlsym(handle, "LookupIDByType");
   glxsym.SecurityLookupIDByClass = my_dlsym(handle, "SecurityLookupIDByClass");
   glxsym.SecurityLookupIDByType = my_dlsym(handle, "SecurityLookupIDByType");
   glxsym.AllocColor = my_dlsym(handle, "AllocColor");
   glxsym.QueryColors = my_dlsym(handle, "QueryColors");
   glxsym.ErrorF = my_dlsym(handle, "ErrorF");
   glxsym.FatalError = my_dlsym(handle, "FatalError");
   glxsym.FlushAllOutput = my_dlsym(handle, "FlushAllOutput");
   glxsym.FreeScratchGC = my_dlsym(handle, "FreeScratchGC");
   glxsym.GetScratchGC = my_dlsym(handle, "GetScratchGC");
   glxsym.DoChangeGC = my_dlsym(handle, "DoChangeGC");
   glxsym.ValidateGC = my_dlsym(handle, "ValidateGC");
   glxsym.GlxExtensionInitPtr = my_dlsym(handle, "GlxExtensionInitPtr");
   glxsym.GlxInitVisualsPtr = my_dlsym(handle, "GlxInitVisualsPtr");
   glxsym.FakeClientID = my_dlsym(handle, "FakeClientID");
   glxsym.FindWindowWithOptional = my_dlsym(handle, "FindWindowWithOptional");
   glxsym.LocalClient = my_dlsym(handle, "LocalClient");
   glxsym.WriteToClient = my_dlsym(handle, "WriteToClient");
   glxsym.Xalloc = my_dlsym(handle, "Xalloc");
   glxsym.Xfree = my_dlsym(handle, "Xfree");
   glxsym.PixmapWidthPaddingInfo = my_dlsym(handle, "PixmapWidthPaddingInfo");
   glxsym.screenInfo = my_dlsym(handle, "screenInfo");

   if (!any_error) 
      fprintf(stderr, "Sucessfully loaded XFree86 3.3 symbols\n");
   else
      fprintf(stderr, "XFree86 3.3 server not detected (missing symbols)\n");

   return !any_error;
}
