/* -*- mode: C; c-basic-offset:8 -*- */
/*
 * GLX Hardware Device Driver for Matrox Millenium G200
 * Copyright (C) 1999 Wittawat Yamwong
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *    original by Wittawat Yamwong <Wittawat.Yamwong@stud.uni-hannover.de>
 *	9/20/99 rewrite by John Carmack <johnc@idsoftware.com>
 */

/* $Id: mgacnvtex.c,v 1.5 2000/02/29 10:40:30 giles Exp $ */

#include <stdlib.h>
#include <stdio.h>

#include <GL/gl.h>

#include "glx_log.h"

#include "mm.h"
#include "g200_mac.h"
#include "mgalib.h"
#include "mgatex.h"


#if defined(USE_MMX_ASM)
#include "mmx.h"
#endif

#include "X86/common_x86asm.h"


/*
 * mgaConvertTexture
 * Converts a mesa format texture to the apropriate hardware format
 * Note that sometimes width may be larger than the texture, like 64x1
 * for an 8x8 texture.  This happens when we have to crutch the pitch
 * limits of the mga by uploading a block of texels as a single line.
 */
void mgaConvertTexture( hwUI32 *destPtr, int texelBytes, 
			struct gl_texture_image *image,
			int x, int y, int width, int height ) {
	register int		i, j;
	hwUI8		*src;
	int stride;
	
	//hwMsg( 0, "texture convert\n" );
	/* FIXME: g400 luminance_alpha internal format */
	switch (texelBytes) {
	  case 1:
	    switch (image->Format) {
		   case GL_COLOR_INDEX:
		   case GL_INTENSITY:
		   case GL_LUMINANCE:
		   case GL_ALPHA:
 	        src = (hwUI8 *)image->Data + ( y * image->Width + x );
			  stride = (image->Width - width);
		     for ( i = height ; i ; i-- ) {
			    for ( j = width >> 2  ; j ; j-- ) {
			
				   *destPtr++ = src[0] | ( src[1] << 8 ) | ( src[2] << 16 ) | ( src[3] << 24 );
				   src += 4;
			    }
				 src += stride;
		     }
			  break;
			default:
			  goto format_error;
		 }
		 break;
	  case 2:
	    switch (image->Format) {
			case GL_RGB:
 	        src = (hwUI8 *)image->Data + ( y * image->Width + x ) * 3;
			  stride = (image->Width - width) * 3;
		     for ( i = height ; i ; i-- ) {
			    for ( j = width >> 1  ; j ; j-- ) {
			
				   *destPtr++ = MGAPACKCOLOR565(src[0],src[1],src[2]) |  
					   ( MGAPACKCOLOR565(src[3],src[4],src[5]) << 16 );
				   src += 6;
			    }
				 src += stride;
		     }
			  break;
			case GL_RGBA:
 	        src = (hwUI8 *)image->Data + ( y * image->Width + x ) * 4;
			  stride = (image->Width - width) * 4;
		     for ( i = height ; i ; i-- ) {
			    for ( j = width >> 1  ; j ; j-- ) {
			
				   *destPtr++ = MGAPACKCOLOR4444(src[0],src[1],src[2],src[3]) |  
				   	( MGAPACKCOLOR4444(src[4],src[5],src[6],src[7]) << 16 );
				   src += 8;
			    }
				 src += stride;
		     }
			  break;
			case GL_LUMINANCE:
 	        src = (hwUI8 *)image->Data + ( y * image->Width + x );
			  stride = (image->Width - width);
		     for ( i = height ; i ; i-- ) {
			    for ( j = width >> 1  ; j ; j-- ) {
				   /* FIXME: should probably use 555 texture to get true grey */
				   *destPtr++ = MGAPACKCOLOR565(src[0],src[0],src[0]) |  
					   ( MGAPACKCOLOR565(src[1],src[1],src[1]) << 16 );
				   src += 2;
			    }
				 src += stride;
		     }
			  break;
			case GL_INTENSITY:
 	        src = (hwUI8 *)image->Data + ( y * image->Width + x );
			  stride = (image->Width - width);
		     for ( i = height ; i ; i-- ) {
			    for ( j = width >> 1  ; j ; j-- ) {
			
				   *destPtr++ = MGAPACKCOLOR4444(src[0],src[0],src[0],src[0]) |  
					   ( MGAPACKCOLOR4444(src[1],src[1],src[1],src[1]) << 16 );
				   src += 2;
			    }
				 src += stride;
		     }
			  break;
			case GL_ALPHA:
 	        src = (hwUI8 *)image->Data + ( y * image->Width + x );
			  stride = (image->Width - width);
		     for ( i = height ; i ; i-- ) {
			    for ( j = width >> 1  ; j ; j-- ) {
			
				   *destPtr++ = MGAPACKCOLOR4444(255,255,255,src[0]) |  
					   ( MGAPACKCOLOR4444(255,255,255,src[1]) << 16 );
				   src += 2;
			    }
				 src += stride;
		     }
			  break;
			case GL_LUMINANCE_ALPHA:
 	        src = (hwUI8 *)image->Data + ( y * image->Width + x ) * 2;
			  stride = (image->Width - width) * 2;
		     for ( i = height ; i ; i-- ) {
			    for ( j = width >> 1  ; j ; j-- ) {
			
				   *destPtr++ = MGAPACKCOLOR4444(src[0],src[0],src[0],src[1]) |  
					   ( MGAPACKCOLOR4444(src[2],src[2],src[2],src[3]) << 16 );
				   src += 4;
			    }
				 src += stride;
		     }
			  break;
			default:
			  goto format_error;
		 }
		 break;
	  case 4:
		 switch (image->Format) {
			case GL_RGB:
 	        src = (hwUI8 *)image->Data + (  y * image->Width + x ) * 3;
			  stride = (image->Width - width) * 3;
		     for ( i = height ; i ; i-- ) {
			    for ( j = width ; j ; j-- ) {
			
				   *destPtr++ = MGAPACKCOLOR8888(src[0],src[1],src[2], 255);
				   src += 3;
			    }
				 src += stride;
		     }
			  break;
			case GL_RGBA:
 	        src = (hwUI8 *)image->Data + (  y * image->Width + x ) * 4;
			  stride = (image->Width - width) * 4;
		     for ( i = height ; i ; i-- ) {
			    for ( j = width  ; j ; j-- ) {
			
				   *destPtr++ = MGAPACKCOLOR8888(src[0],src[1],src[2],src[3]);
				   src += 4;
			    }
				 src += stride;
		     }
			  break;
			case GL_LUMINANCE:
 	        src = (hwUI8 *)image->Data + ( y * image->Width + x );
			  stride = (image->Width - width);
		     for ( i = height ; i ; i-- ) {
			    for ( j = width ; j ; j-- ) {
			
				   *destPtr++ = MGAPACKCOLOR8888(src[0],src[0],src[0], 255);
				   src += 1;
			    }
				 src += stride;
		     }
			  break;
			case GL_INTENSITY:
 	        src = (hwUI8 *)image->Data + (  y * image->Width + x );
			  stride = (image->Width - width);
		     for ( i = height ; i ; i-- ) {
			    for ( j = width ; j ; j-- ) {
			
				   *destPtr++ = MGAPACKCOLOR8888(src[0],src[0],src[0],src[0]);
				   src += 1;
			    }
				 src += stride;
		     }
			  break;
			case GL_ALPHA:
 	        src = (hwUI8 *)image->Data + ( y * image->Width + x );
			  stride = (image->Width - width);
		     for ( i = height ; i ; i-- ) {
			    for ( j = width ; j ; j-- ) {
			
				   *destPtr++ = MGAPACKCOLOR8888(255,255,255,src[0]);
				   src += 1;
			    }
				 src += stride;
		     }
			  break;
			case GL_LUMINANCE_ALPHA:
 	        src = (hwUI8 *)image->Data + ( y * image->Width + x ) * 2;
			  stride = (image->Width - width) * 2;
		     for ( i = height ; i ; i-- ) {
			    for ( j = width ; j ; j-- ) {
			
				   *destPtr++ = MGAPACKCOLOR8888(src[0],src[0],
						       src[0],src[1]);
				   src += 2;
			    }
				 src += stride;
		     }
			  break;
			default:
			  goto format_error;
		 }
		 break;
	  default:
		 goto format_error;
	}

	return;

format_error:

		hwError( "Unsupported texelBytes %i, image->Format %i\n", 
			  texelBytes, image->Format );
}
