
/*
 * GLX Server Extension
 * Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
 * Copyright (C) 1998, 1999 Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * STEVEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/* TODO:
 - destroy context should not destroy until the context is made uncurrent
 - pixmaps
 */

#include "extnsionst.h"
#include "dixstruct.h"
#include "scrnintstr.h"
#include "pixmapstr.h"
#include "windowstr.h"
#include "GL/GLXproto.h"
#include "xsmesaP.h"
#include "xsmesa.h"
#include "config.h"
#include "glx_log.h"
#include "glx_config.h"
#include "glxcmds.h"
#include "glxrender.h"
#include "glxdecode.h"
#include "fontstruct.h"
#include "servermd.h"
#include "glxvisual.h"
#include <stdio.h>
#include <unistd.h>

#include "glx_macros.h"
#include "glx_clients.h"
#include "glx_dispatch.h"
#include "xf86Version.h"
#include "GL/xmesa.h"

#include <assert.h>
#include <signal.h>

#ifdef HAVE_FLOATINGPOINT_H
#include <floatingpoint.h>
#endif

RESTYPE glContexts;
RESTYPE glPixmaps;
RESTYPE glWindows;
RESTYPE glxClients;

#ifdef XFree86LOADER
#include "xf86_libc.h"
#endif

#ifdef HW_ACCEL
#include <vga.h>
#include "../hwglx/glx_init.h"
#include "common/xf86.h"
unsigned int glx_chipset = SOFTWARE_MODE;
#endif

extern XSMesaVisual GLfind_vis(VisualID vid);

GLX_PROCS GLXProcs;

static int ServerMesaDispatch(register ClientPtr client);
static int ServerMesaDispatch_swapped(register ClientPtr client);
static void ServerMesaReset(ExtensionEntry* extEntry)
{
    log_finish();
    glx_freeconfig();
    ErrorF("%s Extension Reset called!\n", GLX_EXTENSION_NAME);
}

int GLDestroyMesaContext(pointer value, XID id)
{
    XSMesaContext ctx;
    fprintf(stderr, "destroying a context\n");
    ctx=(XSMesaContext)value;
    log_print(LOG_ALWAYS, "Destroying context\n");
    GLXProcs.DestroyContext(ctx);
    return 0;
}

int GLDestroyMesaBuffer(pointer value, XID id)
{
    XSMesaBuffer buf=(XSMesaBuffer)value;
    fprintf(stderr, "destroying a buffer\n");
    log_print(LOG_ALWAYS, "Destroying buffer\n");
    GLXProcs.DestroyBuffer(buf);
    return 0;
}

int GLDestroyGLXClients(pointer value, XID id)
{

    fprintf(stderr, "destroying a client: %u!\n", (unsigned int) id);
    log_print(LOG_ALWAYS, "destroy client\n");

    __glXRemoveClient((int)value);
    /* xfree(client); */
    return 0;
}

static int GLNoDriverPrivates( ClientPtr client,
			       XSMesaContext ctx,
			       xGLXVendorPrivateReq *stuff )
{
   ErrorF("GLNoDriverPrivates");
   return GLXUnsupportedPrivateRequest;
}


static int GLDenyDirect( ClientPtr client )
{
   return 0;
}

static void GLFrontBufferAlwaysUpToDate( DrawablePtr b )
{
}


static void (*OldSignalHandler)(int);

void
glxSignalHandler(int sig)
{
   /* clean up any logging before dying */
   log_print(LOG_ALWAYS, "Caught signal %d\n", sig);
   log_finish();
   OldSignalHandler(sig);
}

void
glxInitLogs() {
   fprintf(stderr, "Initializing logs\n");

   /* set up logging capabilities */
   if (set_log_file("/var/log/glx_debug.log")) {
      fprintf(stderr, "glX Error: error setting log file\n");
   }
   log_initialize();
   log_print(LOG_ALWAYS, "OpenGL/GLX Extension log file\n");

   /* Install signal handler */
   /* Which signals else do we need?  -Wittawat */
   /* stolen from mga/g200 driver */
   OldSignalHandler = signal(SIGSEGV,glxSignalHandler);
   if (OldSignalHandler == SIG_ERR) {
      log_print(LOG_ALWAYS, "Could not install signal handler!\n");
      ErrorF("GLX: couldn't install signal handler!\n");
   }

   /* log some configuration information */
   log_print(LOG_ALWAYS, "Configuration info:\n");
#ifdef MESA31
   log_print(LOG_ALWAYS, "Mesa: 3.1 v.%d\n", MESA_VERSION);
#else
   log_print(LOG_ALWAYS, "Mesa: 3.0\n");
#endif
#ifdef HW_ACCEL
#ifdef MGA
   log_print(LOG_ALWAYS, "Hardware accelerated: mga\n");
#endif /* MGA */
#ifdef TNT
   log_print(LOG_ALWAYS, "Hardware accelerated: tnt\n");
#endif  /* TNT */
#ifdef MACH64
   log_print(LOG_ALWAYS, "Hardware accelerated: mach64\n");
#endif  /* MACH64 */
   if(glx_getint("nohw")){
     log_print(LOG_ALWAYS, "Forced to software mode\n");
   }
#else /* HW_ACCEL */
   log_print(LOG_ALWAYS, "Software only\n");
#endif /* HW_ACCEL */
#ifdef USE_X86_ASM
   log_print(LOG_ALWAYS, "Compiled with x86 assembly support\n");
#endif
#ifdef USE_MMX_ASM
   log_print(LOG_ALWAYS, "Compiled with MMX assembly support\n");
#endif
#ifdef USE_3DNOW_ASM
   log_print(LOG_ALWAYS, "Compiled with 3dNow! assembly support\n");
#endif
   log_print(LOG_ALWAYS, "End Configuration info\n");
   log_flush();
}

void GlxExtensionInit()
{
    ExtensionEntry* extEntry;

#ifdef __FreeBSD__
    fpsetmask(0); /* put the FPU in IEEE mode (mask all exceptions) */
#endif

    if(glx_readconf(GLXCONF) == CONFIG_FATAL){
      FatalError("An error occured while parsing %s\n", GLXCONF);
    }

    glxInitLogs();

    glContexts = CreateNewResourceType(GLDestroyMesaContext);
    glWindows  = CreateNewResourceType(GLDestroyMesaBuffer);
    glPixmaps  = CreateNewResourceType(GLDestroyMesaBuffer);
    glxClients = CreateNewResourceType(GLDestroyGLXClients);

    extEntry = AddExtension(GLX_EXTENSION_NAME, GLX_NUMBER_EVENTS,
			    GLX_NUMBER_ERRORS, ServerMesaDispatch,
			    ServerMesaDispatch_swapped, ServerMesaReset,
			    StandardMinorOpcode);

    if( !extEntry ) {
       ErrorF("GlxExtensionInit(): AddExtension() failed\n" );
       return;
    }

    __glxErrorBase = extEntry->errorBase;
    __glxReqBase   = extEntry->base;
    __glxEventBase = extEntry->eventBase;

    /*
     * Set default XSMesa procs.
     */
    GLXProcs.CreateVisual       = XSMesaCreateVisual;
    GLXProcs.DestroyVisual      = XSMesaDestroyVisual;
    GLXProcs.CreateContext      = XSMesaCreateContext;
    GLXProcs.DestroyContext     = XSMesaDestroyContext;
    GLXProcs.MakeCurrent        = XSMesaMakeCurrent;
    GLXProcs.CopyContext        = XSMesaCopyContext;
    GLXProcs.CreateWindowBuffer = XSMesaCreateWindowBuffer;
    GLXProcs.CreatePixmapBuffer = XSMesaCreatePixmapBuffer;
    GLXProcs.DestroyBuffer      = XSMesaDestroyBuffer;
    GLXProcs.BindBuffer         = XSMesaBindBuffer;
    GLXProcs.FindBuffer         = XSMesaFindBuffer;
    GLXProcs.SwapBuffers        = XSMesaSwapBuffers;
    GLXProcs.GetBackBuffer      = XSMesaGetBackBuffer;
    GLXProcs.GetDepthBuffer     = XSMesaGetDepthBuffer;
    GLXProcs.GetCurrentContext  = XSMesaGetCurrentContext;
    GLXProcs.GetCurrentBuffer   = XSMesaGetCurrentBuffer;
    GLXProcs.FeedbackBuffer     = XSMesaFeedbackBuffer;
    GLXProcs.SelectionBuffer    = XSMesaSelectionBuffer;
    GLXProcs.GetPixel           = GLXGetPixel;
    GLXProcs.PutPixel           = GLXPutPixel;
    GLXProcs.DestroyImage       = GLXDestroyImage;
    GLXProcs.CreateImage        = GLXCreateImage;
    GLXProcs.GetDepth           = GLXGetDepth;
    GLXProcs.PutDepth           = GLXPutDepth;
    GLXProcs.CreateDepthBuffer  = GLXCreateDepthBuffer;
    GLXProcs.VendorPrivate      = GLNoDriverPrivates;
    GLXProcs.AllowDirect        = GLDenyDirect;
    GLXProcs.ValidateFrontBuffer = GLFrontBufferAlwaysUpToDate;


    /*
     * Allow hardware drivers to hook into GLX.
     */
#ifdef HW_ACCEL
    if (!glx_getint("nohw")) {
        extern GLboolean (*hwInitGLX)();
#ifndef MACH64
        GLboolean hw_flag = GL_FALSE;
        extern ScrnInfoRec vga256InfoRec;
        if (vga256InfoRec.chipset) {
           log_print(LOG_TRACE, "Looking for chipset %s\n",
                     vga256InfoRec.chipset);
           /* need to add check for g400? */
           if (!strcmp("mgag400", vga256InfoRec.chipset)) {
              glx_chipset = MGA_G400;
              log_print(LOG_TRACE, "Found G400!\n");
#ifdef BUILD_UNIFIED
              hwInitGLX = mgaInitGLX();
              hwInitVisuals = NULL;
#endif
           } else
           if (!strcmp("mgag200", vga256InfoRec.chipset)) {
              hw_flag = GL_TRUE;
              glx_chipset = MGA_G200;
              log_print(LOG_TRACE, "Found G200!\n");
#ifdef BUILD_UNIFIED
              hwInitGLX = mgaInitGLX();
              hwInitVisuals = NULL;
#endif
           } else
           if ( /* XFree86 3.3.3.1 */
                (!strcmp("RIVA128",  vga256InfoRec.chipset)) ||
                (!strcmp("RIVATNT",  vga256InfoRec.chipset)) ||
                (!strcmp("RIVATNT2", vga256InfoRec.chipset)) ||

                /* XFree86 3.3.4 */
                (!strcmp("RIVA 128",         vga256InfoRec.chipset)) ||
                (!strcmp("RIVA TNT",         vga256InfoRec.chipset)) ||
                (!strcmp("RIVA TNT2",        vga256InfoRec.chipset)) ||
                (!strcmp("RIVA ULTRA TNT2",  vga256InfoRec.chipset)) ||
                (!strcmp("RIVA VANTA",       vga256InfoRec.chipset)) ||
                (!strcmp("RIVA ULTRA VANTA", vga256InfoRec.chipset)) ||
                (!strcmp("RIVA INTEGRATED",  vga256InfoRec.chipset)) )  {
              hw_flag = GL_TRUE;
              /* XXX - may need to select correct one */
              glx_chipset = NV_RIVATNT;
              log_print(LOG_TRACE, "Found Riva chipset!\n");
#ifdef BUILD_UNIFIED
              hwInitGLX = nvInitGLX();
              hwInitVisuals = nvInitVisuals;
#endif 
           } else
	   if ( !strcmp("i810", vga256InfoRec.chipset) ||
		!strcmp("i810e", vga256InfoRec.chipset) ||
		!strcmp("i810-dc100", vga256InfoRec.chipset) 	    
	      ) 
	   {
              hw_flag = GL_TRUE;
              glx_chipset = I_810;
              log_print(LOG_TRACE, "Found Intel i810!\n");
#ifdef BUILD_UNIFIED
              hwInitGLX = i810InitGLX();
              hwInitVisuals = NULL;
#endif
	   } 
        } 
#else
	/*
	 * We need to make sure the module will load into XF86_Mach64, and
	 * thus we have to be careful about missing symbols.  All the above
	 * initialization won't work with the Mach64 server.
	 */
	glx_chipset = ATI_RAGEPRO;
	log_print(LOG_TRACE, "Default to Rage Pro!\n");
#endif
        if (glx_chipset == SOFTWARE_MODE) {
	   log_print(LOG_ALWAYS, "Can't determine chipset, ");
	   log_print(LOG_ALWAYS, "forcing software mode fallbacks!!\n");
        } else {
           if (hwInitGLX) (*hwInitGLX)();
        }
    }
#else
    log_print(LOG_ALWAYS, "GLX built without hardware support\n");
#endif

    log_flush();
    GLFinalizeVisuals();
    __glXInitClients();
}

static int ServerMesaDispatch(register ClientPtr client)
{
    __glxClient *clientPtr = NULL;
    __glx_dispatch_proc dispatch_proc = NULL;
    int status = 0;
    REQUEST(xReq);

    clientPtr = __glXFindClient(client->index);
    if (clientPtr == NULL) {
       clientPtr = __glXAddClient(client);
       if (clientPtr == NULL) return BadAlloc;
    }

    log_print(LOG_TRACE, "glx op: %@\n", stuff->data);

    dispatch_proc = __glx_dispatch_table[stuff->data];
    status = (*dispatch_proc)(client);

    log_print(LOG_TRACE, "glxop %@ done.\n", stuff->data);

    return status;
}

static int ServerMesaDispatch_swapped(register ClientPtr client)
{
    __glxClient *clientPtr = NULL;
    __glx_dispatch_proc dispatch_proc = NULL;
    int status = 0;
    REQUEST(xReq);

    clientPtr = __glXFindClient(client->index);
    if (clientPtr == NULL) {
       clientPtr = __glXAddClient(client);
       if (clientPtr == NULL) return BadAlloc;
    }

    log_print(LOG_TRACE, "glx op: %@\n", stuff->data);

    /** Currently, only Render and RenderLarge have _swapped versions **/
    /** Eventually, all of them should have duplicate versions **/

    if (stuff->data < 3) {
       if (stuff->data == 1) {
          return GLRender_swapped(client);
       }
       if (stuff->data == 2) {
          return GLRenderLarge_swapped(client);
       }
       return GLnoop(client);
    }
    dispatch_proc = __glx_dispatch_table[stuff->data];
    status = (*dispatch_proc)(client);

    log_print(LOG_TRACE, "glxop %@ done.\n", stuff->data);

    return status;
}

int GLXDecodeInvalid(int length, char* data)
{
    ErrorF("2. INCOMPLETE: %d, length=%d\n", *(short*)(data-2), length);
    return Success;
}

#if defined( DYNAMIC_MODULE ) || defined( XFree86LOADER )

extern Bool GlxInitVisuals(
    VisualPtr *         /*visualp*/,
    DepthPtr *          /*depthp*/,
    int *               /*nvisualp*/,
    int *               /*ndepthp*/,
    int *               /*rootDepthp*/,
    VisualID *          /*defaultVisp*/,
    unsigned long       /*sizes*/,
    int                 /*bitsPerRGB*/
);

/*
 * Entry point of dynamic loading
 */
extern void (*GlxExtensionInitPtr)(void);

extern Bool (*GlxInitVisualsPtr)(
    VisualPtr *         /*visualp*/,
    DepthPtr *          /*depthp*/,
    int *               /*nvisualp*/,
    int *               /*ndepthp*/,
    int *               /*rootDepthp*/,
    VisualID *          /*defaultVisp*/,
    unsigned long       /*sizes*/,
    int                 /*bitsPerRGB*/
);

#endif

#ifdef DYNAMIC_MODULE

int
#ifndef DLSYM_BUG
init_module(server_version)
#else
init_glx(server_version)
#endif
unsigned long server_version;
{

   GlxExtensionInitPtr = GlxExtensionInit;
   GlxInitVisualsPtr   = GlxInitVisuals;

   if (set_log_file("/var/log/glx_debug.log")) {
      fprintf(stderr, "glX Error: error setting log file\n");
   }
   log_initialize();
   log_print(LOG_TRACE,"Log initialized");

#if defined(MESA_MAJOR_VERSION) && defined(MESA_MINOR_VERSION)
  ErrorF(
     "\t%s extension module for XFree86%s-- Mesa version %d.%d\n\t\tGLX package version %s, GLX protocol version %s.\n",
     GLX_EXTENSION_NAME, XF86_VERSION,
     MESA_MAJOR_VERSION, MESA_MINOR_VERSION,
     GLX_PACKAGE_VERSION, GLX_PROTOCOL_VERSION
  );
#else
  ErrorF(
     "\t%s extension module for XFree86%s--\n\t\tGLX package version %s, GLX protocol version %s.\n",
     GLX_EXTENSION_NAME, XF86_VERSION,
     GLX_PACKAGE_VERSION, GLX_PROTOCOL_VERSION
  );
#endif

  return 1;
}
#endif /* DYNAMIC_MODULE */

#ifdef XFree86LOADER

#include "xf86.h"
#include "xf86_ldext.h"
#include "xf86Version.h"

ExtensionModule glxExt = {
    GlxExtensionInit,
    GLX_EXTENSION_NAME,
    NULL};

void
libglxModuleInit(data,magic)
    pointer     * data;
    INT32       * magic;
{
    static int cnt = 0;

#if defined(MESA_MAJOR_VERSION) && defined(MESA_MINOR_VERSION)
    ErrorF(
       "\t%s extension module for XFree86%s-- Mesa version %d.%d\n\t\tGLX package version %s, GLX protocol version %s.\n",
       GLX_EXTENSION_NAME, XF86_VERSION,
       MESA_MAJOR_VERSION, XMESA_MINOR_VERSION,
       GLX_PACKAGE_VERSION, GLX_PROTOCOL_VERSION
    );
#else
    ErrorF(
       "\t%s extension module for XFree86%s--\n\t\tGLX package version %s, GLX protocol version %s.\n",
       GLX_EXTENSION_NAME, XF86_VERSION,
       GLX_PACKAGE_VERSION, GLX_PROTOCOL_VERSION
    );
#endif

    switch(cnt++)
    {
    case 0:
        *magic = MAGIC_LOAD_EXTENSION;
        * data = (pointer) &glxExt;
        break;
    case 1:
        *magic = MAGIC_GLX_VISUALS_INIT;
        * data = (pointer) GlxInitVisuals;
        break;
    default:
        *magic= MAGIC_DONE;
        break;
    }
    return;
}
#endif /* XFree86LOADER */
