
#
# GLX Server Extension
# Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
# Copyright (C) 1998, 1999  Terence Ripperda (ripperda@sgi.com)
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# STEVEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR 
# ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
# AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

proc splitit {data} {
    global number args decode swap_decode name 
    global encodeproto encode_nogen decode_nogen
    foreach t $data {
	set tname [lindex $t 0]
	set tnumber [lindex $t 1]
	set targs [lindex $t 2]
	set args($tname) $targs
	set number($tname) $tnumber
	if {![info exists name($tnumber)]} {
	    set name($tnumber) $tname
	}
	for {set i 3} {$i < [llength $t]} {incr i 2} {
	    set what [lindex $t $i]
	    if {$what == "swap_decode"} {
		set swap_decode($tname) [lindex $t [expr $i+1]]
	    } elseif {$what == "decode"} {
		set decode($tname) [lindex $t [expr $i+1]]
	    } elseif {$what == "encodeproto"} {
		set encodeproto($tname) [lindex $t [expr $i+1]]
	    } elseif {$what == "encode_nogen"} {
		set encode_nogen($tname) [lindex $t [expr $i+1]]
	    } elseif {$what == "decode_nogen"} {
		set decode_nogen($tname$tnumber) [lindex $t [expr $i+1]]
	    } else {
		puts "unknown optional..."
		exit 1
	    }
	}
    }
}

proc GLsizeof {type} {
    if {$type == "float"} {
	return 4
    } elseif {$type == "enum"} {
	return 4
    } elseif {$type == "bitfield"} {
	return 4
    } elseif {$type == "double"} {
	return 8
    } elseif {$type == "uint"} {
	return 4
    } elseif {$type == "int"} {
	return 4
    } elseif {$type == "boolean"} {
	return 1
    } elseif {$type == "short"} {
	return 2
    } elseif {$type == "ushort"} {
	return 2
    } elseif {$type == "byte"} {
	return 1
    } elseif {$type == "ubyte"} {
	return 1
    } elseif {$type == "void*"} {
	return 1
    } else {
	puts "NEED TYPE: $type"
	exit
    }
}

proc swapname {type} {
    if {$type == "float"} {
	return swapl
    } elseif {$type == "enum"} {
	return swapl
    } elseif {$type == "bitfield"} {
	return swapl
    } elseif {$type == "double"} {
	return swapd
    } elseif {$type == "uint"} {
	return swapl
    } elseif {$type == "int"} {
	return swapl
    } elseif {$type == "boolean"} {
	return none
    } elseif {$type == "short"} {
	return swaps
    } elseif {$type == "ushort"} {
	return swaps
    } elseif {$type == "byte"} {
	return none
    } elseif {$type == "ubyte"} {
	return none
    } elseif {$type == "void*"} {
	return none
    } else {
	puts "NEED TYPE: $type"
	exit
    }
}

proc gen_decode {} {
    set f [open glxdecode.c "w"]
    puts $f "#include <stdio.h>"
    puts $f "#include \"glxrender.h\""
    puts $f "#include \"glx_swap.h\""
    puts $f "#include \"glxdecode.h\""
    puts $f "#include \"glxcommon.h\""
    puts $f "#include \"misc.h\""
    puts $f "#include \"glx_log.h\""
    puts $f "#include \"glx_varray.h\""
    puts $f "GLXRenderFunc GLX_render_funcs\[\] = \{"
    global number name args decode_nogen
    set nums [lsort -integer [array names name]]
    set last 0
    foreach num $nums {
	for {} {$last<$num} {incr last} {
	    puts $f "\tGLXDecodeInvalid, /* $last */"
	}
	puts $f "\tGLXDecode$name($num), /* $num */"
	incr last
    }
    puts $f "\};"
    puts $f ""
    foreach n $nums {
	set nm $name($n)
        if {[info exists decode_nogen($nm$n)]} {
            continue
        }
	if {!([info exists decode($nm)] && $decode($nm) == "-")} {
	    puts $f "int GLXDecode$nm\(int length, char* data\)"
	    puts $f "\{"
            puts $f "\tint expected_length = 0;\n"
	    set offset 0
            set have_offset_other 0
	    set offset_other ""
	    foreach t $args($nm) {
		set type [lindex $t 0]
		set aname [lindex $t 1]

		if {[llength $t] == 2} {
                    if { ![string match unused* $aname] } {
		       puts -nonewline $f "\tGL$type $aname = GET_$type\(data+$offset"
                       if { $have_offset_other != 0 } {
                          puts $f "$offset_other\);"
                       } else {
		          puts $f "\);"
                       }
                    }
		    incr offset [GLsizeof $type]
		} else {
                    if { ![string match unused* $aname] } {
		       puts -nonewline $f "\tGL$type* $aname = (GL$type*)(data+$offset"
                       if { $have_offset_other != 0 } {
                          puts $f "$offset_other\);"
                       } else {
		          puts $f "\);"
                       }
                    }
		    set nt [lindex $t 2]
		    if {[string match "\[0-9\]\[0-9\]" $nt] || [string match "\[0-9\]" $nt]} {
			incr offset [expr $nt*[GLsizeof $type]]
		    } else {
                        set have_offset_other 1
			append offset_other "+([GLsizeof $type]*$nt)"
		    }
		}
	    }

            puts $f "\texpected_length = $offset$offset_other;"

	    puts $f "\tif(length != GLX_pad(expected_length)){"
	    puts $f "\t\tfprintf(stderr, \"Bad length in $nm (have %d, wanted %d)\\n\", length, expected_length);"
            # quick hack to print more about TexImage2D length error
	    foreach t $args($nm) {
		set aname [lindex $t 1]
                if { [ string match "target" $aname ] || 
                     [ string match "format" $aname ] ||
                     [ string match "type" $aname ] } {
                   puts $f "\t\tErrorF(\"$aname: 0x%x\\n\", $aname);"
                } elseif {
                     [ string match "width" $aname ] ||
                     [ string match "height" $aname ] } {
                   puts $f "\t\tErrorF(\"$aname: %d\\n\", $aname);"
                }
            }
	    puts $f "\t\treturn GLXBadRenderRequest;"
	    puts $f "\t}"
	    global decode
	    if {[info exists decode($nm)]} {
		puts $f "\t$decode($nm)"
	    } else {
		puts -nonewline $f "\tgl$nm\("
		set first 1
		foreach t $args($nm) {
		    if {[string first unused $t] == -1} {
			if {!$first} {
			    puts -nonewline $f ", "
			} else {
			    set first 0
			}
			set aname [lindex $t 1]
			puts -nonewline $f $aname
		    }
		}
		puts $f "\);"
	    }
	    #puts $f "\tfprintf(stderr, \"$nm\\n\");"
	    puts $f "\treturn Success;"
	    puts $f "\}"
	    puts $f ""
	}
    }
    close $f

    set f [open glxdecode.h "w"]
    puts $f "#ifndef GLXRENDER_DECODE_H"
    puts $f "#define GLXRENDER_DECODE_H"
    puts $f ""
    puts $f "#define GLX_MAX_RENDER_OPCODE [lrange $nums end end]"
    puts $f ""
    foreach n $nums {
	puts $f "int GLXDecode$name($n)(int length, char* data);"
    }
    puts $f "#endif"
    puts $f ""
    close $f
}

proc swap_function { data_type } {
    if {$data_type == "float"} {
	return swapl
    } elseif {$data_type == "enum"} {
	return swapl
    } elseif {$data_type == "bitfield"} {
	return swapl
    } elseif {$data_type == "double"} {
	return swapd
    } elseif {$data_type == "uint"} {
	return swapl
    } elseif {$data_type == "int"} {
	return swapl
    } elseif {$data_type == "boolean"} {
	return 0
    } elseif {$data_type == "short"} {
	return swaps
    } elseif {$data_type == "ushort"} {
	return swaps
    } elseif {$data_type == "byte"} {
	return 0
    } elseif {$data_type == "ubyte"} {
	return 0
    } elseif {$data_type == "void*"} {
	return 0
    } else {
	puts "NEED TYPE: $data_type"
	exit
    }
}

proc gen_decode_swapped { } {
    set sf [open glxdecode_swapped.c "w"]
    puts $sf "#include <stdio.h>"
    puts $sf "#include \"glxrender.h\""
    puts $sf "#include \"glx_swap.h\""
    puts $sf "#include \"glxdecode.h\""
    puts $sf "#include \"glxdecode_swapped.h\""
    puts $sf "#include \"glxcommon.h\""
    puts $sf "#include \"misc.h\""
    puts $sf "#include \"glx_log.h\""
    puts $sf "#include \"glx_varray.h\""
    puts $sf "GLXRenderFunc GLX_render_funcs_swapped\[\] = {"
    global number name args decode_nogen
    set nums [lsort -integer [array names name]]
    set last 0
    foreach num $nums {
	for {} {$last<$num} {incr last} {
	    puts $sf "\tGLXDecodeInvalid, /* $last */"
	}
        set function_name "GLXDecode"
        append function_name $name($num)
        append function_name "_swapped"
	puts $sf "\t$function_name, /* $num */"
	incr last
    }
    puts $sf "};"
    puts $sf ""
    foreach n $nums {
	set nm $name($n)
        if {[info exists decode_nogen($nm$n)]} {
            continue
        }
	if {!([info exists decode($nm)] && $decode($nm) == "-")} {
            set function_name "GLXDecode"
            append function_name $nm
            append function_name "_swapped"
	    puts $sf "int $function_name\(int length, char* data\)"
	    puts $sf "{"
            puts $sf "\tint expected_length = 0;\n"
	    set offset 0
            set byteswap 0
            set need_swap_var 0
            set have_offset_other 0
	    set offset_other ""

            # declare and set all variables, we'll come back to swap them
	    foreach t $args($nm) {
               set type [lindex $t 0]
               set aname [lindex $t 1]

               # if the byte_swap variable exists, it needs to be inverted.
               if { [ string match swap_bytes $aname ] } {
                  set byteswap 1
               }
               if {[llength $t] == 2} {
                  if { ![string match unused* $aname] } {
                     if { $have_offset_other == 0 } {
                        puts $sf "\tGL$type $aname = GET_$type\(data+$offset\);"
                     } else {
                        puts $sf "\tGL$type $aname;"
                     }
                     set need_swap_var 1
                  }
                  incr offset [GLsizeof $type]
               } else {
                  if { ![string match unused* $aname] } {
                     if { $have_offset_other == 0 } {
                        puts $sf "\tGL$type* $aname = \(GL$type*\)\(data+$offset\);"
                     } else {
                       puts $sf "\tGL$type* $aname;"
                     }
                   }
		   set nt [lindex $t 2]
		   if {[string match "\[0-9\]\[0-9\]" $nt] || \
                       [string match "\[0-9\]" $nt]} {
		      incr offset [expr $nt*[GLsizeof $type]]
		   } else {
                      set have_offset_other 1
		   }
               }
            }

            # check which swapping variables we need
            if { $need_swap_var != 0 } {
	       puts $sf "\tregister int _n = 0;"
            }

            # now go through and swap any larger than a byte
            set offset 0
            set have_offset_other 0
            set offset_other ""
            set format 0
	    foreach t $args($nm) {
                set swapfunc 0
		set type [lindex $t 0]
		set aname [lindex $t 1]
		if {[llength $t] == 2} {
                  if { ![string match unused* $aname] } {
                     set swapfunc [ swap_function $type ] 
                     if { $swapfunc != 0 } {
                        puts $sf "\t$swapfunc\(&$aname, _n\);"
                     }
                  }
                  incr offset [GLsizeof $type]
		} else {
                  # don't swap this data, but make sure the pointers
                  # are correct, since they rely on swapped variables
		   set nt [lindex $t 2]
                  if { ![ string match unused* $aname ] } {
                     if { $have_offset_other == 0 } {
                       set swap_size [GLsizeof $type]
                       if { $swap_size == 8 } {
                          puts $sf "\tGLX_swapd_array($nt, \(double *\)$aname);"
                       } elseif { $swap_size == 4 } {
                          puts $sf "\tGLX_swapl_array($nt, \(GLuint *\)$aname);"
                       } elseif { $swap_size == 2 } {
                          puts $sf "\tGLX_swaps_array($nt, \(short *\)$aname);"
                       }
                     } else {
                       puts $sf "\t$aname = \(GL$type*\)"
                       puts $sf "\(data+$offset$offset_other\);"
                     } 
                  }
		   if {[string match "\[0-9\]\[0-9\]" $nt] || \
                       [string match "\[0-9\]" $nt]} {
		      incr offset [expr $nt*[GLsizeof $type]]
		   } else {
                      set have_offset_other 1
                      append offset_other "+([GLsizeof $type]*$nt)"
		   }
                }
	    };  # foreach t

            puts $sf "\texpected_length = $offset$offset_other;"

	    puts $sf "\tif(length != GLX_pad(expected_length)){"
	    puts $sf "\t\tfprintf(stderr, \"Bad length in $nm (have %d, wanted %d)\\n\", length, expected_length);"
            # quick hack to print more about TexImage2D length error
	    foreach t $args($nm) {
		set aname [lindex $t 1]
                if { [ string match "target" $aname ] || 
                     [ string match "format" $aname ] ||
                     [ string match "type" $aname ] } {
                   puts $sf "\t\tErrorF(\"$aname: 0x%x\\n\", $aname);"
                } elseif {
                     [ string match "width" $aname ] ||
                     [ string match "height" $aname ] } {
                   puts $sf "\t\tErrorF(\"$aname: %d\\n\", $aname);"
                }
            }
	    puts $sf "\t\treturn BadLength;"
	    puts $sf "\t}"

            if { $byteswap != 0 } {
               puts $sf "\tswap_bytes = !swap_bytes;"
            }

	    global decode swap_decode
            if {[info exists swap_decode($nm)]} { 
		puts $sf "\t$swap_decode($nm)"
            } elseif {[info exists decode($nm)]} { 
		puts $sf "\t$decode($nm)"
	    } else {
		puts -nonewline $sf "\tgl$nm\("
		set first 1
		foreach t $args($nm) {
		    if {[string first unused $t] == -1} {
			if {!$first} {
			    puts -nonewline $sf ", "
			} else {
			    set first 0
			}
			set aname [lindex $t 1]
			puts -nonewline $sf $aname
		    }
		}
		puts $sf "\);"
	    }
	    puts $sf "\treturn Success;"
	    puts $sf "}"
	    puts $sf ""
	}
    }
    close $sf

    set sf [open glxdecode_swapped.h "w"]
    puts $sf "#ifndef GLXRENDER_DECODE_SWAPPED_H"
    puts $sf "#define GLXRENDER_DECODE_SWAPPED_H"
    puts $sf ""
    foreach n $nums {
        set function_name "GLXDecode"
        append function_name $name($n)
        append function_name "_swapped"
	puts $sf "int $function_name\(int length, char* data);"
    }
    puts $sf "#endif"
    puts $sf ""
    close $sf
}

source $argv

splitit $GLcalls
gen_decode
gen_decode_swapped
