 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-1999 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-1999 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/

#include <stdlib.h>

/*
 * X includes.
 */
#include "X.h"
#include "Xproto.h"
#include "windowstr.h"
/*
 * Mesa includes.
 */
#include "context.h"
#include "depth.h"
#include "macros.h"
#include "texstate.h"
#include "triangle.h"
#include "vb.h"
#include "types.h"
/*
 * GLX includes.
 */
#include "xsmesaP.h"
#include "glx_log.h"
/*
 * Riva includes.
 */
#include "riva_glx.h"







/*
 * Get the color of a vertex.
 */
#define RivaColor(vv)                                                               \
 (((GLuint)VB->VBCOLOR[vv][0]) << 16)                                                 \
|(((GLuint)VB->VBCOLOR[vv][1]) << 8)                                                  \
|(((GLuint)VB->VBCOLOR[vv][2]))                                                       \
|(((GLuint)VB->VBCOLOR[vv][3]) << 24)                                                 \
|rivaContext.modeMask

/*
 * Compute the fog value for a given distance in eye corrdinates. Taken from Mesa.
 */
static GLint RivaFog
(
    GLcontext *ctx,
    GLfloat    z
)
{
    GLfloat d, f;
    GLuint  fog;

    switch (ctx->Fog.Mode)
    {
        case GL_LINEAR:
            d = 1.0F / (ctx->Fog.End - ctx->Fog.Start);
            f = (ctx->Fog.End - z) * d;
            f = CLAMP(f, 0.0F, 1.0F) * 255.0F;
            break;
        case GL_EXP:
            d = -ctx->Fog.Density;
            f = exp(d * z);
            f = CLAMP(f, 0.0F, 1.0F) * 255.0F;
            break;
        case GL_EXP2:
            d = -(ctx->Fog.Density*ctx->Fog.Density);
            f = exp(d * z*z);
            f = CLAMP(f, 0.0F, 1.0F) * 255.0F;
            break;
        default:
            f = 0.0F;
    }
    RivaFloatToUInt(fog, f);
    return ((fog << 24) ^ 0xFF000000);
}
/*
 * Mesa acceleration for rasterizing 3D primitives.
 */
void RivaPointsNOP
(
    GLcontext *ctx,
    GLuint first,
    GLuint last
)
{
    
}
void RivaPoints3D
(
    GLcontext *ctx,
    GLuint first,
    GLuint last
)
{
    int                   nclipRects, clipped;
    BoxPtr                pclipRect;
    BoxRec                intersectRect, boundRect;
    GLfloat               x, y, z, s, t;
    GLuint                pv, argb, fog;
    struct vertex_buffer *VB        = ctx->VB;
    XSMesaContext         xsmesa    = (XSMesaContext) ctx->DriverCtx;
    WindowPtr             pwin      = (WindowPtr)(xsmesa->xsm_buffer->frontbuffer);
    GLfloat               winOrgX   = (GLfloat)(pwin->drawable.x) - rivaContext.xyAdjust;
    GLfloat               winOrgY   = (GLfloat)(pwin->drawable.y + pwin->drawable.height) - rivaContext.xyAdjust;
    GLfloat               pointSize = ctx->Point.Size * 0.75;
    
    /*
     * Get window clip rects.
     */
    if (pwin->clipList.data)
    {
        if (pwin->clipList.data->numRects == 0)
            return;
        else if (rivaContext.SimpleClip)
        {
            nclipRects = 1;
            pclipRect  = &pwin->clipList.extents;
        }
        else
        {
            nclipRects = pwin->clipList.data->numRects;
            pclipRect  = (BoxPtr)(pwin->clipList.data + 1);
        }
    }
    else
    {
        nclipRects = 1;
        pclipRect  = &pwin->clipList.extents;
    }
    /*
     * Iterate through all clip rects.
     */
    clipped = FALSE;
    while (nclipRects--)
    {
        /*
         * Iterate throught all points.
         */
        for (pv = first; pv <= last; pv++)
        {
            /*
             * Get point extents.
             */
            x = winOrgX + VB->VBWIN[pv][0];
            y = winOrgY - VB->VBWIN[pv][1];
            z =           VB->VBWIN[pv][2] + ctx->PointZoffset;
            RivaFloatToInt(boundRect.x1, x - pointSize);
            RivaFloatToInt(boundRect.x2, x + pointSize);
            RivaFloatToInt(boundRect.y1, y - pointSize);
            RivaFloatToInt(boundRect.y2, y + pointSize);
            /*
             * Intersect line bounds with clip rect.
             */
            intersectRect.x1 = max(pclipRect->x1, boundRect.x1);
            intersectRect.y1 = max(pclipRect->y1, boundRect.y1);
            intersectRect.x2 = min(pclipRect->x2, boundRect.x2);
            intersectRect.y2 = min(pclipRect->y2, boundRect.y2);
            pclipRect++;
            /*
             * Intersect with scissor clip if enabled.
             */
            if (ctx->Scissor.Enabled)
            {
                BoxRec scissor;
    
                scissor.x1 = pwin->drawable.x + ctx->Scissor.X;
                scissor.y2 = pwin->drawable.y + pwin->drawable.height - ctx->Scissor.Y;
                scissor.x2 = scissor.x1       + ctx->Scissor.Width;
                scissor.y1 = scissor.y2       - ctx->Scissor.Height;
                intersectRect.x1 = max(scissor.x1, intersectRect.x1);
                intersectRect.y1 = max(scissor.y1, intersectRect.y1);
                intersectRect.x2 = min(scissor.x2, intersectRect.x2);
                intersectRect.y2 = min(scissor.y2, intersectRect.y2);
            }
            /*
             * Set clip rect if there is a bounds-clip intersection.
             */
            if ((intersectRect.x1 != boundRect.x1)
             || (intersectRect.x2 != boundRect.x2)
             || (intersectRect.y1 != boundRect.y1)
             || (intersectRect.y2 != boundRect.y2))
            {
                /*
                 * Skip this triangle if clipped away.
                 */
                if ((intersectRect.x1 >= intersectRect.x2) || (intersectRect.y1 >= intersectRect.y2))
                   continue;
                RIVA_CLIP3D(intersectRect.x1, intersectRect.y1, 
                            intersectRect.x2, intersectRect.y2);
                clipped = TRUE;
            }
            /*
             * Send line state.
             */
            if (rivaReload3D)
            {
                rivaReload3D = 0;
                RIVA_STATE3D(rivaContext.texOffset,
                             rivaContext.texFormat, 
                             rivaContext.texFilter, 
                             rivaContext.triFogColor, 
                             rivaContext.triControl, 
                             rivaContext.triAlphaTest);
            }
            /*
             * Send point as quad.
             */
            if (ctx->Fog.Enabled && (ctx->Texture.Enabled || (ctx->Hint.Fog == GL_NICEST)))
                fog = RivaFog(ctx, VB->VBCLIP[pv][3]);
            else
                fog = 0x00000000;
            argb = RivaColor(pv);
            s = VB->TEXCOORD(0, pv, 0);
            t = VB->TEXCOORD(0, pv, 1);
            RIVA_VERTEX3D(fog|0x00000000, argb, x - pointSize, y + pointSize, z, 1.0F, s, t);
            RIVA_VERTEX3D(fog|0x00000001, argb, x - pointSize, y - pointSize, z, 1.0F, s, t);
            RIVA_VERTEX3D(fog|0x00000102, argb, x + pointSize, y - pointSize, z, 1.0F, s, t);
            RIVA_VERTEX3D(fog|0x00000203, argb, x + pointSize, y + pointSize, z, 1.0F, s, t);
        }
    }
    /*
     * Reset clip rect if needed.
     */
    if (clipped)
        RIVA_CLIP3D(0, 0, 0x7FFF, 0x7FFF);
}
void RivaAAPoints3D
(
    GLcontext *ctx,
    GLuint first,
    GLuint last
)
{
    int                   nclipRects, clipped;
    BoxPtr                pclipRect;
    BoxRec                intersectRect, boundRect;
    GLfloat               x, y, z;
    GLuint                pv, argb, fog;
    struct vertex_buffer *VB        = ctx->VB;
    XSMesaContext         xsmesa    = (XSMesaContext) ctx->DriverCtx;
    WindowPtr             pwin      = (WindowPtr)(xsmesa->xsm_buffer->frontbuffer);
    GLfloat               winOrgX   = (GLfloat)(pwin->drawable.x) - rivaContext.xyAdjust;
    GLfloat               winOrgY   = (GLfloat)(pwin->drawable.y + pwin->drawable.height) - rivaContext.xyAdjust;
    GLfloat               pointSize = ctx->Point.Size * 0.75;
    
    /*
     * Get window clip rects.
     */
    if (pwin->clipList.data)
    {
        if (pwin->clipList.data->numRects == 0)
            return;
        else if (rivaContext.SimpleClip)
        {
            nclipRects = 1;
            pclipRect  = &pwin->clipList.extents;
        }
        else
        {
            nclipRects = pwin->clipList.data->numRects;
            pclipRect  = (BoxPtr)(pwin->clipList.data + 1);
        }
    }
    else
    {
        nclipRects = 1;
        pclipRect  = &pwin->clipList.extents;
    }
    /*
     * Iterate through all clip rects.
     */
    clipped = FALSE;
    while (nclipRects--)
    {
        /*
         * Iterate throught all points.
         */
        for (pv = first; pv <= last; pv++)
        {
            /*
             * Get point extents.
             */
            x = winOrgX + VB->VBWIN[pv][0];
            y = winOrgY - VB->VBWIN[pv][1];
            z =           VB->VBWIN[pv][2] + ctx->PointZoffset;
            RivaFloatToInt(boundRect.x1, x - pointSize);
            RivaFloatToInt(boundRect.x2, x + pointSize);
            RivaFloatToInt(boundRect.y1, y - pointSize);
            RivaFloatToInt(boundRect.y2, y + pointSize);
            /*
             * Intersect line bounds with clip rect.
             */
            intersectRect.x1 = max(pclipRect->x1, boundRect.x1);
            intersectRect.y1 = max(pclipRect->y1, boundRect.y1);
            intersectRect.x2 = min(pclipRect->x2, boundRect.x2);
            intersectRect.y2 = min(pclipRect->y2, boundRect.y2);
            pclipRect++;
            /*
             * Intersect with scissor clip if enabled.
             */
            if (ctx->Scissor.Enabled)
            {
                BoxRec scissor;
    
                scissor.x1 = pwin->drawable.x + ctx->Scissor.X;
                scissor.y2 = pwin->drawable.y + pwin->drawable.height - ctx->Scissor.Y;
                scissor.x2 = scissor.x1       + ctx->Scissor.Width;
                scissor.y1 = scissor.y2       - ctx->Scissor.Height;
                intersectRect.x1 = max(scissor.x1, intersectRect.x1);
                intersectRect.y1 = max(scissor.y1, intersectRect.y1);
                intersectRect.x2 = min(scissor.x2, intersectRect.x2);
                intersectRect.y2 = min(scissor.y2, intersectRect.y2);
            }
            /*
             * Set clip rect if there is a bounds-clip intersection.
             */
            if ((intersectRect.x1 != boundRect.x1)
             || (intersectRect.x2 != boundRect.x2)
             || (intersectRect.y1 != boundRect.y1)
             || (intersectRect.y2 != boundRect.y2))
            {
                /*
                 * Skip this triangle if clipped away.
                 */
                if ((intersectRect.x1 >= intersectRect.x2) || (intersectRect.y1 >= intersectRect.y2))
                   continue;
                RIVA_CLIP3D(intersectRect.x1, intersectRect.y1, 
                            intersectRect.x2, intersectRect.y2);
                clipped = TRUE;
            }
            /*
             * Send line state.
             */
            if (rivaReload3D)
            {
                rivaReload3D = 0;
                RIVA_STATE3D(rivaContext.texOffset,
                             rivaContext.texFormat, 
                             rivaContext.texFilter, 
                             rivaContext.triFogColor, 
                             rivaContext.triControl, 
                             rivaContext.triAlphaTest);
            }
            /*
             * Send point as quad.
             */
            if (ctx->Fog.Enabled && (ctx->Texture.Enabled || (ctx->Hint.Fog == GL_NICEST)))
                fog = RivaFog(ctx, VB->VBCLIP[pv][3]);
            else
                fog = 0x00000000;
            argb = RivaColor(pv);
            RIVA_VERTEX3D(fog|0x00000000, argb, x - pointSize, y + pointSize, z, 1.0F, 0.0F, 1.0F);
            RIVA_VERTEX3D(fog|0x00000001, argb, x - pointSize, y - pointSize, z, 1.0F, 0.0F, 0.0F);
            RIVA_VERTEX3D(fog|0x00000102, argb, x + pointSize, y - pointSize, z, 1.0F, 1.0F, 0.0F);
            RIVA_VERTEX3D(fog|0x00000203, argb, x + pointSize, y + pointSize, z, 1.0F, 1.0F, 1.0F);
        }
    }
    /*
     * Reset clip rect if needed.
     */
    if (clipped)
        RIVA_CLIP3D(0, 0, 0x7FFF, 0x7FFF);
}
void Riva2PassPoints3D
(
    GLcontext *ctx,
    GLuint first,
    GLuint last
)
{
    unsigned triControlPass1;
    
    /*
     * Call pass 1.
     */
    RivaPoints3D(ctx, first, last);
    rivaReload3D = 1;
    /*
     * Call pass 2.
     */
    triControlPass1        = rivaContext.triControl;
    rivaContext.triControl = (rivaContext.triControl & 0x0F00F0FF) | rivaContext.triControlPass2;
    RivaPoints3D(ctx, first, last);
    /*
     * Restore pass 1 state.
     */
    rivaContext.triControl = triControlPass1;
    rivaReload3D           = 1;
}
void RivaLineNOP
(
    GLcontext *ctx,
    GLuint     v0,
    GLuint     v1,
    GLuint     pv
)
{
}
void RivaLine3D
(
    GLcontext *ctx,
    GLuint     v0,
    GLuint     v1,
    GLuint     pv
)
{
    int                   nclipRects, clipped;
    BoxPtr                pclipRect;
    BoxRec                intersectRect, boundRect;
    GLfloat               x0, x1, dx, y0, y1, dy, z, m, s, t;
    GLuint                argb, fog0, fog1;
    struct vertex_buffer *VB        = ctx->VB;
    XSMesaContext         xsmesa    = (XSMesaContext) ctx->DriverCtx;
    WindowPtr             pwin      = (WindowPtr)(xsmesa->xsm_buffer->frontbuffer);
    GLfloat               winOrgX   = (GLfloat)(pwin->drawable.x) - rivaContext.xyAdjust;
    GLfloat               winOrgY   = (GLfloat)(pwin->drawable.y + pwin->drawable.height) - rivaContext.xyAdjust;
    GLfloat               lineWidth = ctx->Line.Width * 0.5F;

    /*
     * Get window clip rects.
     */
    if (pwin->clipList.data)
    {
        if (pwin->clipList.data->numRects == 0)
            return;
        else if (rivaContext.SimpleClip)
        {
            nclipRects = 1;
            pclipRect  = &pwin->clipList.extents;
        }
        else
        {
            nclipRects = pwin->clipList.data->numRects;
            pclipRect  = (BoxPtr)(pwin->clipList.data + 1);
        }
    }
    else
    {
        nclipRects = 1;
        pclipRect  = &pwin->clipList.extents;
    }
    /*
     * Init fog.
     */
    if (ctx->Fog.Enabled && (ctx->Texture.Enabled || (ctx->Hint.Fog == GL_NICEST)))
    {
        fog0 = RivaFog(ctx, VB->VBCLIP[v0][3]);
        fog1 = RivaFog(ctx, VB->VBCLIP[v1][3]);
    }
    else
    {
        fog0 = 
        fog1 = 0x00000000;
    }
    /*
     * Get line extents.
     */
    x0 = winOrgX + VB->VBWIN[v0][0]; y0 = winOrgY - VB->VBWIN[v0][1];
    x1 = winOrgX + VB->VBWIN[v1][0]; y1 = winOrgY - VB->VBWIN[v1][1];
    if (x0 < x1)
    { 
        RivaFloatToInt(boundRect.x1, x0 - (0.5F + lineWidth));
        RivaFloatToInt(boundRect.x2, x1 + (0.5F + lineWidth));
    }
    else
    {
        RivaFloatToInt(boundRect.x1, x1 - (0.5F + lineWidth));
        RivaFloatToInt(boundRect.x2, x0 + (0.5F + lineWidth));
    }
    if (y0 < y1)
    {
        RivaFloatToInt(boundRect.y1, y0 - (0.5F + lineWidth));
        RivaFloatToInt(boundRect.y2, y1 + (0.5F + lineWidth));
    }
    else
    {
        RivaFloatToInt(boundRect.y1, y1 - (0.5F + lineWidth));
        RivaFloatToInt(boundRect.y2, y0 + (0.5F + lineWidth));
    }
    /*
     * Determine major and minor axis.
     */
    dx = x1 - x0; dy = y1 - y0;
    if (fabs(dx) > fabs(dy))
    {
        dy = lineWidth;
        dx = 0.0F;
    }
    else
    {
        dx = lineWidth;
        dy = 0.0F;
    }
    /*
     * Iterate through all clip rects.
     */
    clipped = FALSE;
    while (nclipRects--)
    {
        /*
         * Intersect line bounds with clip rect.
         */
        intersectRect.x1 = max(pclipRect->x1, boundRect.x1);
        intersectRect.y1 = max(pclipRect->y1, boundRect.y1);
        intersectRect.x2 = min(pclipRect->x2, boundRect.x2);
        intersectRect.y2 = min(pclipRect->y2, boundRect.y2);
        pclipRect++;
        /*
         * Intersect with scissor clip if enabled.
         */
        if (ctx->Scissor.Enabled)
        {
            BoxRec scissor;

            scissor.x1 = pwin->drawable.x + ctx->Scissor.X;
            scissor.y2 = pwin->drawable.y + pwin->drawable.height - ctx->Scissor.Y;
            scissor.x2 = scissor.x1       + ctx->Scissor.Width;
            scissor.y1 = scissor.y2       - ctx->Scissor.Height;
            intersectRect.x1 = max(scissor.x1, intersectRect.x1);
            intersectRect.y1 = max(scissor.y1, intersectRect.y1);
            intersectRect.x2 = min(scissor.x2, intersectRect.x2);
            intersectRect.y2 = min(scissor.y2, intersectRect.y2);
        }
        /*
         * Set clip rect if there is a bounds-clip intersection.
         */
        if ((intersectRect.x1 != boundRect.x1)
         || (intersectRect.x2 != boundRect.x2)
         || (intersectRect.y1 != boundRect.y1)
         || (intersectRect.y2 != boundRect.y2))
        {
            /*
             * Skip this triangle if clipped away.
             */
            if ((intersectRect.x1 >= intersectRect.x2) || (intersectRect.y1 >= intersectRect.y2))
               continue;
            RIVA_CLIP3D(intersectRect.x1, intersectRect.y1, 
                        intersectRect.x2, intersectRect.y2);
            clipped = TRUE;
        }
        /*
         * Send line state.
         */
        if (rivaReload3D)
        {
            rivaReload3D = 0;
            RIVA_STATE3D(rivaContext.texOffset,
                         rivaContext.texFormat, 
                         rivaContext.texFilter, 
                         rivaContext.triFogColor, 
                         rivaContext.triControl, 
                         rivaContext.triAlphaTest);
        }
        /*
         * Send vertex 0.
         */
        if (ctx->Light.ShadeModel == GL_SMOOTH)
            argb = RivaColor(v0);
        else
            argb = RivaColor(pv);
        z = VB->VBWIN[v0][2] + ctx->LineZoffset;
        m = INV_W(v0);
        s = VB->TEXCOORD(0, v0, 0);
        t = VB->TEXCOORD(0, v0, 1);
        RIVA_VERTEX3D(fog0|0x00000000, argb, x0 - dx, y0 - dy, z, m, s, t);
        RIVA_VERTEX3D(fog0|0x00000001, argb, x0 + dx, y0 + dy, z, m, s, t);
        /*
         * Send vertex 1.
         */
        if (ctx->Light.ShadeModel == GL_SMOOTH)
            argb = RivaColor(v1);
        z = VB->VBWIN[v1][2] + ctx->LineZoffset;
        m = INV_W(v1);
        s = VB->TEXCOORD(0, v1, 0);
        t = VB->TEXCOORD(0, v1, 1);
        RIVA_VERTEX3D(fog1|0x00000102, argb, x1 + dx, y1 + dy, z, m, s, t);
        RIVA_VERTEX3D(fog1|0x00000203, argb, x1 - dx, y1 - dy, z, m, s, t);
    }
    /*
     * Reset clip rect if needed.
     */
    if (clipped)
        RIVA_CLIP3D(0, 0, 0x7FFF, 0x7FFF);
}
void RivaAALine3D
(
    GLcontext *ctx,
    GLuint     v0,
    GLuint     v1,
    GLuint     pv
)
{
    int                   nclipRects, clipped;
    BoxPtr                pclipRect;
    BoxRec                intersectRect, boundRect;
    GLfloat               x0, x1, dx, y0, y1, dy, z, m;
    GLuint                argb, fog0, fog1;
    struct vertex_buffer *VB        = ctx->VB;
    XSMesaContext         xsmesa    = (XSMesaContext) ctx->DriverCtx;
    WindowPtr             pwin      = (WindowPtr)(xsmesa->xsm_buffer->frontbuffer);
    GLfloat               winOrgX   = (GLfloat)(pwin->drawable.x) - rivaContext.xyAdjust;
    GLfloat               winOrgY   = (GLfloat)(pwin->drawable.y + pwin->drawable.height) - rivaContext.xyAdjust;
    GLfloat               lineWidth = ctx->Line.Width;

    /*
     * Get window clip rects.
     */
    if (pwin->clipList.data)
    {
        if (pwin->clipList.data->numRects == 0)
            return;
        else if (rivaContext.SimpleClip)
        {
            nclipRects = 1;
            pclipRect  = &pwin->clipList.extents;
        }
        else
        {
            nclipRects = pwin->clipList.data->numRects;
            pclipRect  = (BoxPtr)(pwin->clipList.data + 1);
        }
    }
    else
    {
        nclipRects = 1;
        pclipRect  = &pwin->clipList.extents;
    }
    /*
     * Init fog.
     */
    if (ctx->Fog.Enabled && (ctx->Texture.Enabled || (ctx->Hint.Fog == GL_NICEST)))
    {
        fog0 = RivaFog(ctx, VB->VBCLIP[v0][3]);
        fog1 = RivaFog(ctx, VB->VBCLIP[v1][3]);
    }
    else
    {
        fog0 = 
        fog1 = 0x00000000;
    }
    /*
     * Get line extents.
     */
    x0 = winOrgX + VB->VBWIN[v0][0]; y0 = winOrgY - VB->VBWIN[v0][1];
    x1 = winOrgX + VB->VBWIN[v1][0]; y1 = winOrgY - VB->VBWIN[v1][1];
    if (x0 < x1)
    { 
        RivaFloatToInt(boundRect.x1, x0 - (0.5F + lineWidth));
        RivaFloatToInt(boundRect.x2, x1 + (0.5F + lineWidth));
    }
    else
    {
        RivaFloatToInt(boundRect.x1, x1 - (0.5F + lineWidth));
        RivaFloatToInt(boundRect.x2, x0 + (0.5F + lineWidth));
    }
    if (y0 < y1)
    {
        RivaFloatToInt(boundRect.y1, y0 - (0.5F + lineWidth));
        RivaFloatToInt(boundRect.y2, y1 + (0.5F + lineWidth));
    }
    else
    {
        RivaFloatToInt(boundRect.y1, y1 - (0.5F + lineWidth));
        RivaFloatToInt(boundRect.y2, y0 + (0.5F + lineWidth));
    }
    /*
     * Determine major and minor axis.
     */
    dx = x1 - x0; dy = y1 - y0;
    if (fabs(dx) > fabs(dy))
    {
        dy = lineWidth;
        dx = 0.0F;
    }
    else
    {
        dx = lineWidth;
        dy = 0.0F;
    }
    /*
     * Iterate through all clip rects.
     */
    clipped = FALSE;
    while (nclipRects--)
    {
        /*
         * Intersect line bounds with clip rect.
         */
        intersectRect.x1 = max(pclipRect->x1, boundRect.x1);
        intersectRect.y1 = max(pclipRect->y1, boundRect.y1);
        intersectRect.x2 = min(pclipRect->x2, boundRect.x2);
        intersectRect.y2 = min(pclipRect->y2, boundRect.y2);
        pclipRect++;
        /*
         * Intersect with scissor clip if enabled.
         */
        if (ctx->Scissor.Enabled)
        {
            BoxRec scissor;

            scissor.x1 = pwin->drawable.x + ctx->Scissor.X;
            scissor.y2 = pwin->drawable.y + pwin->drawable.height - ctx->Scissor.Y;
            scissor.x2 = scissor.x1       + ctx->Scissor.Width;
            scissor.y1 = scissor.y2       - ctx->Scissor.Height;
            intersectRect.x1 = max(scissor.x1, intersectRect.x1);
            intersectRect.y1 = max(scissor.y1, intersectRect.y1);
            intersectRect.x2 = min(scissor.x2, intersectRect.x2);
            intersectRect.y2 = min(scissor.y2, intersectRect.y2);
        }
        /*
         * Set clip rect if there is a bounds-clip intersection.
         */
        if ((intersectRect.x1 != boundRect.x1)
         || (intersectRect.x2 != boundRect.x2)
         || (intersectRect.y1 != boundRect.y1)
         || (intersectRect.y2 != boundRect.y2))
        {
            /*
             * Skip this triangle if clipped away.
             */
            if ((intersectRect.x1 >= intersectRect.x2) || (intersectRect.y1 >= intersectRect.y2))
               continue;
            RIVA_CLIP3D(intersectRect.x1, intersectRect.y1, 
                        intersectRect.x2, intersectRect.y2);
            clipped = TRUE;
        }
        /*
         * Send line state.
         */
        if (rivaReload3D)
        {
            rivaReload3D = 0;
            RIVA_STATE3D(rivaContext.texOffset,
                         rivaContext.texFormat, 
                         rivaContext.texFilter, 
                         rivaContext.triFogColor, 
                         rivaContext.triControl, 
                         rivaContext.triAlphaTest);
        }
        /*
         * Send vertex 0.
         */
        if (ctx->Light.ShadeModel == GL_SMOOTH)
            argb = RivaColor(v0);
        else
            argb = RivaColor(pv);
        z = VB->VBWIN[v0][2] + ctx->LineZoffset;
        m = (ctx->Fog.Enabled) ? INV_W(v0) : 1.0F;
        RIVA_VERTEX3D(fog0|0x00000000, argb, x0 - dx, y0 - dy, z, m, 0.5F, 0.0F);
        RIVA_VERTEX3D(fog0|0x00000001, argb, x0 + dx, y0 + dy, z, m, 0.5F, 1.0F);
        /*
         * Send vertex 1.
         */
        if (ctx->Light.ShadeModel == GL_SMOOTH)
            argb = RivaColor(v1);
        z = VB->VBWIN[v1][2] + ctx->LineZoffset;
        m = (ctx->Fog.Enabled) ? INV_W(v1) : 1.0F;
        RIVA_VERTEX3D(fog1|0x00000102, argb, x1 + dx, y1 + dy, z, m, 0.5F, 1.0F);
        RIVA_VERTEX3D(fog1|0x00000203, argb, x1 - dx, y1 - dy, z, m, 0.5F, 0.0F);
    }
    /*
     * Reset clip rect if needed.
     */
    if (clipped)
        RIVA_CLIP3D(0, 0, 0x7FFF, 0x7FFF);
}
void Riva2PassLine3D
(
    GLcontext *ctx,
    GLuint     v0,
    GLuint     v1,
    GLuint     pv
)
{
    unsigned triControlPass1;
    
    /*
     * Call pass 1.
     */
    RivaLine3D(ctx, v0, v1, pv);
    rivaReload3D = 1;
    /*
     * Call pass 2.
     */
    triControlPass1        = rivaContext.triControl;
    rivaContext.triControl = (rivaContext.triControl & 0x0F00F0FF) | rivaContext.triControlPass2;
    RivaLine3D(ctx, v0, v1, pv);
    /*
     * Restore pass 1 state.
     */
    rivaContext.triControl = triControlPass1;
    rivaReload3D           = 1;
}
void RivaTriangleNOP
(
    GLcontext *ctx,
    GLuint     v0,
    GLuint     v1,
    GLuint     v2,
    GLuint     pv
)
{
}
void RivaTriangle3D
(
    GLcontext *ctx,
    GLuint     v0,
    GLuint     v1,
    GLuint     v2,
    GLuint     pv
)
{
    int                   nclipRects, clipped, i0, i1, i2;
    BoxPtr                pclipRect;
    BoxRec                intersectRect, boundRect;
    GLfloat               x0, x1, x2, xmin, xmax, y0, y1, y2, ymin, ymax, m;
    GLuint                argb, fog0, fog1, fog2;
    struct vertex_buffer *VB      = ctx->VB;
    XSMesaContext         xsmesa  = (XSMesaContext) ctx->DriverCtx;
    WindowPtr             pwin    = (WindowPtr)(xsmesa->xsm_buffer->frontbuffer);
    GLfloat               winOrgX = (GLfloat)(pwin->drawable.x) - rivaContext.xyAdjust;
    GLfloat               winOrgY = (GLfloat)(pwin->drawable.y + pwin->drawable.height) - rivaContext.xyAdjust;

    rivaReload3D = 1;

    /*
     * Translate window coordinates into screen coordinates.
     */
    x0 = winOrgX + VB->VBWIN[v0][0];
    y0 = winOrgY - VB->VBWIN[v0][1];
    x1 = winOrgX + VB->VBWIN[v1][0];
    y1 = winOrgY - VB->VBWIN[v1][1];
    x2 = winOrgX + VB->VBWIN[v2][0];
    y2 = winOrgY - VB->VBWIN[v2][1];
    
    /*
     * Init fog.
     */
    if (ctx->Fog.Enabled && (ctx->Texture.Enabled || (ctx->Hint.Fog == GL_NICEST)))
    {
        fog0 = RivaFog(ctx, VB->VBCLIP[v0][3]);
        fog1 = RivaFog(ctx, VB->VBCLIP[v1][3]);
        fog2 = RivaFog(ctx, VB->VBCLIP[v2][3]);
    }
    else
    {
        fog0 = 
        fog1 = 
        fog2 = 0x00000000;
    }
    /*
     * Get window clip rects.
     */
    if (pwin->clipList.data)
    {
        if (pwin->clipList.data->numRects == 0)
            return;
        else if (rivaContext.SimpleClip)
        {
            nclipRects = 1;
            pclipRect  = &pwin->clipList.extents;
        }
        else
        {
            nclipRects = pwin->clipList.data->numRects;
            pclipRect  = (BoxPtr)(pwin->clipList.data + 1);
        }
    }
    else
    {
        nclipRects = 1;
        pclipRect  = &pwin->clipList.extents;
    }
    /*
     * Check for clipping.
     */
    if ( !ctx->Scissor.Enabled
     &&  (nclipRects == 1)
     && ((pclipRect->x2 - pclipRect->x1) == pwin->drawable.width)
     && ((pclipRect->y2 - pclipRect->y1) == pwin->drawable.height))
    {
        /*
         * Send triangle state if needed.
         */
        if (rivaReload3D)
        {
            unsigned long *pvc = (unsigned long *)(rivaContext.VCache);
            pvc[0] = 0xFFFFFFFF; pvc[1] = 0xFFFFFFFF;
            pvc[2] = 0xFFFFFFFF; pvc[3] = 0xFFFFFFFF;
            rivaReload3D = 0;
            RIVA_STATE3D(rivaContext.texOffset,
                         rivaContext.texFormat, 
                         rivaContext.texFilter, 
                         rivaContext.triFogColor, 
                         rivaContext.triControl, 
                         rivaContext.triAlphaTest);
        }
        /*
         * Send vertex 0 with vertex cache check.
         */
        i0 = v0 & RIVA_VCACHE_MASK;
        if (rivaContext.VCache[i0] != v0)
        {
            m = INV_W(v0);
            if (ctx->Light.ShadeModel == GL_SMOOTH)
            {
                argb = RivaColor(v0);
                rivaContext.VCache[i0] = v0;
            }
            else 
            {
                argb = RivaColor(pv);
            }
            RIVA_VERTEX3D(fog0 | i0, 
                          argb, 
                          x0, 
                          y0,
                          VB->VBWIN[v0][2] + ctx->PolygonZoffset,
                          m,
                          VB->TEXCOORD(0, v0, 0),
                          VB->TEXCOORD(0, v0, 1));
        }
        /*
         * Send vertex 1 with vertex cache check.
         */
        i1 = v1 & RIVA_VCACHE_MASK;
        if (i1 == i0)
            i1 = i0 ^ RIVA_VCACHE_MASK;
        if (rivaContext.VCache[i1] != v1)
        {
            m = INV_W(v1);
            if (ctx->Light.ShadeModel == GL_SMOOTH)
            {
                argb = RivaColor(v1);
                rivaContext.VCache[i1] = v1;
            }
            RIVA_VERTEX3D(fog1 | i1, 
                          argb, 
                          x1, 
                          y1,
                          VB->VBWIN[v1][2] + ctx->PolygonZoffset,
                          m,
                          VB->TEXCOORD(0, v1, 0),
                          VB->TEXCOORD(0, v1, 1));
        }
        /*
         * Send vertex 2 and update vertex cache.
         */
        i2 = v2 & RIVA_VCACHE_MASK;
        if (i2 == i0 || i2 == i1)
            while (i2 == i0 || i2 == i1) i2 = (i2 + 1) & RIVA_VCACHE_MASK;
        m = INV_W(v2);
        if (ctx->Light.ShadeModel == GL_SMOOTH)
        {
            argb = RivaColor(v2);
            rivaContext.VCache[i2] = v2;
        }
        RIVA_VERTEX3D(fog2 | (i1 << 8) | (i0 << 4) | i2, 
                      argb, 
                      x2, 
                      y2,
                      VB->VBWIN[v2][2] + ctx->PolygonZoffset,
                      m,
                      VB->TEXCOORD(0, v2, 0),
                      VB->TEXCOORD(0, v2, 1));
    }
    else
    {
        /*
         * Get triangle extents for clipping.
         */
        clipped = FALSE;
        xmin = xmax = x0;
        ymin = ymax = y0;
        if (x1 < xmin) xmin = x1; else if (x1 > xmax) xmax = x1;
        if (y1 < ymin) ymin = y1; else if (y1 > ymax) ymax = y1;
        if (x2 < xmin) xmin = x2; else if (x2 > xmax) xmax = x2;
        if (y2 < ymin) ymin = y2; else if (y2 > ymax) ymax = y2;
        RivaFloatToInt(boundRect.x1, xmin - 0.5F);
        RivaFloatToInt(boundRect.y1, ymin - 0.5F);
        RivaFloatToInt(boundRect.x2, xmax + 0.5F);
        RivaFloatToInt(boundRect.y2, ymax + 0.5F);
        /*
         * Iterate through all clip rects.
         */
        while (nclipRects--)
        {
            /*
             * Intersect rectangle bounds with clip rect.
             */
            intersectRect.x1 = max(pclipRect->x1, boundRect.x1);
            intersectRect.y1 = max(pclipRect->y1, boundRect.y1);
            intersectRect.x2 = min(pclipRect->x2, boundRect.x2);
            intersectRect.y2 = min(pclipRect->y2, boundRect.y2);
            pclipRect++;
            /*
             * Intersect with scissor clip if enabled.
             */
            if (ctx->Scissor.Enabled)
            {
                BoxRec scissor;
    
                scissor.x1 = pwin->drawable.x + ctx->Scissor.X;
                scissor.y2 = pwin->drawable.y + pwin->drawable.height - ctx->Scissor.Y;
                scissor.x2 = scissor.x1       + ctx->Scissor.Width;
                scissor.y1 = scissor.y2       - ctx->Scissor.Height;
                intersectRect.x1 = max(scissor.x1, intersectRect.x1);
                intersectRect.y1 = max(scissor.y1, intersectRect.y1);
                intersectRect.x2 = min(scissor.x2, intersectRect.x2);
                intersectRect.y2 = min(scissor.y2, intersectRect.y2);
            }
            /*
             * Set clip rect if there is a bounds-clip intersection.
             */
            if ((intersectRect.x1 != boundRect.x1)
             || (intersectRect.x2 != boundRect.x2)
             || (intersectRect.y1 != boundRect.y1)
             || (intersectRect.y2 != boundRect.y2))
            {
                /*
                 * Skip this triangle if clipped away.
                 */
                if ((intersectRect.x1 >= intersectRect.x2) || (intersectRect.y1 >= intersectRect.y2))
                    continue;
                RIVA_CLIP3D(intersectRect.x1, intersectRect.y1, 
                            intersectRect.x2, intersectRect.y2);
                clipped = TRUE;
            }
            /*
             * Send triangle state if needed.
             */
            if (rivaReload3D)
            {
                unsigned long *pvc = (unsigned long *)(rivaContext.VCache);
                pvc[0] = 0xFFFFFFFF; pvc[1] = 0xFFFFFFFF;
                pvc[2] = 0xFFFFFFFF; pvc[3] = 0xFFFFFFFF;
                rivaReload3D = 0;
                RIVA_STATE3D(rivaContext.texOffset,
                             rivaContext.texFormat, 
                             rivaContext.texFilter, 
                             rivaContext.triFogColor, 
                             rivaContext.triControl, 
                             rivaContext.triAlphaTest);
            }
            /*
             * Send vertex 0 with vertex cache check.
             */
            i0 = v0 & RIVA_VCACHE_MASK;
            if (rivaContext.VCache[i0] != v0)
            {
                m = INV_W(v0);
                if (ctx->Light.ShadeModel == GL_SMOOTH)
                {
                    argb = RivaColor(v0);
                    rivaContext.VCache[i0] = v0;
                }
                else 
                {
                    argb = RivaColor(pv);
                }
                RIVA_VERTEX3D(fog0 | i0, 
                              argb, 
                              x0, 
                              y0,
                              VB->VBWIN[v0][2] + ctx->PolygonZoffset,
                              m,
                              VB->TEXCOORD(0, v0, 0),
                              VB->TEXCOORD(0, v0, 1));
            }
            /*
             * Send vertex 1 with vertex cache check.
             */
            i1 = v1 & RIVA_VCACHE_MASK;
            if (i1 == i0)
                i1 = i0 ^ RIVA_VCACHE_MASK;
            if (rivaContext.VCache[i1] != v1)
            {
                m = INV_W(v1);
                if (ctx->Light.ShadeModel == GL_SMOOTH)
                {
                    argb = RivaColor(v1);
                    rivaContext.VCache[i1] = v1;
                }
                
                RIVA_VERTEX3D(fog1 | i1, 
                              argb, 
                              x1, 
                              y1,
                              VB->VBWIN[v1][2] + ctx->PolygonZoffset,
                              m,
                              VB->TEXCOORD(0, v1, 0),
                              VB->TEXCOORD(0, v1, 1));
            }
            /*
             * Send vertex 2 and update vertex cache.
             */
            i2 = v2 & RIVA_VCACHE_MASK;
            if (i2 == i0 || i2 == i1)
                while (i2 == i0 || i2 == i1) i2 = (i2 + 1) & RIVA_VCACHE_MASK;
            m = INV_W(v2);
            if (ctx->Light.ShadeModel == GL_SMOOTH)
            {
                argb = RivaColor(v2);
                rivaContext.VCache[i2] = v2;
            }
            	
            RIVA_VERTEX3D(fog2 | (i1 << 8) | (i0 << 4) | i2, 
                          argb, 
                          x2, 
                          y2,
                          VB->VBWIN[v2][2] + ctx->PolygonZoffset,
                          m,
                          VB->TEXCOORD(0, v2, 0),
                          VB->TEXCOORD(0, v2, 1));
        }
        /*
         * Reset clip rect if needed.
         */
        if (clipped)
            RIVA_CLIP3D(0, 0, 0x7FFF, 0x7FFF);
    }
}
void Riva2PassTriangle3D
(
    GLcontext *ctx,
    GLuint     v0,
    GLuint     v1,
    GLuint     v2,
    GLuint     pv
)
{
    unsigned long  triControlPass1;
    
    /*
     * Call pass 1.
     */
    RivaTriangle3D(ctx, v0, v1, v2, pv);
    /*
     * Call pass 2.
     */
    triControlPass1        = rivaContext.triControl;
    rivaContext.triControl = (rivaContext.triControl & 0x0F00F0FF) | rivaContext.triControlPass2;
    rivaReload3D           = 1;
    RivaTriangle3D(ctx, v0, v1, v2, pv);
    /*
     * Restore pass 1 state.
     */
    rivaContext.triControl = triControlPass1;
    rivaReload3D           = 1;
}


