/* $Id: mgavb.h,v 1.7 1999/12/18 22:03:00 keithw Exp $ */
/*
 * GLX Hardware Device Driver for Matrox Millenium G200
 * Copyright (C) 1999 Wittawat Yamwong
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *    Wittawat Yamwong <Wittawat.Yamwong@stud.uni-hannover.de>
 */

#ifndef MGAVB_INC
#define MGAVB_INC

#include "mesaglx/vb.h"
#include "mgawarp.h"
#include "mgacommon.h"

/* The fastpath code still expects a 16-float stride vertex.
 */
union mga_vertex_t {
   mga_warp_vertex1 warp1;	
   mga_warp_vertex2 warp2;
   float f[16];
   mgaUI32 ui[16];
};

typedef union mga_vertex_t mgaVertex;
typedef union mga_vertex_t *mgaVertexPtr;

struct mga_vertex_buffer_t {
   GLvector1ui clipped_elements;
   mgaVertexPtr verts;
   int last_vert;
   GLuint *primitive;
   GLuint *next_primitive;
   void *vert_store;
   GLuint size;

   mgaUI32 *vert_buf;
   mgaUI32 *elt_buf;
   mgaUI32 vert_phys_start;
};
   
typedef struct mga_vertex_buffer_t *mgaVertexBufferPtr;

#define MGA_CONTEXT(ctx)    ((mgaContextPtr)(((XSMesaContext)(ctx)->DriverCtx)->hw_ctx))
#define MGA_DRIVER_DATA(vb) ((mgaVertexBufferPtr)((vb)->driver_data))


#define MGA_SPEC_BIT       0x1
#define MGA_FOG_BIT	   0x2
#define MGA_ALPHA_BIT      0x4	/* GL_BLEND, used for warp selection only */
#define MGA_TEX1_BIT       0x8
#define MGA_TEX0_BIT       0x10	
#define MGA_RGBA_BIT       0x20
#define MGA_WIN_BIT        0x40


extern void mgaChooseRasterSetupFunc(GLcontext *ctx);
extern void mgaPrintSetupFlags(char *msg, GLuint flags );
extern void mgaDDDoRasterSetup( struct vertex_buffer *VB );
extern void mgaDDPartialRasterSetup( struct vertex_buffer *VB );
extern void mgaDDCheckPartialRasterSetup( GLcontext *ctx, 
					  struct gl_pipeline_stage *d );

extern void mgaDDViewport( GLcontext *ctx, 
			   GLint x, GLint y, 
			   GLsizei width, GLsizei height );

extern void mgaDDDepthRange( GLcontext *ctx, 
			     GLclampd nearval, GLclampd farval );


extern void mgaDDUnregisterVB( struct vertex_buffer *VB );
extern void mgaDDRegisterVB( struct vertex_buffer *VB );
extern void mgaDDResizeVB( struct vertex_buffer *VB, GLuint size );

extern void mgaDDSetupInit( void );


#endif
