
static void mgaUpdateStencil(const GLcontext *ctx)
{
   mgaUI32 stencil, stencilctl = 0;
   
   if (ctx->Stencil.Enabled)
     {
       MGA_SET_FIELD(stencil, S_sref_MASK, ctx->Stencil.Ref);
       MGA_SET_FIELD(stencil, S_smsk_MASK, ctx->Stencil.ValueMask << S_smsk_SHIFT);
       MGA_SET_FIELD(stencil, S_swtmsk_MASK, ctx->Stencil.WriteMask << S_swtmsk_SHIFT);
       
       switch (ctx->Stencil.Function)
	 {
	 case GL_NEVER:
	   MGA_SET_FIELD(stencilctl, SC_smode_MASK, SC_smode_snever);
	   break;
	 case GL_LESS:
	   MGA_SET_FIELD(stencilctl, SC_smode_MASK, SC_smode_slt);
	   break;
	 case GL_LEQUAL:
	   MGA_SET_FIELD(stencilctl, SC_smode_MASK, SC_smode_slte);
	   break;
	 case GL_GREATER:
	   MGA_SET_FIELD(stencilctl, SC_smode_MASK, SC_smode_sgt);
	   break;
	 case GL_GEQUAL:
	   MGA_SET_FIELD(stencilctl, SC_smode_MASK, SC_smode_sgte);
	   break;
	 case GL_NOTEQUAL:
	   MGA_SET_FIELD(stencilctl, SC_smode_MASK, SC_smode_sne);
	   break;
	 case GL_ALWAYS:
	   MGA_SET_FIELD(stencilctl, SC_smode_MASK, SC_smode_salways);
	 default:
	   break;
	 }
       
       switch (ctx->Stencil.FailFunc)
	 {     
	 case GL_KEEP:
	   MGA_SET_FIELD(stencilctl, SC_sfailop_MASK, SC_sfailop_keep);
	   break;
	 case GL_ZERO:
	   MGA_SET_FIELD(stencilctl, SC_sfailop_MASK, SC_sfailop_zero);
	   break;
	 case GL_REPLACE:
	   MGA_SET_FIELD(stencilctl, SC_sfailop_MASK, SC_sfailop_replace);
	   break;
	 case GL_INCR:
	   MGA_SET_FIELD(stencilctl, SC_sfailop_MASK, SC_sfailop_incrsat);
	   break;
	 case GL_DECR:
	   MGA_SET_FIELD(stencilctl, SC_sfailop_MASK, SC_sfailop_decrsat);
	   break;
	 case GL_INVERT:
	   MGA_SET_FIELD(stencilctl, SC_sfailop_MASK, SC_sfailop_invert);
	   break;
	 default:
	   break;
	 }
       
       switch (ctx->Stencil.ZFailFunc)
	 {     
	 case GL_KEEP:
	   MGA_SET_FIELD(stencilctl, SC_szfailop_MASK, SC_szfailop_keep);
	   break;
	 case GL_ZERO:
	   MGA_SET_FIELD(stencilctl, SC_szfailop_MASK, SC_szfailop_zero);
	   break;
	 case GL_REPLACE:
	   MGA_SET_FIELD(stencilctl, SC_szfailop_MASK, SC_szfailop_replace);
	   break;
	 case GL_INCR:
	   MGA_SET_FIELD(stencilctl, SC_szfailop_MASK, SC_szfailop_incrsat);
	   break;
	 case GL_DECR:
	   MGA_SET_FIELD(stencilctl, SC_szfailop_MASK, SC_szfailop_decrsat);
	   break;
	 case GL_INVERT:
	   MGA_SET_FIELD(stencilctl, SC_szfailop_MASK, SC_szfailop_invert);
	   break;
	 default:
	   break;
	 }
       
       switch (ctx->Stencil.ZPassFunc)
	 {     
	 case GL_KEEP:
	   MGA_SET_FIELD(stencilctl, SC_szpassop_MASK, SC_szpassop_keep);
	   break;
	 case GL_ZERO:
	   MGA_SET_FIELD(stencilctl, SC_szpassop_MASK, SC_szpassop_zero);
	   break;
	 case GL_REPLACE:
	   MGA_SET_FIELD(stencilctl, SC_szpassop_MASK, SC_szpassop_replace);
	   break;
	 case GL_INCR:
	   MGA_SET_FIELD(stencilctl, SC_szpassop_MASK, SC_szpassop_incrsat);
	   break;
	 case GL_DECR:
	   MGA_SET_FIELD(stencilctl, SC_szpassop_MASK, SC_szpassop_decrsat);
	   break;
	 case GL_INVERT:
	   MGA_SET_FIELD(stencilctl, SC_szpassop_MASK, SC_szpassop_invert);
	   break;
	 default:
	   break;
	 }
       
       mgaCtx->regSTENCIL = stencil;
       mgaCtx->regSTENCILCTL = stencilctl;
       
     }
}

