/*
 * GLX Hardware Device Driver for Matrox Millenium G200
 * Copyright (C) 1999 Wittawat Yamwong
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *    Wittawat Yamwong <Wittawat.Yamwong@stud.uni-hannover.de>
 */

/* $Id: mgaglx.h,v 1.4 1999/09/30 11:05:53 keithw Exp $ */

#ifndef MGAGLX_INC
#define MGAGLX_INC

void mgaDumpDB(mgaBufferPtr buf);
void mgaGLXCreateDepthBuffer(GLcontext* ctx);
void mgaGLXDestroyImage(GLXImage* image);
GLXImage* mgaGLXCreateImage(WindowPtr pwindow, int depth, int width, int height);
GLboolean mgaGLXMakeCurrent( XSMesaContext c );
GLboolean mgaGLXBindBuffer( XSMesaContext c, XSMesaBuffer b );
XSMesaContext mgaGLXCreateContext( XSMesaVisual v,  
                                   XSMesaContext share_list );
void mgaGLXDestroyContext( XSMesaContext c );

extern int mgaBackToFront(DrawablePtr drawable, mgaBufferPtr buf);
extern void (*mgaGLXSwapBuffers)(XSMesaBuffer b);
extern void mgaPerformanceBoxes( int is_direct );


#endif
