
#include "mach64glx.h"

/*
 * mach64Clear
 * perform hardware accelerated clearing of the color and/or depth
 * buffer.  Software may still clear stencil buffers.
 * If all==GL_TRUE, clear whole buffer, else just clear region defined
 * by x,y,width,height
 */
GLbitfield mach64Clear( GLcontext *ctx, GLbitfield mask, GLboolean all,
		     GLint x, GLint y, GLint width, GLint height ) 
{
	DMALOCALS;
	
	mach64Msg( 10, "mach64Clear( %i, %i, %i, %i, %i )\n", mask, x, y, width, height );

	if (all == GL_TRUE) {
		x = 0;
		y = 0;
		width = mach64DB->width;
		height = mach64DB->height;
	}
	
	if ( y + height > mach64DB->height ) {
		height = mach64DB->height - y;
	}
	if ( x + width > mach64DB->width ) {
		width = mach64DB->width - x;
	}
	if ( x < 0 ) {
		width += x;
		x = 0;
	}
	if ( y < 0 ) {
		height += y;
		y = 0;
	}
	if ( x >= mach64DB->width || y >= mach64DB->height || width < 1 || height < 1 ) {
		return 0;
	}

	/* flip top to bottom */
	y = mach64DB->height - y - height;
	
	DMAGETPTR( 100 );
	
	/* color buffer */
	/* mesa doesn't let us just not clear the color buffer, so do it ourselves
	even if we are in software rendering */
	if ( mask & GL_COLOR_BUFFER_BIT ) {
		int		r, g, b;
		int		color;
		
		r = 255 * ctx->Color.ClearColor[0];
		g = 255 * ctx->Color.ClearColor[1];
		b = 255 * ctx->Color.ClearColor[2];
		
		if ( mach64DB->backBufferBlock ) {
			/* hardware accelerated clear */
	DMAOUTREG( MACH64REG_Z_CNTL, 0 );
	DMAOUTREG( MACH64REG_SCALE_3D_CNTL, 0 );
	DMAOUTREG( MACH64REG_DP_SRC, 
		DP_bkgd_src_background | DP_frgd_src_foreground | DP_mono_src_1 );
	DMAOUTREG( MACH64REG_DST_OFF_PITCH, ( (mach64DB->pitch/8) << 22 ) | (mach64DB->backBufferBlock->ofs>>3) ) ;

	color = MACH64PACKCOLOR565(r,g,b);
	color = (color<<16) | color;
	
	DMAOUTREG( MACH64REG_DP_FRGD_CLR, color );
	DMAOUTREG( MACH64REG_DP_WRITE_MASK, 0xffffffff );	/* write to all */
	DMAOUTREG( MACH64REG_DP_MIX, 0x00070003 );	/* bkground leave alone */
	DMAOUTREG( MACH64REG_DP_SRC, 
		DP_bkgd_src_foreground | DP_frgd_src_foreground | DP_mono_src_1 );
	DMAOUTREG( MACH64REG_CLR_CMP_CNTL, 0 );			/* disable color compare */
	DMAOUTREG( MACH64REG_GUI_TRAJ_CNTL, 3 );			/* left to right, top to bottom */ 
	DMAOUTREG( MACH64REG_DST_X_Y, (y<<16)|x );
	DMAOUTREG( MACH64REG_DST_WIDTH_HEIGHT, (height<<16)|width );
		} else {
			/* software clear */
			int		i, j;
			int		pixel;
			
			pixel = MACH64PACKCOLOR555(r,g,b,255);
			for ( i = 0 ; i < height ; i++ ) {
				unsigned short *dest;

				dest = (unsigned short *)mach64DB->backBuffer + 
					i * mach64DB->pitch + x;
				
				for ( j = 0 ; j < width ; j++ ) {
					dest[j] = pixel;
				}
			}	
		}		
		mask &= ~GL_COLOR_BUFFER_BIT;
	}

	/* depth buffer */
	if ( mask & GL_DEPTH_BUFFER_BIT ) {
		if ( 1 /* !ctx->Depth.Mask */ ) {
			mach64UI32	zval;
			
			zval = (mach64UI32) (ctx->Depth.Clear * DEPTH_SCALE);

			if ( mach64DB->depthBufferBlock ) {
				/* hardware accelerated clear */
			
	DMAOUTREG( MACH64REG_Z_CNTL, 0 );
	DMAOUTREG( MACH64REG_SCALE_3D_CNTL, 0 );
	DMAOUTREG( MACH64REG_DP_SRC, 
		DP_bkgd_src_background | DP_frgd_src_foreground | DP_mono_src_1 );
	DMAOUTREG( MACH64REG_DST_OFF_PITCH, ( (mach64DB->pitch/8) << 22 ) | (mach64DB->depthBufferBlock->ofs>>3) ) ;

	DMAOUTREG( MACH64REG_DP_FRGD_CLR, zval | ( zval << 16 ) );
	DMAOUTREG( MACH64REG_DP_WRITE_MASK, 0xffffffff );	/* write to all */
	DMAOUTREG( MACH64REG_DP_MIX, 0x00070003 );			/* bkground leave alone */
	DMAOUTREG( MACH64REG_DP_SRC, 
		DP_bkgd_src_foreground | DP_frgd_src_foreground | DP_mono_src_1 );
	DMAOUTREG( MACH64REG_CLR_CMP_CNTL, 0 );			/* disable color compare */
	DMAOUTREG( MACH64REG_GUI_TRAJ_CNTL, 3 );			/* left to right, top to bottom */ 
	DMAOUTREG( MACH64REG_DST_X_Y, (y<<16)|x );
	DMAOUTREG( MACH64REG_DST_WIDTH_HEIGHT, (height<<16)|width );
			} else {
				/* software clear */
				int		i, j;
			
				for ( i = 0 ; i < height ; i++ ) {
					unsigned short *dest;

					dest = (unsigned short *)mach64DB->depthBuffer + 
						i * mach64DB->pitch + x;
				
					for ( j = 0 ; j < width ; j++ ) {
						dest[j] = zval;
					}
				}	
			}		
		}			
		mask &= ~GL_DEPTH_BUFFER_BIT;
	}

	DMAADVANCE();

	return mask;
}


