
static inline void TAG(triangle)( GLcontext *ctx, GLuint e0,
				  GLuint e1, GLuint e2, GLuint pv )
{
   struct vertex_buffer *VB = ctx->VB;
   i810VertexPtr i810VB = I810_DRIVER_DATA(VB)->verts;
   const i810_vertex *v0 = &i810VB[e0].v.v;  
   const i810_vertex *v1 = &i810VB[e1].v.v;  
   const i810_vertex *v2 = &i810VB[e2].v.v;  

#if (IND & I810_OFFSET_BIT)
   GLfloat offset = ctx->Polygon.OffsetUnits * 1.0/0x10000;
#endif

#if (IND & (I810_FLAT_BIT|I810_TWOSIDE_BIT))
   int c0 = *(int *)&i810VB[pv].v.v.color; 
   int c1 = c0;
   int c2 = c0;
#endif


#if (IND & (I810_TWOSIDE_BIT|I810_OFFSET_BIT)) 
   {
      GLfloat ex = v0->x - v2->x;
      GLfloat ey = v0->y - v2->y;
      GLfloat fx = v1->x - v2->x;
      GLfloat fy = v1->y - v2->y;
      GLfloat c = ex*fy-ey*fx;
	 
#if (IND & I810_TWOSIDE_BIT) 
      {
	 GLuint facing = (c>0.0) ^ ctx->Polygon.FrontBit;
	 GLubyte (*vbcolor)[4] = VB->Color[facing]->data;
	 if (IND & I810_FLAT_BIT) {
	    I810_COLOR((char *)&c0,vbcolor[pv]);
	    c2 = c1 = c0;
	 } else {
	    I810_COLOR((char *)&c0,vbcolor[e0]);
	    I810_COLOR((char *)&c1,vbcolor[e1]);
	    I810_COLOR((char *)&c2,vbcolor[e2]);
	 }
      }
#endif
      
#if (IND & I810_OFFSET_BIT) 
      {
	 if (c * c > 1e-16) {
	    GLfloat factor = ctx->Polygon.OffsetFactor;
	    GLfloat ez = v0->z - v2->z;
	    GLfloat fz = v1->z - v2->z;
	    GLfloat a = ey*fz-ez*fy;
	    GLfloat b = ez*fx-ex*fz;
	    GLfloat ic = 1.0 / c;
	    GLfloat ac = a * ic;
	    GLfloat bc = b * ic;
	    if (ac<0.0F)  ac = -ac;
	    if (bc<0.0F)  bc = -bc;
	    offset += MAX2( ac, bc ) * factor;
	 }
      }
#endif
   }
#endif  

   i810glx.c_triangles++;

#if 0
#define WID 512
#define HI 384
   {
      GLuint print = 0, draw = 1;
      GLfloat area = ((v0->x - v2->x) * (v1->y - v2->y) -
		      (v0->y - v2->y) * (v1->x - v2->x));

      if (v0->x < -.501 || v0->x > WID || v0->y < -.501 || v0->y > HI ||
	  v1->x < -.501 || v1->x > WID || v1->y < -.501 || v1->y > HI ||
	  v2->x < -.501 || v2->x > WID || v2->y < -.501 || v2->y > HI) {
	 fprintf(stderr, "not clipped\n");
	 print = 1;
      } 

      if (area == 0 && ((v0 == v1) || (v1 == v2))) {
	 fprintf(stderr, "zero area %p %p %p\n", v0, v1, v2);
	 draw = 0;
      }

      if (print) {
	 fprintf(stderr,"v0: %f %f %f %f col: %x tex: %f %f\n",
		 v0->x, v0->y, v0->z, v0->oow, 
		 *(GLuint*)&v0->color, v0->tu0, v0->tv0);
	 fprintf(stderr,"v1: %f %f %f %f col: %x tex: %f %f\n",
		 v1->x, v1->y, v1->z, v1->oow, 
		 *(GLuint*)&v1->color, v1->tu0, v1->tv0);
	 fprintf(stderr,"v2: %f %f %f %f col: %x tex: %f %f\n",
		 v2->x, v2->y, v2->z, v2->oow, 
		 *(GLuint*)&v2->color, v2->tu0, v2->tv0);
/*  	 return; */
      }
      
      if (!draw) return;
   }
#endif
   
   {
      i810_vertex *wv = (i810_vertex *)i810AllocPrimitiveVerts( 3 * 10 );
      wv[0] = *v0;
#if (IND & (I810_FLAT_BIT|I810_TWOSIDE_BIT))
      *((int *)(&wv[0].color)) = c0;
#endif
#if (IND & I810_OFFSET_BIT)
      wv[0].z = v0->z + offset;
#endif


      wv[1] = *v1;
#if (IND & (I810_FLAT_BIT|I810_TWOSIDE_BIT))
      *((int *)(&wv[1].color)) = c1;
#endif
#if (IND & I810_OFFSET_BIT)
      wv[1].z = v1->z + offset;
#endif

      wv[2] = *v2;
#if (IND & (I810_FLAT_BIT|I810_TWOSIDE_BIT))
      *((int *)(&wv[2].color)) = c2;
#endif
#if (IND & I810_OFFSET_BIT)
      wv[2].z = v2->z + offset;
#endif

      FINISH_PRIM();
   }
}



static void TAG(quad)( GLcontext *ctx, GLuint v0,
		       GLuint v1, GLuint v2, GLuint v3, 
		       GLuint pv )
{
   TAG(triangle)( ctx, v0, v1, v3, pv );
   TAG(triangle)( ctx, v1, v2, v3, pv );
}


#if ((IND & ~I810_FLAT_BIT) == 0)

static void TAG(line)( GLcontext *ctx, GLuint v0, GLuint v1, GLuint pv )
{
   i810VertexPtr i810VB = I810_DRIVER_DATA(ctx->VB)->verts;
   i810_vertex tmp0 = i810VB[v0].v.v;
   i810_vertex tmp1 = i810VB[v1].v.v;
   float width = ctx->Line.Width;

   if (IND & I810_FLAT_BIT) {
      *(int *)&tmp1.color = *(int *)&tmp0.color = 
	 *(int *)&i810VB[pv].v.v.color;
   }

   i810_draw_line( &tmp0, &tmp1, width );
}


static void TAG(points)( GLcontext *ctx, GLuint first, GLuint last )
{
   int i;
   struct vertex_buffer *VB = ctx->VB;
   i810VertexPtr i810VB = I810_DRIVER_DATA(VB)->verts;
   GLfloat sz = ctx->Point.Size * .5;

   /* Culling is disabled automatically via. the
    * ctx->Driver.ReducedPrimitiveChange() callback.  
    */

   for(i=first;i<=last;i++) {
      if(VB->ClipMask[i]==0) {
	 i810_vertex *tmp = &i810VB[i].v.v;
	 i810_draw_point( tmp, sz );
      }
   }
}

#endif


static void TAG(init)()
{
   tri_tab[IND] = TAG(triangle);
   quad_tab[IND] = TAG(quad);

#if ((IND & ~I810_FLAT_BIT) == 0) 
   line_tab[IND] = TAG(line);
   points_tab[IND] = TAG(points);
#endif
}


#undef IND
#undef TAG
