/*
 * GLX Hardware Device Driver for Intel i810
 * Copyright (C) 1999 Wittawat Yamwong
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 */

/* $Id: i810glx.h,v 1.1 1999/12/13 12:47:44 keithw Exp $ */

#ifndef I810GLX_INC
#define I810GLX_INC

void i810DumpDB(struct i810_dest_buffer *buf);
void i810GLXCreateDepthBuffer(GLcontext* ctx);
void i810GLXDestroyImage(GLXImage* image);
GLXImage* i810GLXCreateImage(WindowPtr pwindow, int depth, int width, int height);
GLboolean i810GLXMakeCurrent( XSMesaContext c );
GLboolean i810GLXBindBuffer( XSMesaContext c, XSMesaBuffer b );
XSMesaContext i810GLXCreateContext( XSMesaVisual v,  
                                   XSMesaContext share_list );
void i810GLXDestroyContext( XSMesaContext c );

extern int i810BackToFront(DrawablePtr drawable, struct i810_dest_buffer *buf);
extern void (*i810GLXSwapBuffers)(XSMesaBuffer b);
extern void i810PerformanceBoxes( int is_direct );


#endif
