/* pointers.c,v 1.1 1998/10/10 11:31:28 ripperda Exp */

/*
 * Mesa 3-D graphics library
 * Version:  3.0
 * Copyright (C) 1995-1998  Brian Paul
 * Copyright (C) 1998 Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
 * OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR  
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


/*
 * pointers.c,v
 * Revision 1.1  1998/10/10 11:31:28  ripperda
 * added for api table, integrating with Mesa
 *
 * Revision 3.3  1998/06/07 22:18:52  brianp
 * implemented GL_EXT_multitexture extension
 *
 * Revision 3.2  1998/02/20 04:50:44  brianp
 * implemented GL_SGIS_multitexture
 *
 * Revision 3.1  1998/02/01 20:05:10  brianp
 * added glDrawRangenElements()
 *
 * Revision 3.0  1998/01/31 21:00:28  brianp
 * initial rev
 *
 */

#include "glxlib.h"
#include "pointers.h"
#include "misc.h"
#include "extensions.h"
#include "glx_varray.h"
#include "direct_protocol.h"


static void null_ptr_quit()
{
  fprintf(stderr, "libGL: Application called unsupported GL API function.\n\tFix the application!\n");
  exit(1);
}

static void check_pointers( struct gl_api_table *table )
{
   void **entry;
   int numentries = sizeof( struct gl_api_table ) / sizeof(void*);
   int i;

   entry = (void **) table;

   for (i=0;i<numentries;i++) {
      if (!entry[i]) {
	 entry[i] = (void *) null_ptr_quit;
      }
   }
}


/*
 * Assign all the pointers in 'table' to point to Mesa's immediate-mode
 * execution functions.
 */
static void init_indirect_execution_pointers( struct gl_api_table *table )
{
   table->Accum = __glx_Accum;
   table->AlphaFunc = __glx_AlphaFunc;
   table->AreTexturesResident = __glx_AreTexturesResident;
   table->ArrayElement = __glx_ArrayElement;
   table->Begin = __glx_Begin;
   table->BindTexture = __glx_BindTexture;
   table->Bitmap = __glx_Bitmap;
   table->BlendColor = __glx_BlendColorEXT;
   table->BlendEquation = __glx_BlendEquationEXT;
   table->BlendFunc = __glx_BlendFunc;
   table->CallList = __glx_CallList;
   table->CallLists = __glx_CallLists;
   table->Clear = __glx_Clear;
   table->ClearAccum = __glx_ClearAccum;
   table->ClearColor = __glx_ClearColor;
   table->ClearDepth = __glx_ClearDepth;
   table->ClearIndex = __glx_ClearIndex;
   table->ClearStencil = __glx_ClearStencil;
   table->ClipPlane = __glx_ClipPlane;
   table->Color3f = __glx_Color3f;
   table->Color3fv = __glx_Color3fv;
   table->Color4f = __glx_Color4f;
   table->Color4fv = __glx_Color4fv;
   table->Color4ub = __glx_Color4ub;
   table->Color4ubv = __glx_Color4ubv;
   table->ColorMask = __glx_ColorMask;
   table->ColorMaterial = __glx_ColorMaterial;
   table->ColorPointer = __glx_ColorPointer;

#if BUILD_COLOR_TABLE_EXT
   table->ColorTable = __glx_ColorTableEXT;
#if 0
   table->ColorSubTable = __glx_ColorSubTable;
#endif
#endif

   table->CopyPixels = __glx_CopyPixels;
   table->CopyTexImage1D = __glx_CopyTexImage1D;
   table->CopyTexImage2D = __glx_CopyTexImage2D;
   table->CopyTexSubImage1D = __glx_CopyTexSubImage1D;
   table->CopyTexSubImage2D = __glx_CopyTexSubImage2D;
#if 0
   table->CopyTexSubImage3DEXT = __glx_CopyTexSubImage3DEXT;
#endif
   table->CullFace = __glx_CullFace;
   table->DeleteLists = __glx_DeleteLists;
   table->DeleteTextures = __glx_DeleteTextures;
   table->DepthFunc = __glx_DepthFunc;
   table->DepthMask = __glx_DepthMask;
   table->DepthRange = __glx_DepthRange;
   table->Disable = __glx_disable_hook;
   table->DisableClientState = __glx_DisableClientState;
   table->DrawArrays = __glx_draw_arrays;
   table->DrawBuffer = __glx_DrawBuffer;
   table->DrawElements = __glx_draw_elements;					     
/*   table->DrawElements = __glx_DrawElements; */
   table->DrawPixels = __glx_DrawPixels;
   table->DrawRangeElements = __glx_DrawRangeElements;
   table->EdgeFlag = __glx_EdgeFlag;
   table->EdgeFlagPointer = __glx_EdgeFlagPointer;
   table->Enable = __glx_enable_hook;
   table->EnableClientState = __glx_EnableClientState;
   table->End = __glx_End;
   table->EndList = __glx_EndList;
   table->EvalCoord1f = __glx_EvalCoord1f;
   table->EvalCoord2f = __glx_EvalCoord2f;
   table->EvalMesh1 = __glx_EvalMesh1;
   table->EvalMesh2 = __glx_EvalMesh2;
   table->EvalPoint1 = __glx_EvalPoint1;
   table->EvalPoint2 = __glx_EvalPoint2;
   table->FeedbackBuffer = __glx_FeedbackBuffer;
   table->Finish = __glx_Finish;
   table->Flush = __glx_Flush;
   table->Fogfv = __glx_Fogfv;
   table->FrontFace = __glx_FrontFace;
   table->Frustum = __glx_Frustum;
   table->GenLists = __glx_GenLists;
   table->GenTextures = __glx_GenTextures;
   table->GetBooleanv = __glx_GetBooleanv;
   table->GetClipPlane = __glx_GetClipPlane;
#if 0
   table->GetColorTable = __glx_GetColorTable;
   table->GetColorTableParameteriv = __glx_GetColorTableParameteriv;
#endif
   table->GetDoublev = __glx_GetDoublev;
   table->GetError = __glx_GetError;
   table->GetFloatv = __glx_GetFloatv;
   table->GetIntegerv = __glx_GetIntegerv;
   table->GetPointerv = __glx_GetPointerv;
   table->GetLightfv = __glx_GetLightfv;
   table->GetLightiv = __glx_GetLightiv;
   table->GetMapdv = __glx_GetMapdv;
   table->GetMapfv = __glx_GetMapfv;
   table->GetMapiv = __glx_GetMapiv;
   table->GetMaterialfv = __glx_GetMaterialfv;
   table->GetMaterialiv = __glx_GetMaterialiv;
   table->GetPixelMapfv = __glx_GetPixelMapfv;
   table->GetPixelMapuiv = __glx_GetPixelMapuiv;
   table->GetPixelMapusv = __glx_GetPixelMapusv;
   table->GetPolygonStipple = __glx_GetPolygonStipple;
   table->GetString = __glx_GetString;
   table->GetTexEnvfv = __glx_GetTexEnvfv;
   table->GetTexEnviv = __glx_GetTexEnviv;
   table->GetTexGendv = __glx_GetTexGendv;
   table->GetTexGenfv = __glx_GetTexGenfv;
   table->GetTexGeniv = __glx_GetTexGeniv;
   table->GetTexImage = __glx_GetTexImage;
   table->GetTexLevelParameterfv = __glx_GetTexLevelParameterfv;
   table->GetTexLevelParameteriv = __glx_GetTexLevelParameteriv;
   table->GetTexParameterfv = __glx_GetTexParameterfv;
   table->GetTexParameteriv = __glx_GetTexParameteriv;
   table->Hint = __glx_Hint;
   table->Indexf = __glx_Indexf;
   table->Indexi = __glx_Indexi;
   table->IndexMask = __glx_IndexMask;
   table->IndexPointer = __glx_IndexPointer;
   table->InitNames = __glx_InitNames;
   table->InterleavedArrays = __glx_InterleavedArrays;
   table->IsEnabled = __glx_isenabled_hook;
   table->IsList = __glx_IsList;
   table->IsTexture = __glx_IsTexture;
   table->LightModelfv = __glx_LightModelfv;
   table->Lightfv = __glx_Lightfv;
   table->LineStipple = __glx_LineStipple;
   table->LineWidth = __glx_LineWidth;
   table->ListBase = __glx_ListBase;
   table->LoadIdentity = __glx_LoadIdentity;
   table->LoadMatrixf = __glx_LoadMatrixf;
   table->LoadName = __glx_LoadName;
   table->LogicOp = __glx_LogicOp;
   table->Map1d = __glx_Map1d;
   table->Map1f = __glx_Map1f;
   table->Map2d = __glx_Map2d;
   table->Map2f = __glx_Map2f;
   table->MapGrid1f = __glx_MapGrid1f;
   table->MapGrid2f = __glx_MapGrid2f;
   table->Materialfv = __glx_Materialfv;
   table->MatrixMode = __glx_MatrixMode;
   table->MultMatrixf = __glx_MultMatrixf;
   table->NewList = __glx_NewList;
   table->Normal3f = __glx_Normal3f;
   table->NormalPointer = __glx_NormalPointer;
   table->Normal3fv = __glx_Normal3fv;
   table->Ortho = __glx_Ortho;
   table->PassThrough = __glx_PassThrough;
   table->PixelMapfv = __glx_PixelMapfv;
   table->PixelStorei = __glx_PixelStorei;
   table->PixelTransferf = __glx_PixelTransferf;
   table->PixelZoom = __glx_PixelZoom;
   table->PointSize = __glx_PointSize;
   table->PolygonMode = __glx_PolygonMode;
   table->PolygonOffset = __glx_PolygonOffset;
   table->PolygonStipple = __glx_PolygonStipple;
   table->PopAttrib = __glx_PopAttrib;
   table->PopClientAttrib = __glx_PopClientAttrib;
   table->PopMatrix = __glx_PopMatrix;
   table->PopName = __glx_PopName;
   table->PrioritizeTextures = __glx_PrioritizeTextures;
   table->PushAttrib = __glx_PushAttrib;
   table->PushClientAttrib = __glx_PushClientAttrib;
   table->PushMatrix = __glx_PushMatrix;
   table->PushName = __glx_PushName;
   table->RasterPos4f = __glx_RasterPos4f;
   table->ReadBuffer = __glx_ReadBuffer;
   table->ReadPixels = __glx_ReadPixels;
   table->Rectf = __glx_Rectf;
   table->RenderMode = __glx_RenderMode;
   table->Rotatef = __glx_Rotatef;
   table->Scalef = __glx_Scalef;
   table->Scissor = __glx_Scissor;
   table->SelectBuffer = __glx_SelectBuffer;
   table->ShadeModel = __glx_ShadeModel;
   table->StencilFunc = __glx_StencilFunc;
   table->StencilMask = __glx_StencilMask;
   table->StencilOp = __glx_StencilOp;
   table->TexCoord2f = __glx_TexCoord2f;
   table->TexCoord4f = __glx_TexCoord4f;
   table->TexCoordPointer = __glx_TexCoordPointer;
   table->TexEnvfv = __glx_TexEnvfv;
   table->TexGenfv = __glx_TexGenfv;
   table->TexImage1D = __glx_TexImage1D;
   table->TexImage2D = __glx_TexImage2D;
#if 0
   table->TexImage3DEXT = __glx_TexImage3DEXT;
#endif
   table->TexSubImage1D = __glx_TexSubImage1D;
   table->TexSubImage2D = __glx_TexSubImage2D;
#if 0
   table->TexSubImage3DEXT = __glx_TexSubImage3DEXT;
   table->PointParameterfvEXT = __glx_PointParameterfvEXT;
#endif
   table->TexParameterfv = __glx_TexParameterfv;
   table->Translatef = __glx_Translatef;

   table->Vertex2d = __glx_Vertex2d;
   table->Vertex2dv = __glx_Vertex2dv;
   table->Vertex2f = __glx_Vertex2f;
   table->Vertex2fv = __glx_Vertex2fv;
   table->Vertex2i = __glx_Vertex2i;
   table->Vertex2iv = __glx_Vertex2iv;
   table->Vertex2s = __glx_Vertex2s;
   table->Vertex2sv = __glx_Vertex2sv;

   table->Vertex3d = __glx_Vertex3d;
   table->Vertex3dv = __glx_Vertex3dv;
   table->Vertex3f = __glx_Vertex3f;
   table->Vertex3fv = __glx_Vertex3fv;
   table->Vertex3i = __glx_Vertex3i;
   table->Vertex3iv = __glx_Vertex3iv;
   table->Vertex3s = __glx_Vertex3s;
   table->Vertex3sv = __glx_Vertex3sv;

   table->Vertex4d = __glx_Vertex4d;
   table->Vertex4dv = __glx_Vertex4dv;
   table->Vertex4f = __glx_Vertex4f;
   table->Vertex4fv = __glx_Vertex4fv;
   table->Vertex4i = __glx_Vertex4i;
   table->Vertex4iv = __glx_Vertex4iv;
   table->Vertex4s = __glx_Vertex4s;
   table->Vertex4sv = __glx_Vertex4sv;

   table->VertexPointer = __glx_VertexPointer;
   table->Viewport = __glx_Viewport;

#if 0
   /* GL_MESA_window_pos extension */
   table->WindowPos4fMESA = __glx_WindowPos4fMESA;

   /* GL_MESA_resize_buffers extension */
   table->ResizeBuffersMESA = __glx_ResizeBuffersMESA;

   /* GL_SGIS_multitexture / GL_EXT_multitexture */
   table->MultiTexCoord4f = __glx_MultiTexCoord4f;
   table->MultiTexCoordPointer = __glx_MultiTexCoordPointer;
   table->InterleavedTextureCoordSets = __glx_InterleavedTextureCoordSets;
   table->SelectTextureSGIS = __glx_SelectTextureSGIS;
   table->SelectTexture = __glx_SelectTexture;
   table->SelectTextureCoordSet = __glx_SelectTextureCoordSet;
   table->SelectTextureTransform = __glx_SelectTextureTransform;
#endif
}


#include <stdio.h>
#include <dlfcn.h>

static int any_error;

static void *my_dlsym(void *handle, const char *name)
{
   void *tmp = dlsym(handle, name);
   char *error;
/*     fprintf(stderr, "sym: %s\n", name); */
   if ((error = dlerror()) != 0) {
      fputs(error, stderr);
      any_error = 1;
      return 0;
   }
   return tmp;
}


int __glx_init_direct_execution_pointers( void *lib, 
					  struct gl_api_table *table )
{
   any_error = 0;
   table->Accum = my_dlsym(lib, "glAccum");
   table->AlphaFunc = my_dlsym(lib, "glAlphaFunc");
   table->AreTexturesResident = my_dlsym(lib, "glAreTexturesResident");
   table->ArrayElement = my_dlsym(lib, "glArrayElement");
   table->Begin = my_dlsym(lib, "glBegin");
   table->BindTexture = my_dlsym(lib, "glBindTexture");
   table->Bitmap = my_dlsym(lib, "glBitmap");
   table->BlendColor = my_dlsym(lib, "glBlendColorEXT");
   table->BlendEquation = my_dlsym(lib, "glBlendEquationEXT");
   table->BlendFunc = my_dlsym(lib, "glBlendFunc");
   table->CallList = my_dlsym(lib, "glCallList");
   table->CallLists = my_dlsym(lib, "glCallLists");
   table->Clear = my_dlsym(lib, "glClear");
   table->ClearAccum = my_dlsym(lib, "glClearAccum");
   table->ClearColor = my_dlsym(lib, "glClearColor");
   table->ClearDepth = my_dlsym(lib, "glClearDepth");
   table->ClearIndex = my_dlsym(lib, "glClearIndex");
   table->ClearStencil = my_dlsym(lib, "glClearStencil");
   table->ClipPlane = my_dlsym(lib, "glClipPlane");
   table->Color3f = my_dlsym(lib, "glColor3f");
   table->Color3fv = my_dlsym(lib, "glColor3fv");
   table->Color4f = my_dlsym(lib, "glColor4f");
   table->Color4fv = my_dlsym(lib, "glColor4fv");
   table->Color4ub = my_dlsym(lib, "glColor4ub");
   table->Color4ubv = my_dlsym(lib, "glColor4ubv");
   table->ColorMask = my_dlsym(lib, "glColorMask");
   table->ColorMaterial = my_dlsym(lib, "glColorMaterial");
   table->ColorPointer = my_dlsym(lib, "glColorPointer");

#if BUILD_COLOR_TABLE_EXT
   table->ColorTable = my_dlsym(lib, "glColorTableEXT");
#if 0
   table->ColorSubTable = my_dlsym(lib, "glColorSubTableEXT");
#endif
#endif

   table->CopyPixels = my_dlsym(lib, "glCopyPixels");
   table->CopyTexImage1D = my_dlsym(lib, "glCopyTexImage1D");
   table->CopyTexImage2D = my_dlsym(lib, "glCopyTexImage2D");
   table->CopyTexSubImage1D = my_dlsym(lib, "glCopyTexSubImage1D");
   table->CopyTexSubImage2D = my_dlsym(lib, "glCopyTexSubImage2D");
   table->CopyTexSubImage3DEXT = my_dlsym(lib, "glCopyTexSubImage3DEXT");
   table->CullFace = my_dlsym(lib, "glCullFace");
   table->DeleteLists = my_dlsym(lib, "glDeleteLists");
   table->DeleteTextures = my_dlsym(lib, "glDeleteTextures");
   table->DepthFunc = my_dlsym(lib, "glDepthFunc");
   table->DepthMask = my_dlsym(lib, "glDepthMask");
   table->DepthRange = my_dlsym(lib, "glDepthRange");
   table->Disable = my_dlsym(lib, "glDisable");
   table->DisableClientState = my_dlsym(lib, "glDisableClientState");
   table->DrawArrays = my_dlsym(lib, "glDrawArrays");
   table->DrawBuffer = my_dlsym(lib, "glDrawBuffer");
   table->DrawElements = my_dlsym(lib, "glDrawElements");
   table->DrawPixels = my_dlsym(lib, "glDrawPixels");
   table->DrawRangeElements = my_dlsym(lib, "glDrawRangeElements");
   table->EdgeFlag = my_dlsym(lib, "glEdgeFlag");
   table->EdgeFlagPointer = my_dlsym(lib, "glEdgeFlagPointer");
   table->Enable = my_dlsym(lib, "glEnable");
   table->EnableClientState = my_dlsym(lib, "glEnableClientState");
   table->End = my_dlsym(lib, "glEnd");
   table->EndList = my_dlsym(lib, "glEndList");
   table->EvalCoord1f = my_dlsym(lib, "glEvalCoord1f");
   table->EvalCoord2f = my_dlsym(lib, "glEvalCoord2f");
   table->EvalMesh1 = my_dlsym(lib, "glEvalMesh1");
   table->EvalMesh2 = my_dlsym(lib, "glEvalMesh2");
   table->EvalPoint1 = my_dlsym(lib, "glEvalPoint1");
   table->EvalPoint2 = my_dlsym(lib, "glEvalPoint2");
   table->FeedbackBuffer = my_dlsym(lib, "glFeedbackBuffer");
   table->Finish = my_dlsym(lib, "glFinish");
   table->Flush = my_dlsym(lib, "glFlush");
   table->Fogfv = my_dlsym(lib, "glFogfv");
   table->FrontFace = my_dlsym(lib, "glFrontFace");
   table->Frustum = my_dlsym(lib, "glFrustum");
   table->GenLists = my_dlsym(lib, "glGenLists");
   table->GenTextures = my_dlsym(lib, "glGenTextures");
   table->GetBooleanv = my_dlsym(lib, "glGetBooleanv");
   table->GetClipPlane = my_dlsym(lib, "glGetClipPlane");

#if BUILD_COLOR_TABLE_EXT
   table->GetColorTable = my_dlsym(lib, "glGetColorTableEXT");
   table->GetColorTableParameteriv = my_dlsym(lib, "glGetColorTableParameterivEXT");
#endif

   table->GetDoublev = my_dlsym(lib, "glGetDoublev");
   table->GetError = my_dlsym(lib, "glGetError");
   table->GetFloatv = my_dlsym(lib, "glGetFloatv");
   table->GetIntegerv = my_dlsym(lib, "glGetIntegerv");
   table->GetPointerv = my_dlsym(lib, "glGetPointerv");
   table->GetLightfv = my_dlsym(lib, "glGetLightfv");
   table->GetLightiv = my_dlsym(lib, "glGetLightiv");
   table->GetMapdv = my_dlsym(lib, "glGetMapdv");
   table->GetMapfv = my_dlsym(lib, "glGetMapfv");
   table->GetMapiv = my_dlsym(lib, "glGetMapiv");
   table->GetMaterialfv = my_dlsym(lib, "glGetMaterialfv");
   table->GetMaterialiv = my_dlsym(lib, "glGetMaterialiv");
   table->GetPixelMapfv = my_dlsym(lib, "glGetPixelMapfv");
   table->GetPixelMapuiv = my_dlsym(lib, "glGetPixelMapuiv");
   table->GetPixelMapusv = my_dlsym(lib, "glGetPixelMapusv");
   table->GetPolygonStipple = my_dlsym(lib, "glGetPolygonStipple");
   table->GetString = my_dlsym(lib, "glGetString");
   table->GetTexEnvfv = my_dlsym(lib, "glGetTexEnvfv");
   table->GetTexEnviv = my_dlsym(lib, "glGetTexEnviv");
   table->GetTexGendv = my_dlsym(lib, "glGetTexGendv");
   table->GetTexGenfv = my_dlsym(lib, "glGetTexGenfv");
   table->GetTexGeniv = my_dlsym(lib, "glGetTexGeniv");
   table->GetTexImage = my_dlsym(lib, "glGetTexImage");
   table->GetTexLevelParameterfv = my_dlsym(lib, "glGetTexLevelParameterfv");
   table->GetTexLevelParameteriv = my_dlsym(lib, "glGetTexLevelParameteriv");
   table->GetTexParameterfv = my_dlsym(lib, "glGetTexParameterfv");
   table->GetTexParameteriv = my_dlsym(lib, "glGetTexParameteriv");
   table->Hint = my_dlsym(lib, "glHint");
   table->Indexf = my_dlsym(lib, "glIndexf");
   table->Indexi = my_dlsym(lib, "glIndexi");
   table->IndexMask = my_dlsym(lib, "glIndexMask");
   table->IndexPointer = my_dlsym(lib, "glIndexPointer");
   table->InitNames = my_dlsym(lib, "glInitNames");
   table->InterleavedArrays = my_dlsym(lib, "glInterleavedArrays");
   table->IsEnabled = my_dlsym(lib, "glIsEnabled");
   table->IsList = my_dlsym(lib, "glIsList");
   table->IsTexture = my_dlsym(lib, "glIsTexture");
   table->LightModelfv = my_dlsym(lib, "glLightModelfv");
   table->Lightfv = my_dlsym(lib, "glLightfv");
   table->LineStipple = my_dlsym(lib, "glLineStipple");
   table->LineWidth = my_dlsym(lib, "glLineWidth");
   table->ListBase = my_dlsym(lib, "glListBase");
   table->LoadIdentity = my_dlsym(lib, "glLoadIdentity");
   table->LoadMatrixf = my_dlsym(lib, "glLoadMatrixf");
   table->LoadName = my_dlsym(lib, "glLoadName");
   table->LogicOp = my_dlsym(lib, "glLogicOp");
   table->Map1f = my_dlsym(lib, "glMap1f");
   table->Map2f = my_dlsym(lib, "glMap2f");
   table->MapGrid1f = my_dlsym(lib, "glMapGrid1f");
   table->MapGrid2f = my_dlsym(lib, "glMapGrid2f");
   table->Materialfv = my_dlsym(lib, "glMaterialfv");
   table->MatrixMode = my_dlsym(lib, "glMatrixMode");
   table->MultMatrixf = my_dlsym(lib, "glMultMatrixf");
   table->NewList = my_dlsym(lib, "glNewList");
   table->Normal3f = my_dlsym(lib, "glNormal3f");
   table->NormalPointer = my_dlsym(lib, "glNormalPointer");
   table->Normal3fv = my_dlsym(lib, "glNormal3fv");
   table->Ortho = my_dlsym(lib, "glOrtho");
   table->PassThrough = my_dlsym(lib, "glPassThrough");
   table->PixelMapfv = my_dlsym(lib, "glPixelMapfv");
   table->PixelStorei = my_dlsym(lib, "glPixelStorei");
   table->PixelTransferf = my_dlsym(lib, "glPixelTransferf");
   table->PixelZoom = my_dlsym(lib, "glPixelZoom");
   table->PointSize = my_dlsym(lib, "glPointSize");
   table->PolygonMode = my_dlsym(lib, "glPolygonMode");
   table->PolygonOffset = my_dlsym(lib, "glPolygonOffset");
   table->PolygonStipple = my_dlsym(lib, "glPolygonStipple");
   table->PopAttrib = my_dlsym(lib, "glPopAttrib");
   table->PopClientAttrib = my_dlsym(lib, "glPopClientAttrib");
   table->PopMatrix = my_dlsym(lib, "glPopMatrix");
   table->PopName = my_dlsym(lib, "glPopName");
   table->PrioritizeTextures = my_dlsym(lib, "glPrioritizeTextures");
   table->PushAttrib = my_dlsym(lib, "glPushAttrib");
   table->PushClientAttrib = my_dlsym(lib, "glPushClientAttrib");
   table->PushMatrix = my_dlsym(lib, "glPushMatrix");
   table->PushName = my_dlsym(lib, "glPushName");
   table->RasterPos4f = my_dlsym(lib, "glRasterPos4f");
   table->ReadBuffer = my_dlsym(lib, "glReadBuffer");
   table->ReadPixels = my_dlsym(lib, "glReadPixels");
   table->Rectf = my_dlsym(lib, "glRectf");
   table->RenderMode = my_dlsym(lib, "glRenderMode");
   table->Rotatef = my_dlsym(lib, "glRotatef");
   table->Scalef = my_dlsym(lib, "glScalef");
   table->Scissor = my_dlsym(lib, "glScissor");
   table->SelectBuffer = my_dlsym(lib, "glSelectBuffer");
   table->ShadeModel = my_dlsym(lib, "glShadeModel");
   table->StencilFunc = my_dlsym(lib, "glStencilFunc");
   table->StencilMask = my_dlsym(lib, "glStencilMask");
   table->StencilOp = my_dlsym(lib, "glStencilOp");
   table->TexCoord2f = my_dlsym(lib, "glTexCoord2f");
   table->TexCoord4f = my_dlsym(lib, "glTexCoord4f");
   table->TexCoordPointer = my_dlsym(lib, "glTexCoordPointer");
   table->TexEnvfv = my_dlsym(lib, "glTexEnvfv");
   table->TexGenfv = my_dlsym(lib, "glTexGenfv");
   table->TexImage1D = my_dlsym(lib, "glTexImage1D");
   table->TexImage2D = my_dlsym(lib, "glTexImage2D");
/*     table->TexImage3DEXT = my_dlsym(lib, "glTexImage3DEXT"); */
   table->TexSubImage1D = my_dlsym(lib, "glTexSubImage1D");
   table->TexSubImage2D = my_dlsym(lib, "glTexSubImage2D");
/*     table->TexSubImage3DEXT = my_dlsym(lib, "glTexSubImage3DEXT"); */
   table->PointParameterfvEXT = my_dlsym(lib, "glPointParameterfvEXT");
   table->TexParameterfv = my_dlsym(lib, "glTexParameterfv");
   table->Translatef = my_dlsym(lib, "glTranslatef");


   table->Vertex2d = my_dlsym(lib, "glVertex2d");
   table->Vertex2dv = my_dlsym(lib, "glVertex2dv");
   table->Vertex2f = my_dlsym(lib, "glVertex2f");
   table->Vertex2fv = my_dlsym(lib, "glVertex2fv");
   table->Vertex2i = my_dlsym(lib, "glVertex2i");
   table->Vertex2iv = my_dlsym(lib, "glVertex2iv");
   table->Vertex2s = my_dlsym(lib, "glVertex2s");
   table->Vertex2sv = my_dlsym(lib, "glVertex2sv");

   table->Vertex3d = my_dlsym(lib, "glVertex3d");
   table->Vertex3dv = my_dlsym(lib, "glVertex3dv");
   table->Vertex3f = my_dlsym(lib, "glVertex3f");
   table->Vertex3fv = my_dlsym(lib, "glVertex3fv");
   table->Vertex3i = my_dlsym(lib, "glVertex3i");
   table->Vertex3iv = my_dlsym(lib, "glVertex3iv");
   table->Vertex3s = my_dlsym(lib, "glVertex3s");
   table->Vertex3sv = my_dlsym(lib, "glVertex3sv");

   table->Vertex4d = my_dlsym(lib, "glVertex4d");
   table->Vertex4dv = my_dlsym(lib, "glVertex4dv");
   table->Vertex4f = my_dlsym(lib, "glVertex4f");
   table->Vertex4fv = my_dlsym(lib, "glVertex4fv");
   table->Vertex4i = my_dlsym(lib, "glVertex4i");
   table->Vertex4iv = my_dlsym(lib, "glVertex4iv");
   table->Vertex4s = my_dlsym(lib, "glVertex4s");
   table->Vertex4sv = my_dlsym(lib, "glVertex4sv");

   table->VertexPointer = my_dlsym(lib, "glVertexPointer");
   table->Viewport = my_dlsym(lib, "glViewport");
   table->WindowPos4fMESA = my_dlsym(lib, "glWindowPos4fMESA");
   table->ResizeBuffersMESA = my_dlsym(lib, "glResizeBuffersMESA");

#if defined(MESA31)
   /* GL_ARB_multitexture */
   table->MultiTexCoord1f = my_dlsym(lib, "glMultiTexCoord1fARB");
   table->MultiTexCoord2f = my_dlsym(lib, "glMultiTexCoord2fARB");
   table->MultiTexCoord3f = my_dlsym(lib, "glMultiTexCoord3fARB");
   table->MultiTexCoord4f = my_dlsym(lib, "glMultiTexCoord4fARB");
   table->ActiveTexture = my_dlsym(lib, "glActiveTextureARB");
   table->ClientActiveTexture = my_dlsym(lib, "glClientActiveTextureARB");

   /* GL_EXT_compiled_vertex_array */
   table->LockArrays = my_dlsym(lib, "glLockArraysEXT");
   table->UnlockArrays = my_dlsym(lib, "glUnlockArraysEXT");
#endif

   return any_error == 0;
}





void glx_init_api_function_pointers( GLContext *ctx )
{
   extern Proto directProto;

   if (ctx->ContextType == _GLX_DIRECT) {
      ctx->API = *(directProto.api_table);
   } else {
      init_indirect_execution_pointers( &ctx->API );
   }
   check_pointers(&ctx->API);
}

