/* apiext.c,v 1.1 1998/10/10 11:31:28 ripperda Exp */

/*
 * Mesa 3-D graphics library
 * Version:  3.0
 * Copyright (C) 1995-1998  Brian Paul
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


/*
 * apiext.c,v
 * Revision 1.1  1998/10/10 11:31:28  ripperda
 * added for api table, integrating with Mesa
 *
 * Revision 3.2  1998/06/07 22:18:52  brianp
 * implemented GL_EXT_multitexture extension
 *
 * Revision 3.1  1998/03/27 03:30:36  brianp
 * fixed G++ warnings
 *
 * Revision 3.0  1998/02/20 04:45:50  brianp
 * implemented GL_SGIS_multitexture
 *
 */

#include "glxlib.h"
#include "api.h"
#include <GL/gl.h>


/*
 * Extension API functions
 */



/*
 * GL_EXT_blend_minmax
 */

void APIENTRY glBlendEquationEXT( GLenum mode )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.BlendEquation)( mode);
}




/*
 * GL_EXT_blend_color
 */

void APIENTRY glBlendColorEXT( GLclampf red, GLclampf green,
                               GLclampf blue, GLclampf alpha )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.BlendColor)( red, green, blue, alpha);
}




/*
 * GL_EXT_vertex_array
 */

void APIENTRY glVertexPointerEXT( GLint size, GLenum type, GLsizei stride,
                                  GLsizei count, const GLvoid *ptr )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.VertexPointer)( size, type, stride, ptr);
   (void) count;
}


void APIENTRY glNormalPointerEXT( GLenum type, GLsizei stride, GLsizei count,
                                  const GLvoid *ptr )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.NormalPointer)( type, stride, ptr);
   (void) count;
}


void APIENTRY glColorPointerEXT( GLint size, GLenum type, GLsizei stride,
                                 GLsizei count, const GLvoid *ptr )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ColorPointer)( size, type, stride, ptr);
   (void) count;
}


void APIENTRY glIndexPointerEXT( GLenum type, GLsizei stride,
                                 GLsizei count, const GLvoid *ptr )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.IndexPointer)( type, stride, ptr);
   (void) count;
}


void APIENTRY glTexCoordPointerEXT( GLint size, GLenum type, GLsizei stride,
                                    GLsizei count, const GLvoid *ptr )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.TexCoordPointer)( size, type, stride, ptr);
   (void) count;
}


void APIENTRY glEdgeFlagPointerEXT( GLsizei stride, GLsizei count,
                                    const GLboolean *ptr )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.EdgeFlagPointer)( stride, ptr);
   (void) count;
}


void APIENTRY glGetPointervEXT( GLenum pname, GLvoid **params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.GetPointerv)( pname, params);
}


void APIENTRY glArrayElementEXT( GLint i )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ArrayElement)( i);
}


void APIENTRY glDrawArraysEXT( GLenum mode, GLint first, GLsizei count )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.DrawArrays)( mode, first, count);
}




/*
 * GL_EXT_texture_object
 */

GLboolean APIENTRY glAreTexturesResidentEXT( GLsizei n, const GLuint *textures,
                                             GLboolean *residences )
{
   return glAreTexturesResident( n, textures, residences );
}


void APIENTRY glBindTextureEXT( GLenum target, GLuint texture )
{
   glBindTexture( target, texture );
}


void APIENTRY glDeleteTexturesEXT( GLsizei n, const GLuint *textures)
{
   glDeleteTextures( n, textures );
}


void APIENTRY glGenTexturesEXT( GLsizei n, GLuint *textures )
{
   glGenTextures( n, textures );
}


GLboolean APIENTRY glIsTextureEXT( GLuint texture )
{
   return glIsTexture( texture );
}


void APIENTRY glPrioritizeTexturesEXT( GLsizei n, const GLuint *textures,
                                       const GLclampf *priorities )
{
   glPrioritizeTextures( n, textures, priorities );
}




/*
 * GL_EXT_texture3D
 */

void APIENTRY glCopyTexSubImage3DEXT( GLenum target, GLint level, GLint xoffset,
                                      GLint yoffset, GLint zoffset,
                                      GLint x, GLint y, GLsizei width,
                                      GLsizei height )
{
   glCopyTexSubImage3D(target, level, xoffset, yoffset, zoffset,
                       x, y, width, height);
}


#if 0
void APIENTRY glTexImage3DEXT( GLenum target, GLint level, GLenum internalformat,
                               GLsizei width, GLsizei height, GLsizei depth,
                               GLint border, GLenum format, GLenum type,
                               const GLvoid *pixels )
{
   glTexImage3D(target, level, internalformat, width, height, depth,
                border, format, type, pixels);
}

void APIENTRY glTexSubImage3DEXT( GLenum target, GLint level, GLint xoffset,
                                  GLint yoffset, GLint zoffset, GLsizei width,
                                  GLsizei height, GLsizei depth, GLenum format,
                                  GLenum type, const GLvoid *pixels )
{
   glTexSubImage3D(target, level, xoffset, yoffset, zoffset,
                   width, height, depth, format, type, pixels);
}
#endif




/*
 * GL_EXT_point_parameters
 */

void APIENTRY glPointParameterfEXT( GLenum pname, GLfloat param )
{
   GLfloat params[3];
   GET_CONTEXT;
   CHECK_CONTEXT;
   params[0] = param;
   params[1] = 0.0;
   params[2] = 0.0;
   (*GLCurrent->API.PointParameterfvEXT)( pname, params);
}


void APIENTRY glPointParameterfvEXT( GLenum pname, const GLfloat *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PointParameterfvEXT)( pname, params);
}




#ifdef GL_MESA_window_pos
/*
 * Mesa implementation of glWindowPos*MESA()
 */
void APIENTRY glWindowPos4fMESA( GLfloat x, GLfloat y, GLfloat z, GLfloat w )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.WindowPos4fMESA)( x, y, z, w );
}
#else
/* Implementation in winpos.c is used */
#endif


void APIENTRY glWindowPos2iMESA( GLint x, GLint y )
{
   glWindowPos4fMESA( (GLfloat) x, (GLfloat) y, 0.0F, 1.0F );
}

void APIENTRY glWindowPos2sMESA( GLshort x, GLshort y )
{
   glWindowPos4fMESA( (GLfloat) x, (GLfloat) y, 0.0F, 1.0F );
}

void APIENTRY glWindowPos2fMESA( GLfloat x, GLfloat y )
{
   glWindowPos4fMESA( x, y, 0.0F, 1.0F );
}

void APIENTRY glWindowPos2dMESA( GLdouble x, GLdouble y )
{
   glWindowPos4fMESA( (GLfloat) x, (GLfloat) y, 0.0F, 1.0F );
}

void APIENTRY glWindowPos2ivMESA( const GLint *p )
{
   glWindowPos4fMESA( (GLfloat) p[0], (GLfloat) p[1], 0.0F, 1.0F );
}

void APIENTRY glWindowPos2svMESA( const GLshort *p )
{
   glWindowPos4fMESA( (GLfloat) p[0], (GLfloat) p[1], 0.0F, 1.0F );
}

void APIENTRY glWindowPos2fvMESA( const GLfloat *p )
{
   glWindowPos4fMESA( p[0], p[1], 0.0F, 1.0F );
}

void APIENTRY glWindowPos2dvMESA( const GLdouble *p )
{
   glWindowPos4fMESA( (GLfloat) p[0], (GLfloat) p[1], 0.0F, 1.0F );
}

void APIENTRY glWindowPos3iMESA( GLint x, GLint y, GLint z )
{
   glWindowPos4fMESA( (GLfloat) x, (GLfloat) y, (GLfloat) z, 1.0F );
}

void APIENTRY glWindowPos3sMESA( GLshort x, GLshort y, GLshort z )
{
   glWindowPos4fMESA( (GLfloat) x, (GLfloat) y, (GLfloat) z, 1.0F );
}

void APIENTRY glWindowPos3fMESA( GLfloat x, GLfloat y, GLfloat z )
{
   glWindowPos4fMESA( x, y, z, 1.0F );
}

void APIENTRY glWindowPos3dMESA( GLdouble x, GLdouble y, GLdouble z )
{
   glWindowPos4fMESA( (GLfloat) x, (GLfloat) y, (GLfloat) z, 1.0F );
}

void APIENTRY glWindowPos3ivMESA( const GLint *p )
{
   glWindowPos4fMESA( (GLfloat) p[0], (GLfloat) p[1], (GLfloat) p[2], 1.0F );
}

void APIENTRY glWindowPos3svMESA( const GLshort *p )
{
   glWindowPos4fMESA( (GLfloat) p[0], (GLfloat) p[1], (GLfloat) p[2], 1.0F );
}

void APIENTRY glWindowPos3fvMESA( const GLfloat *p )
{
   glWindowPos4fMESA( p[0], p[1], p[2], 1.0F );
}

void APIENTRY glWindowPos3dvMESA( const GLdouble *p )
{
   glWindowPos4fMESA( (GLfloat) p[0], (GLfloat) p[1], (GLfloat) p[2], 1.0F );
}

void APIENTRY glWindowPos4iMESA( GLint x, GLint y, GLint z, GLint w )
{
   glWindowPos4fMESA( (GLfloat) x, (GLfloat) y, (GLfloat) z, (GLfloat) w );
}

void APIENTRY glWindowPos4sMESA( GLshort x, GLshort y, GLshort z, GLshort w )
{
   glWindowPos4fMESA( (GLfloat) x, (GLfloat) y, (GLfloat) z, (GLfloat) w );
}

void APIENTRY glWindowPos4dMESA( GLdouble x, GLdouble y, GLdouble z, GLdouble w )
{
   glWindowPos4fMESA( (GLfloat) x, (GLfloat) y, (GLfloat) z, (GLfloat) w );
}


void APIENTRY glWindowPos4ivMESA( const GLint *p )
{
   glWindowPos4fMESA( (GLfloat) p[0], (GLfloat) p[1],
                      (GLfloat) p[2], (GLfloat) p[3] );
}

void APIENTRY glWindowPos4svMESA( const GLshort *p )
{
   glWindowPos4fMESA( (GLfloat) p[0], (GLfloat) p[1],
                      (GLfloat) p[2], (GLfloat) p[3] );
}

void APIENTRY glWindowPos4fvMESA( const GLfloat *p )
{
   glWindowPos4fMESA( p[0], p[1], p[2], p[3] );
}

void APIENTRY glWindowPos4dvMESA( const GLdouble *p )
{
   glWindowPos4fMESA( (GLfloat) p[0], (GLfloat) p[1],
                      (GLfloat) p[2], (GLfloat) p[3] );
}




/*
 * GL_MESA_resize_buffers
 */

/*
 * Called by user application when window has been resized.
 */
void APIENTRY glResizeBuffersMESA( void )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ResizeBuffersMESA)( );
}





/*
 * GL_ARB_multitexture
 */

void APIENTRY glActiveTextureARB(GLenum texture)
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ActiveTexture)( texture );
}

void APIENTRY glClientActiveTextureARB(GLenum texture)
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ClientActiveTexture)( texture);
}

void APIENTRY glMultiTexCoord1dARB(GLenum target, GLdouble s)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord1f)( target, s );
}

void APIENTRY glMultiTexCoord1dvARB(GLenum target, const GLdouble *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord1f)( target, v[0] );
}

void APIENTRY glMultiTexCoord1fARB(GLenum target, GLfloat s)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord1f)( target, s );
}

void APIENTRY glMultiTexCoord1fvARB(GLenum target, const GLfloat *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord1f)( target, v[0] );
}

void APIENTRY glMultiTexCoord1iARB(GLenum target, GLint s)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord1f)( target, s );
}

void APIENTRY glMultiTexCoord1ivARB(GLenum target, const GLint *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord1f)( target, v[0] );
}

void APIENTRY glMultiTexCoord1sARB(GLenum target, GLshort s)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord1f)( target, s );
}

void APIENTRY glMultiTexCoord1svARB(GLenum target, const GLshort *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord1f)( target, v[0] );
}

void APIENTRY glMultiTexCoord2dARB(GLenum target, GLdouble s, GLdouble t)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord2f)( target, s, t );
}

void APIENTRY glMultiTexCoord2dvARB(GLenum target, const GLdouble *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord2f)( target, v[0], v[1] );
}

void APIENTRY glMultiTexCoord2fARB(GLenum target, GLfloat s, GLfloat t)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord2f)( target, s, t );
}

void APIENTRY glMultiTexCoord2fvARB(GLenum target, const GLfloat *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord2f)( target, v[0], v[1] );
}

void APIENTRY glMultiTexCoord2iARB(GLenum target, GLint s, GLint t)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord2f)( target, s, t );
}

void APIENTRY glMultiTexCoord2ivARB(GLenum target, const GLint *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord2f)( target, v[0], v[1] );
}

void APIENTRY glMultiTexCoord2sARB(GLenum target, GLshort s, GLshort t)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord2f)( target, s, t );
}

void APIENTRY glMultiTexCoord2svARB(GLenum target, const GLshort *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord2f)( target, v[0], v[1] );
}

void APIENTRY glMultiTexCoord3dARB(GLenum target, GLdouble s, GLdouble t, GLdouble r)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord3f)( target, s, t, r );
}

void APIENTRY glMultiTexCoord3dvARB(GLenum target, const GLdouble *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord3f)( target, v[0], v[1], v[2] );
}

void APIENTRY glMultiTexCoord3fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord3f)( target, s, t, r );
}

void APIENTRY glMultiTexCoord3fvARB(GLenum target, const GLfloat *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord3f)( target, v[0], v[1], v[2] );
}

void APIENTRY glMultiTexCoord3iARB(GLenum target, GLint s, GLint t, GLint r)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord3f)( target, s, t, r );
}

void APIENTRY glMultiTexCoord3ivARB(GLenum target, const GLint *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord3f)( target, v[0], v[1], v[2] );
}

void APIENTRY glMultiTexCoord3sARB(GLenum target, GLshort s, GLshort t, GLshort r)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord3f)( target, s, t, r );
}

void APIENTRY glMultiTexCoord3svARB(GLenum target, const GLshort *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord3f)( target, v[0], v[1], v[2] );
}

void APIENTRY glMultiTexCoord4dARB(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord4f)( target, s, t, r, q );
}

void APIENTRY glMultiTexCoord4dvARB(GLenum target, const GLdouble *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord4f)( target, v[0], v[1], v[2], v[3] );
}

void APIENTRY glMultiTexCoord4fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord4f)( target, s, t, r, q );
}

void APIENTRY glMultiTexCoord4fvARB(GLenum target, const GLfloat *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord4f)( target, v[0], v[1], v[2], v[3] );
}

void APIENTRY glMultiTexCoord4iARB(GLenum target, GLint s, GLint t, GLint r, GLint q)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord4f)( target, s, t, r, q );
}

void APIENTRY glMultiTexCoord4ivARB(GLenum target, const GLint *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord4f)( target, v[0], v[1], v[2], v[3] );
}

void APIENTRY glMultiTexCoord4sARB(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord4f)( target, s, t, r, q );
}

void APIENTRY glMultiTexCoord4svARB(GLenum target, const GLshort *v)
{
   GET_CONTEXT;
   (*GLCurrent->API.MultiTexCoord4f)( target, v[0], v[1], v[2], v[3] );
}




/*
 * GL_EXT_compiled_vertex_array
 */
void APIENTRY glLockArraysEXT(int first, GLsizei count)
{
   GET_CONTEXT;
   (*GLCurrent->API.LockArrays)( first, count );
}


void APIENTRY glUnlockArraysEXT( void )
{
   GET_CONTEXT;
   (*GLCurrent->API.UnlockArrays)();
}






