/*
 * This was originally xmesa.h, but has been heavily changed for use
 * within the Xserver - Steve Parker
 */


/*
 * Mesa 3-D graphics library
 * Version:  2.4
 * Copyright (C) 1995-1996  Brian Paul
 *
 * GLX Server Extension
 * Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
 * Copyright (C) 1998, 1999 Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * STEVEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR 
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef XSMESA_H
#define XSMESA_H

#ifdef __cplusplus
extern "C" {
#endif

/* #include "GL/gl.h"*/
#include "extnsionst.h"
#include "dixstruct.h"
#include "scrnintstr.h"
#include "pixmap.h"
#include "GL/GLXproto.h"
#include "GL/glx.h"
#include "mesaglx/types.h"

/*
 * Special Mesa types
 */

typedef struct xsmesa_context *XSMesaContext;

typedef struct xsmesa_visual  *XSMesaVisual;

typedef struct xsmesa_buffer  *XSMesaBuffer;

typedef struct glx_image GLXImage;

extern void XSMesaCopyContext(XSMesaContext src, XSMesaContext dst,
                              unsigned int mask);

extern GLboolean XSMesaBindBuffer( XSMesaContext c, XSMesaBuffer b );


/*
 * Create a new Xserver/Mesa visual.
 * Input:  display - X11 display
 *         visinfo - an XVisualInfo pointer
 *         rgb_flag - GL_TRUE = RGB mode,
 *                    GL_FALSE = color index mode
 *         alpha_flag - alpha buffer requested?
 *         db_flag - GL_TRUE = double-buffered,
 *                   GL_FALSE = single buffered
 *         depth_size - requested bits/depth values, or zero
 *         stencil_size - requested bits/stencil values, or zero
 *         accum_size - requested bits/component values, or zero
 *         ximage_flag - GL_TRUE = use an XImage for back buffer,
 *                       GL_FALSE = use an off-screen pixmap for back buffer
 * Return;  a new XMesaVisual or 0 if error.
 */
extern XSMesaVisual XSMesaCreateVisual(ScreenPtr pScreen,
                				       VisualPtr pVisual,
                				       GLboolean rgb_flag,
                				       GLboolean alpha_flag,
                				       GLboolean db_flag,
                				       GLboolean ximage_flag,
                				       GLint depth_size,
                				       GLint stencil_size,
                				       GLint accum_size,
                				       GLint level );			     
/*
 * Destroy an XMesaVisual, but not the associated XVisualInfo.
 */
extern void XSMesaDestroyVisual(XSMesaVisual v);

/*
 * Create a new XMesaContext for rendering into an X11 window.
 *
 * Input:  visual - an XMesaVisual
 *         share_list - another XMesaContext with which to share display
 *                      lists or NULL if no sharing is wanted.
 * Return:  an XMesaContext or NULL if error.
 */
extern XSMesaContext XSMesaCreateContext(XSMesaVisual visual,
                    					 XSMesaContext share_list);

/*
 * Destroy a rendering context as returned by XMesaCreateContext()
 */
extern void XSMesaDestroyContext(XSMesaContext c);

/*
 * Create an XMesaBuffer from an X window.
 */
extern XSMesaBuffer XSMesaCreateWindowBuffer(XSMesaVisual v,
                                             ClientPtr client,
                        					 WindowPtr w);

/*
 * Create an XMesaBuffer from an X pixmap.
 */
extern XSMesaBuffer XSMesaCreatePixmapBuffer(XSMesaVisual v,
                        					 ClientPtr client,
					                         PixmapPtr p,
                        					 ColormapPtr c);

/*
 * Destroy an XMesaBuffer, but not the corresponding window or pixmap.
 */
extern void XSMesaDestroyBuffer(XSMesaBuffer b);

/*
 * Return the XMesaBuffer handle which corresponds to an X drawable, if any.
 * New in Mesa 2.3.
 */
extern XSMesaBuffer XSMesaFindBuffer(ScreenPtr pScreen, DrawablePtr d);

extern GLboolean XSMesaGetBackBuffer(XSMesaBuffer b, 
                                     PixmapPtr *pixmap,
                                     XImage **ximage);
extern GLboolean XSMesaGetDepthBuffer(XSMesaBuffer b, 
                                      GLint *width, 
                                      GLint *height, 
                                      GLint *bytesPerValue,
                                      void **buffer);

/*
 * Bind a buffer to a context and make the context the current one.
 */
extern GLboolean XSMesaMakeCurrent(XSMesaContext c);

/*
 * Return a handle to the current context.
 */
extern XSMesaContext XSMesaGetCurrentContext(void);

/*
 * Return handle to the current buffer.
 */
extern XSMesaBuffer XSMesaGetCurrentBuffer(void);

/*
 * Swap the front and back buffers for the given buffer.  No action is
 * taken if the buffer is not double buffered.
 */
extern void XSMesaSwapBuffers(XSMesaBuffer b);

/*
 * Get under the hood to the feedback/selection buffers
 */
extern char* XSMesaFeedbackBuffer(XSMesaContext ctx);
extern char* XSMesaSelectionBuffer(XSMesaContext ctx);

/*
 * XImage buffers.
 */
extern void          GLXDestroyImage(GLXImage*);
extern GLXImage*     GLXCreateImage(WindowPtr pwindow, int depth,int width, int height, GLXImage* old_image);
extern unsigned long GLXGetPixel(GLXImage*, int x, int y);
extern void          GLXPutPixel(GLXImage*, int x, int y, unsigned long pixel);
extern void          GLXCreateDepthBuffer(GLcontext* ctx);
extern GLdepth       GLXGetDepth(XSMesaContext xsmesa, int x, int y);
extern void          GLXPutDepth(XSMesaContext xsmesa, int x, int y, GLdepth depth);

#ifdef __cplusplus
}
#endif

#endif /* XSMESA_H */
