
/*
 * GLX Server Extension
 * Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * STEVEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR 
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "X.h"
#include "Xproto.h"
#include "scrnintstr.h"

#include "types.h"

#include "glxvisual.h"
#include "xsmesaP.h"
#include "glx_log.h"
#include <stdio.h>

#include "os.h"

#ifdef XFree86LOADER
#include "xf86_libc.h"
#endif

GLScreen __glScreens[MAXSCREENS];

Vis* __vislist;

/* These should have a better home.  They are grabbed by the client in
 * direct contexts, but should be independent of the driver.  A
 * mach64, mga or other (can you guess?) direct clients should use the
 * same values. 
 */
int __glx_is_server = 1, __glx_first_visual = 0;


Bool
XSMesaInitVisuals (visualp, depthp, nvisualp, ndepthp, rootDepthp, defaultVisp, sizes, bitsPerRGB)
VisualPtr   *visualp;
DepthPtr    *depthp;
int     *nvisualp, *ndepthp;
int     *rootDepthp;
VisualID    *defaultVisp;
unsigned long   sizes;
int     bitsPerRGB;
{
    int i;
    VisualPtr old_visual;
    VisualPtr visual=*visualp;
    int nvisual=*nvisualp;
    DepthPtr depths=*depthp;
    int ndepths=*ndepthp;
    int have_default=0;

    int nongl_visuals=0;
    int gl_visuals=0;


    Vis* vhead=0;
    Vis* vtail=0;
    Vis* v;
    Vis* nextv;

    /* Make a list of visuals... */
    for (i=0;i<nvisual;i++)
    {
        VisualPtr pVisual=(*visualp)+i;
        int ci, rgb;

	if (!pVisual->vid) {
	   fprintf(stderr, "visual %d of %d has zero vid\n",
		   i, nvisual);
	   abort();
	}

        /* See if OpenGL supports this visual... */
        ci=rgb=GL_FALSE;
        switch (pVisual->CLASS)
        {
            case StaticGray:
            case GrayScale:
                /* Any StaticGray/GrayScale visual works in RGB or CI mode */
                ci=GL_TRUE;
                rgb=GL_TRUE;
                break;
            case StaticColor:
            case PseudoColor:
                /* Any StaticColor/PseudoColor visual of at least 4 bits */
                if (pVisual->nplanes)
                {
                    ci=GL_TRUE;
                }
                else
                {
                    ci=GL_FALSE;
                }
                break;
            case TrueColor:
            case DirectColor:
                /* Any depth of TrueColor or DirectColor works in RGB mode */
                rgb=GL_TRUE;
                break;
            default:
                /* This should never happen */
                ci=GL_FALSE;
                rgb=GL_FALSE;
                break;
        }
        if (!ci && !rgb)
        {
            Vis* v=(Vis*)xalloc(sizeof(Vis));
            v->orig_visual=pVisual;
            v->usegl=GL_FALSE;
            v->next=0;
            if (vtail)
                vtail->next=v;
            else
                vhead=v;
            vtail=v;
            nongl_visuals++;
        }
        if (rgb)
        {
            int db, alpha, stencil, depth, accum;
            for (db=0;db<=1;db++)
            {
                for (alpha=0;alpha<=1;alpha++)
                {
                    for (stencil=0;stencil<=1;stencil++)
                    {
                        for (depth=0;depth<=1;depth++)
                        {
                            for (accum=0;accum<=1;accum++)
                            {
                                Vis* v=(Vis*)xalloc(sizeof(Vis));
                                v->orig_visual=pVisual;
                                v->usegl=GL_TRUE;
                                v->rgb=GL_TRUE;
                                v->db=db;
                                v->alpha=alpha;
                                v->stencil=stencil;
                                v->depthb=depth;
                                v->accum=accum;
                                v->next=0;
                                if (vtail)
                                    vtail->next=v;
                                else
                                    vhead=v;
                                vtail=v;

                                gl_visuals++;
                            }
                        }
                    }
                }
            }
        }
        if (ci)
        {
            int db, stencil, depth;
            for (db=0;db<=1;db++)
            {
                for (stencil=0;stencil<=1;stencil++)
                {
                    for (depth=0;depth<=1;depth++)
                    {
                        Vis* v=(Vis*)xalloc(sizeof(Vis));
                        v->orig_visual=pVisual;
                        v->usegl=GL_TRUE;
                        v->rgb=GL_FALSE;
                        v->db=db;
                        v->alpha=GL_FALSE;
                        v->stencil=stencil;
                        v->depthb=depth;
                        v->accum=GL_FALSE;
                        v->next=0;
                        if (vtail)
                            vtail->next=v;
                        else
                            vhead=v;
                        vtail=v;
                        gl_visuals++;
                    }
                }
            }
        }
    }
    old_visual=visual;
    nvisual=gl_visuals+nongl_visuals;
    ErrorF("nvisual=%d (%d+%d)\n", nvisual, nongl_visuals, gl_visuals);

    visual = (VisualPtr) xalloc (nvisual * sizeof (VisualRec));
    if (!visual)
    {
        return FALSE;
    }
    *visualp = visual;
    *nvisualp = nvisual;


    for (v = vhead; v!=0; v=nextv)
    {
        nextv = v->next;
        for (i=0;i<ndepths;i++)
        {
            int j;
            v->depth=0;
            for (j=0;j<depths[i].numVids;j++)
            {
                if (depths[i].vids[j] == v->orig_visual->vid)
                {
                    v->depth=&depths[i];
                    break;
                }
            }
        }
    }
    
/*      new_depths = (DepthPtr) xmalloc( ndepths * sizeof(DepthRec) ); */

    /* Don't do this recycle? */
    for (i=0;i<ndepths;i++)
    {
/*         new_depths[i].depth = depths[i].depth; */
        xfree(depths[i].vids);
        depths[i].vids=0;
        depths[i].numVids=0;
    }
    have_default=0;

    /* Do what is needed to synchronize visual id's with the direct client.
     */
    if (__glx_is_server)
       __glx_first_visual = FakeClientID(0);
    else
       while (FakeClientID(0) < __glx_first_visual);

    for (v = vhead; v!=0; v=nextv)
    {
        VisualID* newdepth;
        nextv = v->next;

        /** is this replacing the ordering of the original visuals?? **/
        *visual = *v->orig_visual;

        /** doesn't each visual already have a Visual ID?? **/
        visual->vid = FakeClientID (0);


        /** if we are indeed replacing visuals, this returns a new VID **/
        /** if ( (visual->vid == *defaultVisp) && !have_default) { **/
        if (v->orig_visual->vid == *defaultVisp && !have_default)
        {
            have_default=1;
            /** why is this set if they're the same above?? **/
            *defaultVisp=visual->vid;
        }

        /** make sure GLX has the new Visual ID **/
        v->vid=visual->vid;

        /* Add this one to this depth */
        newdepth=(VisualID*)xalloc(sizeof(VisualID)*(v->depth->numVids+1));
        if (v->depth->vids)
        {
           for (i=0;i<v->depth->numVids;i++)
              newdepth[i]=v->depth->vids[i];
           xfree(v->depth->vids);
        }
        v->depth->vids=newdepth;
        v->depth->vids[v->depth->numVids]=visual->vid;
        v->depth->numVids++;

        /** we do appear to be overwriting the original visual list **/
        visual++;
    }

    /** what is this freeing? **/
    /** I see, we're freeing the original list here. We had created a new **/
    /** list of visuals. Why? So we have new Visual IDs?? Why?            **/
    xfree(old_visual);


    v=__vislist;
    if (v)
    {
        while (v->next)
            v=v->next;
        v->next=vhead;
    }
    else
    {
        __vislist=vhead;
    }
    return TRUE;
}

Bool GlxInitVisuals (VisualPtr   *visualp, 
		     DepthPtr    *depthp,
		     int         *nvisualp, 
		     int         *ndepthp,
		     int         *rootDepthp,
		     VisualID    *defaultVisp,
		     unsigned long   sizes,
		     int     bitsPerRGB )
{
#ifdef HW_ACCEL
    {  
        extern GLboolean (*hwInitVisuals)(VisualPtr *, DepthPtr *, int *, int *, int *, VisualID *, unsigned long, int);          
        if (hwInitVisuals) return ((*hwInitVisuals)(visualp, depthp, nvisualp, ndepthp, rootDepthp, defaultVisp, sizes, bitsPerRGB
));   
    } 
#endif
    return (XSMesaInitVisuals(visualp, depthp, nvisualp, ndepthp, rootDepthp, defaultVisp, sizes, bitsPerRGB));                   
}

static Vis* findv(VisualID vid)
{
    Vis* v;
    for (v = __vislist; v!=0; v=v->next)
    {
        if (v->vid==vid)
            return v;
    }
    return 0;
}


void
GLFinalizeVisuals()
{
    int screen;
    int i;
    Vis* v;
    for (screen=0;screen<screenInfo.numScreens;screen++)
    {
        ScreenPtr pScreen=screenInfo.screens[screen];
        GLScreen* glscreen=&__glScreens[screen];
        int numVis=pScreen->numVisuals;
        glscreen->visuals=(XSMesaVisual*)xalloc(sizeof(XSMesaVisual)*numVis);
        glscreen->numVisuals=numVis;
        for (i=0;i<numVis;i++)
        {
            VisualPtr pVisual=&pScreen->visuals[i];
            Vis* v=findv(pVisual->vid);
            if (v && v->usegl)
            {
                glscreen->visuals[i]=GLXProcs.CreateVisual(pScreen,
                                                           pVisual,
                                                           v->rgb, v->alpha,
                                                           !v->db, GL_TRUE,
                                                           !v->depthb*DEPTH_BITS,
                                                           !v->stencil*STENCIL_BITS,
                                                           !v->accum*ACCUM_BITS,
                                                           0);


            }
            else
            {
                glscreen->visuals[i]=0;
            }
        }
    }
    v=__vislist;
    while (v)
    {
        Vis* next=v->next;
        xfree(v);
        v=next;
    }
    __vislist=0;
}

XSMesaVisual GLfind_vis(VisualID vid)
{
    int i;
    int screen;
    for (screen=0;screen<screenInfo.numScreens;screen++)
    {
        ScreenPtr pScreen=screenInfo.screens[screen];
        int numVis=pScreen->numVisuals;
        GLScreen* glscreen=&__glScreens[screen];
        for (i=0;i<numVis;i++)
        {
            if (glscreen->visuals[i]->pVisual->vid == vid)
                return glscreen->visuals[i];
        }
    }
    return 0;
}

