
/*
 * GLX Server Extension
 * Copyright (C) 1998, 1999 Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef GLX_GLOBALS_H
#define GLX_GLOBALS_H

#include "glx_macros.h"
#include "dix.h"
#include "dixstruct.h"

typedef struct glx_client  __glxClient;


/*
 * Mesa wrapper for connected client information
 */
struct glx_client {
    ClientPtr   client;
    int         index;
    Bool        inUse;
    int		major;
    int		minor;
    char       *exts;
    Bool        no_accel;
    Bool        try_direct;
    int         largePacketsExpected;
    int         largePacketsReceived;
    int         largeBytesExpected;
    int	        largeBytesReceived;
};

void          __glXInitClients();
__glxClient * __glXFindClient(int index);
__glxClient * __glXAddClient(ClientPtr client);
int           __glXRemoveClient(int index);

#endif

