/***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-1999 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-1999 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/

#include <stdlib.h>

/*
 * X includes.
 */
#include "X.h"
#include "Xproto.h"
#include "windowstr.h"
#define GC void
#include "xf86.h"
#include "xf86Priv.h"
#include "xf86xaa.h"
#undef GC
/*
 * Mesa includes.
 */


#include "context.h"
#include "depth.h"
#include "macros.h"
#include "texstate.h"
#include "triangle.h"
#include "vb.h"
#include "types.h"
#include "vbxform.h"

#ifdef MESA31
#include "dd.h"
#else
#include "config.h"
#endif
/*
 * GLX includes.
 */
#include "xsmesaP.h"
#include "glx_log.h"
/*
 * Riva includes.
 */
#include "riva_glx.h"
/*
 * Riva 3D context.
 */
RIVA_3D_CTX rivaContext;
/*
 * Sync flag for put/get pix.
 */
int rivaSyncPix;
/*
 * Blend equation conversion table.
 */
#define RIVA_SRCNORM_SRCA_DESTC_SRCC        0x00000100
#define RIVA_SRCNORM_SRCA_ZERO_SRCC         0x40000100
#define RIVA_SRCNORM_SRCA_DESTC_ZERO        0x40000100
#define RIVA_SRCNORM_SRCA_ZERO_ZERO         0xC0000100
#define RIVA_SRCNORM_DESTC_DESTC_SRCC       0x20000100
#define RIVA_SRCNORM_DESTC_ZERO_SRCC        0x60000100
#define RIVA_SRCNORM_DESTC_DESTC_ZERO       0xA0000100
#define RIVA_SRCNORM_ADD_WITH_SATURATION    0x10000000
#define RIVA_COLORINV_SRCA_DESTC_ZERO       0x80000500
#define RIVA_COLORINV_DESTC_DESTC_SRCC      0x20000500
#define RIVA_COLORINV_DESTC_ZERO_SRCC       0x60000500
#define RIVA_COLORINV_ADD_WITH_SATURATION   0x10000500
#define RIVA_ALPHAINV_SRCA_DESTC_SRCC       0x00000900
#define RIVA_ALPHAINV_SRCA_ZERO_SRCC        0x40000900
#define RIVA_ALPHAINV_SRCA_DESTC_ZERO       0x80000900
#define RIVA_ALPHAINV_DESTC_DESTC_SRCC      0x20000900
#define RIVA_ALPHA1_SRCA_DESTC_SRCC         0x00000D00
#define RIVA_ALPHA1_SRCA_ZERO_SRCC          0x40000D00
#define RIVA_SRCALPHA_ONE_4444              0x00000100
#define RIVA_BLEND_DEFAULT                  RIVA_ALPHA1_SRCA_ZERO_SRCC
#define RIVA_NO_BLEND_DEFAULT               RIVA_ALPHA1_SRCA_ZERO_SRCC
#define RIVA_NO_SECOND_PASS                 0xFFFFFFFF

unsigned long rivaBlendXlate[11][11][2] =
{
    {
        {RIVA_SRCNORM_SRCA_ZERO_ZERO,             RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_DESTC_ZERO_SRCC,            RIVA_NO_SECOND_PASS},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_NO_SECOND_PASS},
        {RIVA_ALPHAINV_SRCA_DESTC_ZERO,           RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_SRCA_DESTC_ZERO,            RIVA_NO_SECOND_PASS},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_DESTC_DESTC_SRCC},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_DESTC_DESTC_SRCC},  
        {RIVA_SRCNORM_DESTC_ZERO_SRCC,            RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_DESTC_DESTC_ZERO,           RIVA_NO_SECOND_PASS},  
        {RIVA_COLORINV_SRCA_DESTC_ZERO,           RIVA_SRCNORM_DESTC_DESTC_ZERO},
    },
    {
        {RIVA_ALPHA1_SRCA_ZERO_SRCC,              RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_DESTC_ZERO_SRCC,            RIVA_SRCNORM_ADD_WITH_SATURATION},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_ADD_WITH_SATURATION},
        {RIVA_ALPHAINV_SRCA_DESTC_ZERO,           RIVA_SRCNORM_ADD_WITH_SATURATION},
        {RIVA_SRCNORM_SRCA_DESTC_ZERO,            RIVA_SRCNORM_ADD_WITH_SATURATION},
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_SRCNORM_ADD_WITH_SATURATION},
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_SRCNORM_ADD_WITH_SATURATION},  
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_ADD_WITH_SATURATION},
        {RIVA_SRCNORM_DESTC_DESTC_ZERO,           RIVA_SRCNORM_ADD_WITH_SATURATION},  
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_ALPHAINV_SRCA_DESTC_SRCC},
    },
    {
        {RIVA_ALPHA1_SRCA_DESTC_SRCC,             RIVA_SRCNORM_DESTC_ZERO_SRCC},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_ADD_WITH_SATURATION},  
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_SRCNORM_DESTC_ZERO_SRCC},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_ADD_WITH_SATURATION},  
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_ALPHAINV_SRCA_DESTC_SRCC},
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_SRCNORM_SRCA_DESTC_SRCC},  
        {RIVA_ALPHAINV_SRCA_DESTC_SRCC,           RIVA_SRCNORM_SRCA_DESTC_SRCC},
        {RIVA_ALPHAINV_SRCA_DESTC_SRCC,           RIVA_SRCNORM_SRCA_DESTC_SRCC},  
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_ADD_WITH_SATURATION},
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_SRCNORM_DESTC_DESTC_SRCC},
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_SRCNORM_DESTC_ZERO_SRCC},
    },
    {
        {RIVA_ALPHA1_SRCA_DESTC_SRCC,             RIVA_COLORINV_DESTC_ZERO_SRCC},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_ADD_WITH_SATURATION},  
        {RIVA_COLORINV_ADD_WITH_SATURATION,       RIVA_SRCNORM_DESTC_ZERO_SRCC},
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_COLORINV_DESTC_ZERO_SRCC},  
        {RIVA_COLORINV_SRCA_DESTC_ZERO,           RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_SRCA_DESTC_ZERO,            RIVA_NO_SECOND_PASS},  
        {RIVA_COLORINV_DESTC_DESTC_SRCC,          RIVA_SRCNORM_DESTC_DESTC_SRCC},
        {RIVA_COLORINV_DESTC_DESTC_SRCC,          RIVA_SRCNORM_DESTC_DESTC_SRCC},
        {RIVA_SRCNORM_SRCA_DESTC_SRCC,            RIVA_NO_SECOND_PASS},
        {RIVA_COLORINV_DESTC_DESTC_SRCC,          RIVA_SRCNORM_DESTC_DESTC_SRCC},  
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_DESTC_DESTC_SRCC},
    },
    {
        {RIVA_SRCNORM_SRCA_ZERO_SRCC,             RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_SRCA_DESTC_SRCC,            RIVA_NO_SECOND_PASS},  
        {RIVA_SRCNORM_DESTC_ZERO_SRCC,            RIVA_SRCNORM_SRCA_DESTC_SRCC},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_SRCA_DESTC_SRCC},  
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_COLORINV_SRCA_DESTC_ZERO},
        {RIVA_SRCNORM_SRCA_DESTC_SRCC,            RIVA_NO_SECOND_PASS},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_SRCA_DESTC_SRCC},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_SRCA_DESTC_SRCC},  
        {RIVA_SRCNORM_SRCA_DESTC_SRCC,            RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_DESTC_DESTC_ZERO,           RIVA_SRCNORM_SRCA_DESTC_SRCC},  
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_COLORINV_SRCA_DESTC_ZERO},
    },
    {
        {RIVA_ALPHAINV_SRCA_ZERO_SRCC,            RIVA_NO_SECOND_PASS},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_ADD_WITH_SATURATION},  
        {RIVA_SRCNORM_DESTC_ZERO_SRCC,            RIVA_ALPHAINV_SRCA_DESTC_SRCC},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_ALPHAINV_SRCA_DESTC_SRCC},  
        {RIVA_ALPHAINV_SRCA_DESTC_SRCC,           RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_SRCNORM_SRCA_DESTC_ZERO},  
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_ALPHAINV_SRCA_DESTC_SRCC},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_ALPHAINV_SRCA_DESTC_SRCC},  
        {RIVA_ALPHAINV_SRCA_DESTC_SRCC,           RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_DESTC_DESTC_ZERO,           RIVA_ALPHAINV_SRCA_DESTC_SRCC}, 
        {RIVA_SRCNORM_DESTC_ZERO_SRCC,            RIVA_ALPHAINV_SRCA_DESTC_SRCC},
    },
    {
        {RIVA_SRCNORM_DESTC_DESTC_ZERO,           RIVA_SRCNORM_DESTC_DESTC_SRCC},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_ADD_WITH_SATURATION},  
        {RIVA_COLORINV_ADD_WITH_SATURATION,       RIVA_SRCNORM_DESTC_DESTC_SRCC},
        {RIVA_COLORINV_DESTC_DESTC_SRCC,          RIVA_NO_SECOND_PASS},  
        {RIVA_ALPHAINV_SRCA_DESTC_SRCC,           RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_SRCA_DESTC_SRCC,            RIVA_NO_SECOND_PASS},  
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_SRCNORM_DESTC_DESTC_SRCC},  
        {RIVA_SRCNORM_SRCA_DESTC_SRCC,            RIVA_NO_SECOND_PASS},
        {RIVA_COLORINV_DESTC_DESTC_SRCC,          RIVA_SRCNORM_DESTC_DESTC_SRCC},  
        {RIVA_SRCNORM_DESTC_ZERO_SRCC,            RIVA_SRCNORM_SRCA_DESTC_SRCC},
    },
    {
        {RIVA_SRCNORM_DESTC_DESTC_ZERO,           RIVA_SRCNORM_DESTC_DESTC_SRCC},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_ADD_WITH_SATURATION},  
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_DESTC_DESTC_SRCC},
        {RIVA_COLORINV_DESTC_DESTC_SRCC,          RIVA_NO_SECOND_PASS},  
        {RIVA_ALPHAINV_SRCA_DESTC_SRCC,           RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_SRCA_DESTC_SRCC,            RIVA_NO_SECOND_PASS},  
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_SRCNORM_DESTC_DESTC_SRCC},
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_NO_SECOND_PASS},  
        {RIVA_ALPHAINV_SRCA_DESTC_SRCC,           RIVA_NO_SECOND_PASS},
        {RIVA_COLORINV_DESTC_DESTC_SRCC,          RIVA_SRCNORM_DESTC_DESTC_SRCC},  
        {RIVA_COLORINV_ADD_WITH_SATURATION,       RIVA_SRCNORM_DESTC_ZERO_SRCC},
    },
    {
        {RIVA_SRCNORM_DESTC_ZERO_SRCC,            RIVA_NO_SECOND_PASS},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_ADD_WITH_SATURATION},  
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_SRCNORM_DESTC_DESTC_SRCC},
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_NO_SECOND_PASS},  
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_NO_SECOND_PASS},
        {RIVA_ALPHAINV_DESTC_DESTC_SRCC,          RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_NO_SECOND_PASS},  
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_NO_SECOND_PASS},  
        {RIVA_SRCNORM_DESTC_DESTC_SRCC,           RIVA_NO_SECOND_PASS},
    },
    {
        {RIVA_COLORINV_ADD_WITH_SATURATION,       RIVA_SRCNORM_DESTC_DESTC_ZERO},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_ADD_WITH_SATURATION},  
        {RIVA_ALPHA1_SRCA_ZERO_SRCC,              RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_COLORINV_DESTC_ZERO_SRCC},  
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_COLORINV_SRCA_DESTC_ZERO},
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_SRCNORM_SRCA_DESTC_ZERO},  
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_SRCNORM_DESTC_DESTC_SRCC},
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_SRCNORM_DESTC_DESTC_SRCC},  
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_ADD_WITH_SATURATION},
        {RIVA_ALPHAINV_SRCA_ZERO_SRCC,            RIVA_SRCNORM_SRCA_DESTC_SRCC},  
        {RIVA_SRCNORM_DESTC_DESTC_ZERO,           RIVA_SRCNORM_SRCA_DESTC_SRCC},
    },
    {
        {RIVA_SRCNORM_SRCA_ZERO_SRCC,             RIVA_SRCNORM_DESTC_DESTC_ZERO},
        {RIVA_SRCNORM_SRCA_DESTC_SRCC,            RIVA_NO_SECOND_PASS},  
        {RIVA_SRCNORM_DESTC_ZERO_SRCC,            RIVA_SRCNORM_SRCA_DESTC_SRCC},
        {RIVA_COLORINV_DESTC_DESTC_SRCC,          RIVA_NO_SECOND_PASS},  
        {RIVA_SRCNORM_ADD_WITH_SATURATION,        RIVA_COLORINV_SRCA_DESTC_ZERO},
        {RIVA_SRCNORM_SRCA_DESTC_SRCC,            RIVA_NO_SECOND_PASS},  
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_SRCA_DESTC_SRCC},
        {RIVA_COLORINV_DESTC_ZERO_SRCC,           RIVA_SRCNORM_SRCA_DESTC_SRCC},  
        {RIVA_SRCNORM_SRCA_DESTC_SRCC,            RIVA_NO_SECOND_PASS},
        {RIVA_SRCNORM_DESTC_DESTC_ZERO,           RIVA_SRCNORM_SRCA_DESTC_SRCC}, 
        {RIVA_COLORINV_SRCA_DESTC_ZERO,           RIVA_SRCNORM_DESTC_DESTC_SRCC},
    }
};


/***************************************
 * Mesa's Driver Functions
 ***************************************/
#ifdef MESA31  
static void RivaRenderStart( GLcontext *ctx)
{
	rivaReload3D = 1; 
	return;
}
         
static void RivaRenderFinish( GLcontext *ctx)
{
	rivaReload3D = 1; 
	return;
}
#endif


static void RivaNearFar( GLcontext *ctx, GLfloat nearVal, GLfloat farVal )
{  
#define INVWMAX 128.0F

    rivaContext.InvWScale = 1.0;
    if (nearVal > 0) { 
        int exp2;   
        if (frexp(INVWMAX * nearVal,&exp2) != 0) {
            if (exp2 >= 2) {
                rivaContext.InvWScale = 1 << (exp2-1);
            } else if (exp2 <= 0) {
                rivaContext.InvWScale = 1.0 / (1 << (-exp2+1));
            }          
        }               
    }
}





/*
 * String identifier.
 */
static const char *RivaString(void)
{
    static char string[20];
    sprintf(string, "NVIDIA RIVA %d.%d\n",riva.Version >> 16,riva.Version & 0xFFFF);
    return (string);
}

/*
 * Parameters 
 */
static GLint RivaGetParameteri(const GLcontext *ctx, GLint param)
{
    switch (param) {  

    case DD_HAVE_HARDWARE_FOG:
        return 1;
#ifndef MESA31 /* Mesa 3.0 */ 
    case DD_MAX_TEXTURES:
        return MAX_TEX_SETS;
    case DD_MAX_TEXTURE_SIZE:
        return MAX_TEXTURE_SIZE;
#endif
    default:
        return -1; /* Should I really return 0? */
    }
}


static GLboolean RivaSetBuffer
(
    GLcontext *ctx,
    GLenum mode
)
{
    XSMesaContext xsmesa = (XSMesaContext) ctx->DriverCtx;

    if (mode == GL_FRONT || !xsmesa->xsm_buffer->db_state)
    {
        /*
         * Set front buffer rendering.
         */
        xsmesa->xsm_buffer->buffer = xsmesa->xsm_buffer->frontbuffer;
        xsmesa_setup_DD_pointers(ctx);
        RivaUpdateState(ctx);
        return ((mode == GL_FRONT) ? GL_TRUE : GL_FALSE);
    }
    else
    {
        /*
         * Set back buffer rendering.
         */
        if (xsmesa->xsm_buffer->backpixmap)
        {
            xsmesa->xsm_buffer->buffer = (DrawablePtr)xsmesa->xsm_buffer->backpixmap;
        }
        else if (xsmesa->xsm_buffer->backimage)
        {
            xsmesa->xsm_buffer->buffer = None;
        }
        xsmesa_setup_DD_pointers(ctx);
        RivaUpdateState(ctx);
        return (GL_TRUE);
    }
}
/*
 * Pipeline flush stuff.
 */
static void RivaFinish
(
    GLcontext *ctx
)
{
    while (riva.Busy(&riva));    
}
static void RivaFlush
(
    GLcontext *ctx
)
{
}
/*
 * Buffer operations.
 */
static GLbitfield RivaClearBuffers
(
    GLcontext *ctx,
    GLbitfield mask,
    GLboolean all,
    GLint x,
    GLint y,
    GLint width,
    GLint height
) 
{
    int           nclipRects, red, green, blue, color24, color16, control, clearmask;
    float         depth;
    BoxPtr        pclipRect;
    BoxRec        clearRect, intersectRect;
    XSMesaContext xsmesa = (XSMesaContext)ctx->DriverCtx;
    WindowPtr     pwin   = (WindowPtr)(xsmesa->xsm_buffer->frontbuffer);

    RivaFloatToUInt(red,   ctx->Color.ClearColor[0] * 255.0F);
    RivaFloatToUInt(green, ctx->Color.ClearColor[1] * 255.0F);
    RivaFloatToUInt(blue,  ctx->Color.ClearColor[2] * 255.0F);
    if (red   > 0xFF) red   = 0xFF;
    if (green > 0xFF) green = 0xFF;
    if (blue  > 0xFF) blue  = 0xFF;
    color24   = 0xFF000000 | (red << 16) | (green << 8) | blue;
    color16   = ((red & 0xF8) << 8) | ((green & 0xFC) << 3) | (blue >> 3);
    depth     = ctx->Depth.Clear * DEPTH_SCALE;
    control   = 0x00081160;
    clearmask = 0;
    if (mask & GL_COLOR_BUFFER_BIT)
    {
        control   |= 0x04000000;
        clearmask |= GL_COLOR_BUFFER_BIT;
    }
    if (mask & GL_DEPTH_BUFFER_BIT)
    {
        control   |= 0x00400000;
        clearmask |= GL_DEPTH_BUFFER_BIT;
    }
    control   |= 0x00400000;
    if (rivaGLXEnabled)
    {
        /*
         * Get window clip rects.
         */
        if (pwin->clipList.data)
        {
            if (pwin->clipList.data->numRects == 0)
                return (mask ^ clearmask);
            else
            {
                nclipRects = pwin->clipList.data->numRects;
                pclipRect  = (BoxPtr)(pwin->clipList.data + 1);
            }
        }
        else
        {
            nclipRects = 1;
            pclipRect  = &pwin->clipList.extents;
        }
        if (all)
        {
            clearRect.x1 = pwin->drawable.x;
            clearRect.y1 = pwin->drawable.y;
            clearRect.x2 = clearRect.x1 + pwin->drawable.width;
            clearRect.y2 = clearRect.y1 + pwin->drawable.height;
        }
        else
        {
            clearRect.x1 = pwin->drawable.x                         + x;
            clearRect.y2 = pwin->drawable.y + pwin->drawable.height - y;
            clearRect.x2 = clearRect.x1 + width;
            clearRect.y1 = clearRect.y2 - height;
        }
        /*
         * Intersect with scissor clip if enabled.
         */
        if (ctx->Scissor.Enabled)
        {
            BoxRec scissor;
    
            scissor.x1 = pwin->drawable.x + ctx->Scissor.X;
            scissor.y2 = pwin->drawable.y + pwin->drawable.height - ctx->Scissor.Y;
            scissor.x2 = scissor.x1       + ctx->Scissor.Width;
            scissor.y1 = scissor.y2       - ctx->Scissor.Height;
            clearRect.x1 = max(scissor.x1, clearRect.x1);
            clearRect.y1 = max(scissor.y1, clearRect.y1);
            clearRect.x2 = min(scissor.x2, clearRect.x2);
            clearRect.y2 = min(scissor.y2, clearRect.y2);
        }
        /*
         * Set 3D state reload flag (but only for the first time).
         */
        rivaReload3D = 1;
        while (nclipRects--)
        {
            /*
             * Clear through clip rect.
             */
            intersectRect.x1 = max(pclipRect->x1, clearRect.x1);
            intersectRect.y1 = max(pclipRect->y1, clearRect.y1);
            intersectRect.x2 = min(pclipRect->x2, clearRect.x2);
            intersectRect.y2 = min(pclipRect->y2, clearRect.y2);
            if ((intersectRect.x1 < intersectRect.x2) && (intersectRect.y1 < intersectRect.y2))
            {
                /*
                 * Send quad to clear buffers.
                 */
                if (rivaReload3D)
                {
                                                
                    rivaReload3D = 0;
                    RIVA_STATE3D(rivaTexHeap.DefaultOffset, 0x22300000, 0x00000000, 0x00000000, control, 0x00000800);
                }
                RIVA_VERTEX3D(0x00000000, color24, intersectRect.x1, intersectRect.y1, depth, 1.0, 0.0, 0.0);
                RIVA_VERTEX3D(0x00000001, color24, intersectRect.x2, intersectRect.y1, depth, 1.0, 0.0, 0.0);
                RIVA_VERTEX3D(0x00000102, color24, intersectRect.x2, intersectRect.y2, depth, 1.0, 0.0, 0.0);
                RIVA_VERTEX3D(0x00000203, color24, intersectRect.x1, intersectRect.y2, depth, 1.0, 0.0, 0.0);
            }
            pclipRect++;
        }
        /*
         * Set 3D state reload flag.
         */
        rivaReload3D = rivaSyncPix = 1;
    }
    
    
    
    /*
     * This should return the original mask, minus the cleared buffer bits.
     */
    return (mask ^ clearmask);
}
/*
 * Swap back buffer with front buffer.
 */
void RivaSwapBuffers
(
    XSMesaBuffer b
)
{
    int       nclipRects;
    BoxPtr    pclipRect;
    WindowPtr pwin = (WindowPtr)(b->frontbuffer);

    if (rivaGLXEnabled)
    {
        /*
         * Get window clip rects.
         */
        if (pwin->clipList.data)
        {
            if (pwin->clipList.data->numRects == 0)
                return;
            else
            {
                nclipRects = pwin->clipList.data->numRects;
                pclipRect  = (BoxPtr)(pwin->clipList.data + 1);
            }
        }
        else
        {
            nclipRects = 1;
            pclipRect  = &pwin->clipList.extents;
        }
        /*
         * Switch to buffer surfaces.
         */
        riva.SetSurfaces2D(&riva, rivaBufferOffset[RIVA_FRONT_BUFFER], rivaBufferOffset[RIVA_BACK_BUFFER]);
        /*
         * Use XAA to BLT surface.
         */
        xf86AccelInfoRec.SetupForScreenToScreenCopy(0, 0, GXcopy, 0xFF, 0);
        while (nclipRects--)
        {
            /*
             * BLT through clip rect.
             */
            xf86AccelInfoRec.SubsequentScreenToScreenCopy(pclipRect->x1,
                                                          pclipRect->y1,
                                                          pclipRect->x1,
                                                          pclipRect->y1,
                                                          pclipRect->x2 - pclipRect->x1,
                                                          pclipRect->y2 - pclipRect->y1);
            pclipRect++;
        }
        /*
         * Sync get/put pixel with HW.
         */
        rivaSyncPix = 1;
        /*
         * Restore surfaces and triangle object.
         */
        riva.SetSurfaces2D(&riva, rivaBufferOffset[RIVA_FRONT_BUFFER], rivaBufferOffset[RIVA_FRONT_BUFFER]);
    }
}
/*
 * Hook into Mesa GL context.
 */
void RivaUpdateState
(
    GLcontext *ctx
)
{
    int src, dst;

    if (rivaGLXEnabled)
    {
        /*
         * Reset basic driver hooks.
         */
        ctx->Driver.PointsFunc     = RivaPoints3D;
        ctx->Driver.LineFunc       = RivaLine3D;
        ctx->Driver.TriangleFunc   = RivaTriangle3D;
        xsmesa_setup_DD_pointers(ctx);
        ctx->Driver.UpdateState    = RivaUpdateState;
        ctx->Driver.RendererString = RivaString;
        ctx->Driver.Flush          = RivaFlush;
        ctx->Driver.NearFar        = RivaNearFar;
        ctx->Driver.Finish         = RivaFinish;
        ctx->Driver.SetBuffer      = RivaSetBuffer;
        ctx->Driver.Clear          = RivaClearBuffers;
        ctx->Driver.TexImage       = RivaTexImage;
        ctx->Driver.TexSubImage    = RivaTexSubImage;
        ctx->Driver.DeleteTexture  = RivaDeleteTexture;
        ctx->Driver.BindTexture    = RivaBindTexture;
        ctx->Driver.GetParameteri  = RivaGetParameteri;
#ifdef MESA31
	ctx->Driver.RenderStart	   = RivaRenderStart;
	ctx->Driver.RenderFinish   = RivaRenderFinish;
#else
        ctx->Driver.RenderVB       = RivaRenderVB;
#endif
        /*                  
         * Unsupported render modes.  Bail to software rendering.
         */
        if (ctx->Stencil.Enabled || ctx->Line.StippleFlag || ctx->Polygon.StippleFlag)
        {
            /*
             * Bail to SW rendering.
             * Mesa will fill in generic Funcs.
             */
            ctx->Driver.PointsFunc     = NULL;
            ctx->Driver.LineFunc       = NULL;
            ctx->Driver.TriangleFunc   = NULL;
            ctx->Driver.QuadFunc       = NULL;
            ctx->Driver.RectFunc       = NULL;
#ifdef MESA31
            ctx->Driver.RenderStart    = NULL;
            ctx->Driver.RenderFinish   = NULL;
#else
            ctx->Driver.RenderVB       = NULL;
#endif           
            return;
        }
        /*
         * Blending state.
         */
        rivaContext.triControl = 0x00001000;
        if (ctx->Color.BlendEnabled)
        {
#ifdef MESA31
            src = (ctx->Color.BlendSrcRGB & 0x0F) + ((ctx->Color.BlendSrcRGB >> 8) & 0x02);
            dst = (ctx->Color.BlendDstRGB & 0x0F) + ((ctx->Color.BlendDstRGB >> 8) & 0x02);
#else
            src = (ctx->Color.BlendSrc & 0x0F) + ((ctx->Color.BlendSrc >> 8) & 0x02);
            dst = (ctx->Color.BlendDst & 0x0F) + ((ctx->Color.BlendDst >> 8) & 0x02);
#endif
            rivaContext.triControl      |= rivaBlendXlate[src][dst][0];
            rivaContext.triControlPass2  = rivaBlendXlate[src][dst][1];
            /*
             * Set render functiona based on blend mode.
             */
            if (rivaContext.triControlPass2 != RIVA_NO_SECOND_PASS)
            {
                ctx->Driver.PointsFunc   = Riva2PassPoints3D;
                ctx->Driver.LineFunc     = Riva2PassLine3D;
                ctx->Driver.TriangleFunc = Riva2PassTriangle3D;
            }
        }
        else
        
        {
            rivaContext.triControl      |= RIVA_NO_BLEND_DEFAULT;
            rivaContext.triControlPass2  = RIVA_NO_SECOND_PASS;
        }
        /*
         * Alpha test.
         */
        if (ctx->Color.AlphaEnabled)
        {
            rivaContext.triAlphaTest = ctx->Color.AlphaRef | (((ctx->Color.AlphaFunc & 0x07) + 1) << 8);
            /*
             * NV4 HW bugfix.
             */
            if (riva.Architecture == 4)
            {
                if ((rivaContext.triControl & 0xF0000F00) == RIVA_ALPHA1_SRCA_ZERO_SRCC)
                {
                    /*
                     * Alpha test works on TNT with this combination.
                     */
                    rivaContext.triControl = (rivaContext.triControl & ~0xF0000F00) | 0x70000000;
                }
            }
        }
        else 
        {
            rivaContext.triAlphaTest = 0x0800;
        }
        /*
         * Depth test.
         */
        if (ctx->Depth.Test)
        {
            rivaContext.triControl      |= (((ctx->Depth.Func & 0x07) + 1) << 16)
                                        |   ((ctx->Depth.Mask) ? 0x03300000 : 0x03000000);
            rivaContext.triControlPass2 |= 0x00030000; /* Z EQ */
            /*
             * NV4 HW bugfix.
             */
            if (riva.Architecture == 4)
            {
                if (ctx->Depth.Mask)
                    rivaContext.BugFix &= ~NV4_Z_ENABLE_BUG;
                else
                    rivaContext.BugFix |=  NV4_Z_ENABLE_BUG;
            }
        }
        else
        {
            rivaContext.triControl      |= 0x04080000;
            rivaContext.triControlPass2 |= 0x00080000; /* Z TRUE */
            /*
             * NV4 HW bugfix.
             */
            rivaContext.BugFix &= ~NV4_Z_ENABLE_BUG;
        }
        /*
         * Texturing.
         */
#ifdef MESA31
        if (ctx->Texture.Enabled && ctx->Texture.Unit[0].CurrentD[2])
        {
            struct gl_texture_object *tObj = ctx->Texture.Unit[0].CurrentD[2];
#else
        if (ctx->Texture.Enabled && ctx->Texture.Set[0].Current2D)
        {
            struct gl_texture_object *tObj = ctx->Texture.Set[0].Current2D;
#endif
            if (rivaContext.texObj != tObj)
            {
                RivaBindTexture(ctx, 0, tObj);
            }
            else
            {
                RIVA_TEX_BLOCK *pblk = (RIVA_TEX_BLOCK *)tObj->DriverData;
                /*
                 * Wrap/clamp.
                 */
                rivaContext.triControl |= (tObj->WrapS == GL_CLAMP) ? 0x30 : 0x10;
                rivaContext.triControl |= (tObj->WrapT == GL_CLAMP) ? 0xC0 : 0x40;
                /*
                 * Filtering. Make sure we adhere to OGL texture sampling with each filter mode.
                 */
                if (tObj->MagFilter == GL_LINEAR)
                {
                    rivaContext.triControl |= 0x0002;
                    rivaContext.sAdjust     = pblk->sAdjust;
                    rivaContext.tAdjust     = pblk->tAdjust;
                }
                else
                {
                    rivaContext.sAdjust     = 0.0F;
                    rivaContext.tAdjust     = 0.0F;
                }
                /*
                 * Mipmapping.
                 */
                if ((tObj->MinFilter == GL_NEAREST) || (tObj->MinFilter == GL_LINEAR))
                    rivaContext.texFormat =  (pblk->Format & 0xF0FFFFFF)
                                          | ((pblk->Format & 0xF0000000) >> 4);
                else
                    rivaContext.texFormat =   pblk->Format;
            }
#ifdef MESA31
            rivaContext.modeMask = ctx->Texture.Unit[0].EnvMode == GL_MODULATE ? 0x00000000 : 0x00FFFFFF;
#else
            rivaContext.modeMask = ctx->Texture.Set[0].EnvMode == GL_MODULATE ? 0x00000000 : 0x00FFFFFF;
#endif
            /*
             * Fog Color.
             */
            if (ctx->Fog.Enabled)
            {
                int r, g, b;

                RivaFloatToUInt(r, ctx->Fog.Color[0] * 255.0F);
                RivaFloatToUInt(g, ctx->Fog.Color[1] * 255.0F);
                RivaFloatToUInt(b, ctx->Fog.Color[2] * 255.0F);
                rivaContext.triFogColor = (r << 16) | (b << 8) | b;
            }
        }
        else
        {
            /*
             * Load default texture.
             */
            rivaContext.texObj    = NULL;
            rivaContext.texOffset = rivaTexHeap.DefaultOffset;
            rivaContext.texFormat = 0x22300000;
            rivaContext.modeMask  = 0x00000000;
            rivaContext.sAdjust   = 0.0F;
            rivaContext.tAdjust   = 0.0F;
            /*
             * Check for antialiased lines and points.
             */
            if (ctx->Point.SmoothFlag)
            {
                ctx->Driver.PointsFunc  = RivaAAPoints3D;
                rivaContext.texOffset   = rivaTexHeap.DefaultAAOffset;
                rivaContext.texFormat   = 0x44200000;
                rivaContext.triControl |= 0xF2;
            }
            if (ctx->Line.SmoothFlag)
            {
                ctx->Driver.LineFunc    = RivaAALine3D;
                rivaContext.texOffset   = rivaTexHeap.DefaultAAOffset;
                rivaContext.texFormat   = 0x44200000;
                rivaContext.triControl |= 0xF2;
            }
            rivaContext.triFogColor = 0;
        }
        /*
         * Render buffer.
         */
        if (ctx->Color.DrawBuffer != rivaContext.bufRender)
        {
            rivaContext.bufRender = ctx->Color.DrawBuffer;
            riva.SetSurfaces3D(&riva, 
                               rivaBufferOffset[(rivaContext.bufRender == GL_FRONT) ? RIVA_FRONT_BUFFER : RIVA_BACK_BUFFER],
                               rivaBufferOffset[RIVA_DEPTH_BUFFER]);
        }
        /*
         * Check for simple clip case.
         */
        rivaContext.SimpleClip = (rivaContext.bufRender != GL_FRONT) && (rivaContext.NumCtxs == 1);
        /*
         * Update HW context flag.
         */
        rivaReload3D = 1;
    }
    else
    {
        /*
         * Reset basic driver hooks to use NOP routines.
         */
        ctx->Driver.PointsFunc     = RivaPointsNOP;
        ctx->Driver.LineFunc       = RivaLineNOP;
        ctx->Driver.TriangleFunc   = RivaTriangleNOP;
        xsmesa_setup_DD_pointers(ctx);
        ctx->Driver.UpdateState    = RivaUpdateState;
        ctx->Driver.RendererString = RivaString;
        ctx->Driver.Flush          = NULL;
        ctx->Driver.Finish         = NULL;
        ctx->Driver.NearFar        = NULL;
        ctx->Driver.SetBuffer      = NULL;
        ctx->Driver.Clear          = RivaClearBuffers;
        ctx->Driver.TexImage       = NULL;
        ctx->Driver.TexSubImage    = NULL;
        ctx->Driver.DeleteTexture  = NULL;
        ctx->Driver.BindTexture    = NULL;
#ifdef MESA31
        ctx->Driver.RenderStart    = NULL;
        ctx->Driver.RenderFinish   = NULL;
#else
        ctx->Driver.RenderVB       = RivaRenderVB;
#endif
    }
}



