/*
 * GLX Hardware Device Driver for Matrox G200/G400
 * Copyright (C) 1999 Wittawat Yamwong
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *    Wittawat Yamwong <Wittawat.Yamwong@stud.uni-hannover.de>
 */

/* $Id: mgadd.c,v 1.23 1999/12/12 22:07:20 stephenc Exp $ */


#include "xsmesaP.h"
#include "mesaglx/types.h"
#include "vbrender.h"
#include "glx_log.h"
#include "glx_config.h"

#include "vga.h"
#include "vgaPCI.h"

#include <stdio.h>
#include <stdlib.h>

#include "mm.h"
#include "g200_mac.h"
#include "mgalib.h"
#include "mgaglx.h"
#include "mgaclear.h"
#include "mgadd.h"
#include "mgadirect.h"
#include "mgadepth.h"
#include "mgalog.h"
#include "mgastate.h"
#include "mgaspan.h"
#include "mgatex.h"
#include "mgatris.h"
#include "mgavb.h"
#include "extensions.h"
#include "vb.h"
#include "dd.h"
#include "mgapixel.h"

extern void xsmesa_setup_DD_pointers( GLcontext *ctx );


/***************************************
 * Mesa's Driver Functions
 ***************************************/


const GLubyte *mgaDDGetString( GLcontext *ctx, GLenum name )
{
   switch (name) {
   case GL_VENDOR:
      return "Utah GLX";
   case GL_RENDERER:
      if (MGA_IS_G200(MGAchipset)) return "GLX-MGA-G200";
      if (MGA_IS_G400(MGAchipset)) return "GLX-MGA-G400";
      return "GLX-MGA";
   default:
      return 0;
   }
}


void mgaDDExtensionsInit( GLcontext *ctx )
{
   int i = 0;
   
   /* CVA only available for direct contexts.
    */
   if (__glx_is_server) 
      gl_extensions_disable( ctx, "GL_EXT_compiled_vertex_array" );

   /* paletted_textures currently doesn't work on G400 */
   if (MGA_IS_G400(MGAchipset)) {
      gl_extensions_disable( ctx, "GL_EXT_paletted_texture" );
      gl_extensions_disable( ctx, "GL_EXT_shared_texture_palette" );
   }

   /* Support multitexture only on the g400.
    *    -- Disable by default due to lockup problems.
    */
   if (glx_getvar("mga_enable_multitex")) 
     i = atoi(glx_getvar("mga_enable_multitex"));
   
   if (!MGA_IS_G400( MGAchipset ) || !i)
   {
      gl_extensions_disable( ctx, "GL_EXT_multitexture" );
      gl_extensions_disable( ctx, "GL_SGIS_multitexture" );
      gl_extensions_disable( ctx, "GL_ARB_multitexture" );
   }
    
   /* we don't support point parameters in hardware yet */
   gl_extensions_disable( ctx, "GL_EXT_point_parameters" );

   /* No support for fancy imaging stuff.  This should kill off 
    * a few rogue fallbacks.
    */
   gl_extensions_disable( ctx, "ARB_imaging" );
   gl_extensions_disable( ctx, "GL_EXT_blend_minmax" );
   gl_extensions_disable( ctx, "GL_EXT_blend_logic_op" );
   gl_extensions_disable( ctx, "GL_EXT_blend_subtract" );
   gl_extensions_disable( ctx, "GL_INGR_blend_func_separate" );   
}


static GLint mgaGetParameteri(const GLcontext *ctx, GLint param)
{
  switch (param) {
  case DD_HAVE_HARDWARE_FOG:  
    return 1; 
  default:
    mgaError("mgaGetParameteri(): unknown parameter!\n");
    return 0; /* Should I really return 0? */
  }
}

void mgaDisableHW(GLcontext *ctx)
{
    /* disable hardware accel. */
    mgaMsg(5,"no hw accel.\n");

    ctx->Driver.RenderStart  = NULL; 
    ctx->Driver.RenderFinish = NULL; 
    ctx->Driver.NearFar = NULL;
    ctx->Driver.GetParameteri = NULL;
    ctx->Driver.RasterSetup = NULL;    
    ctx->Driver.TexEnv = NULL;
    ctx->Driver.TexImage = NULL;
    ctx->Driver.BindTexture = NULL;
    ctx->Driver.DeleteTexture = NULL;
    ctx->Driver.TexParameter = NULL;
    
    xsmesa_setup_DD_pointers(ctx);
    ctx->Driver.UpdateState = mga_setup_DD_pointers;
}

/*
 * if we can't hardware accelerate the context now, but could
 * before (the window was sized up to the point a buffer alloc failed)
 * then just have software mesa do everything.
 */
int mgaCanUseHardware( GLcontext *ctx )
{
   XSMesaContext xsmesa = (XSMesaContext) ctx->DriverCtx;
   XSMesaBuffer xsmbuf = xsmesa->xsm_buffer;
  
   if (!VALID_MGA_CONTEXT(mgaCtx)) 
   { 
     mgaDisableHW(ctx);
     return 0;
   }
   /* We shouldn't really be relying so much on mgaCtx - should go
    * straight from ctx->DriverCtx->....  Perhaps this should be
    * reworked to remove one level of indirection.
    */
   if ( ctx != mgaCtx->gl_ctx ) {
      FatalError("mgaCtx->gl_ctx != ctx in mgaCanUseHardware()");
    }

   if ( !VALID_MGA_BUFFER(mgaDB) || 
        !mgaDB->Drawable || 
        xsmbuf->buffer != XIMAGE ) {
     	    mgaDisableHW(ctx);	
	    return 0;
   }
   return 1;
}



/*
 * mga_setup_DD_pointers
 * This is called at initialization time, and on each state change
 * after hardware acceleration has been disabled.
 */
void mga_setup_DD_pointers( GLcontext *ctx ) {

   if ( !mgaCanUseHardware(ctx) ) {
      return;
   }

   xsmesa_setup_DD_pointers(ctx);

   mgaDDInitStatePointers(ctx);
  
#if 0
   ctx->Driver.DrawPixels = mgaDDDrawPixels; 
   ctx->Driver.Bitmap = mgaDDBitmap;
#endif
  
   ctx->Driver.Viewport = mgaDDViewport;
   ctx->Driver.DepthRange = mgaDDDepthRange;
   ctx->Driver.GetString = mgaDDGetString;
   ctx->Driver.UpdateState = mgaDDUpdateState;
   ctx->Driver.RegisterVB = mgaDDRegisterVB;
   ctx->Driver.UnregisterVB = mgaDDUnregisterVB;
   ctx->Driver.Clear = mgaClear;
   ctx->Driver.GetParameteri = mgaGetParameteri;
   ctx->Driver.TexEnv = mgaTexEnv;
   ctx->Driver.TexImage = mgaTexImage;
   ctx->Driver.TexSubImage = mgaTexSubImage;
   ctx->Driver.BindTexture = mgaBindTexture;
   ctx->Driver.DeleteTexture = mgaDeleteTexture;
   ctx->Driver.TexParameter = mgaTexParameter;
   ctx->Driver.UpdateTexturePalette = mgaUpdateTexturePalette;
   ctx->Driver.IsTextureResident = mgaIsTextureResident;

   ctx->Driver.TriangleCaps = (DD_TRI_CULL|
			       DD_TRI_LIGHT_TWOSIDE|
			       DD_TRI_OFFSET);
				      
   mgaDDInitSpans( ctx );
   mgaDDInitDepthFuncs( ctx );
  
   /* Also do the normal GL state-change checks.
    */
   mgaDDUpdateState( ctx );
}
