

#include "xsmesaP.h"
#include "mesaglx/types.h"
#include "vbrender.h"
#include "glx_log.h"

#include "vga.h"
#include "vgaPCI.h"

#include <stdio.h>

#include "mm.h"
#include "g200_mac.h"
#include "mgalib.h"
#include "mgadd.h"
#include "mgaglx.h"
#include "mgaclear.h"
#include "mgastate.h"



/*
 * mgaClear
 * perform hardware accelerated clearing of the color and/or depth
 * buffer.  Software may still clear stencil buffers.
 * If all==GL_TRUE, clear whole buffer, else just clear region defined
 * by x,y,width,height
 */
#define MGA_CLEAR_COLOR 1
#define MGA_CLEAR_Z     2
#define MGA_CLEAR_ALL   MGA_CLEAR_COLOR|MGA_CLEAR_Z

GLbitfield mgaClear( GLcontext *ctx, GLbitfield mask, GLboolean all,
		     GLint x, GLint y, GLint width, GLint height ) 
{
	XSMesaContext xsmesa = (XSMesaContext) ctx->DriverCtx;
	GLubyte	*c;
	mgaUI32	zval;
	DMALOCALS;
	mgaUI32	cmd;
	
	mgaMsg( 10, "mgaClear( %i, %i, %i, %i, %i )\n", mask, x, y, width, height );
	
	CHECK_CONTEXT(					\
		mgaError("mgaDB is not valid in mgaClear().\n");	\
		return mask;					\
	);
	if ( !mgaDB->Drawable ) {
		return mask;
	}

	if (all == GL_TRUE) {
		x = 0;
		y = 0;
		width = mgaDB->Width;
		height = mgaDB->Height;
	}
	
	if ( y + height > mgaDB->Height ) {
		height = mgaDB->Height - y;
	}
	if ( x + width > mgaDB->Width ) {
		width = mgaDB->Width - x;
	}
	if ( x < 0 ) {
		width += x;
		x = 0;
	}
	if ( y < 0 ) {
		height += y;
		y = 0;
	}
	if ( x >= mgaDB->Width || y >= mgaDB->Height || width < 1 || height < 1 ) {
		return 0;
	}

	/* make sure all triangles are flushed before we reprogram some regs */	
	mgaCtx->new_state |= MGA_NEW_CONTEXT;
	mgaDDUpdateHwState( ctx );
	
	/* flip top to bottom */
	y = mgaDB->Height-y-height;
	c = xsmesa->clearcolor;
	zval = (mgaUI32) (ctx->Depth.Clear * DEPTH_SCALE);
	
	MGADMAGETPTR( 32 );

	/* color buffer */
	if ( mask & GL_COLOR_BUFFER_BIT ) {
		cmd = DC_opcod_trap | DC_arzero_enable | DC_sgnzero_enable | 
		  DC_shftzero_enable | (0xC << DC_bop_SHIFT) | DC_clipdis_enable | 
		  DC_solid_enable | DC_transc_enable;
	  
		/* use SGRAM block clears if possible */
		if ( mgaglx.nosgram || mgaDB->SystemMemory ) {
			cmd |= DC_atype_rstr;
		} else {
			cmd |= DC_atype_blk;
		}	

		mask &= ~GL_COLOR_BUFFER_BIT;
	
		MGADMA_FCOL(mgaPackColor(c[0],c[1],c[2],c[3]));
		MGADMA_YDSTLEN(y,height);
		MGADMA_FXBNDRY(x,x+width);
		MGADMA_DWGCTL_EXEC(cmd);
	}

	/* depth buffer */
	if ( (mask & GL_DEPTH_BUFFER_BIT) && mgaDB->HasZORG && ctx->Depth.Mask ) {
		mgaUI32 maccess = mgaDB->Setup[MGA_SETUP_MACCESS];
		
		cmd = DC_opcod_trap | DC_arzero_enable | DC_sgnzero_enable | 
		  DC_shftzero_enable | (0xC << DC_bop_SHIFT) | DC_clipdis_enable | 
		  DC_solid_enable | DC_transc_enable;
	  
		/* use SGRAM block clears if possible */
		if ( mgaglx.nosgram || mgaDB->ZBuffer->SystemMemory ) {
			cmd |= DC_atype_rstr;
		} else {
			cmd |= DC_atype_blk;
		}

		mask &= ~GL_DEPTH_BUFFER_BIT;

		DMAOUTREG(MGAREG_DSTORG,mgaDB->ZBuffer->Setup[MGA_SETUP_ZORG]);
		#if DEPTH_BITS==16
		MGA_SET_FIELD(maccess,MA_pwidth_MASK,MA_pwidth_16);
		#elif DEPTH_BITS==32
		MGA_SET_FIELD(maccess,MA_pwidth_MASK,MA_pwidth_32);
		#else
		#  error DEPTH_BITS must be either 16 or 32.
		#endif
		DMAOUTREG(MGAREG_MACCESS,maccess);
		MGADMA_FCOL(zval);
		MGADMA_YDSTLEN(y,height);
		MGADMA_FXBNDRY(x,x+width);
		MGADMA_DWGCTL_EXEC(cmd);
	}


	if (MESA_VERBOSE & VERBOSE_DRIVER)
	   fprintf(stderr, "needEnter3D in mgaClear\n");

	DMAADVANCE();

	/* we are NOT flushing the dma here.  if things are running smoothly,
	the only dma flush will be at swapbuffers time */

	/* restore DSTORG, MACCESS, and DWGCTL before drawing again */
	mgaCtx->new_state |= MGA_NEW_CONTEXT;

	mgaMsg(10, "exiting mgaClear\n" );
	
	return mask;
}


