/*
 * GLX Hardware Device Driver for Matrox Millenium G200
 * Copyright (C) 1999 Wittawat Yamwong
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *    Wittawat Yamwong <Wittawat.Yamwong@stud.uni-hannover.de>
 */

/* $Id: mgabuf.h,v 1.6 1999/12/12 20:37:12 keithw Exp $ */

#ifndef MGABUF_INC
#define MGABUF_INC

#include "mgacommon.h"
#include "mm.h"

#define mgaBufferMagic 0x65e813a1
#define VALID_MGA_BUFFER(b) ((b) && (b)->magic == mgaBufferMagic)

/* mga_buffer_t.Attrib */
#define MGA_TYPE_MASK 0xf
#define MGA_COLORBUFFER 1
#define MGA_ZBUFFER16   2
#define MGA_MISCBUFFER  3
#define MGA_ZBUFFER32   4
#define MGA_TEXBUFFER   5

/* if type == MGA_COLORBUFFER */
#define MGA_PF_MASK  0xf0
#define MGA_PF_INDEX 0
#define MGA_PF_565   (1 << 4)
#define MGA_PF_555   (9 << 4)
#define MGA_PF_888   (3 << 4)
#define MGA_PF_8888  (10 << 4)
#define MGA_PF_HASALPHA (8 << 4)

#define	MGA_FORCE_SYSMEM	(1<<16)


/* mga_buffer_t.Setup */
#define MGA_SETUP_0        0x27262023
#define MGA_SETUP_PITCH    1
#define MGA_SETUP_CXBNDRY  2
#define MGA_SETUP_YTOP     3
#define MGA_SETUP_YBOT     4
#define MGA_SETUP_5        0x030701ae
#define MGA_SETUP_DSTORG   6
#define MGA_SETUP_MACCESS  7
#define MGA_SETUP_PLNWT    8
#define MGA_SETUP_ZORG     9
#define MGA_SETUP_SIZE     10

/* Some phony ones for the reg_dirty bitfield:
 */
#define MGA_SETUP_DWGCTL    11
#define MGA_SETUP_ALPHACTRL 12
#define MGA_SETUP_FOGCOLOR  13
#define MGA_SETUP_TDUAL0    14
#define MGA_SETUP_TDUAL1    15
#define MGA_SETUP_WFLAG     16


struct mga_buffer_t {
  mgaUI32 magic;
  struct mga_buffer_t *next;

  int Attrib;

  int Drawable:1;		/* if false, we can't use hardware
                                   acceleration */
  int HasZORG:1;
  int SystemMemory:1;		/* in PCI/AGP space instead of framebuffer */

  mgaUI32 Setup[MGA_SETUP_SIZE];
  int SetupSize;

  void    *BufAddr;		/* pointer to buffer in virtual memory */
  PMemBlock MemBlock;

  int Width,Height;		/* in pixels */
  int Pitch;			/* in pixels */
  int BytesPerPixel;
  int Size;
  
  struct mga_buffer_t *ZBuffer;
};

typedef struct mga_buffer_t mgaBuffer;
typedef struct mga_buffer_t *mgaBufferPtr;


mgaBufferPtr mgaCreateBuffer(int Attrib, int Size, int Width, int Height,
			     int Pitch);
mgaBufferPtr mgaCreatePrimaryBuffer(int Attrib, int Width, int Height,
				  int Pitch);
int mgaDestroyBuffer(mgaBufferPtr buf);
mgaBufferPtr mgaAttachZBuffer(mgaBufferPtr parent, mgaBufferPtr zb,
			      int Type);


#endif
