/* $Id: mach64log.h,v 1.2 1999/12/04 08:27:05 johnc Exp $ */

/*
 * GLX Hardware Device Driver for ATI Rage Pro
 * Copyright (C) 1999 Gareth Hughes
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Based on MGA driver: mgalog.h 1.5
 *
 *    Gareth Hughes <garethh@bell-labs.com>
 */

/* Usage:
 * - use mach64Error for error messages. Always write to X error and log file.
 * - use mach64Msg for debugging. Can be disabled by undefining MGA_LOG_ENABLED.
 */

#ifndef __MACH64_LOG_H__
#define __MACH64_LOG_H__

#ifndef DBG_MODULE_PREFIX
#define DBG_MODULE_PREFIX "[mach64] "
#endif

/* use the same preprocessor definition for the mach64 module. */
#ifdef MGA_LOG_ENABLED

#include <stdarg.h>

#define DBG_LEVEL_BASE		1
#define DBG_LEVEL_VERBOSE	10
#define DBG_LEVEL_ENTEREXIT	20

/* open and close log file. */
int  mach64OpenLog( const char *filename );
void mach64CloseLog();

/* return 1 if log file is succesfully opened */
int  mach64IsLogReady();

/* set current log level to 'level'. Messages with level less than or equal
   the current log level will be written to the log file. */
void mach64SetLogLevel( int level );
int  mach64GetLogLevel();

/* mach64Log and mach64Logv write a message to the log file.	*/
/* do not call these directly, use mach64Msg() instead	*/
void mach64Log( int level, const char *format, ... );
void mach64Logv( int level, const char *format, va_list ap );


/* mach64Msg writes a message to the log file or to the standard X error file. */
#define mach64Msg( level, format, args... )				\
    if ( level <= mach64glx.logLevel ) {				\
	if ( mach64IsLogReady() ) {					\
	    int __t = usec();						\
	    mach64Log( level, "%6i:", __t - mach64glx.timeTemp );	\
	    mach64glx.timeTemp = __t;					\
	    mach64Log( level, format, ## args );			\
	} else {							\
	    if ( level <= mach64GetLogLevel() ) {			\
		ErrorF( DBG_MODULE_PREFIX );				\
		ErrorF( format, ## args );				\
	    }								\
	}								\
    }

#define mach64Error( format, args... )					\
    do {								\
	ErrorF( DBG_MODULE_PREFIX );					\
	ErrorF( format, ## args );					\
	mach64Log( 0, format, ## args );				\
    } while ( 0 )

#else

static __inline__ int mach64OpenLog( const char *f )	{ return -1; }
static __inline__ int mach64IsLogReady()		{ return 0; }
static __inline__ int mach64GetLogLevel()		{ return -1; }
static __inline__ int mach64LogLevel( int level )	{ return 0; }

#define mach64CloseLog()
#define mach64SetLogLevel( x )
#define mach64Log( l, f, a... )
#define mach64Logv( l, f, a )
#define mach64Msg( l, f, a... )

#define mach64Error( format, args... )					\
    do {								\
	ErrorF( DBG_MODULE_PREFIX );					\
	ErrorF( format, ## args );					\
    } while ( 0 )

#endif

#endif


/*
 * Local Variables:
 * mode: c
 * c-basic-offset: 4
 * End:
 */
