/* $Id: mach64log.c,v 1.2 1999/12/04 08:27:05 johnc Exp $ */

/*
 * GLX Hardware Device Driver for ATI Rage Pro
 * Copyright (C) 1999 Gareth Hughes
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Based on MGA driver: mgalog.c 1.3
 *
 *    Gareth Hughes <garethh@bell-labs.com>
 */

#include "mach64glx.h"

#ifdef MGA_LOG_ENABLED

int mach64OpenLog( const char *filename )
{
    mach64CloseLog();
    if ( !filename ) {
	return -1;
    }
    if ( ( mach64glx.logFile = fopen( filename, "w" ) ) == NULL ) {
	return -1;
    }
    mach64SetLogLevel( 0 );
    return 0;
}

void mach64CloseLog()
{
    if ( mach64glx.logFile ) {
	fclose( mach64glx.logFile );
	mach64glx.logFile = NULL;
    }
}

int mach64IsLogReady()
{
    return ( mach64glx.logFile != NULL );
}

void mach64SetLogLevel( int level )
{
    mach64glx.logLevel = level;
}

int mach64GetLogLevel()
{
    return mach64glx.logLevel;
}

void mach64Log( int level, const char *format, ... )
{
    va_list ap;
    va_start( ap, format );

    mach64Logv( level, format, ap );

    va_end( ap );
}

void mach64Logv( int l, const char *format, va_list ap )
{
    if ( mach64glx.logFile && ( l <= mach64glx.logLevel ) ) {
	vfprintf( mach64glx.logFile, format, ap );
	fflush( mach64glx.logFile );
    }
}

#else /* ifdef MGA_LOG_ENABLED */

int mach64logdummy()
{
    return 0;
}

#endif


/*
 * Local Variables:
 * mode: c
 * c-basic-offset: 4
 * End:
 */
