/* $Id: mach64dd.c,v 1.4 1999/12/12 08:55:40 johnc Exp $ */

/*
 * GLX Hardware Device Driver for ATI Rage Pro
 * Copyright (C) 1999 Gareth Hughes
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Based on MGA driver: mgadd.c 1.13
 *
 *    Gareth Hughes <garethh@bell-labs.com>
 */

#include "mach64glx.h"


/***************************************
 * Mesa's Driver Functions
 ***************************************/


const GLubyte *mach64DDGetString( GLcontext *ctx, GLenum name )
{
    switch ( name )
    {
    case GL_VENDOR:
      	return "Utah GLX";
    case GL_RENDERER:
    	/* Quake3 needs to see "rage pro" to cut out some broken features */
    	return "GLX-rage pro *** EARLY DEVELOPMENT ***";	
    default:
	return 0;
    }
}


void mach64DDExtensionsInit( GLcontext *ctx )
{
    /* CVA only available for direct contexts.
     */
    if ( __glx_is_server ) {
	gl_extensions_disable( ctx, "GL_EXT_compiled_vertex_array" );
    }

   /* No support for multitexture
    */
    gl_extensions_disable( ctx, "GL_EXT_multitexture" );
    gl_extensions_disable( ctx, "GL_SGIS_multitexture" );
    gl_extensions_disable( ctx, "GL_ARB_multitexture" );

	/* we can support paletted textures later if we really care */	
    gl_extensions_disable( ctx, "GL_EXT_paletted_texture" );
    gl_extensions_disable( ctx, "GL_EXT_shared_texture_palette" );
   
    /* we don't support point parameters in hardware yet */
    gl_extensions_disable( ctx, "GL_EXT_point_parameters" );

    /* No support for fancy imaging stuff.  This should kill off
    * a few rogue fallbacks.
    */
    gl_extensions_disable( ctx, "ARB_imaging" );
    gl_extensions_disable( ctx, "GL_EXT_blend_minmax" );
    gl_extensions_disable( ctx, "GL_EXT_blend_logic_op" );
    gl_extensions_disable( ctx, "GL_EXT_blend_subtract" );
    gl_extensions_disable( ctx, "GL_INGR_blend_func_separate" );
}


static GLint mach64GetParameteri( const GLcontext *ctx, GLint param )
{
    switch ( param )
    {
    case DD_HAVE_HARDWARE_FOG:
	return 1;
    default:
	mach64Error( "mach64GetParameteri(): unknown parameter!\n" );
	return 0; /* Should I really return 0? */
    }
}


void mach64_setup_DD_pointers( GLcontext *ctx )
{
    xsmesa_setup_DD_pointers( ctx );
		
	mach64DDInitStatePointers( ctx );

    ctx->Driver.GetString = mach64DDGetString;
    ctx->Driver.UpdateState = mach64DDUpdateState;
    ctx->Driver.Clear = mach64Clear;
    ctx->Driver.GetParameteri = mach64GetParameteri;

	ctx->Driver.TriangleFunc = mach64Triangle;

    ctx->Driver.TriangleCaps = 0;		/* no special handling yet */
   
//  ( DD_TRI_LIGHT_TWOSIDE |
//				 DD_TRI_OFFSET ); /* FIXME: not correct! */

    mach64DDInitSpans( ctx );

    /* Also do the normal GL state-change checks. */
    mach64DDUpdateState( ctx );
}


/*
 * Local Variables:
 * mode: c
 * c-basic-offset: 4
 * End:
 */
