/* $Id: i810log.h,v 1.1 1999/12/13 12:47:45 keithw Exp $ */

/*
 * GLX Hardware Device Driver for Intel i810
 * Copyright (C) 1999 Keith Whitwell
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * KEITH WHITWELL, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 */
 
/* Usage:
 * - use i810Error for error messages. Always write to X error and log file.
 * - use i810Msg for debugging. Can be disabled by undefining I810_LOG_ENABLED.
 */
 
#ifndef I810LOG_INC
#define I810LOG_INC

static __inline__ int i810OpenLog(const char *f) { return -1; }
static __inline__ int i810IsLogReady() { return 0; }
static __inline__ int i810GetLogLevel() { return -1; }
static __inline__ int i810LogLevel(int level) { return 0; }

#define i810CloseLog()
#define i810SetLogLevel(x)
#define i810Log(l,f,a...)
#define i810Logv(l,f,a)

#define DBG_LEVEL 10
#define i810Msg(l,f,a...) do {				\
   if ((I810_DEBUG&DEBUG_VERBOSE_MSG) && l<DBG_LEVEL)	\
       fprintf(stderr, f, ## a);			\
} while(0)

#define i810Error(format, args...) do {		\
  ErrorF(format, ## args);			\
} while(0)

#endif
