
/*
 * GLX Server Extension
 * Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
 * Copyright (C) 1998, 1999  Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * STEPHEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR 
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef GLXCOMMON_H
#define GLXCOMMON_H 1

#include "GL/gl.h"
#include <stdio.h>

#ifdef XFree86LOADER
#include "xf86_libc.h"
#endif

#define GLX_pad(a)  (((a) + 3) & ~3)

/** functions to calculate various sizes **/

int GLX_data_size(GLenum data_type);
int GLX_num_elements(GLenum format);
int GLX_light_size(GLenum pname);
int GLX_map1_size(GLenum target);
int GLX_map2_size(GLenum target);
int GLX_material_size(GLenum pname);
int GLX_get_size(GLenum pname);
int GLX_lightmodel_size(GLenum pname);
int GLX_tex_size(GLenum pname);
int GLX_texparameter_size(GLenum pname);
int GLX_texlevelparameter_size(GLenum pname);
int GLX_texgen_size(GLenum pname);
int GLX_fog_size(GLenum pname);
int GLX_list_size(GLint n, GLenum type);
int GLX_list_pad(GLint n, GLenum type);
int GLX_texenv_size(GLenum pname);
int GLX_image_size(GLsizei width, GLsizei height,
			  GLenum format, GLenum type);
int GLX_image_pad(GLsizei width, GLsizei height,
			  GLenum format, GLenum type);
int GLX_texture_size(GLsizei width, GLsizei height,
			  GLenum format, GLenum type, GLenum target);
int GLX_texture_pad(GLsizei width, GLsizei height,
			  GLenum format, GLenum type, GLenum target);

#endif
