/*
 * Code for OpenGL extensions:
 */

#include <string.h>
#include "glxlib.h"
#include "glxcommon.h"
#include "pixel.h"
#include "extensions/Xext.h"
#include "extensions/extutil.h"

extern XExtDisplayInfo * __gl_find_display(Display*);
static char* gl_extension_name = "GLX";

#define GLCheckExtension(dpy, i, val) \
   XextCheckExtension(dpy, i, gl_extension_name, val)

#define GLSimpleCheckExtension(dpy, i) \
   XextSimpleCheckExtension(dpy, i, gl_extension_name)


#if BUILD_COLOR_TABLE_EXT

void __glx_ColorTableEXT( GLenum target, GLenum internalFormat,
                          GLsizei width, GLenum format, GLenum type,
                          const GLvoid *table )
{
    char* buffer = NULL;
    int s=GLX_image_size(width, 1, format, type);
    __GLX_GET_RENDER_BUFFER(buffer, 2053, 44, s);
    __GLX_PUT_PIXEL_DATA_ARGUMENTS;
    __GLX_PUT_enum(buffer, target);
    __GLX_PUT_enum(buffer, internalFormat);
    __GLX_PUT_int(buffer, width);
    __GLX_PUT_enum(buffer, format);
    __GLX_PUT_enum(buffer, type);
    __GLX_PUT_buffer(buffer, table, width, 1, type, format, s);
}	

void __glx_ColorSubTableEXT ( GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *table )
{
#if 0  
        int _size, components, compsize;
	char* buffer = NULL;
	compsize   = GLX_data_size(type);
        components = GLX_num_elements(format);
        _size = 44 + components * compsize * count;
        /* Missing GLX protocol definition... */
  	__gl_get_render_buffer(buffer,_size);
	PUT_short(buffer, _size);
#endif  
}	

#endif  

#define USE_MGA_DIRECT_X333 
#ifdef USE_MGA_DIRECT_X333 

/* The communications to the server required to setup experimental
 * direct rendering with XFree86 3.3.3.1.  This isn't PI's DRI - this
 * is just a big hack what I done one weekend.
 *
 * Of all the GLX protocol requests, these ones can never be direct.  
 */

/* If the reply is successful, it will fire all the client side
 * initialization required to support direct rendering, including
 * loading "glx.so" and initializing our interface to hardware.
 *
 * Because of the way this works, the first GLX request seen by the
 * server from a client on the local machine will be one of these.  
 */

/* This is an internal protocol not exported to the user of the library.
 */
char *__glx_request_direct( Display *dpy )
{
   xGLXVendorPrivateReq* req;
   XExtDisplayInfo* info = __gl_find_display(dpy); 
   char *data;
   int num_bytes;
   xGLXGetStringReply reply;

   if (dpy == NULL) return 0;

   GLCheckExtension(dpy, info, 0);
                                                                                
   GLXRenderFlush();		/* noop */
   LockDisplay(dpy);
   GetReq(GLXVendorPrivate, req);

   req->reqType = info->codes->major_opcode;
   req->glx_opcode = X_GLXVendorPrivateWithReply;
   req->opcode = X_GLXDirectGoDirect;
   req->context_tag = 0;/*   GLCurrent->contextTag; */

   /* specific to receiving acknowledgement and data 
    */
   if (!_XReply(dpy, (xReply*)&reply, 0, xFalse)) {
      UnlockDisplay(dpy);
      SyncHandle();
      return NULL;
   }

   /* Cope with a variable length reply.
    */
   num_bytes = reply.n * sizeof(int); /* hmm */

   data = (char *) malloc(num_bytes * sizeof(char));
   _XRead(dpy,  data, num_bytes);

   UnlockDisplay(dpy);
   SyncHandle(); 
   return data;
}

/* Where should this be called from?
 */
void
__glx_release_direct()
{
    xGLXVendorPrivateReq* req;
    XExtDisplayInfo* info = __gl_find_display(GLCurrent->dpy);                  
    Display* dpy=GLCurrent->dpy; 
                                                                                
    GLSimpleCheckExtension(GLCurrent->dpy, info);
                                                                                
    GLXRenderFlush();                                                           
    LockDisplay(dpy);
    GetReq(GLXVendorPrivate, req);

    req->reqType = info->codes->major_opcode;
    req->glx_opcode = X_GLXVendorPrivate;
    req->opcode = X_GLXDirectRelease;
    req->context_tag = GLCurrent->contextTag;

    UnlockDisplay(dpy);
    SyncHandle(); 
    return;
}


/* These are patched into glx.so when it is loaded so it can talk to
 * itself on the server.
 */
int 
__glx_send_vendor_private_with_reply( int opcode,
				      char *vp, 
				      size_t vp_sz,
				      xReply *reply,
				      char *data,
				      size_t data_sz )
{
    xGLXVendorPrivateReq* req;
    XExtDisplayInfo* info;
    Display* dpy;

    if (!GLCurrent) 
       return 0;

    dpy = GLCurrent->dpy; 
    info = __gl_find_display(GLCurrent->dpy);                  

    GLCheckExtension(dpy, info, 0);
                                                                                
    GLXRenderFlush();                                                           
    LockDisplay(dpy);
    GetReq(GLXVendorPrivate, req);

    req->reqType = info->codes->major_opcode;
    req->glx_opcode = X_GLXVendorPrivateWithReply;
    req->opcode = opcode;
    req->context_tag = GLCurrent->contextTag;

    /* Queue up any additional data.
     */
    if (vp) {
       req->length += GLX_pad(vp_sz) >> 2;
       _XSend(dpy, vp, GLX_pad(vp_sz));
    }

    if (reply) {
       /* Flush and wait for reply
	*/
       if (!_XReply(dpy, reply, 0, xFalse)) {
	  UnlockDisplay(dpy);
	  SyncHandle();
	  return 0;
       }
       
       /* Read any additional reply data.
	*/
       if (data) {
	  data_sz = (data_sz + 3) & 0xFFFC; 
	  _XRead(dpy, data, data_sz);
       }
    }

    UnlockDisplay(dpy);
    SyncHandle(); 
    return 1;
}


#endif


