
#include <X11/Xlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>

#undef Bool

#include "dixstruct.h"
#include "glxcommon.h"
#include "glxlib.h"



#define GC XXGC
#include "gcstruct.h"
#include "pixmapstr.h"
#include "servermd.h" /* PixmapBytePad */
#include "scrnintstr.h"
#include "regionstr.h"
#include "windowstr.h"
#undef GC


#include "direct_protocol.h"
#include "direct_resources.h"


/* There is a serious lack of notification from server to client of
 * changes affecting these structs.  A DRI would address this, but the
 * best strategy is to rely increasingly less on this information.
 */
#define MAX_DIRECT_RESOURCE 20


static gc_map gc_list[MAX_DIRECT_RESOURCE];
static int nr_active_gcs = 0;

/* XLib does something like this too, but I think it does flush a little
 * more aggressively.
 */
GC find_client_gc_from_ptr( void *ptr )
{
   int i;

   for (i = 0 ; i < nr_active_gcs ; i++)
      if (gc_list[i].ptr == ptr) {
	 if (gc_list[i].mask) {
	    int rv =  XChangeGC( directDisplay,
				 gc_list[i].gc,
				 gc_list[i].mask,
				 &gc_list[i].xgcv );
	    
	    fprintf(stderr, "XChangeGC (%x) returned %d\n", 
		    gc_list[i].mask, rv);
	    
	    gc_list[i].mask = 0;
	 }
	 return gc_list[i].gc;
      }

   return 0;
}

gc_map *find_gc_map_from_ptr( void *ptr )
{
   int i;

   for (i = 0 ; i < nr_active_gcs ; i++)
      if (gc_list[i].ptr == ptr) 
	 return &gc_list[i];

   return 0;
}


GCPtr GetScratchGC(unsigned depth, ScreenPtr pScreen)
{
   int screen = 0;		     /* get from pScreen??? */
   Display *dpy = directDisplay;
   Drawable d = RootWindow(dpy, screen);
   XGCValues gcv;
   GCPtr pGC;
   
      
   /* Check root depth is correct so that we can use rootwindow as the
    * drawable in creating the gc.  It's the least we can do (really).
    */
   if (pScreen->rootDepth != depth)
      return 0;

   if (nr_active_gcs == MAX_DIRECT_RESOURCE) 
      return 0;

   gc_list[nr_active_gcs].gc = XCreateGC( dpy, d, 0, &gcv );

   if (!gc_list[nr_active_gcs].gc) 
      return 0;

   pGC = (GCPtr) calloc( sizeof(*pGC), 1 );
   pGC->ops = &fake_gcops;
   pGC->depth = depth;

   gc_list[nr_active_gcs].ptr = pGC;
   gc_list[nr_active_gcs].mask = 0;
   nr_active_gcs++;
   return pGC;
}


void FreeScratchGC(GCPtr pGC)
{
   int i;
   
   for (i = 0 ; i < nr_active_gcs ; i++)
      if (gc_list[i].ptr == pGC) {
	 XFreeGC( directDisplay, gc_list[i].gc );
	 free(pGC);
	 nr_active_gcs--;
	 if (nr_active_gcs > i) 
	    gc_list[i] = gc_list[nr_active_gcs];
      }	       
}


typedef struct {
   DrawablePtr ptr;
   Drawable drawable;
} drawable_map;

typedef struct {
   PixmapPtr ptr;
   Pixmap pixmap;
} pixmap_map;

typedef struct {
   WindowPtr ptr;
   Window window;
} window_map;

static drawable_map drawable_list[MAX_DIRECT_RESOURCE];
static int nr_active_drawables = 0;

static pixmap_map pixmap_list[MAX_DIRECT_RESOURCE];
static int nr_active_pixmaps = 0;

static window_map window_list[MAX_DIRECT_RESOURCE];
static int nr_active_windows = 0;


Drawable find_client_drawable_from_ptr( void *ptr )
{
   int i;

   for (i = 0 ; i < nr_active_drawables ; i++)
      if (drawable_list[i].ptr == ptr) 
	 return drawable_list[i].drawable;

   fprintf(stderr, "couldn't find drawable matching ptr %p\n", ptr);

   return 0;
}

static DrawablePtr build_pixmap_rec( int id )
{
   PixmapPtr pPix;
   Window dummy;
   int x, y;
   unsigned int width_return, height_return;
   unsigned int border_width_return;
   unsigned int depth_return;

   if (nr_active_drawables == MAX_DIRECT_RESOURCE) 
      return 0;

   pPix = (PixmapPtr) calloc(1, sizeof(PixmapRec));

   pPix->drawable.type = DRAWABLE_PIXMAP;
   pPix->drawable.pScreen = &directScreen;
   pPix->drawable.id = id;

   if (!XGetGeometry( directDisplay, 
		      id,
		      &dummy,
		      &x, &y,
		      &width_return, &height_return,
		      &border_width_return,
		      &depth_return ))
   {
      free(pPix);
      fprintf(stderr, "couldn't get geometry for pixmap id %d\n", id);
      return 0;
   }

   pPix->drawable.x = x;
   pPix->drawable.y = y;
   pPix->drawable.width = width_return;
   pPix->drawable.height = height_return;
   pPix->drawable.depth = depth_return;
   pPix->drawable.bitsPerPixel = depth_return; /* hmm */

   pixmap_list[nr_active_pixmaps].pixmap = id;
   pixmap_list[nr_active_pixmaps].ptr = pPix;
   nr_active_pixmaps++;

   drawable_list[nr_active_drawables].drawable = id;
   drawable_list[nr_active_drawables].ptr = (DrawablePtr) pPix;
   nr_active_drawables++;

   return (DrawablePtr) pPix;
}

static DrawablePtr build_window_rec( int id, XWindowAttributes *xwa )
{
   WindowPtr pWin = calloc(1, sizeof(WindowRec));

   if (nr_active_drawables == MAX_DIRECT_RESOURCE) 
      return 0;

   if (xwa->class == InputOnly) {
      pWin->drawable.type = UNDRAWABLE_WINDOW;
   } else {
      pWin->drawable.type = DRAWABLE_WINDOW;
   }

   pWin->drawable.pScreen = &directScreen;
   pWin->drawable.id = id;
   pWin->drawable.x = xwa->x;
   pWin->drawable.y = xwa->y;
   pWin->drawable.width = xwa->width;
   pWin->drawable.height = xwa->height;
   pWin->drawable.depth = xwa->depth;
   pWin->drawable.bitsPerPixel = xwa->depth;

   pWin->optional = (WindowOptPtr) calloc(sizeof(WindowOptRec), 1);
   pWin->optional->visual = xwa->visual->visualid;
   pWin->optional->colormap = xwa->colormap;
   
   /* Am I going to query the whole tree?  Not if I can help it.
    */
   pWin->parent = 0;

   window_list[nr_active_windows].window = id;
   window_list[nr_active_windows].ptr = pWin;
   nr_active_windows++;

   drawable_list[nr_active_drawables].drawable = id;
   drawable_list[nr_active_drawables].ptr = (DrawablePtr) pWin;
   nr_active_drawables++;

   return (DrawablePtr) pWin;
}

static int x_error;

static int tmp_handler( Display *dpy, XErrorEvent *ev )
{
   x_error = 1;
   return 0;
}


DrawablePtr find_server_drawable_from_id( int id )
{
   int i;
   int (*handler)(Display *, XErrorEvent *);
   XWindowAttributes xwa;
   DrawablePtr pDraw;
   
   for (i = 0 ; i < nr_active_drawables ; i++)
      if (drawable_list[i].drawable == id)
	 return drawable_list[i].ptr;


   /* For the purposes of the driver, just need to establish
    * whether this an InputOnly window or not.
    */
   x_error = 0;
   handler = XSetErrorHandler(tmp_handler);
   if (!XGetWindowAttributes( directDisplay, id, &xwa )) {
      x_error = 1;
   }
   XSetErrorHandler(handler);
   
   if (x_error) {
      pDraw = build_pixmap_rec( id );
   } else {
      pDraw = build_window_rec( id, &xwa );
   }

   return pDraw;
}


PixmapPtr find_server_pixmap_from_id( int id )
{
   int i;

   for (i = 0 ; i < nr_active_pixmaps ; i++)
      if (pixmap_list[i].pixmap == id)
	 return pixmap_list[i].ptr;

   fprintf(stderr, "couldn't find pixmap ptr for id %d\n", id);

   return 0;
}


/* Always build the optional struct, so this should never be called.
 */
WindowPtr FindWindowWithOptional(WindowPtr w)
{
   fprintf(stderr, "FindWindowWithOptional called\n");
   abort();
   return 0;
}


#if 0

typedef struct {
   ColormapPtr ptr;
   Colormap colormap;
} colormap_map;

static colormap_map colormap_list[MAX_DIRECT_RESOURCE];
static int nr_active_colormaps = 0;


ColormapPtr find_server_colormap_from_id( int id )
{
   int i;
   int (*handler)(Display *, XErrorEvent *);
   XWindowAttributes xwa;
   ColormapPtr pDraw;
   
   for (i = 0 ; i < nr_active_colormaps ; i++)
      if (colormap_list[i].colormap == id)
	 return colormap_list[i].ptr;
}


#endif



#define MAX_DIRECT_RESOURCE_TYPE 5

typedef struct {
   void *ptr;
   int id;
} resource_map;

static resource_map res_maps[MAX_DIRECT_RESOURCE_TYPE][MAX_DIRECT_RESOURCE];
static int res_nr[MAX_DIRECT_RESOURCE_TYPE];
static int max_resource_type;


/* Called extensively in protocol unpacking:
 */

pointer LookupIDByType(XID id, RESTYPE rtype)
{
   /* For pre-existing resourse types, check the local database for an
    * existing entry.  If none exists, query the server.  The hole in
    * this scheme is that we never learn of updates, and the X
    * protocol doesn't give us all the information anyway.  However we
    * get enough to get by.  Buffer swapping has to be done by the
    * server though.  
    */
   switch (rtype) {
   case RT_COLORMAP:
      return (ColormapPtr) id;	/* hello sailor */
   case RT_PIXMAP:
      return find_server_pixmap_from_id( id );
   case RT_FONT:
      return 0;			/* not implemented [need new proto request] */
   case RT_WINDOW:
      fprintf(stderr, "******************ni\n");
   case RT_GC:
   case RT_CURSOR:
   case RT_CMAPENTRY:
   case RT_OTHERCLIENT:
   case RT_PASSIVEGRAB:
   case RT_LASTPREDEF:
   case RT_NONE:
      return 0;			/* not used in glx.so */
   default:
      /* It's one of ours:  Linear scan is ok as there will usually only
       * be one item.
       */
      rtype -= RT_LASTPREDEF + 1;
      if (rtype >= 0 && rtype < max_resource_type) {
	 resource_map *array = res_maps[rtype];
	 int i;
	 for (i = 0 ; i < res_nr[rtype] ; i++)
	    if (array[i].id == id) 
	       return array[i].ptr;
      }

      return 0;
   }
}

/* Called
 */
pointer LookupIDByClass(XID id, RESTYPE classes)
{
   switch (classes) {
   case RC_DRAWABLE:
      return find_server_drawable_from_id( id );
   default:
      return 0;
   }
}

#ifdef XCSECURITY
pointer SecurityLookupIDByClass(ClientPtr client, XID id, RESTYPE rtype, Mask bleagh)
{
   return(LookupIDByClass(id, rtype));
}

pointer SecurityLookupIDByType(ClientPtr client, XID id, RESTYPE rtype, Mask bleagh)
{
   return(LookupIDByType(id, rtype));
}
#endif


RESTYPE CreateNewResourceType(DeleteType deleteFunc)
{
   if (max_resource_type == MAX_DIRECT_RESOURCE_TYPE)
      return 0;

   return RT_LASTPREDEF + ++max_resource_type;
}



Bool AddResource(XID id, RESTYPE rtype, pointer value)
{
   rtype -= RT_LASTPREDEF + 1;
   if (rtype >= 0 && rtype < max_resource_type) {
      resource_map *array = res_maps[rtype];
      int idx;
      
      if (res_nr[rtype] == MAX_DIRECT_RESOURCE) {
	 fprintf(stderr, "resource array %ld full\n", rtype);
	 return 0;
      }

      idx = res_nr[rtype]++;
      array[idx].id = id;
      array[idx].ptr = value;
      return 1;
   }

   fprintf(stderr, "Tried to add non-local resource type %ld\n", rtype);
   return 0;
}

/* This doesn't really meet specification, but it gels with our usage.
 * Best thing to do is to stop using this stuff in direct contexts.
 */
void FreeResource(XID id, RESTYPE rtype)
{
   rtype -= RT_LASTPREDEF + 1;
   if (rtype >= 0 && rtype < max_resource_type) {
      resource_map *array = res_maps[rtype];
      int i;
      
      for (i = 0 ; i < res_nr[rtype] ; i++)
	 if (array[i].id == id) {
	    res_nr[rtype]--;
	    array[i] = array[res_nr[rtype]];
	    return;
	 }

      fprintf(stderr, 
	      "couldn't find to remove res type %ld id %ld (%d active)\n",
		    rtype, id, res_nr[rtype]);

   }
}



