/* api2.c,v 1.1 1998/10/10 11:31:28 ripperda Exp */

/*
 * Mesa 3-D graphics library
 * Version:  3.0
 * Copyright (C) 1995-1998  Brian Paul
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


/*
 * api2.c,v
 * Revision 1.1  1998/10/10 11:31:28  ripperda
 * added for api table, integrating with Mesa
 *
 * Revision 3.6  1998/08/21 02:43:52  brianp
 * implemented true packing/unpacking of polygon stipples
 *
 * Revision 3.5  1998/07/26 02:32:43  brianp
 * removed unused variable
 *
 * Revision 3.4  1998/03/27 03:30:36  brianp
 * fixed G++ warnings
 *
 * Revision 3.3  1998/03/10 01:26:57  brianp
 * updated for David's v0.23 fxmesa driver
 *
 * Revision 3.2  1998/02/20 04:49:19  brianp
 * move extension functions into apiext.c
 *
 * Revision 3.1  1998/02/06 01:57:42  brianp
 * added GL 1.2 3-D texture enums and functions
 *
 * Revision 3.0  1998/01/31 20:43:12  brianp
 * initial rev
 *
 */

#include "glxlib.h"
#include "api.h"


/*
 * Part 2 of API functions
 */


void APIENTRY glOrtho( GLdouble left, GLdouble right,
                       GLdouble bottom, GLdouble top,
                       GLdouble nearval, GLdouble farval )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Ortho)( left, right, bottom, top, nearval, farval);
}


void APIENTRY glPassThrough( GLfloat token )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PassThrough)( token);
}


void APIENTRY glPixelMapfv( GLenum map, GLint mapsize, const GLfloat *values )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PixelMapfv)( map, mapsize, values );
}


void APIENTRY glPixelMapuiv( GLenum map, GLint mapsize, const GLuint *values )
{
   GLfloat fvalues[MAX_PIXEL_MAP_TABLE];
   GLint i;
   GET_CONTEXT;
   CHECK_CONTEXT;

   if (map==GL_PIXEL_MAP_I_TO_I || map==GL_PIXEL_MAP_S_TO_S) {
      for (i=0;i<mapsize;i++) {
         fvalues[i] = (GLfloat) values[i];
      }
   }
   else {
      for (i=0;i<mapsize;i++) {
         fvalues[i] = UINT_TO_FLOAT( values[i] );
      }
   }
   (*GLCurrent->API.PixelMapfv)( map, mapsize, fvalues );
}



void APIENTRY glPixelMapusv( GLenum map, GLint mapsize, const GLushort *values )
{
   GLfloat fvalues[MAX_PIXEL_MAP_TABLE];
   GLint i;
   GET_CONTEXT;
   CHECK_CONTEXT;

   if (map==GL_PIXEL_MAP_I_TO_I || map==GL_PIXEL_MAP_S_TO_S) {
      for (i=0;i<mapsize;i++) {
         fvalues[i] = (GLfloat) values[i];
      }
   }
   else {
      for (i=0;i<mapsize;i++) {
         fvalues[i] = USHORT_TO_FLOAT( values[i] );
      }
   }
   (*GLCurrent->API.PixelMapfv)( map, mapsize, fvalues );
}


void APIENTRY glPixelStoref( GLenum pname, GLfloat param )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PixelStorei)( pname, (GLint) param );
}


void APIENTRY glPixelStorei( GLenum pname, GLint param )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PixelStorei)( pname, param );
}


void APIENTRY glPixelTransferf( GLenum pname, GLfloat param )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PixelTransferf)( pname, param);
}


void APIENTRY glPixelTransferi( GLenum pname, GLint param )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PixelTransferf)( pname, (GLfloat) param);
}


void APIENTRY glPixelZoom( GLfloat xfactor, GLfloat yfactor )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PixelZoom)( xfactor, yfactor);
}


void APIENTRY glPointSize( GLfloat size )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PointSize)( size);
}


void APIENTRY glPolygonMode( GLenum face, GLenum mode )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PolygonMode)( face, mode);
}


void APIENTRY glPolygonOffset( GLfloat factor, GLfloat units )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PolygonOffset)( factor, units );
}


/* GL_EXT_polygon_offset */
void APIENTRY glPolygonOffsetEXT( GLfloat factor, GLfloat bias )
{
   glPolygonOffset( factor, bias * DEPTH_SCALE );
}


void APIENTRY glPolygonStipple( const GLubyte *pattern )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
      (*GLCurrent->API.PolygonStipple)( pattern );
}


void APIENTRY glPopAttrib( void )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PopAttrib)();
}


void APIENTRY glPopClientAttrib( void )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PopClientAttrib)();
}


void APIENTRY glPopMatrix( void )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PopMatrix)( );
}


void APIENTRY glPopName( void )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PopName)();
}


void APIENTRY glPrioritizeTextures( GLsizei n, const GLuint *textures,
                                    const GLclampf *priorities )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PrioritizeTextures)( n, textures, priorities);
}


void APIENTRY glPushMatrix( void )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PushMatrix)( );
}


void APIENTRY glRasterPos2d( GLdouble x, GLdouble y )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) x, (GLfloat) y, 0.0F, 1.0F );
}


void APIENTRY glRasterPos2f( GLfloat x, GLfloat y )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) x, (GLfloat) y, 0.0F, 1.0F );
}


void APIENTRY glRasterPos2i( GLint x, GLint y )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) x, (GLfloat) y, 0.0F, 1.0F );
}


void APIENTRY glRasterPos2s( GLshort x, GLshort y )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) x, (GLfloat) y, 0.0F, 1.0F );
}


void APIENTRY glRasterPos3d( GLdouble x, GLdouble y, GLdouble z )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) x, (GLfloat) y, (GLfloat) z, 1.0F );
}


void APIENTRY glRasterPos3f( GLfloat x, GLfloat y, GLfloat z )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) x, (GLfloat) y, (GLfloat) z, 1.0F );
}


void APIENTRY glRasterPos3i( GLint x, GLint y, GLint z )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) x, (GLfloat) y, (GLfloat) z, 1.0F );
}


void APIENTRY glRasterPos3s( GLshort x, GLshort y, GLshort z )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) x, (GLfloat) y, (GLfloat) z, 1.0F );
}


void APIENTRY glRasterPos4d( GLdouble x, GLdouble y, GLdouble z, GLdouble w )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) x, (GLfloat) y,
							   (GLfloat) z, (GLfloat) w );
}


void APIENTRY glRasterPos4f( GLfloat x, GLfloat y, GLfloat z, GLfloat w )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( x, y, z, w );
}


void APIENTRY glRasterPos4i( GLint x, GLint y, GLint z, GLint w )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) x, (GLfloat) y,
                           (GLfloat) z, (GLfloat) w );
}


void APIENTRY glRasterPos4s( GLshort x, GLshort y, GLshort z, GLshort w )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) x, (GLfloat) y,
                           (GLfloat) z, (GLfloat) w );
}


void APIENTRY glRasterPos2dv( const GLdouble *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) v[0], (GLfloat) v[1], 0.0F, 1.0F );
}


void APIENTRY glRasterPos2fv( const GLfloat *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) v[0], (GLfloat) v[1], 0.0F, 1.0F );
}


void APIENTRY glRasterPos2iv( const GLint *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) v[0], (GLfloat) v[1], 0.0F, 1.0F );
}


void APIENTRY glRasterPos2sv( const GLshort *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) v[0], (GLfloat) v[1], 0.0F, 1.0F );
}


/*** 3 element vector ***/

void APIENTRY glRasterPos3dv( const GLdouble *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) v[0], (GLfloat) v[1],
                           (GLfloat) v[2], 1.0F );
}


void APIENTRY glRasterPos3fv( const GLfloat *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) v[0], (GLfloat) v[1],
                               (GLfloat) v[2], 1.0F );
}


void APIENTRY glRasterPos3iv( const GLint *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) v[0], (GLfloat) v[1],
                           (GLfloat) v[2], 1.0F );
}


void APIENTRY glRasterPos3sv( const GLshort *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) v[0], (GLfloat) v[1],
                           (GLfloat) v[2], 1.0F );
}


void APIENTRY glRasterPos4dv( const GLdouble *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) v[0], (GLfloat) v[1],
                           (GLfloat) v[2], (GLfloat) v[3] );
}


void APIENTRY glRasterPos4fv( const GLfloat *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( v[0], v[1], v[2], v[3] );
}


void APIENTRY glRasterPos4iv( const GLint *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) v[0], (GLfloat) v[1],
                           (GLfloat) v[2], (GLfloat) v[3] );
}


void APIENTRY glRasterPos4sv( const GLshort *v )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.RasterPos4f)( (GLfloat) v[0], (GLfloat) v[1],
                           (GLfloat) v[2], (GLfloat) v[3] );
}


void APIENTRY glReadBuffer( GLenum mode )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ReadBuffer)( mode );
}


void APIENTRY glReadPixels( GLint x, GLint y, GLsizei width, GLsizei height,
		   GLenum format, GLenum type, GLvoid *pixels )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ReadPixels)( x, y, width, height, format, type, pixels );
}


void APIENTRY glRectd( GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2 )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Rectf)( (GLfloat) x1, (GLfloat) y1,
                     (GLfloat) x2, (GLfloat) y2 );
}


void APIENTRY glRectf( GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2 )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Rectf)( x1, y1, x2, y2 );
}


void APIENTRY glRecti( GLint x1, GLint y1, GLint x2, GLint y2 )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Rectf)( (GLfloat) x1, (GLfloat) y1,
                         (GLfloat) x2, (GLfloat) y2 );
}


void APIENTRY glRects( GLshort x1, GLshort y1, GLshort x2, GLshort y2 )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Rectf)( (GLfloat) x1, (GLfloat) y1,
                     (GLfloat) x2, (GLfloat) y2 );
}


void APIENTRY glRectdv( const GLdouble *v1, const GLdouble *v2 )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Rectf)( (GLfloat) v1[0], (GLfloat) v1[1],
                    (GLfloat) v2[0], (GLfloat) v2[1]);
}


void APIENTRY glRectfv( const GLfloat *v1, const GLfloat *v2 )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Rectf)( v1[0], v1[1], v2[0], v2[1]);
}


void APIENTRY glRectiv( const GLint *v1, const GLint *v2 )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Rectf)( (GLfloat) v1[0], (GLfloat) v1[1],
                     (GLfloat) v2[0], (GLfloat) v2[1] );
}


void APIENTRY glRectsv( const GLshort *v1, const GLshort *v2 )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Rectf)( (GLfloat) v1[0], (GLfloat) v1[1],
        (GLfloat) v2[0], (GLfloat) v2[1]);
}


void APIENTRY glScissor( GLint x, GLint y, GLsizei width, GLsizei height)
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Scissor)( x, y, width, height);
}


GLboolean APIENTRY glIsEnabled( GLenum cap )
{
   GET_CONTEXT;
   CHECK_CONTEXT_RETURN(GL_FALSE);
   return (*GLCurrent->API.IsEnabled)( cap );
}



void APIENTRY glPushAttrib( GLbitfield mask )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PushAttrib)( mask);
}


void APIENTRY glPushClientAttrib( GLbitfield mask )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PushClientAttrib)( mask);
}


void APIENTRY glPushName( GLuint name )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.PushName)( name);
}


GLint APIENTRY glRenderMode( GLenum mode )
{
   GET_CONTEXT;
   CHECK_CONTEXT_RETURN(0);
   return (*GLCurrent->API.RenderMode)( mode);
}


void APIENTRY glRotated( GLdouble angle, GLdouble x, GLdouble y, GLdouble z )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Rotatef)( (GLfloat) angle,
                       (GLfloat) x, (GLfloat) y, (GLfloat) z );
}


void APIENTRY glRotatef( GLfloat angle, GLfloat x, GLfloat y, GLfloat z )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Rotatef)( angle, x, y, z );
}


void APIENTRY glSelectBuffer( GLsizei size, GLuint *buffer )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.SelectBuffer)( size, buffer);
}


void APIENTRY glScaled( GLdouble x, GLdouble y, GLdouble z )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Scalef)( (GLfloat) x, (GLfloat) y, (GLfloat) z );
}


void APIENTRY glScalef( GLfloat x, GLfloat y, GLfloat z )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Scalef)( x, y, z );
}


void APIENTRY glShadeModel( GLenum mode )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.ShadeModel)( mode);
}


void APIENTRY glStencilFunc( GLenum func, GLint ref, GLuint mask )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.StencilFunc)( func, ref, mask);
}


void APIENTRY glStencilMask( GLuint mask )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.StencilMask)( mask);
}


void APIENTRY glStencilOp( GLenum fail, GLenum zfail, GLenum zpass )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.StencilOp)( fail, zfail, zpass);
}


void APIENTRY glTexCoord1d( GLdouble s )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) s, 0.0, 0.0, 1.0 );
}


void APIENTRY glTexCoord1f( GLfloat s )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( s, 0.0, 0.0, 1.0 );
}


void APIENTRY glTexCoord1i( GLint s )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) s, 0.0, 0.0, 1.0 );
}


void APIENTRY glTexCoord1s( GLshort s )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) s, 0.0, 0.0, 1.0 );
}


void APIENTRY glTexCoord2d( GLdouble s, GLdouble t )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord2f)( (GLfloat) s, (GLfloat) t );
}


void APIENTRY glTexCoord2f( GLfloat s, GLfloat t )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord2f)( s, t );
}


void APIENTRY glTexCoord2i( GLint s, GLint t )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord2f)( (GLfloat) s, (GLfloat) t );
}


void APIENTRY glTexCoord2s( GLshort s, GLshort t )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord2f)( (GLfloat) s, (GLfloat) t );
}


void APIENTRY glTexCoord3d( GLdouble s, GLdouble t, GLdouble r )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) s, (GLfloat) t, (GLfloat) r, 1.0 );
}


void APIENTRY glTexCoord3f( GLfloat s, GLfloat t, GLfloat r )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( s, t, r, 1.0 );
}


void APIENTRY glTexCoord3i( GLint s, GLint t, GLint r )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) s, (GLfloat) t,
                               (GLfloat) r, 1.0 );
}


void APIENTRY glTexCoord3s( GLshort s, GLshort t, GLshort r )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) s, (GLfloat) t,
                               (GLfloat) r, 1.0 );
}


void APIENTRY glTexCoord4d( GLdouble s, GLdouble t, GLdouble r, GLdouble q )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) s, (GLfloat) t,
                               (GLfloat) r, (GLfloat) q );
}


void APIENTRY glTexCoord4f( GLfloat s, GLfloat t, GLfloat r, GLfloat q )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( s, t, r, q );
}


void APIENTRY glTexCoord4i( GLint s, GLint t, GLint r, GLint q )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) s, (GLfloat) t,
                               (GLfloat) r, (GLfloat) q );
}


void APIENTRY glTexCoord4s( GLshort s, GLshort t, GLshort r, GLshort q )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) s, (GLfloat) t,
                               (GLfloat) r, (GLfloat) q );
}


void APIENTRY glTexCoord1dv( const GLdouble *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) *v, 0.0, 0.0, 1.0 );
}


void APIENTRY glTexCoord1fv( const GLfloat *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( *v, 0.0, 0.0, 1.0 );
}


void APIENTRY glTexCoord1iv( const GLint *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( *v, 0.0, 0.0, 1.0 );
}


void APIENTRY glTexCoord1sv( const GLshort *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) *v, 0.0, 0.0, 1.0 );
}


void APIENTRY glTexCoord2dv( const GLdouble *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord2f)( (GLfloat) v[0], (GLfloat) v[1] );
}


void APIENTRY glTexCoord2fv( const GLfloat *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord2f)( v[0], v[1] );
}


void APIENTRY glTexCoord2iv( const GLint *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord2f)( (GLfloat) v[0], (GLfloat) v[1] );
}


void APIENTRY glTexCoord2sv( const GLshort *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord2f)( (GLfloat) v[0], (GLfloat) v[1] );
}


void APIENTRY glTexCoord3dv( const GLdouble *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) v[0], (GLfloat) v[1],
                               (GLfloat) v[2], 1.0 );
}


void APIENTRY glTexCoord3fv( const GLfloat *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( v[0], v[1], v[2], 1.0 );
}


void APIENTRY glTexCoord3iv( const GLint *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) v[0], (GLfloat) v[1],
                          (GLfloat) v[2], 1.0 );
}


void APIENTRY glTexCoord3sv( const GLshort *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) v[0], (GLfloat) v[1],
                               (GLfloat) v[2], 1.0 );
}


void APIENTRY glTexCoord4dv( const GLdouble *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) v[0], (GLfloat) v[1],
                               (GLfloat) v[2], (GLfloat) v[3] );
}


void APIENTRY glTexCoord4fv( const GLfloat *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( v[0], v[1], v[2], v[3] );
}


void APIENTRY glTexCoord4iv( const GLint *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) v[0], (GLfloat) v[1],
                               (GLfloat) v[2], (GLfloat) v[3] );
}


void APIENTRY glTexCoord4sv( const GLshort *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.TexCoord4f)( (GLfloat) v[0], (GLfloat) v[1],
                               (GLfloat) v[2], (GLfloat) v[3] );
}


void APIENTRY glTexCoordPointer( GLint size, GLenum type, GLsizei stride,
                                 const GLvoid *ptr )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.TexCoordPointer)( size, type, stride, ptr);
}


void APIENTRY glTexGend( GLenum coord, GLenum pname, GLdouble param )
{
   GLfloat p = (GLfloat) param;
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.TexGenfv)( coord, pname, &p );
}


void APIENTRY glTexGenf( GLenum coord, GLenum pname, GLfloat param )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.TexGenfv)( coord, pname, &param );
}


void APIENTRY glTexGeni( GLenum coord, GLenum pname, GLint param )
{
   GLfloat p = (GLfloat) param;
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.TexGenfv)( coord, pname, &p );
}


void APIENTRY glTexGendv( GLenum coord, GLenum pname, const GLdouble *params )
{
   GLfloat p[4];
   GET_CONTEXT;
   CHECK_CONTEXT;
   p[0] = params[0];
   p[1] = params[1];
   p[2] = params[2];
   p[3] = params[3];
   (*GLCurrent->API.TexGenfv)( coord, pname, p );
}


void APIENTRY glTexGeniv( GLenum coord, GLenum pname, const GLint *params )
{
   GLfloat p[4];
   GET_CONTEXT;
   CHECK_CONTEXT;
   p[0] = params[0];
   p[1] = params[1];
   p[2] = params[2];
   p[3] = params[3];
   (*GLCurrent->API.TexGenfv)( coord, pname, p );
}


void APIENTRY glTexGenfv( GLenum coord, GLenum pname, const GLfloat *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.TexGenfv)( coord, pname, params );
}




void APIENTRY glTexEnvf( GLenum target, GLenum pname, GLfloat param )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.TexEnvfv)( target, pname, &param );
}



void APIENTRY glTexEnvi( GLenum target, GLenum pname, GLint param )
{
   GLfloat p[4];
   GET_CONTEXT;
   p[0] = (GLfloat) param;
   p[1] = p[2] = p[3] = 0.0;
   CHECK_CONTEXT;
   (*GLCurrent->API.TexEnvfv)( target, pname, p );
}



void APIENTRY glTexEnvfv( GLenum target, GLenum pname, const GLfloat *param )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.TexEnvfv)( target, pname, param );
}



void APIENTRY glTexEnviv( GLenum target, GLenum pname, const GLint *param )
{
   GLfloat p[4];
   GET_CONTEXT;
   p[0] = INT_TO_FLOAT( param[0] );
   p[1] = INT_TO_FLOAT( param[1] );
   p[2] = INT_TO_FLOAT( param[2] );
   p[3] = INT_TO_FLOAT( param[3] );
   CHECK_CONTEXT;
   (*GLCurrent->API.TexEnvfv)( target, pname, p );
}


void APIENTRY glTexImage1D( GLenum target, GLint level, GLint internalformat,
                            GLsizei width, GLint border,
                            GLenum format, GLenum type, const GLvoid *pixels )
{
   GET_CONTEXT;
   CHECK_CONTEXT;

      (*GLCurrent->API.TexImage1D)( target, level, internalformat,
                          width, border, format, type, pixels);
}



void APIENTRY glTexImage2D( GLenum target, GLint level, GLint internalformat,
                            GLsizei width, GLsizei height, GLint border,
                            GLenum format, GLenum type, const GLvoid *pixels )
{
  GET_CONTEXT;
  CHECK_CONTEXT;
  (*GLCurrent->API.TexImage2D)( target, level, internalformat,
				width, height, border, format, type, pixels);

}

#if 0
void APIENTRY glTexImage3D( GLenum target, GLint level, GLenum internalformat,
                            GLsizei width, GLsizei height, GLsizei depth,
                            GLint border, GLenum format, GLenum type,
                            const GLvoid *pixels )
{
   GET_CONTEXT;
   CHECK_CONTEXT;

   (*GLCurrent->API.TexImage3DEXT)( target, level, internalformat,
                             width, height, depth, border, format, type, 
                             pixels );
}
#endif

void APIENTRY glTexParameterf( GLenum target, GLenum pname, GLfloat param )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.TexParameterfv)( target, pname, &param );
}


void APIENTRY glTexParameteri( GLenum target, GLenum pname, GLint param )
{
   GLfloat fparam[4];
   GET_CONTEXT;
   fparam[0] = (GLfloat) param;
   fparam[1] = fparam[2] = fparam[3] = 0.0;
   CHECK_CONTEXT;
   (*GLCurrent->API.TexParameterfv)( target, pname, fparam );
}


void APIENTRY glTexParameterfv( GLenum target, GLenum pname, const GLfloat *params )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.TexParameterfv)( target, pname, params );
}


void APIENTRY glTexParameteriv( GLenum target, GLenum pname, const GLint *params )
{
   GLfloat p[4];
   GET_CONTEXT;
   CHECK_CONTEXT;
   if (pname==GL_TEXTURE_BORDER_COLOR) {
      p[0] = INT_TO_FLOAT( params[0] );
      p[1] = INT_TO_FLOAT( params[1] );
      p[2] = INT_TO_FLOAT( params[2] );
      p[3] = INT_TO_FLOAT( params[3] );
   }
   else {
      p[0] = (GLfloat) params[0];
      p[1] = (GLfloat) params[1];
      p[2] = (GLfloat) params[2];
      p[3] = (GLfloat) params[3];
   }
   (*GLCurrent->API.TexParameterfv)( target, pname, p );
}


void APIENTRY glTexSubImage1D( GLenum target, GLint level, GLint xoffset,
                               GLsizei width, GLenum format,
                               GLenum type, const GLvoid *pixels )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.TexSubImage1D)( target, level, xoffset, width,
                             format, type, pixels);
}


void APIENTRY glTexSubImage2D( GLenum target, GLint level,
                               GLint xoffset, GLint yoffset,
                               GLsizei width, GLsizei height,
                               GLenum format, GLenum type,
                               const GLvoid *pixels )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.TexSubImage2D)( target, level, xoffset, yoffset,
                             width, height, format, type, pixels);
}

#if 0
void APIENTRY glTexSubImage3D( GLenum target, GLint level, GLint xoffset,
                               GLint yoffset, GLint zoffset, GLsizei width,
                               GLsizei height, GLsizei depth, GLenum format,
                               GLenum type, const GLvoid *pixels )
{
   GET_CONTEXT;
   CHECK_CONTEXT;

      (*GLCurrent->API.TexSubImage3DEXT)( target, level, xoffset, yoffset, 
                                zoffset,
                                width, height, depth, format, type, pixels);
}
#endif

void APIENTRY glTranslated( GLdouble x, GLdouble y, GLdouble z )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Translatef)( (GLfloat) x, (GLfloat) y, (GLfloat) z );
}


void APIENTRY glTranslatef( GLfloat x, GLfloat y, GLfloat z )
{
   GET_CONTEXT;
   CHECK_CONTEXT;
   (*GLCurrent->API.Translatef)( x, y, z );
}


void APIENTRY glVertex2d( GLdouble x, GLdouble y )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex2f)( (GLfloat) x, (GLfloat) y );
}


void APIENTRY glVertex2f( GLfloat x, GLfloat y )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex2f)( x, y );
}


void APIENTRY glVertex2i( GLint x, GLint y )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex2f)( (GLfloat) x, (GLfloat) y );
}


void APIENTRY glVertex2s( GLshort x, GLshort y )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex2f)( (GLfloat) x, (GLfloat) y );
}


void APIENTRY glVertex3d( GLdouble x, GLdouble y, GLdouble z )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex3f)( (GLfloat) x, (GLfloat) y, (GLfloat) z );
}


void APIENTRY glVertex3f( GLfloat x, GLfloat y, GLfloat z )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex3f)( x, y, z );
}


void APIENTRY glVertex3i( GLint x, GLint y, GLint z )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex3f)( (GLfloat) x, (GLfloat) y, (GLfloat) z );
}


void APIENTRY glVertex3s( GLshort x, GLshort y, GLshort z )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex3f)( (GLfloat) x, (GLfloat) y, (GLfloat) z );
}


void APIENTRY glVertex4d( GLdouble x, GLdouble y, GLdouble z, GLdouble w )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex4f)( (GLfloat) x, (GLfloat) y,
                            (GLfloat) z, (GLfloat) w );
}


void APIENTRY glVertex4f( GLfloat x, GLfloat y, GLfloat z, GLfloat w )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex4f)( x, y, z, w );
}


void APIENTRY glVertex4i( GLint x, GLint y, GLint z, GLint w )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex4f)( (GLfloat) x, (GLfloat) y,
                            (GLfloat) z, (GLfloat) w );
}


void APIENTRY glVertex4s( GLshort x, GLshort y, GLshort z, GLshort w )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex4f)( (GLfloat) x, (GLfloat) y,
                            (GLfloat) z, (GLfloat) w );
}


void APIENTRY glVertex2dv( const GLdouble *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex2f)( (GLfloat) v[0], (GLfloat) v[1] );
}


void APIENTRY glVertex2fv( const GLfloat *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex2f)( v[0], v[1] );
}


void APIENTRY glVertex2iv( const GLint *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex2f)( (GLfloat) v[0], (GLfloat) v[1] );
}


void APIENTRY glVertex2sv( const GLshort *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex2f)( (GLfloat) v[0], (GLfloat) v[1] );
}


void APIENTRY glVertex3dv( const GLdouble *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex3f)( (GLfloat) v[0], (GLfloat) v[1], (GLfloat) v[2] );
}


void APIENTRY glVertex3fv( const GLfloat *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex3fv)( v );
}


void APIENTRY glVertex3iv( const GLint *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex3f)( (GLfloat) v[0], (GLfloat) v[1], (GLfloat) v[2] );
}


void APIENTRY glVertex3sv( const GLshort *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex3f)( (GLfloat) v[0], (GLfloat) v[1], (GLfloat) v[2] );
}


void APIENTRY glVertex4dv( const GLdouble *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex4f)( (GLfloat) v[0], (GLfloat) v[1],
                            (GLfloat) v[2], (GLfloat) v[3] );
}


void APIENTRY glVertex4fv( const GLfloat *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex4f)( v[0], v[1], v[2], v[3] );
}


void APIENTRY glVertex4iv( const GLint *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex4f)( (GLfloat) v[0], (GLfloat) v[1],
                            (GLfloat) v[2], (GLfloat) v[3] );
}


void APIENTRY glVertex4sv( const GLshort *v )
{
   GET_CONTEXT;
   (*GLCurrent->API.Vertex4f)( (GLfloat) v[0], (GLfloat) v[1],
                            (GLfloat) v[2], (GLfloat) v[3] );
}


void APIENTRY glVertexPointer( GLint size, GLenum type, GLsizei stride,
                               const GLvoid *ptr )
{
   GET_CONTEXT;
   (*GLCurrent->API.VertexPointer)( size, type, stride, ptr);
}


void APIENTRY glViewport( GLint x, GLint y, GLsizei width, GLsizei height )
{
   GET_CONTEXT;
   (*GLCurrent->API.Viewport)( x, y, width, height );
}

