/***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-1999 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-1999 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/
/*
 * Lets us know where and when we can talk to the HW.
 */
extern int xf86VTSema;
extern int vgaLinearBase;
extern void * (*vgaSaveFunc)(void *);
extern void   (*vgaRestoreFunc)(void *);
/*
 * RIVA includes from X server.
 */
#include "riva_hw.h"
/*
 * RIVA hardware instance structure.
 */
extern RIVA_HW_INST riva;

/* Compatibility #defines */
#ifdef MESA31
#define VBCOLOR ColorPtr->data
#define VBWIN Win.data  
#define VBCLIP Clip.data
#define VBEYE Eye.data
#define TEXCOORD(x, y, z) TexCoordPtr[x]->data[y][z]
#else
#define VBCOLOR Color
#define VBWIN Win  
#define VBCLIP Clip
#define VBEYE Eye
#define TEXCOORD(x, y, z) MultiTexCoord[x][y][z]
#endif
/*
 * Buffers.
 */
#define RIVA_FRONT_BUFFER       0
#define RIVA_BACK_BUFFER        1
#define RIVA_DEPTH_BUFFER       2
#define RIVA_TEXTURE_BUFFER     3
#define RIVA_CACHE_BUFFER       4
extern unsigned rivaBufferOffset[5];
/*
 * 2D rendered flag. Also used to force 3D context reload.
 */
extern int rivaRendered2D;
/*
 * !!! This is the same variable !!!
 */
#define rivaReload3D    rivaRendered2D
/*
 * Sync get/put pixel with HW.
 */
extern int rivaSyncPix;
/*
 * RIVA GLX enabled flag.
 */
extern int rivaGLXEnabled;
/*
 * Structures defining the texture buffer heap.
 */
typedef struct riva_tex_block
{
    struct   gl_texture_object *Owner;
    unsigned Priority;
    unsigned Format;
    unsigned maxLevel;
    unsigned baseWidthLog2;
    unsigned baseHeightLog2;
    float    sAdjust;
    float    tAdjust;
    int      Index;
    int      Size;
    int      Next;
    int      Prev;
    int      NextLRU;
    int      PrevLRU;
} RIVA_TEX_BLOCK;
typedef struct riva_tex_heap
{
    int             Total;
    int             Free;
    int             FreeBlocks;
    int             Head;
    int             Tail;
    int             HeadLRU;
    int             TailLRU;
    unsigned        DefaultOffset;
    unsigned        DefaultAAOffset;
    RIVA_TEX_BLOCK *Blocks;
} RIVA_TEX_HEAP;
extern RIVA_TEX_HEAP rivaTexHeap;
#define NULL_INDEX  0
/*
 * Current 3D state context.
 */
typedef struct riva_3d_ctx
{
    struct gl_texture_object *texObj;
    unsigned                  texOffset;
    unsigned                  texFormat;
    unsigned                  texFilter;
    unsigned                  triControl;
    unsigned                  triControlPass2;
    unsigned                  triFogColor;
    unsigned                  triAlphaTest;
    unsigned                  modeMask;
    float                     sAdjust;
    float                     tAdjust;
    int                       bufRender;
    unsigned short            VCache[16];
    int                       NumCtxs;
    int                       SimpleClip;
    float                     xyAdjust;
    unsigned                  BugFix;
    float                     InvWScale;
} RIVA_3D_CTX;
extern RIVA_3D_CTX rivaContext;
#define RIVA_VCACHE_MASK        0x07
#define NV4_Z_ENABLE_BUG        0x00000001
#define NV4_ALPHATEST_BUG       0x00000002
/*
 * Texture alignment/block sizes.
 */
#define RIVA_TEX_ALIGN          256
#define RIVA_TEX_BLOCK_SIZE     8192
#define RIVA_TEX_BLOCK_OFFSET(b)    (rivaBufferOffset[RIVA_TEXTURE_BUFFER] + (b)*RIVA_TEX_BLOCK_SIZE)
#define RIVA_TEX_BLOCK_ADDRESS(b)   ((char *)(vgaLinearBase + RIVA_TEX_BLOCK_OFFSET(b)))
/*
 * Priorities.
 */
#define TEX_MAX_PRIORITY    0x3F800000
#define TEX_MIN_PRIORITY    0x00000000
/*
 * Texel copy/conversion.
 */
#define TEX_FIX_SCALE           16
/*
 * Some cool macros for use during texture swizzling.
 */
#define RIVA_U_INC(uu)          (((uu) + 0xAAAAAAAB) & 0x55555555)
#define RIVA_U_INC2(uu)         (((uu) + 0xAAAAAAAC) & 0x55555555)
#define RIVA_V_INC(vv)          (((vv) + 0x55555556) & 0xAAAAAAAA)
#define RIVA_UV_OFFSET(vv,uu)   ((vv)|(uu))
/*
 * HW macros.
 */
#define RIVA_CLIP3D(xx1, yy1, xx2, yy2)                                             \
{                                                                                   \
rivaRendered2D=1;                                                                   \
RIVA_FIFO_FREE(riva,Clip,2);                                                        \
riva.Clip->TopLeft     = ((yy1)     << 16) | (xx1);                                 \
riva.Clip->WidthHeight = ((yy2-yy1) << 16) | (xx2-xx1);                             \
}
#define RIVA_STATE3D(t0, t1, t2, fc, cc, at)                                        \
{                                                                                   \
RIVA_FIFO_FREE(riva,Tri03,6);                                                       \
riva.Tri03->TextureOffset = t0;                                                     \
riva.Tri03->TextureFormat = t1;                                                     \
riva.Tri03->TextureFilter = t2;                                                     \
riva.Tri03->FogColor      = fc;                                                     \
riva.Tri03->Control       = cc;                                                     \
riva.Tri03->AlphaTest     = at;                                                     \
if (rivaContext.BugFix & NV4_Z_ENABLE_BUG)                                          \
{                                                                                   \
    while (riva.Busy(&riva));                                                       \
    riva.PGRAPH[0x00000818/4] |= 0x00004000;                                        \
}                                                                                   \
}
#define DEPTH_UNSCALE   (1.0F/(float)DEPTH_SCALE)
#define RIVA_VERTEX3D(fi, argb, xx, yy, zz, mm, ss, tt)                             \
{                                                                                   \
RIVA_FIFO_FREE(riva,Tri03,8);                                                       \
riva.Tri03->FogAndIndex = fi;                                                       \
riva.Tri03->Color       = argb;                                                     \
riva.Tri03->ScreenX     = xx;                                                       \
riva.Tri03->ScreenY     = yy;                                                       \
riva.Tri03->ScreenZ     = (zz)*DEPTH_UNSCALE;                                       \
riva.Tri03->EyeM        = mm;                                                       \
riva.Tri03->TextureS    = (ss) - rivaContext.sAdjust;                               \
riva.Tri03->TextureT    = (tt) - rivaContext.tAdjust;                               \
}

#ifdef MESA31
/*
 * Get 1.0/W out of win coordinatea.
 */
#define INV_W(vv)   VB->VBWIN[vv][3] * rivaContext.InvWScale
#else
/*
 * Recalc 1.0/W
 */
#define INV_W(vv)   1.0F/VB->VBCLIP[vv][3]
#endif

/*
 * Fast float->int conversions.
 */
#define RivaFloatToInt(intbits, fp)                                                 \
{                                                                                   \
    GLfloat fpbits  = fp + 8388608.0F;                                              \
    intbits = (*(GLint *)&fpbits & 0x80000000)                                      \
            ? -(*(GLint *)&fpbits & 0x007FFFFF) : *(GLint *)&fpbits & 0x007FFFFF;   \
}
#define RivaFloatToUInt(intbits, fp)                                                \
{                                                                                   \
    GLfloat fpbits  = fp + 8388608.0F;                                              \
    intbits = *(GLint *)&fpbits & 0x007FFFFF;                                       \
}
/*
 * Link for hooking accelerated funcitons.
 */
void      RivaPointsNOP(GLcontext *, GLuint, GLuint);
void      RivaPoints3D(GLcontext *, GLuint, GLuint);
void      RivaAAPoints3D(GLcontext *, GLuint, GLuint);
void      Riva2PassPoints3D(GLcontext *, GLuint, GLuint);
void      RivaLineNOP(GLcontext *, GLuint, GLuint, GLuint);
void      RivaLine3D(GLcontext *, GLuint, GLuint, GLuint);
void      RivaAALine3D(GLcontext *, GLuint, GLuint, GLuint);
void      Riva2PassLine3D(GLcontext *, GLuint, GLuint, GLuint);
void      RivaTriangleNOP(GLcontext *, GLuint, GLuint, GLuint, GLuint);
void      RivaTriangle3D(GLcontext *, GLuint, GLuint, GLuint, GLuint);
void      Riva2PassTriangle3D(GLcontext *, GLuint, GLuint, GLuint, GLuint);
GLboolean RivaRenderVB(GLcontext *, GLboolean);
void      RivaUpdateState(GLcontext *ctx);
void      RivaReleaseTextures(void);
int       RivaInitTextureHeap(void);
void      RivaTexImage(GLcontext *,GLenum,struct gl_texture_object *,GLint,GLint,const struct gl_texture_image *);
void      RivaTexSubImage(GLcontext *,GLenum,struct gl_texture_object *,GLint,GLint,GLint,GLint,GLint,GLint,const struct gl_texture_image *);
void      RivaDeleteTexture(GLcontext *, struct gl_texture_object *);
void      RivaBindTexture(GLcontext *, GLenum, struct gl_texture_object *);
void      RivaSwapBuffers(XSMesaBuffer);
GLboolean nvInitGLX(void);
GLboolean nvInitVisuals(VisualPtr *, DepthPtr *, int *, int *, int *, VisualID *, unsigned long, int);
extern GLboolean (*hwInitGLX)();
extern GLboolean (*hwInitVisuals)(VisualPtr *, DepthPtr *, int *, int *, int *, VisualID *, unsigned long, int);

