
#include <stdio.h>

#include "xsmesaP.h"

#include "types.h"
#include "pb.h"
#include "dd.h"

#include "glx_log.h"
#include "mm.h"
#include "g200_mac.h"
#include "mgalib.h"
#include "mgaglx.h"
#include "mgadd.h"
#include "mgastate.h"
#include "mgadepth.h"
#include "mgatex.h"
#include "mgalog.h"
#include "mgavb.h"
#include "mgatris.h"



static void mgaUpdateZMode(const GLcontext *ctx)
{
  int zmode = 0;

  if (ctx->Depth.Test && mgaDB->HasZORG) {
    switch(ctx->Depth.Func)  { 
    case GL_NEVER:
      zmode = DC_zmode_nozcmp; break;
    case GL_ALWAYS:  
      zmode = DC_zmode_nozcmp; break;
    case GL_LESS:
      zmode = DC_zmode_zlt; break; 
    case GL_LEQUAL:
      zmode = DC_zmode_zlte; break;
    case GL_EQUAL:
      zmode = DC_zmode_ze; break;
    case GL_GREATER:
      zmode = DC_zmode_zgt; break;
    case GL_GEQUAL:
      zmode = DC_zmode_zgte; break;
    case GL_NOTEQUAL:
      zmode = DC_zmode_zne; break;
    default:
      break;
    }
    if (ctx->Depth.Mask)
      zmode |= DC_atype_zi;
    else
      zmode |= DC_atype_i;
  } else {
    zmode |= DC_zmode_nozcmp | DC_atype_i;
  }

  mgaCtx->regDWGCTL &= DC_zmode_MASK & DC_atype_MASK;
  mgaCtx->regDWGCTL |= zmode;

  mgaCtx->reg_dirty |= (1<<MGA_SETUP_DWGCTL);
}


static void mgaDDAlphaFunc(GLcontext *ctx, GLenum func, GLclampf ref)
{
   MGA_CONTEXT(ctx)->new_state |= MGA_NEW_ALPHA;
}


static void mgaDDBlendEquation(GLcontext *ctx, GLenum mode) 
{
   MGA_CONTEXT(ctx)->new_state |= MGA_NEW_ALPHA;
}

static void mgaDDBlendFunc(GLcontext *ctx, GLenum sfactor, GLenum dfactor)
{
   MGA_CONTEXT(ctx)->new_state |= MGA_NEW_ALPHA;
}

static void mgaDDBlendFuncSeparate( GLcontext *ctx, GLenum sfactorRGB, 
				    GLenum dfactorRGB, GLenum sfactorA,
				    GLenum dfactorA )
{
   MGA_CONTEXT(ctx)->new_state |= MGA_NEW_ALPHA;
}



static void mgaDDLightModelfv(GLcontext *ctx, GLenum pname, 
			      const GLfloat *param)
{
   if (pname == GL_LIGHT_MODEL_COLOR_CONTROL) {
      MGA_CONTEXT(ctx)->new_state |= MGA_NEW_TEXTURE;
   }
}


static void mgaDDShadeModel(GLcontext *ctx, GLenum mode)
{
   if (1) {
      MGA_CONTEXT(ctx)->new_state |= MGA_NEW_TEXTURE; 
     mgaMsg(8, "mgaDDShadeModel: %x\n", mode);
   }
}


static void mgaDDDepthFunc(GLcontext *ctx, GLenum func)
{
   MGA_CONTEXT(ctx)->new_state |= MGA_NEW_DEPTH;
}

static void mgaDDDepthMask(GLcontext *ctx, GLboolean flag)
{
   MGA_CONTEXT(ctx)->new_state |= MGA_NEW_DEPTH;
}




static void mgaUpdateFogAttrib( GLcontext *ctx )
{
   mgaContextPtr mmesa = MGA_CONTEXT(ctx);

   mgaUI32 color = MGAPACKCOLOR888((mgaUI8)(ctx->Fog.Color[0]*255.0F), 
				   (mgaUI8)(ctx->Fog.Color[1]*255.0F), 
				   (mgaUI8)(ctx->Fog.Color[2]*255.0F));

   if (color != mmesa->regFOGCOLOR) {
      mmesa->regFOGCOLOR = color;
      mmesa->reg_dirty |= (1<<MGA_SETUP_FOGCOLOR);
   }

   mmesa->DB->Setup[MGA_SETUP_MACCESS] &= ~MA_fogen_enable;
   if (ctx->FogMode == FOG_FRAGMENT) 
      mmesa->DB->Setup[MGA_SETUP_MACCESS] |= MA_fogen_enable;
   mmesa->reg_dirty |= (1<<MGA_SETUP_MACCESS);
}

static void mgaDDFogfv(GLcontext *ctx, GLenum pname, const GLfloat *param)
{
   MGA_CONTEXT(ctx)->new_state |= MGA_NEW_FOG;
}




/* =============================================================
 * Alpha blending
 */


static void mgaUpdateAlphaMode(GLcontext *ctx)
{
   int a = 0;

   /* determine source of alpha for blending and testing */
   if ( !ctx->Texture.Enabled || (mgaCtx->SoftwareFallback & FALLBACK_TEXTURE)) 
      a |= AC_alphasel_diffused;
   else {
      switch (ctx->Texture.Unit[0].EnvMode) {
      case GL_DECAL:
      case GL_REPLACE:
	 a |= AC_alphasel_fromtex;
	 break;
      case GL_BLEND:
      case GL_MODULATE:
	 a |= AC_alphasel_modulated;
	 break;
      default:
      }
   }


   /* alpha test control - disabled by default.
    */
   if (ctx->Color.AlphaEnabled) {
      GLubyte ref = ctx->Color.AlphaRef;
      switch (ctx->Color.AlphaFunc) {
      case GL_NEVER:		
	 a |= AC_atmode_alt;
	 ref = 0;
	 break;
      case GL_LESS:
	 a |= AC_atmode_alt; 
	 break;
      case GL_GEQUAL:
	 a |= AC_atmode_agte; 
	 break;
      case GL_LEQUAL:  
	 a |= AC_atmode_alte; 
	 break;
      case GL_GREATER:  
	 a |= AC_atmode_agt; 
	 break;
      case GL_NOTEQUAL: 
	 a |= AC_atmode_ane; 
	 break;
      case GL_EQUAL: 
	 a |= AC_atmode_ae; 
	 break;
      case GL_ALWAYS:
	 a |= AC_atmode_noacmp; 
	 break;
      default:
      }
      a |= MGA_FIELD(AC_atref,ref);
   }

   /* blending control */
   if (ctx->Color.BlendEnabled) {
      switch (ctx->Color.BlendSrcRGB) {
      case GL_ZERO:
	 a |= AC_src_zero; break;
      case GL_SRC_ALPHA:
	 a |= AC_src_src_alpha; break;
      case GL_ONE:
	 a |= AC_src_one; break;
      case GL_DST_COLOR:
	 a |= AC_src_dst_color; break;
      case GL_ONE_MINUS_DST_COLOR:
	 a |= AC_src_om_dst_color; break;
      case GL_ONE_MINUS_SRC_ALPHA:
	 a |= AC_src_om_src_alpha; break;
      case GL_DST_ALPHA:
	 if (mgaDB->Attrib & MGA_PF_HASALPHA)
	    a |= AC_src_dst_alpha;
	 else
	    a |= AC_src_one;
	 break;
      case GL_ONE_MINUS_DST_ALPHA:
	 if (mgaDB->Attrib & MGA_PF_HASALPHA)
	    a |= AC_src_om_dst_alpha; 
	 else 
	    a |= AC_src_zero;
	 break;
      case GL_SRC_ALPHA_SATURATE:
	 a |= AC_src_src_alpha_sat; 
	 break;
      default:		/* never happens */
      }

      switch (ctx->Color.BlendDstRGB) {
      case GL_SRC_ALPHA:
	 a |= AC_dst_src_alpha; break;
      case GL_ONE_MINUS_SRC_ALPHA:
	 a |= AC_dst_om_src_alpha; break;
      case GL_ZERO:
	 a |= AC_dst_zero; break;
      case GL_ONE:
	 a |= AC_dst_one; break;
      case GL_SRC_COLOR:
	 a |= AC_dst_src_color; break;
      case GL_ONE_MINUS_SRC_COLOR:
	 a |= AC_dst_om_src_color; break;
      case GL_DST_ALPHA:
	 if (mgaDB->Attrib & MGA_PF_HASALPHA)
	    a |= AC_dst_dst_alpha;
	 else
	    a |= AC_dst_one;
	 break;
      case GL_ONE_MINUS_DST_ALPHA:
	 if (mgaDB->Attrib & MGA_PF_HASALPHA)
	    a |= AC_dst_om_dst_alpha;
	 else
	    a |= AC_dst_zero;
	 break;
      default:		/* never happens */
      }
   } else {
      a |= AC_src_one|AC_dst_zero;
   }

   mgaCtx->regALPHACTRL = AC_amode_alpha_channel | 
    AC_astipple_disable | AC_aten_disable | AC_atmode_noacmp | a;
 
   mgaCtx->reg_dirty |= 1<<MGA_SETUP_ALPHACTRL;
}



/* =============================================================
 * Hardware clipping
 */

static void mgaUpdateClipping(const GLcontext *ctx)
{
   int x1,x2,y1,y2;

   if ( ctx->Scissor.Enabled) {
      x1 = ctx->Scissor.X;
      x2 = ctx->Scissor.X + ctx->Scissor.Width - 1;
      y1 = mgaDB->Height - ctx->Scissor.Y - ctx->Scissor.Height;
      y2 = mgaDB->Height - ctx->Scissor.Y - 1;
   } else {
      x1 = 0;
      y1 = 0;
      x2 = mgaDB->Width-1;
      y2 = mgaDB->Height-1;
   }
  
   if (x1 < 0) x1 = 0;
   if (y1 < 0) y1 = 0;
   if (x2 >= mgaDB->Width) x2 = mgaDB->Width-1;
   if (y2 >= mgaDB->Height) y2 = mgaDB->Height-1;

   if (x1 > x2 || y1 > y2) {
      x1 = 0; x2 = 0;
      y2 = 0; y1 = 1;
   }

   /* the G400 seems to have an issue with the second WARP not
      stalling clipper register writes.  This bothers me, but the
      only way I could get it to never clip the last triangle under
      any circumstances is by inserting TWO dwgsync commands 
   */
   if(MGA_IS_G400(MGAchipset)) {
      DMALOCALS;
      
      MGADMAGETPTR(4);
      DMAOUTREG( MGAREG_DWGSYNC, SYNC_DMA_BUSY );
      DMAOUTREG( MGAREG_DWGSYNC, SYNC_DMA_BUSY );
      DMAADVANCE();
   }

   mgaDB->Setup[MGA_SETUP_CXBNDRY] = (MGA_FIELD(CXB_cxright,x2) | 
				      MGA_FIELD(CXB_cxleft,x1));
   mgaDB->Setup[MGA_SETUP_YTOP] = y1*mgaDB->Pitch;
   mgaDB->Setup[MGA_SETUP_YBOT] = y2*mgaDB->Pitch;


   mgaCtx->reg_dirty |= ((1<<MGA_SETUP_CXBNDRY) |
			 (1<<MGA_SETUP_YTOP) |
			 (1<<MGA_SETUP_YBOT));
}


static void mgaDDScissor( GLcontext *ctx, GLint x, GLint y, 
			  GLsizei w, GLsizei h )
{
   MGA_CONTEXT(ctx)->new_state |= MGA_NEW_CLIP;
}


/* =============================================================
 * Culling
 */

#define _CULL_DISABLE 0
#define _CULL_NEGATIVE ((1<<11)|(1<<5)|(1<<16))
#define _CULL_POSITIVE (1<<11)


void mgaUpdateCull( GLcontext *ctx )
{
   mgaContextPtr mmesa = MGA_CONTEXT(ctx);
   GLuint mode = _CULL_DISABLE;
   
   if (ctx->Polygon.CullFlag && 
       ctx->PB->primitive == GL_POLYGON &&       
       ctx->Polygon.CullFaceMode != GL_FRONT_AND_BACK) 
   {
      mode = _CULL_NEGATIVE;
      if (ctx->Polygon.CullFaceMode == GL_FRONT)
	 mode ^= (_CULL_POSITIVE ^ _CULL_NEGATIVE);
      if (ctx->Polygon.FrontFace != GL_CCW)
	 mode ^= (_CULL_POSITIVE ^ _CULL_NEGATIVE);
      if (mmesa->multitex)
	 mode ^= (_CULL_POSITIVE ^ _CULL_NEGATIVE); /* why??? */
   }

   mmesa->regWFLAG = mode;
   mmesa->reg_dirty |= (1<<MGA_SETUP_WFLAG);
}


static void mgaDDCullFace(GLcontext *ctx, GLenum mode)
{
   MGA_CONTEXT(ctx)->new_state |= MGA_NEW_CULL;
}

static void mgaDDFrontFace(GLcontext *ctx, GLenum mode)
{
   MGA_CONTEXT(ctx)->new_state |= MGA_NEW_CULL;
}



/* =============================================================
 * Color masks
 */

/* Mesa calls this from the wrong place:
 */
static GLboolean mgaDDColorMask(GLcontext *ctx, 
				GLboolean r, GLboolean g, 
				GLboolean b, GLboolean a )
{
   GLuint mask;
   mask = mgaPackColor(ctx->Color.ColorMask[RCOMP],
		       ctx->Color.ColorMask[GCOMP],
		       ctx->Color.ColorMask[BCOMP],
		       ctx->Color.ColorMask[ACOMP]);
  
   switch (mgaDB->Attrib & MGA_PF_MASK)
   {
   case MGA_PF_555:
   case MGA_PF_565:
      mask = mask | (mask << 16);
      break;
   }

   if (mgaDB->Setup[MGA_SETUP_PLNWT] != mask) {
      mgaDB->Setup[MGA_SETUP_PLNWT] = mask;      
      MGA_CONTEXT(ctx)->new_state |= MGA_NEW_MASK; 
      mgaCtx->reg_dirty |= (1<<MGA_SETUP_PLNWT);
   }

   return 1;
}



/* =============================================================
 */

static void mgaDDEnable(GLcontext *ctx, GLenum cap, GLboolean state)
{
   switch(cap) {
   case GL_ALPHA_TEST:
      MGA_CONTEXT(ctx)->new_state |= MGA_NEW_ALPHA;
      break;
   case GL_BLEND:
      MGA_CONTEXT(ctx)->new_state |= MGA_NEW_ALPHA;
      break;
   case GL_DEPTH_TEST:
      MGA_CONTEXT(ctx)->new_state |= MGA_NEW_DEPTH;
      break;
   case GL_SCISSOR_TEST:
      MGA_CONTEXT(ctx)->new_state |= MGA_NEW_CLIP;
      break;
   case GL_FOG:
      MGA_CONTEXT(ctx)->new_state |= MGA_NEW_FOG;
      break;
   case GL_CULL_FACE:
      MGA_CONTEXT(ctx)->new_state |= MGA_NEW_CULL;
      break;
   case GL_TEXTURE_2D:
      MGA_CONTEXT(ctx)->new_state |= MGA_NEW_TEXTURE;
      break;
   default:
      ; 
   }    
}


/* Don't use the regs parm yet.
 * This is called directly on dma buffer overflow, which
 * can't tolerate recursive entry into texture uploading.
 */
void mgaUpdateRegs( GLuint regs ) 
{
   DMALOCALS;
      
   MGADMAGETPTR( 24 ); 

   DMAOUTREG( MGAREG_PITCH, mgaDB->Setup[MGA_SETUP_PITCH] );
   DMAOUTREG( MGAREG_CXBNDRY, mgaDB->Setup[MGA_SETUP_CXBNDRY] );
   DMAOUTREG( MGAREG_YTOP, mgaDB->Setup[MGA_SETUP_YTOP] );
   DMAOUTREG( MGAREG_YBOT, mgaDB->Setup[MGA_SETUP_YBOT] );
   DMAOUTREG( MGAREG_DSTORG, mgaDB->Setup[MGA_SETUP_DSTORG] );
   DMAOUTREG( MGAREG_MACCESS, mgaDB->Setup[MGA_SETUP_MACCESS] );
   DMAOUTREG( MGAREG_PLNWT, mgaDB->Setup[MGA_SETUP_PLNWT] );
   DMAOUTREG( MGAREG_ZORG, mgaDB->Setup[MGA_SETUP_ZORG] );
   DMAOUTREG( MGAREG_DWGCTL, mgaCtx->regDWGCTL );
   DMAOUTREG( MGAREG_ALPHACTRL, mgaCtx->regALPHACTRL );
   DMAOUTREG( MGAREG_FOGCOL, mgaCtx->regFOGCOLOR );
   DMAOUTREG( MGAREG_WFLAG, mgaCtx->regWFLAG );

   if (MGA_IS_G400(MGAchipset)) { 
      DMAOUTREG( MGAREG_WFLAG1, mgaCtx->regWFLAG );
      DMAOUTREG( MGAREG_TDUALSTAGE0, mgaCtx->regTDUAL[0] );
      DMAOUTREG( MGAREG_TDUALSTAGE1, mgaCtx->regTDUAL[1] );      
   }

   DMAADVANCE();
}


/* =============================================================
 */

static void mgaDDPrintState( const char *msg, GLuint state )
{
   mgaMsg(1, "%s (0x%x): %s%s%s%s%s%s%s%s\n",
	   msg,
	   state,
	   (state & MGA_NEW_DEPTH)   ? "depth, " : "",
	   (state & MGA_NEW_ALPHA)   ? "alpha, " : "",
	   (state & MGA_NEW_FOG)     ? "fog, " : "",
	   (state & MGA_NEW_CLIP)    ? "clip, " : "",
	   (state & MGA_NEW_MASK)    ? "colormask, " : "",
	   (state & MGA_NEW_CULL)    ? "cull, " : "",
	   (state & MGA_NEW_TEXTURE) ? "texture, " : "",
	   (state & MGA_NEW_CONTEXT) ? "context, " : "");
}

void mgaDDUpdateHwState( GLcontext *ctx )
{
   int new_state = MGA_CONTEXT(ctx)->new_state;

   if (new_state) 
   {
      mgaMsg( 15, "mgaDDUpdateHwState\n" );
      
      MGA_CONTEXT(ctx)->new_state = 0;
      mgaWarpFinishSerie();

      if (MESA_VERBOSE&VERBOSE_DRIVER)
	 mgaDDPrintState("UpdateHwState", new_state);

      if (new_state & MGA_NEW_DEPTH)
      {
        mgaUpdateZMode(ctx);
	mgaDDInitDepthFuncs(ctx);
      }

      if (new_state & MGA_NEW_ALPHA)
        mgaUpdateAlphaMode(ctx);

      if (new_state & MGA_NEW_FOG)
        mgaUpdateFogAttrib(ctx);

      if (new_state & MGA_NEW_CLIP)
        mgaUpdateClipping(ctx);

      if (new_state & (MGA_NEW_WARP|MGA_NEW_CULL))
	 mgaUpdateCull(ctx);

      if (new_state & (MGA_NEW_WARP|MGA_NEW_TEXTURE))
	  mgaUpdateTextureState(ctx);

      if (new_state & MGA_NEW_CONTEXT)
	 MGA_CONTEXT(ctx)->reg_dirty = ~0;

      if (MGA_CONTEXT(ctx)->reg_dirty)
	 mgaUpdateRegs( MGA_CONTEXT(ctx)->reg_dirty );
      
      mgaglx.warp_serieStart = mgaAllocSecondaryBuffer(0);
   }
}



void mgaDDInitStatePointers(GLcontext *ctx)
{
   ctx->Driver.Enable = mgaDDEnable;
   ctx->Driver.LightModelfv = mgaDDLightModelfv;
   ctx->Driver.AlphaFunc = mgaDDAlphaFunc;
   ctx->Driver.BlendEquation = mgaDDBlendEquation;
   ctx->Driver.BlendFunc = mgaDDBlendFunc;
   ctx->Driver.BlendFuncSeparate = mgaDDBlendFuncSeparate;
   ctx->Driver.DepthFunc = mgaDDDepthFunc;
   ctx->Driver.DepthMask = mgaDDDepthMask;
   ctx->Driver.Fogfv = mgaDDFogfv;
   ctx->Driver.Scissor = mgaDDScissor;
   ctx->Driver.CullFace = mgaDDCullFace;
   ctx->Driver.FrontFace = mgaDDFrontFace;
   ctx->Driver.ShadeModel = mgaDDShadeModel;
   ctx->Driver.ColorMask = mgaDDColorMask;
   ctx->Driver.ReducedPrimitiveChange = mgaDDReducedPrimitiveChange;
   ctx->Driver.RenderStart = mgaDDUpdateHwState; 
   ctx->Driver.RenderFinish = 0; 
}



void mgaDDReducedPrimitiveChange( GLcontext *ctx, GLenum prim )
{
   mgaWarpFinishSerie();
   mgaUpdateCull(ctx);
   mgaUpdateRegs( MGA_CONTEXT(ctx)->reg_dirty );
   mgaglx.warp_serieStart = mgaAllocSecondaryBuffer(0);
}


#define INTERESTED (~(NEW_MODELVIEW|NEW_PROJECTION|\
                      NEW_TEXTURE_MATRIX|\
                      NEW_USER_CLIP|NEW_CLIENT_STATE|\
                      NEW_TEXTURE_ENABLE))

void mgaDDUpdateState( GLcontext *ctx )
{
   mgaglx.c_setupPointers++;


   /* Find a better way to do this.
    */
   if ( !mgaCanUseHardware(ctx) ) {
      return;
   }

   /* Include mgaUpdateTextureState here temporarily until John's
    * rework of mgatex.c is done.
    */
   if (ctx->NewState & INTERESTED) {
      mgaDDChooseRenderState(ctx);  
      mgaChooseRasterSetupFunc(ctx);
      mgaWarpUpdateState(ctx);
   }
   
   /* TODO: stop mesa from clobbering these.
    */
   ctx->Driver.PointsFunc=mgaCtx->PointsFunc;
   ctx->Driver.LineFunc=mgaCtx->LineFunc;
   ctx->Driver.TriangleFunc=mgaCtx->TriangleFunc;
   ctx->Driver.QuadFunc=mgaCtx->QuadFunc;
}
