#include <stdio.h>
#include "mgadd.h"
#include "mgavb.h"
#include "mgadma.h"
#include "mgalib.h"
#include "mgatris.h"
#include "mgastate.h"
#include "xsmesaP.h"
#include "enums.h"

#define POINT(x) mga_draw_point(&gWin[x], psize)

#if 1
#define LINE(x,y) mga_draw_line(&gWin[x], &gWin[y], lwidth)
#define TRI(x,y,z) mga_draw_triangle(&gWin[x], &gWin[y], &gWin[z])
#else
#define LINE(x,y) ctx->Driver.LineFunc( ctx, x, y, x )
#define TRI(x,y,z) ctx->TriangleFunc( ctx, x, y, z, x )
#endif

/* Direct, and no clipping required.  I haven't written the clip funcs
 * yet, so this is only useful for the fast path, which does its own
 * clipping.
 */
#define RENDER_POINTS( start, count )		\
do {						\
   GLuint e;					\
   for(e=start;e<=count;e++)			\
     POINT(elt[e]);				\
} while (0)

#define RENDER_LINE( i1, i )			\
do {						\
   GLuint e1 = elt[i1], e = elt[i];		\
   LINE( e1, e );				\
} while (0)


#define RENDER_TRI( i2, i1, i, pv, parity)		\
do {							\
{  GLuint e2 = elt[i2], e1 = elt[i1], e = elt[i];	\
  if (parity) {GLuint tmp = e2; e2 = e1; e1 = tmp;}	\
  TRI(e2, e1, e);					\
}} while (0)


#define RENDER_QUAD( i3, i2, i1, i, pv)				\
do {								\
  GLuint e3 = elt[i3], e2 = elt[i2], e1 = elt[i1], e = elt[i];	\
  TRI(e3, e2, e);						\
  TRI(e2, e1, e);						\
} while (0)

#define LOCAL_VARS					\
   mgaVertexPtr gWin = MGA_DRIVER_DATA(VB)->verts;	\
   const GLuint *elt = VB->EltPtr->data;		\
   const GLfloat lwidth = VB->ctx->Line.Width;		\
   const GLfloat psize = VB->ctx->Point.Size;		\
   GLcontext *ctx = VB->ctx; \
   (void) lwidth; (void)psize; (void)ctx; (void) gWin;


#define TAG(x) x##_mga_smooth_indirect
#include "render_tmp.h"




#define RENDER_POINTS( start, count )		\
do {						\
   GLuint e;					\
   for(e=start;e<=count;e++)			\
     POINT(e);					\
} while (0)

#define RENDER_LINE( i1, i )			\
do {						\
   LINE( i1, i );				\
} while (0)


#define RENDER_TRI( i2, i1, i, pv, parity)		\
do {							\
  GLuint e2 = i2, e1 = i1;				\
  if (parity) {GLuint tmp = e2; e2 = e1; e1 = tmp;}	\
  TRI(e2, e1, i);					\
} while (0)


#define RENDER_QUAD( i3, i2, i1, i, pv)		\
do {						\
  TRI(i3, i2, i);				\
  TRI(i2, i1, i);				\
} while (0)

#define LOCAL_VARS					\
   mgaVertexPtr gWin = MGA_DRIVER_DATA(VB)->verts;	\
   const GLfloat lwidth = VB->ctx->Line.Width;		\
   const GLfloat psize = VB->ctx->Point.Size;		\
   GLcontext *ctx = VB->ctx; \
   (void) lwidth; (void)psize; (void)ctx; (void) gWin;

#define TAG(x) x##_mga_smooth_direct
#include "render_tmp.h"



/* Currently only used on the fast path - need a set of render funcs
 * for clipped primitives.
 */
void mgaDDRenderElementsDirect( struct vertex_buffer *VB )
{
   GLcontext *ctx = VB->ctx;
   GLenum prim = ctx->CVA.elt_mode;
   GLuint nr = VB->EltPtr->count;
   render_func func = render_tab_mga_smooth_indirect[prim];
   GLuint p = 0;
   
   struct vertex_buffer *saved_vb = ctx->VB;

   if (mgaCtx->new_state)
      mgaDDUpdateHwState( ctx );

   ctx->VB = VB;

   do {
      func( VB, 0, nr, 0 );
   } while (ctx->Driver.MultipassFunc &&
	    ctx->Driver.MultipassFunc( VB, ++p ));

   ctx->VB = saved_vb;
}


void mgaDDRenderElementsImmediate( struct vertex_buffer *VB )
{
   GLcontext *ctx = VB->ctx;
   GLuint nr = VB->EltPtr->count;
   render_func *tab = render_tab_mga_smooth_indirect;
   GLuint parity = VB->Parity;
   GLuint p = 0;
   GLuint i, next;

   if (mgaCtx->new_state)
      mgaDDUpdateHwState( ctx );

   do {
      for ( i= VB->CopyStart ; i < nr ; parity = 0, i = next ) 
      {
	 GLenum prim = VB->Primitive[i];
	 next = VB->NextPrimitive[i];
	 tab[prim]( VB, i, next, parity );
      }
   } while (ctx->Driver.MultipassFunc &&
	    ctx->Driver.MultipassFunc( VB, ++p ));
}


void mgaDDRenderDirect( struct vertex_buffer *VB )
{
   GLcontext *ctx = VB->ctx;
   GLuint nr = VB->Count;
   render_func *tab = render_tab_mga_smooth_direct;
   GLuint parity = VB->Parity;
   GLuint p = 0;
   GLuint i, next;

   if (mgaCtx->new_state)
      mgaDDUpdateHwState( ctx );

   do {
      for ( i= VB->CopyStart ; i < nr ; parity = 0, i = next ) 
      {
	 GLenum prim = VB->Primitive[i];
	 next = VB->NextPrimitive[i];
	 tab[prim]( VB, i, next, parity );
      }
   } while (ctx->Driver.MultipassFunc &&
	    ctx->Driver.MultipassFunc( VB, ++p ));
}



void mgaDDRenderInit()
{
   render_init_mga_smooth_indirect();
   render_init_mga_smooth_direct();
}


