/*
 * Experimental code - disabled by default.
 *
 * (see mga_setup_DD_pointers)
 * 
 */


#include "xsmesaP.h"
#include "mesaglx/types.h"
#include "mgalog.h"
#include "mgastate.h"
#include "mm.h"
#include "g200_mac.h"
#include "mgalib.h"
#include "mgaglx.h"


GLboolean mgaDDDrawPixels(GLcontext *ctx,
                            GLint x, GLint y, GLsizei width, GLsizei height,
                            GLenum format, GLenum type,
                            const struct gl_pixelstore_attrib *unpack,
                            const GLvoid *pixels )
{
  	mgaMsg(11, "mgaDDDrawPixels %d/%d %d/%d\n", x,y, width, height);
  	/* 
	 * nothing done yet 
	 */
	return GL_FALSE; 
}


/* copy one row and shift it "xofs" bits */
static void bitmove(mgaUI8 *dst, mgaUI8 *src, int srcwidth, int xofs)
{
  mgaUI32 data,carry;
  
  if (!xofs) {
    memcpy(dst, src, srcwidth);
    return;
  }
  
  while (xofs>7) 
  {
    dst++;
    xofs -=8;
  }
  
  carry = 0;
  while (srcwidth)
  {
    data = *(src++);
    data = ((data << 8) >> xofs) | (carry << 8);
    carry = (data & 0xff);
    data = data >> 8;  	
    *(dst++) = data;
    srcwidth--;
  }
  *dst = carry;
}


/* 
 * A lot of FIXMEs:
 *   - Check the "unpack" attribs...
 *   - Check bitmap size /dma size
 *   - Textured bitmaps(?)
 *   - Clipping
 */
GLboolean mgaDDBitmap ( GLcontext *ctx,
                        GLint x, GLint y, GLsizei width, GLsizei height,
                        const struct gl_pixelstore_attrib *unpack,
                        const GLubyte *bitmap )
{
	int		x2, xofs, srcwidth, h, ow;
	int		dwords;
        mgaUI32		*dest;
        int		cmd;
  	GLubyte 	*d2, *srcp;
 	DMALOCALS;
  
    	mgaMsg(11, "mgaDDBitmap %d/%d %d/%d\n", x,y, width, height);
    	mgaDDUpdateHwState(ctx); /* make sure dstorg is ok */
	
  	srcwidth = (width + 7)/8; /* in byte not pixels */
  	ow = width;
	x2 = x + width;
  	xofs = x & 31;
	x = x & ~31;
  	y = mgaDB->Height - y - height; 
	width = (x2 - x +31) & ~31;
  
  	/* Cases we don't handle: */
  	if (!mgaDB || !bitmap ||
	    (height<1) || !srcwidth ||
	    (x < 0) ||  (x+ow >= mgaDB->Width) ||
	    (y<0) || (y+height>mgaDB->Height)
	    )
    		return GL_FALSE;
  
	srcp = bitmap + (height-1)*srcwidth; 
    	dwords = (width >> 5) * height;

	mgaMsg(11, " => %d/%d %d/%d\n", x, y, width, height);
	       
  	/* flush any warp verts before we allocate secondary memory */
	mgaWarpFinishSerie();
	/* allocate a secondary dma buffer for the bitmap */
	/* this may cause a flush if it doesn't fit in the current buffer */
	dest = mgaAllocSecondaryBuffer( dwords );
	
	/* start the primary commands */
	/* FIXME: if this MGADMAGETPTR overflows, the secondary buffer will be wrong.
	we need a way to atomically allocate in both primary and secondary */
	MGADMAGETPTR( 20 );

	/* linear destination, linear iload */
	cmd = DC_opcod_iload | 		/* image load */
  	      DC_atype_rpl |		/* raster mode */
	      DC_linear_linear | 	/* linear source */
	      DC_bltmod_bmonowf |	/* bitmap source */
	      (0xC << DC_bop_SHIFT)  | 	/* use source bit op */
 	      DC_sgnzero_enable |	/* scanning direction */
 	      DC_shftzero_enable |	/* required for iload */
    	      DC_transc_enable |	/* background is transparent */
 	      DC_clipdis_enable;	/* don't use the clip rect */
	
	DMAOUTREG( MGAREG_YDST, y );
	MGADMA_LEN( height );	
	MGADMA_FXBNDRY( x, x+width-1 );	

	DMAOUTREG( MGAREG_AR0, width*height - 1);	
	DMAOUTREG( MGAREG_AR3, 0 );			/* required */
	DMAOUTREG( MGAREG_AR3, 0 ); 
  	{
	      GLint r, g, b, a;
	      r = (GLint) (ctx->Current.RasterColor[0] * 255.0F);
	      g = (GLint) (ctx->Current.RasterColor[1] * 255.0F);
	      b = (GLint) (ctx->Current.RasterColor[2] * 255.0F);
	      a = (GLint) (ctx->Current.RasterColor[3] * 255.0F);
	  
	      MGADMA_FCOL(mgaPackColor(r,g,b,a));  
	}
  
	/* pad if needed so the exec is at the end of a register quad */
	MGADMA_DWGCTL_EXEC(cmd);	
		
	DMAADVANCE();
  
        d2 = (GLubyte *) dest;
	memset(d2, 0, dwords*4);
  	for (h = 0; h<height; h++) {
	  bitmove(d2, srcp, srcwidth, xofs);
	  srcp -= srcwidth;
	  d2 += (width >> 5)*4;
	}
	/* send the secondary data */	
	mgaSecondaryDma( TT_BLIT, dest, dwords );

	mgaglx.warp_serieStart = mgaAllocSecondaryBuffer(0);	// FIXME: do this better...

	/* we need to go back to normal drawing setings after the iload */
	mgaCtx->new_state = ~0;
  	return GL_TRUE;
}
