/* $Id: mgalog.h,v 1.5 1999/10/14 05:51:11 giles Exp $ */

/*
 * GLX Hardware Device Driver for Matrox Millenium G200
 * Copyright (C) 1999 Wittawat Yamwong
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *    Wittawat Yamwong <Wittawat.Yamwong@stud.uni-hannover.de>
 */
 
/* Usage:
 * - use mgaError for error messages. Always write to X error and log file.
 * - use mgaMsg for debugging. Can be disabled by undefining MGA_LOG_ENABLED.
 */
 
#ifndef MGALOG_INC
#define MGALOG_INC

#ifndef DBG_MODULE_PREFIX
#define DBG_MODULE_PREFIX "[mga] "
#endif

#ifdef MGA_LOG_ENABLED

#include <stdarg.h>
#include "mgalib.h"

#define DBG_LEVEL_BASE		1
#define DBG_LEVEL_VERBOSE	10
#define DBG_LEVEL_ENTEREXIT	20

/* open and close log file. */
int  mgaOpenLog(const char *filename);
void mgaCloseLog();

/* return 1 if log file is succesfully opened */
int  mgaIsLogReady();

/* set current log level to 'level'. Messages with level less than or equal
   the current log level will be written to the log file. */
void mgaSetLogLevel(int level);
int  mgaGetLogLevel();

/* mgaLog and mgaLogv write a message to the log file.	*/
/* do not call these directly, use mgaMsg() instead	*/
void mgaLog(int level, const char *format, ...);
void mgaLogv(int level, const char *format, va_list ap);


/* mgaMsg writes a message to the log file or to the standard X error file. */
#define mgaMsg(level,format, args...) if ( level <= mgaglx.logLevel ) {	\
  if (mgaIsLogReady()) {			\
  	int __t=usec();mgaLog(level,"%6i:",__t-mgaglx.timeTemp);mgaglx.timeTemp=__t; \
    mgaLog(level,format, ## args);		\
  } else {					\
    if (level <= mgaGetLogLevel()) {		\
      ErrorF(DBG_MODULE_PREFIX);		\
      ErrorF(format, ## args);			\
    } 						\
  }			\
}

#define mgaError(format, args...) do {		\
  ErrorF(DBG_MODULE_PREFIX);			\
  ErrorF(format, ## args);			\
  mgaLog(0,format, ## args);			\
} while(0)

#else

static __inline__ int mgaOpenLog(const char *f) { return -1; }
static __inline__ int mgaIsLogReady() { return 0; }
static __inline__ int mgaGetLogLevel() { return -1; }
static __inline__ int mgaLogLevel(int level) { return 0; }

#define mgaCloseLog()
#define mgaSetLogLevel(x)
#define mgaLog(l,f,a...)
#define mgaLogv(l,f,a)
#define mgaMsg(l,f,a...)

#define mgaError(format, args...) do {		\
  ErrorF(DBG_MODULE_PREFIX);			\
  ErrorF(format, ## args);			\
} while(0)

#endif

#endif
