/* $Id: mgalog.c,v 1.3 1999/09/13 06:00:47 giles Exp $ */

/*
 * GLX Hardware Device Driver for Matrox Millenium G200
 * Copyright (C) 1999 Wittawat Yamwong
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *    Wittawat Yamwong <Wittawat.Yamwong@stud.uni-hannover.de>
 */
 
#include "mgalib.h"
#include "mgalog.h"

#ifdef MGA_LOG_ENABLED

int mgaOpenLog(const char *filename)
{
  mgaCloseLog();
  if (!filename)
    return -1;
  if ((mgaglx.logFile = fopen(filename,"w")) == NULL)
      return -1;
  mgaSetLogLevel(0);
  return 0;
}

void mgaCloseLog()
{
  if (mgaglx.logFile) {
    fclose(mgaglx.logFile);
    mgaglx.logFile = NULL;
  }
}

int mgaIsLogReady()
{
  return (mgaglx.logFile != NULL);
}

void mgaSetLogLevel(int level)
{
  mgaglx.logLevel = level;
/*    mgaglx.logLevel = 30; */
}

int mgaGetLogLevel()
{
  return mgaglx.logLevel;
}

void mgaLog(int level, const char *format, ...)
{
  va_list ap;
  va_start(ap,format);
  mgaLogv(level,format,ap);
  va_end(ap);
}

void mgaLogv(int l, const char *format, va_list ap)
{
  if (mgaglx.logFile && (l <= mgaglx.logLevel)) {
    vfprintf(mgaglx.logFile,format,ap);
    fflush(mgaglx.logFile);
  }
}

#else /* ifdef MGA_LOG_ENABLED */

int mgalogdummy()
{
  return 0;
}

#endif
