/*
 * GLX Hardware Device Driver for Matrox Millenium G200
 * Copyright (C) 1999 Wittawat Yamwong
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *    Wittawat Yamwong <Wittawat.Yamwong@stud.uni-hannover.de>
 */

/* $Id: g200_mac.h,v 1.3 1999/11/27 18:33:42 stephenc Exp $ */

#ifndef G200_MAC_INC
#define G200_MAC_INC

#include "vga.h"
#include "vgaPCI.h"

#include "mga.h"
#include "mga_macros.h"
#include "xf86_OSproc.h"

#include "g200_reg.h"

#define MGA_SET_FIELD(reg,mask,val)  reg = ((reg) & (mask)) | ((val) & ~(mask))
#define MGA_FIELD(field,val) (((val) << (field ## _SHIFT)) & ~(field ## _MASK))
#define MGA_GET_FIELD(field, val) ((val & ~(field ## _MASK)) >> (field ## _SHIFT))

#define mgaF1800(x) (((mgaI32) (x)) & 0x0003ffff)
#define mgaF1715(x) ((mgaI32) ((x) * (1 << 15)))
#define mgaF0915(x) (((mgaI32) ((x) * (1 << 15))) & 0x00ffffff)
#define mgaF2400(x) (((mgaI32) (x)) & 0x00ffffff)
#define mgaF2200(x) (((mgaI32) (x)) & 0x003fffff)
#define mgaF3315(x,msb,lsb)				\
     msb = ((mgaUI32) (x)) >> 17;			\
     lsb = (mgaUI32)((x) - (msb << 17)) * (1 << 15));
#define mgaF1220(x) ((mgaI32)((x) * (1 << 20)))
#define mgaF1616(x) ((mgaI32)((x) * (1 << 16)))

/* Global initialization */

#define MGADMA_PITCH(x)			DMAOUTREG(MGAREG_PITCH,x)
#define MGADMA_DSTORG(x)		DMAOUTREG(MGAREG_DSTORG,x)
#define MGADMA_SRCORG(x)		DMAOUTREG(MGAREG_SRCORG,x)
#define MGADMA_MACCESS(x)		DMAOUTREG(MGAREG_MACCESS,x)
#define MGADMA_CXBNDRY(x)		DMAOUTREG(MGAREG_CXBNDRY,x)
#define MGADMA_YTOP(x)			DMAOUTREG(MGAREG_YTOP,x)
#define MGADMA_YBOT(x)			DMAOUTREG(MGAREG_YBOT,x)
#define MGADMA_PLNWT(x)			DMAOUTREG(MGAREG_PLNWT,x)
#define MGADMA_ZORG(x)			DMAOUTREG(MGAREG_ZORG,x)
#define MGADMA_DWGCTL(x)		DMAOUTREG(MGAREG_DWGCTL,x)
#define MGADMA_DWGCTL_EXEC(x)		DMAOUTREG(MGAREG_DWGCTL+MGAREG_MGA_EXEC,x)

#define MGADMA_FCOL(x)			DMAOUTREG(MGAREG_FCOL,x)
#define MGADMA_ALPHACTRL(x)		DMAOUTREG(MGAREG_ALPHACTRL,x)
#define MGADMA_SGN(x)			DMAOUTREG(MGAREG_SGN,x)
#define MGADMA_FXBNDRY(x1,x2)		DMAOUTREG(MGAREG_FXBNDRY,((x2) << 16) | (x1))
#define MGADMA_YDSTLEN(y,LEN)		DMAOUTREG(MGAREG_YDSTLEN,((y) << 16) | (LEN))
#define MGADMA_YDSTLEN_EXEC(y,LEN) 	DMAOUTREG(MGAREG_YDSTLEN+MGAREG_MGA_EXEC, \
                                                  ((y) << 16) | (LEN))
#define MGADMA_LEN(x)			DMAOUTREG(MGAREG_LEN,x)
#define MGADMA_LEN_EXEC(x)		DMAOUTREG(MGAREG_LEN+MGAREG_MGA_EXEC,x)


#define MGADMA_A(start,xinc,yinc) do {		\
    DMAOUTREG(MGAREG_ALPHASTART,start);		\
    DMAOUTREG(MGAREG_ALPHAXINC,xinc);		\
    DMAOUTREG(MGAREG_ALPHAYINC,yinc);		\
  } while(0)
#define MGADMA_R(start,xinc,yinc) do { 		\
    DMAOUTREG(MGAREG_DR4,start);			\
    DMAOUTREG(MGAREG_DR6,xinc);			\
    DMAOUTREG(MGAREG_DR7,yinc);			\
  } while(0)
#define MGADMA_G(start,xinc,yinc) do { 		\
    DMAOUTREG(MGAREG_DR8,start);			\
    DMAOUTREG(MGAREG_DR10,xinc);			\
    DMAOUTREG(MGAREG_DR11,yinc);			\
  } while(0)
#define MGADMA_B(start,xinc,yinc) do {		\
    DMAOUTREG(MGAREG_DR12,start);			\
    DMAOUTREG(MGAREG_DR14,xinc);			\
    DMAOUTREG(MGAREG_DR15,yinc);			\
  } while(0)


#define MGADMA_SPECR(start,xinc,yinc) do { 		\
    DMAOUTREG(MGAREG_SPECRSTART,start);			\
    DMAOUTREG(MGAREG_SPECRXINC,xinc);			\
    DMAOUTREG(MGAREG_SPECRYINC,yinc);			\
  } while(0)
#define MGADMA_SPECG(start,xinc,yinc) do { 		\
    DMAOUTREG(MGAREG_SPECGSTART,start);			\
    DMAOUTREG(MGAREG_SPECGXINC,xinc);			\
    DMAOUTREG(MGAREG_SPECGYINC,yinc);			\
  } while(0)
#define MGADMA_SPECB(start,xinc,yinc) do {		\
    DMAOUTREG(MGAREG_SPECBSTART,start);			\
    DMAOUTREG(MGAREG_SPECBXINC,xinc);			\
    DMAOUTREG(MGAREG_SPECBYINC,yinc);			\
  } while(0)


#define MGADMA_Z16(start,xinc,yinc) do {		\
    DMAOUTREG(MGAREG_DR0,start);			\
    DMAOUTREG(MGAREG_DR2,xinc);			\
    DMAOUTREG(MGAREG_DR3,yinc);			\
  } while(0)


#define MGADMA_FOG(start,xinc,yinc,col) do {		\
    DMAOUTREG(MGAREG_FOGSTART,start);		\
    DMAOUTREG(MGAREG_FOGXINC,xinc);		\
    DMAOUTREG(MGAREG_FOGYINC,yinc);		\
    DMAOUTREG(MGAREG_FOGCOL,col);			\
  } while(0)


#define MGADMA_S(start,xinc,yinc) do {		\
    DMAOUTREG(MGAREG_TMR6,start);			\
    DMAOUTREG(MGAREG_TMR0,xinc);			\
    DMAOUTREG(MGAREG_TMR1,yinc);			\
  } while (0)
#define MGADMA_T(start,xinc,yinc) do {		\
    DMAOUTREG(MGAREG_TMR7,start);			\
    DMAOUTREG(MGAREG_TMR2,xinc);			\
    DMAOUTREG(MGAREG_TMR3,yinc);			\
  } while (0)
#define MGADMA_Q(start,xinc,yinc) do {		\
    DMAOUTREG(MGAREG_TMR8,start);			\
    DMAOUTREG(MGAREG_TMR4,xinc);			\
    DMAOUTREG(MGAREG_TMR5,yinc);			\
  } while (0)


#define MGADMA_LSLOPE(dx,dy,sgn,err) do {			\
    DMAOUTREG(MGAREG_AR0,mgaF1800(dy));			\
    if ((dx) >= 0) {					\
      DMAOUTREG(MGAREG_AR1,mgaF2400(-(dx)+(err)));		\
      DMAOUTREG(MGAREG_AR2,mgaF1800(-(dx)));		\
      MGA_SET_FIELD(sgn,S_sdxl_MASK,S_sdxl_pos);	\
    } else {						\
      DMAOUTREG(MGAREG_AR1,mgaF2400((dx)+(dy)-(err)-1) );	\
      DMAOUTREG(MGAREG_AR2,mgaF1800(dx));			\
      MGA_SET_FIELD(sgn,S_sdxl_MASK,S_sdxl_neg);	\
    }							\
  } while(0)

 
#define MGADMA_G400_LSLOPE(dx,dy,sgn,err) do {                        \
     DMAOUTREG(MGAREG_AR0,mgaF2200(dy));                  \
     if ((dx) >= 0) {                                  \
      DMAOUTREG(MGAREG_AR1,mgaF2400(-(dx)+(err)));               \
      DMAOUTREG(MGAREG_AR2,mgaF2200(-(dx)));             \
      MGA_SET_FIELD(sgn,S_sdxl_MASK,S_sdxl_pos);      \
     } else {                                          \
      DMAOUTREG(MGAREG_AR1,mgaF2400((dx)+(dy)-(err)-1) );        \
      DMAOUTREG(MGAREG_AR2,mgaF2200(dx));                        \
      MGA_SET_FIELD(sgn,S_sdxl_MASK,S_sdxl_neg);      \
   }                                                 \
  } while(0)

#define MGADMA_RSLOPE(dx,dy,sgn,err) do {			\
    DMAOUTREG(MGAREG_AR6,mgaF1800(dy));			\
    if ((dx) >= 0) {					\
      DMAOUTREG(MGAREG_AR4,mgaF1800(-(dx)+(err)));		\
      DMAOUTREG(MGAREG_AR5,mgaF1800(-(dx)));		\
      MGA_SET_FIELD(sgn,S_sdxr_MASK,S_sdxr_pos);	\
    } else {						\
      DMAOUTREG(MGAREG_AR4,mgaF1800((dx)+(dy)-(err)-1));		\
      DMAOUTREG(MGAREG_AR5,mgaF1800(dx));			\
      MGA_SET_FIELD(sgn,S_sdxr_MASK,S_sdxr_neg);	\
    }							\
  } while(0)

#define MGADMA_G400_RSLOPE(dx,dy,sgn,err) do {                     \
     DMAOUTREG(MGAREG_AR6,mgaF2200(dy));                       \
     if ((dx) >= 0) {                                  \
       DMAOUTREG(MGAREG_AR4,mgaF2200(-(dx)+(err)));            \
       DMAOUTREG(MGAREG_AR5,mgaF2200(-(dx)));          \
       MGA_SET_FIELD(sgn,S_sdxr_MASK,S_sdxr_pos);      \
     } else {                                          \
       DMAOUTREG(MGAREG_AR4,mgaF2200((dx)+(dy)-(err)-1));              \
       DMAOUTREG(MGAREG_AR5,mgaF2200(dx));                     \
       MGA_SET_FIELD(sgn,S_sdxr_MASK,S_sdxr_neg);      \
     }                                                 \
   } while(0)

/* Line programming */
#define MGADMA_AUTO_LINE(x1,y1,x2,y2) do {			\
    DMAOUTREG(MGAREG_XYSTRT,(y1 << XYSA_y_start_SHIFT) | 	\
                            (x1 & ~XYSA_x_start_MASK));	\
    DMAOUTREG(MGAREG_XYEND,(y2 << XYEA_y_end_SHIFT) | 	\
                           (x2 & ~XYEA_x_end_MASK));	\
  } while(0)

#endif
