#include "mach64glx.h"


void mach64Triangle( GLcontext *ctx, GLuint e0, GLuint e1, GLuint e2, GLuint pv )
{
	const struct vertex_buffer *VB;
	int		offset;
	int		roff;
	float		ooa;
	int		i, j;
	int		flatShade;
	DMALOCALS;
	
	mach64glx.c_triangles++;

	VB = ctx->VB;

	if ( ctx->TriangleCaps & DD_FLATSHADE ) {
		flatShade = 1;
	} else {
		flatShade = 0;
	}

	/* calculate one-over-area, culling the triangle if needed */ 
{	
	GLfloat *w0 = VB->Win.data[e0];
	GLfloat *w1 = VB->Win.data[e1];
	GLfloat *w2 = VB->Win.data[e2];

	ooa = ( ( w1[0] - w0[0] ) * ( w0[1] - w2[1] ) +
		 ( w1[1] - w0[1] ) * ( w2[0] - w0[0] ) );

	if ( ooa * ctx->backface_sign < 0 ) {
		return;		/* culled */
	}
            
	ooa = 1.0 / ooa;
}
	
	if ( ctx->TriangleCaps & DD_TRI_OFFSET ) {
		offset = ctx->Polygon.OffsetUnits;
	} else {
		offset = 0;
	}
	
	DMAGETPTR(60);

	/* FIXME: projective textures */
	
	for ( j = 0 ; j < 3 ; j++ ) {
		switch( j ) {
		case 0:
			i = e0;
			roff = 0;
			break;
		case 1:
			i = e1;
			roff = MACH64REG_VERTEX_2_S - MACH64REG_VERTEX_1_S;
			break;
		case 2:
			i = e2;
			roff = MACH64REG_VERTEX_3_S - MACH64REG_VERTEX_1_S;
			break;
		}
		
{	// window / depth / homogeneous coordinate
	GLfloat *win = VB->Win.data[i];
	int	x, y;

	// x / y have two bits of integer precision
	x = (int)(win[0] * 4);
	y = ( mach64DB->height << 2 ) - (int)(win[1] * 4);
	DMAOUTREG( MACH64REG_VERTEX_1_X_Y+roff, ( x<<16) | y );
	DMAOUTREG( MACH64REG_VERTEX_1_Z+roff, ((int)win[2] + offset) << 16 );
	DMAOUTFLOAT( MACH64REG_VERTEX_1_W+roff, win[3] );
}

{	// shaded color
	GLubyte *col;
	
	if ( flatShade ) {
		col = &(VB->Color[0]->data[pv][0]);
	} else {
		col = &(VB->Color[0]->data[i][0]);
	}	
	DMAOUTREG( MACH64REG_VERTEX_1_ARGB+roff,
		(col[3]<<24) | (col[0]<<16) | (col[1]<<8) | col[2] );
}

{	// texcoord
	GLfloat (*tc)[4] = VB->TexCoordPtr[0]->data;
	
	DMAOUTFLOAT( MACH64REG_VERTEX_1_S+roff, tc[i][0] );
	DMAOUTFLOAT( MACH64REG_VERTEX_1_T+roff, tc[i][1] );
}

{	// specular / fog factor
	GLubyte *col;
	
	col = &(VB->Spec[0][i][0]);
	DMAOUTREG( MACH64REG_VERTEX_1_SPEC_ARGB+roff,
		(col[3]<<24) | (col[0]<<16) | (col[1]<<8) | col[2] );
}
	
	}
	
	// write one-over-area to kick off the triangle
	DMAOUTFLOAT( MACH64REG_ONE_OVER_AREA_UC, ooa );
	
	DMAADVANCE();
}


