#include "types.h"
#include "i810buf.h"
#include "i810dd.h"
#include "i810lib.h"
#include "i810dma.h"
#include "i810log.h"

static void (*xsmWriteRGBASpan)( const GLcontext *ctx,
				 GLuint n, GLint x, GLint y,
				 CONST GLubyte rgba[][4], 
				 const GLubyte mask[] );
static void (*xsmWriteRGBSpan)( const GLcontext *ctx,
				GLuint n, GLint x, GLint y,
				CONST GLubyte rgb[][3], const GLubyte mask[] );
static void (*xsmWriteMonoRGBASpan)(const GLcontext *ctx, GLuint n, 
				    GLint x, GLint y,const GLubyte mask[] );
static void (*xsmWriteRGBAPixels)(const GLcontext *ctx,
				  GLuint n, const GLint x[], const GLint y[],
				  CONST GLubyte rgba[][4], 
				  const GLubyte mask[] );
static void (*xsmWriteMonoRGBAPixels)(const GLcontext *ctx,GLuint n, 
				      const GLint x[], const GLint y[],
				      const GLubyte mask[] );
static void (*xsmReadRGBASpan)(const GLcontext *ctx, GLuint n, 
			       GLint x, GLint y,GLubyte rgba[][4] );
static void (*xsmReadRGBAPixels)(const GLcontext *ctx,GLuint n, 
				 const GLint x[], const GLint y[],
				 GLubyte rgba[][4], const GLubyte mask[] );

/* Wrapper functions */

static void WriteRGBASpan( const GLcontext *ctx,
			   GLuint n, GLint x, GLint y,
			   CONST GLubyte rgba[][4], 
			   const GLubyte mask[] )
{
  i810Msg(12,__FUNCTION__ "\n"); 
  i810WaitDrawingEngine();
  (*xsmWriteRGBASpan)(ctx,n,x,y,rgba,mask);
}

static void WriteRGBSpan( const GLcontext *ctx,
			  GLuint n, GLint x, GLint y,
			  CONST GLubyte rgb[][3], const GLubyte mask[] )
{
  i810Msg(12,__FUNCTION__ "\n");
  i810WaitDrawingEngine();
  (*xsmWriteRGBSpan)(ctx,n,x,y,rgb,mask);
}

static void WriteMonoRGBASpan(const GLcontext *ctx, GLuint n, 
			      GLint x, GLint y,const GLubyte mask[] )
{
  i810Msg(12,__FUNCTION__ "\n");
  i810WaitDrawingEngine();
  (*xsmWriteMonoRGBASpan)(ctx,n,x,y,mask);
}

static void WriteRGBAPixels(const GLcontext *ctx,
			    GLuint n, const GLint x[], const GLint y[],
			    CONST GLubyte rgba[][4], 
			    const GLubyte mask[] )
{
  i810Msg(12,__FUNCTION__ "\n");
  i810WaitDrawingEngine();
  (*xsmWriteRGBAPixels)(ctx,n,x,y,rgba,mask);
}

static void WriteMonoRGBAPixels(const GLcontext *ctx,GLuint n, 
				const GLint x[], const GLint y[],
				const GLubyte mask[] )
{
  i810Msg(12,__FUNCTION__ "\n");
  i810WaitDrawingEngine();
  (*xsmWriteMonoRGBAPixels)(ctx,n,x,y,mask);
}

static void ReadRGBASpan(const GLcontext *ctx, GLuint n, 
			 GLint x, GLint y,GLubyte rgba[][4] )
{
  i810Msg(12,__FUNCTION__ "\n");
  i810WaitDrawingEngine();
  (*xsmReadRGBASpan)(ctx,n,x,y,rgba);
}

static void ReadRGBAPixels(const GLcontext *ctx,GLuint n, 
			   const GLint x[], const GLint y[],
			   GLubyte rgba[][4], const GLubyte mask[] )
{
  i810Msg(12,__FUNCTION__ "\n");
  i810WaitDrawingEngine();
  (*xsmReadRGBAPixels)(ctx,n,x,y,rgba,mask);
}

#define WRAP(x) 				\
    xsm ## x = ctx->Driver.x;			\
    ctx->Driver.x = x

void i810DDInitSpans( GLcontext *ctx )
{
   /* Need another hook from mesa to synchronize hardware before
    * write-pixels and read-spans/pixels.
    */ 
   WRAP(WriteRGBASpan);
   WRAP(WriteRGBSpan);
   WRAP(WriteMonoRGBASpan);
   WRAP(WriteRGBAPixels);
   WRAP(WriteMonoRGBAPixels);
   WRAP(ReadRGBASpan);
   WRAP(ReadRGBAPixels);
}
