

#include "xsmesaP.h"
#include "mesaglx/types.h"
#include "vbrender.h"
#include "glx_log.h"

#include "vga.h"
#include "vgaPCI.h"

#include <stdio.h>
#include <stdlib.h>

#include "mm.h"
#include "i810lib.h"
#include "i810dd.h"
#include "i810glx.h"
#include "i810clear.h"
#include "i810state.h"
#include "i810tris.h"



/*
 * i810Clear
 * perform hardware accelerated clearing of the color and/or depth
 * buffer.  Software may still clear stencil buffers.
 * If all==GL_TRUE, clear whole buffer, else just clear region defined
 * by x,y,width,height
 */
#define I810_CLEAR_COLOR 1
#define I810_CLEAR_Z     2
#define I810_CLEAR_ALL   I810_CLEAR_COLOR|I810_CLEAR_Z


GLbitfield i810Clear( GLcontext *ctx, GLbitfield mask, GLboolean all,
		     GLint x, GLint y, GLint width, GLint height ) 
{
   XSMesaContext xsmesa = (XSMesaContext) ctx->DriverCtx;
   GLubyte	*c;
   GLuint	zval;

   i810Msg(10, "i810Clear( %i, %i, %i, %i, %i )\n",
	   mask, x, y, width, height );
	
   CHECK_CONTEXT( return mask; );

   if (all == GL_TRUE) {
      x = 0;
      y = 0;
      width = i810DB->Width;
      height = i810DB->Height;
   }

   if ( y + height > i810DB->Height ) {
      height = i810DB->Height - y;
   }
   if ( x + width > i810DB->Width ) {
      width = i810DB->Width - x;
   }
   if ( x < 0 ) {
      width += x;
      x = 0;
   }
   if ( y < 0 ) {
      height += y;
      y = 0;
   }
   if ( x >= i810DB->Width || y >= i810DB->Height || width < 1 || height < 1 ) {
      return 0;
   }

   /* flip top to bottom */
   y = i810DB->Height-y-height;
   c = xsmesa->clearcolor;
   zval = (GLuint) (ctx->Depth.Clear * DEPTH_SCALE);

   i810FinishPrimitive();

   if (1)
   {
      BEGIN_BATCH(2);   
      OUT_BATCH( INST_PARSER_CLIENT | INST_OP_FLUSH );
      OUT_BATCH( 0 );		/* pad to quadword */
      ADVANCE_BATCH();      
   }

   /* color buffer */
   if (mask & GL_COLOR_BUFFER_BIT) 
   {
      int start = (i810DB->MemBlock->ofs +  
		   y * i810DB->Pitch + 
		   x * vgaBytesPerPixel);

      BEGIN_BATCH(6);
   
      OUT_BATCH( BR00_BITBLT_CLIENT | BR00_OP_COLOR_BLT | 0x3 );
      OUT_BATCH( BR13_SOLID_PATTERN | 
		 (0xF0 << 16) |
		 i810DB->Pitch );
      OUT_BATCH( (height << 16) | (width * vgaBytesPerPixel));
      OUT_BATCH( start );
      OUT_BATCH( i810PackColor( c[0], c[1], c[2], c[3] ) );
      OUT_BATCH( 0 );

      ADVANCE_BATCH();
      
      mask &= ~GL_COLOR_BUFFER_BIT;
   }

   /* depth buffer */
   if ( (mask & GL_DEPTH_BUFFER_BIT) && 
	i810DB->ZBuffer && 
	ctx->Depth.Mask ) 
   {
      int start = (i810DB->ZBuffer->MemBlock->ofs + 
		   y * i810DB->ZBuffer->Pitch + 
		   x * 2);

      BEGIN_BATCH(6);
   
      OUT_BATCH( BR00_BITBLT_CLIENT | BR00_OP_COLOR_BLT | 0x3 );
      OUT_BATCH( BR13_SOLID_PATTERN | 
		 (0xF0 << 16) |
		 i810DB->ZBuffer->Pitch );
      OUT_BATCH( (height << 16) | (width * 2));
      OUT_BATCH( start );
      OUT_BATCH( zval );
      OUT_BATCH( 0 );

      ADVANCE_BATCH();   

      mask &= ~GL_DEPTH_BUFFER_BIT;
   }

   if (1)
   {
      BEGIN_BATCH(2);   
      OUT_BATCH( INST_PARSER_CLIENT | INST_OP_FLUSH );
      OUT_BATCH( 0 );		/* pad to quadword */
      ADVANCE_BATCH();      
   }

   return mask;
}


