

#
# GLX Server Extension
# Copyright (C) 1996  Steven G. Parker  (sparker@cs.utah.edu)
# Copyright (C) 1998, 1999  Terence Ripperda (ripperda@sgi.com)
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# STEVEN PARKER, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR 
# ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
# AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#



set GLcalls {
    {CallList 1 {
	{uint list}
}   }
    {CallLists 2 {
	{int n}
	{enum type}
	{void* lists GLX_list_size(n,type)}
	{void* unused GLX_list_pad(n,type)}
    }
    swap_decode {
        GLX_swap_array(type, GLX_list_size(n,type), (void *)lists);
	glCallLists(n, type, lists);
    }
    decode {
	glCallLists(n, type, lists);
    }
    encode_nogen true
}
    {ListBase 3 {
	{uint base}
}   }
    {Begin 4 {
	{enum mode}
}   }
    {Bitmap 5 {
	{boolean unused1}
	{boolean lsb_first}
	{byte unused2 2}
	{uint row_length}
	{uint skip_rows}
	{uint skip_pixels}
	{uint alignment}
	{int width}
	{int height}
	{float xorig}
	{float yorig}
	{float xmove}
	{float ymove}
	{ubyte pixels GLX_image_size(width,height,GL_COLOR_INDEX,GL_BITMAP)}
	{ubyte unused3 GLX_image_pad(width,height,GL_COLOR_INDEX,GL_BITMAP)}
    }
    decode {
	glPixelStorei(GL_UNPACK_LSB_FIRST, lsb_first);
	glPixelStorei(GL_UNPACK_ROW_LENGTH, row_length);
	glPixelStorei(GL_UNPACK_SKIP_PIXELS, skip_pixels);
	glPixelStorei(GL_UNPACK_SKIP_ROWS, skip_rows);
	glPixelStorei(GL_UNPACK_ALIGNMENT, alignment);
	glBitmap(width, height, xorig, yorig, xmove, ymove, pixels);
    }
    encode_nogen true
}
    {Color3bv 6 {
	{byte c 3}
	{byte unused}
}   }
    {Color3b 6 {
	{byte r}
	{byte g}
	{byte b}
	{byte unused}
}   }
    {Color3dv 7 {
	{double c 3}
}   }
    {Color3d 7 {
	{double r}
	{double g}
	{double b}
}   }
    {Color3fv 8 {
	{float c 3}
}   }
    {Color3f 8 {
	{float r}
	{float g}
	{float b}
}   }
    {Color3iv 9 {
	{int c 3}
}   }
    {Color3i 9 {
	{int r}
	{int g}
	{int b}
}   }
    {Color3sv 10 {
	{short c 3}
	{short unused}
}   }
    {Color3s 10 {
	{short r}
	{short g}
	{short b}
	{short unused}
}   }
    {Color3ubv 11 {
	{ubyte c 3}
	{ubyte unused}
}   }
    {Color3ub 11 {
	{ubyte r}
	{ubyte g}
	{ubyte b}
	{ubyte unused}
}   }
    {Color3uiv 12 {
	{uint c 3}
}   }
    {Color3ui 12 {
	{uint r}
	{uint g}
	{uint b}
}   }
    {Color3usv 13 {
	{ushort c 3}
	{ushort unused}
}   }
    {Color3us 13 {
	{ushort r}
	{ushort g}
	{ushort b}
	{ushort unused}
}   }
    {Color4bv 14 {
	{byte c 4}
}   }
    {Color4b 14 {
	{byte r}
	{byte g}
	{byte b}
	{byte a}
}   }
    {Color4dv 15 {
	{double c 4}
}   }
    {Color4d 15 {
	{double r}
	{double g}
	{double b}
	{double a}
}   }
    {Color4fv 16 {
	{float c 4}
}   }
    {Color4f 16 {
	{float r}
	{float g}
	{float b}
	{float a}
}   }
    {Color4iv 17 {
	{int c 4}
}   }
    {Color4i 17 {
	{int r}
	{int g}
	{int b}
	{int a}
}   }
    {Color4sv 18 {
	{short c 4}
}   }
    {Color4s 18 {
	{short r}
	{short g}
	{short b}
	{short a}
}   }
    {Color4ubv 19 {
	{ubyte c 4}
}   }
    {Color4ub 19 {
	{ubyte r}
	{ubyte g}
	{ubyte b}
	{ubyte a}
}   }
    {Color4uiv 20 {
	{uint c 4}
}   }
    {Color4ui 20 {
	{uint r}
	{uint g}
	{uint b}
	{uint a}
}   }
    {Color4usv 21 {
	{ushort c 4}
}   }
    {Color4us 21 {
	{ushort r}
	{ushort g}
	{ushort b}
	{ushort a}
}   }
    {EdgeFlagv 22 {
	{boolean flag 1}
	{byte unused 3}
}   }
    {EdgeFlag 22 {
	{boolean flag}
	{byte unused 3}
}   }
    {End 23 {
}   }
    {Indexdv 24 {
	{double c 1}
}   }
    {Indexd 24 {
	{double c}
}   }
    {Indexfv 25 {
	{float c 1}
}   }
    {Indexf 25 {
	{float c}
}   }
    {Indexiv 26 {
	{int c 1}
}   }
    {Indexi 26 {
	{int c}
}   }
    {Indexsv 27 {
	{short c 1}
	{short unused}
}   }
    {Indexs 27 {
	{short c}
	{short unused}
}   }
    {Normal3bv 28 {
	{byte v 3}
	{byte unused}
}   }
    {Normal3b 28 {
	{byte x}
	{byte y}
	{byte z}
	{byte unused}
}   }
    {Normal3dv 29 {
	{double v 3}
}   }
    {Normal3d 29 {
	{double x}
	{double y}
	{double z}
}   }
    {Normal3fv 30 {
	{float v 3}
}   }
    {Normal3f 30 {
	{float x}
	{float y}
	{float z}
}   }
    {Normal3iv 31 {
	{int v 3}
}   }
    {Normal3i 31 {
	{int x}
	{int y}
	{int z}
}   }
    {Normal3sv 32 {
	{short v 3}
	{short unused}
}   }
    {Normal3s 32 {
	{short x}
	{short y}
	{short z}
	{short unused}
}   }
    {RasterPos2dv 33 {
	{double v 2}
}   }
    {RasterPos2d 33 {
	{double x}
	{double y}
}   }
    {RasterPos2fv 34 {
	{float v 2}
}   }
    {RasterPos2f 34 {
	{float x}
	{float y}
}   }
    {RasterPos2iv 35 {
	{int v 2}
}   }
    {RasterPos2i 35 {
	{int x}
	{int y}
}   }
    {RasterPos2sv 36 {
	{short v 2}
}   }
    {RasterPos2s 36 {
	{short x}
	{short y}
}   }
    {RasterPos3dv 37 {
	{double v 3}
}   }
    {RasterPos3d 37 {
	{double x}
	{double y}
	{double z}
}   }
    {RasterPos3fv 38 {
	{float v 3}
}   }
    {RasterPos3f 38 {
	{float x}
	{float y}
	{float z}
}   }
    {RasterPos3iv 39 {
	{int v 3}
}   }
    {RasterPos3i 39 {
	{int x}
	{int y}
	{int z}
}   }
    {RasterPos3sv 40 {
	{short v 3}
	{short unused}
}   }
    {RasterPos3s 40 {
	{short x}
	{short y}
	{short z}
	{short unused}
}   }
    {RasterPos4dv 41 {
	{double v 4}
}   }
    {RasterPos4d 41 {
	{double x}
	{double y}
	{double z}
	{double w}
}   }
    {RasterPos4fv 42 {
	{float v 4}
}   }
    {RasterPos4f 42 {
	{float x}
	{float y}
	{float z}
	{float w}
}   }
    {RasterPos4iv 43 {
	{int v 4}
}   }
    {RasterPos4i 43 {
	{int x}
	{int y}
	{int z}
	{int w}
}   }
    {RasterPos4sv 44 {
	{short v 4}
}   }
    {RasterPos4s 44 {
	{short x}
	{short y}
	{short z}
	{short w}
}   }
    {Rectdv 45 {
	{double v1 2}
	{double v2 2}
}   }
    {Rectd 45 {
	{double x1}
	{double y1}
	{double x2}
	{double y2}
}   }
    {Rectfv 46 {
	{float v1 2}
	{float v2 2}
}   }
    {Rectf 46 {
	{float x1}
	{float y1}
	{float x2}
	{float y2}
}   }
    {Rectiv 47 {
	{int v1 2}
	{int v2 2}
}   }
    {Recti 47 {
	{int x1}
	{int y1}
	{int x2}
	{int y2}
}   }
    {Rectsv 48 {
	{short v1 2}
	{short v2 2}
}   }
    {Rects 48 {
	{short x1}
	{short y1}
	{short x2}
	{short y2}
}   }
    {TexCoord1dv 49 {
	{double v 1}
}   }
    {TexCoord1d 49 {
	{double v}
}   }
    {TexCoord1fv 50 {
	{float v 1}
}   }
    {TexCoord1f 50 {
	{float v}
}   }
    {TexCoord1iv 51 {
	{int v 1}
}   }
    {TexCoord1i 51 {
	{int v}
}   }
    {TexCoord1sv 52 {
	{short v 1}
	{short unused}
}   }
    {TexCoord1s 52 {
	{short v}
	{short unused}
}   }
    {TexCoord2dv 53 {
	{double v 2}
}   }
    {TexCoord2d 53 {
	{double s}
	{double t}
}   }
    {TexCoord2fv 54 {
	{float v 2}
}   }
    {TexCoord2f 54 {
	{float s}
	{float t}
}   }
    {TexCoord2iv 55 {
	{int v 2}
}   }
    {TexCoord2i 55 {
	{int s}
	{int t}
}   }
    {TexCoord2sv 56 {
	{short v 2}
}   }
    {TexCoord2s 56 {
	{short s}
	{short t}
}   }
    {TexCoord3dv 57 {
	{double v 3}
}   }
    {TexCoord3d 57 {
	{double s}
	{double t}
	{double u}
}   }
    {TexCoord3fv 58 {
	{float v 3}
}   }
    {TexCoord3f 58 {
	{float s}
	{float t}
	{float u}
}   }
    {TexCoord3iv 59 {
	{int v 3}
}   }
    {TexCoord3i 59 {
	{int s}
	{int t}
	{int u}
}   }
    {TexCoord3sv 60 {
	{short v 3}
	{short unused}
}   }
    {TexCoord3s 60 {
	{short s}
	{short t}
	{short u}
	{short unused}
}   }
    {TexCoord4dv 61 {
	{double v 4}
}   }
    {TexCoord4d 61 {
	{double s}
	{double t}
	{double u}
	{double v}
}   }
    {TexCoord4fv 62 {
	{float v 4}
}   }
    {TexCoord4f 62 {
	{float s}
	{float t}
	{float u}
	{float v}
}   }
    {TexCoord4iv 63 {
	{int v 4}
}   }
    {TexCoord4i 63 {
	{int s}
	{int t}
	{int u}
	{int v}
}   }
    {TexCoord4sv 64 {
	{short v 4}
}   }
    {TexCoord4s 64 {
	{short s}
	{short t}
	{short u}
	{short v}
}   }
    {Vertex2dv 65 {
	{double v 2}
}   }
    {Vertex2d 65 {
	{double x}
	{double y}
}   }
    {Vertex2fv 66 {
	{float v 2}
}   }
    {Vertex2f 66 {
	{float x}
	{float y}
}   }
    {Vertex2iv 67 {
	{int v 2}
}   }
    {Vertex2i 67 {
	{int x}
	{int y}
}   }
    {Vertex2sv 68 {
	{short v 2}
}   }
    {Vertex2s 68 {
	{short x}
	{short y}
}   }
    {Vertex3dv 69 {
	{double v 3}
}   }
    {Vertex3d 69 {
	{double x}
	{double y}
	{double z}
}   }
    {Vertex3fv 70 {
	{float v 3}
}   }
    {Vertex3f 70 {
	{float x}
	{float y}
	{float z}
}   }
    {Vertex3iv 71 {
	{int v 3}
}   }
    {Vertex3i 71 {
	{int x}
	{int y}
	{int z}
}   }
    {Vertex3sv 72 {
	{short v 3}
	{short unused}
}   }
    {Vertex3s 72 {
	{short x}
	{short y}
	{short z}
	{short unused}
}   }
    {Vertex4dv 73 {
	{double v 4}
}   }
    {Vertex4d 73 {
	{double x}
	{double y}
	{double z}
	{double w}
}   }
    {Vertex4fv 74 {
	{float v 4}
}   }
    {Vertex4f 74 {
	{float x}
	{float y}
	{float z}
	{float w}
}   }
    {Vertex4iv 75 {
	{int v 4}
}   }
    {Vertex4i 75 {
	{int x}
	{int y}
	{int z}
	{int w}
}   }
    {Vertex4sv 76 {
	{short v 4}
}   }
    {Vertex4s 76 {
	{short x}
	{short y}
	{short z}
	{short w}
}   }
    {ClipPlane 77 {
	{double equation 4}
	{enum plane}
    }
    decode {
	glClipPlane(plane, equation);
    }   
    encodeproto {
	void __glx_ClipPlane(GLenum plane, const GLdouble* equation)
}   }
    {ColorMaterial 78 {
	{enum face}
	{enum mode}
}   }
    {CullFace 79 {
	{enum mode}
}   }
    {Fogf 80 {
	{enum pname}
	{float param}
}   }
    {Fogfv 81 {
	{enum pname}
	{float params GLX_fog_size(pname)}
}   }
    {Fogi 82 {
	{enum pname}
	{int param}
}   }
    {Fogiv 83 {
	{enum pname}
	{int params GLX_fog_size(pname)}
}   }
    {FrontFace 84 {
	{enum mode}
}   }
    {Hint 85 {
	{enum target}
	{enum mode}
}   }
    {Lightf 86 {
	{enum light}
	{enum pname}
	{float param}
}   }
    {Lightfv 87 {
	{enum light}
	{enum pname}
	{float params GLX_light_size(pname)}
}   }
    {Lighti 88 {
	{enum light}
	{enum pname}
	{int param}
}   }
    {Lightiv 89 {
	{enum light}
	{enum pname}
	{int params GLX_light_size(pname)}
}   }
    {LightModelf 90 {
	{enum pname}
	{float param}
}   }
    {LightModelfv 91 {
	{enum pname}
	{float params GLX_lightmodel_size(pname)}
}   }
    {LightModeli 92 {
	{enum pname}
	{int param}
}   }
    {LightModeliv 93 {
	{enum pname}
	{int params GLX_lightmodel_size(pname)}
}   }
    {LineStipple 94 {
	{int factor}
	{ushort pattern}
	{short unused}
}   }
    {LineWidth 95 {
	{float width}
}   }
    {Materialf 96 {
	{enum face}
	{enum pname}
	{float param}
}   }
    {Materialfv 97 {
	{enum face}
	{enum pname}
	{float params GLX_material_size(pname)}
}   }
    {Materiali 98 {
	{enum face}
	{enum pname}
	{int param}
}   }
    {Materialiv 99 {
	{enum face}
	{enum pname}
	{int params GLX_material_size(pname)}
}   }
    {PointSize 100 {
	{float size}
}   }
    {PolygonMode 101 {
	{enum face}
	{enum mode}
}   }
    {PolygonStipple 102 {
        {byte unused1}
        {boolean lsb_first}
        {byte unused2 2}
        {uint row_length}
        {uint skip_rows}
        {uint skip_pixels}
        {uint alignment}
        {ubyte mask GLX_image_size(32,32,GL_COLOR_INDEX,GL_BITMAP)}
        {ubyte unused3 GLX_image_pad(32,32,GL_COLOR_INDEX,GL_BITMAP)}
    }
    decode {
        glPixelStorei(GL_UNPACK_LSB_FIRST, lsb_first);
        glPixelStorei(GL_UNPACK_ROW_LENGTH, row_length);
        glPixelStorei(GL_UNPACK_SKIP_PIXELS, skip_pixels);
        glPixelStorei(GL_UNPACK_SKIP_ROWS, skip_rows);
        glPixelStorei(GL_UNPACK_ALIGNMENT, alignment);
        glPolygonStipple(mask);
    }
    encode_nogen true
}
    {Scissor 103 {
	{int x}
	{int y}
	{int width}
	{int height}
}   }
    {ShadeModel 104 {
	{enum mode}
}   }
    {TexParameterf 105 {
	{enum target}
	{enum pname}
	{float param}
}   }
    {TexParameterfv 106 {
	{enum target}
	{enum pname}
	{float params GLX_texparameter_size(pname)}
}   }
    {TexParameteri 107 {
	{enum target}
	{enum pname}
	{int param}
}   }
    {TexParameteriv 108 {
	{enum target}
	{enum pname}
	{int params GLX_texparameter_size(pname)}
}   }
    {TexImage1D 109 {
	{boolean swap_bytes}
	{boolean lsb_first}
	{byte unused1 2}
	{uint row_length}
	{uint skip_rows}
	{uint skip_pixels}
	{uint alignment}
	{enum target}
	{int level}
	{int components}
	{int width}
	{int unused2}
	{int border}
	{enum format}
	{enum type}
	{ubyte pixels GLX_texture_size(width,1,format,type,target)}
	{void* unused3 GLX_texture_pad(width,1,format,type,target)}
    }
    decode {
        if (target==GL_PROXY_TEXTURE_1D) pixels = NULL;
	glPixelStorei(GL_UNPACK_SWAP_BYTES, swap_bytes);
	glPixelStorei(GL_UNPACK_LSB_FIRST, lsb_first);
	glPixelStorei(GL_UNPACK_ROW_LENGTH, row_length);
	glPixelStorei(GL_UNPACK_SKIP_PIXELS, skip_pixels);
	glPixelStorei(GL_UNPACK_SKIP_ROWS, skip_rows);
	glPixelStorei(GL_UNPACK_ALIGNMENT, alignment);
	glTexImage1D(target, level, components, width, border,
	             format, type, pixels);
    }
    encode_nogen true
}
    {TexSubImage1D 4099 {
	{boolean swap_bytes}
	{boolean lsb_first}
	{byte unused1 2}
	{uint row_length}
	{uint skip_rows}
	{uint skip_pixels}
	{uint alignment}
	{enum target}
	{int level}
	{int xoffset}
	{int yoffset}
	{int width}
	{int height}
	{enum format}
	{enum type}
	{byte unused2 4}
	{ubyte pixels GLX_image_size(width,height,format,type)}
	{void* unused3 GLX_image_pad(width,height,format,type)}
    }
    decode {
	glPixelStorei(GL_UNPACK_SWAP_BYTES, swap_bytes);
	glPixelStorei(GL_UNPACK_LSB_FIRST, lsb_first);
	glPixelStorei(GL_UNPACK_ROW_LENGTH, row_length);
	glPixelStorei(GL_UNPACK_SKIP_PIXELS, skip_pixels);
	glPixelStorei(GL_UNPACK_SKIP_ROWS, skip_rows);
	glPixelStorei(GL_UNPACK_ALIGNMENT, alignment);
	glTexSubImage1D(target, level, xoffset, width, format, type, pixels);
    }
    encode_nogen true
}

    {TexImage2D 110 {
	{boolean swap_bytes}
	{boolean lsb_first}
	{byte unused1 2}
	{uint row_length}
	{uint skip_rows}
	{uint skip_pixels}
	{uint alignment}
	{enum target}
	{int level}
	{int components}
	{int width}
	{int height}
	{int border}
	{enum format}
	{enum type}
	{ubyte pixels GLX_texture_size(width,height,format,type,target)}
	{void* unused3 GLX_texture_pad(width,height,format,type,target)}
    }
    decode {
        if (target==GL_PROXY_TEXTURE_2D) pixels = NULL;
	glPixelStorei(GL_UNPACK_SWAP_BYTES, swap_bytes);
	glPixelStorei(GL_UNPACK_LSB_FIRST, lsb_first);
	glPixelStorei(GL_UNPACK_ROW_LENGTH, row_length);
	glPixelStorei(GL_UNPACK_SKIP_PIXELS, skip_pixels);
	glPixelStorei(GL_UNPACK_SKIP_ROWS, skip_rows);
	glPixelStorei(GL_UNPACK_ALIGNMENT, alignment);
	glTexImage2D(target, level, components, width, height, border,
	             format, type, pixels);
    }
    encode_nogen true
}

    {TexSubImage2D 4100 {
	{boolean swap_bytes}
	{boolean lsb_first}
	{byte unused1 2}
	{uint row_length}
	{uint skip_rows}
	{uint skip_pixels}
	{uint alignment}
	{enum target}
	{int level}
	{int xoffset}
	{int yoffset}
	{int width}
	{int height}
	{enum format}
	{enum type}
	{byte unused2 4}
	{ubyte pixels GLX_image_size(width,height,format,type)}
	{void* unused3 GLX_image_pad(width,height,format,type)}
    }
    decode {
	glPixelStorei(GL_UNPACK_SWAP_BYTES, swap_bytes);
	glPixelStorei(GL_UNPACK_LSB_FIRST, lsb_first);
	glPixelStorei(GL_UNPACK_ROW_LENGTH, row_length);
	glPixelStorei(GL_UNPACK_SKIP_PIXELS, skip_pixels);
	glPixelStorei(GL_UNPACK_SKIP_ROWS, skip_rows);
	glPixelStorei(GL_UNPACK_ALIGNMENT, alignment);
	glTexSubImage2D(target, level, xoffset, yoffset, width, height,
                        format, type, pixels);
    }
    encode_nogen true
}
    {TexEnvf 111 {
	{enum target}
	{enum pname}
	{float param}
}   }
    {TexEnvfv 112 {
	{enum target}
	{enum pname}
	{float params GLX_texenv_size(pname)}
}   }
    {TexEnvi 113 {
	{enum target}
	{enum pname}
	{int param}
}   }
    {TexEnviv 114 {
	{enum target}
	{enum pname}
	{int params GLX_texenv_size(pname)}
}   }
    {TexGend 115 {
	{enum coord}
	{enum pname}
	{double param}
}   }
    {TexGendv 116 {
	{enum coord}
	{enum pname}
	{double params GLX_texgen_size(pname)}
}   }
    {TexGenf 117 {
	{enum coord}
	{enum pname}
	{float param}
}   }
    {TexGenfv 118 {
	{enum coord}
	{enum pname}
	{float params GLX_texgen_size(pname)}
}   }
    {TexGeni 119 {
	{enum coord}
	{enum pname}
	{int param}
}   }
    {TexGeniv 120 {
	{enum coord}
	{enum pname}
	{int params GLX_texgen_size(pname)}
}   }
    {InitNames 121 {
}   }
    {LoadName 122 {
	{uint name}
}   }
    {PassThrough 123 {
	{float token}
}   }
    {PopName 124 {
}   }
    {PushName 125 {
	{uint name}
}   }
    {DrawBuffer 126 {
	{enum mode}
}   }
    {Clear 127 {
	{bitfield mask}
}   }
    {ClearAccum 128 {
	{float red}
	{float green}
	{float blue}
	{float alpha}
}   }
    {ClearIndex 129 {
	{float index}
}   }
    {ClearColor 130 {
	{float red}
	{float green}
	{float blue}
	{float alpha}
}   }
    {ClearStencil 131 {
	{int s}
}   }
    {ClearDepth 132 {
	{double depth}
}   }
    {StencilMask 133 {
	{uint mask}
}   }
    {ColorMask 134 {
	{boolean red}
	{boolean green}
	{boolean blue}
	{boolean alpha}
}   }
    {DepthMask 135 {
	{boolean flag}
	{boolean unused 3}
}   }
    {IndexMask 136 {
	{uint mask}
}   }
    {Accum 137 {
	{enum op}
	{float value}
}   }
    {Disable 138 {
	{enum cap}
}   }
    {Enable 139 {
	{enum cap}
}   }
    {PopAttrib 141 {
}   }
    {PushAttrib 142 {
	{bitfield mask}
}   }
    {Map1d 143 {
	{double u1}
	{double u2}
	{enum target}
	{int order}
	{double points GLX_map1_size(target)*order}
    }
    decode {
	glMap1d(target, u1, u2, GLX_map1_size(target), order, points);
    }
    encode_nogen true
}
    {Map1f 144 {
	{enum target}
	{float u1}
	{float u2}
	{int order}
	{float points GLX_map1_size(target)*order}
    }
    decode {
	glMap1f(target, u1, u2, GLX_map1_size(target), order, points);
    }
    encode_nogen true
}
    {Map2d 145 {
	{double u1}
	{double u2}
	{double v1}
	{double v2}
	{enum target}
	{int uorder}
	{int vorder}
	{double points GLX_map2_size(target)*uorder*vorder}
    }
    decode {
	glMap2d(target, u1, u2, GLX_map2_size(target)*vorder, uorder, v1, v2, GLX_map2_size(target), vorder, points);
    }
    encode_nogen true
}
    {Map2f 146 {
	{enum target}
	{float u1}
	{float u2}
	{int uorder}
	{float v1}
	{float v2}
	{int vorder}
	{float points GLX_map2_size(target)*uorder*vorder}
    }
    decode {
	glMap2f(target, u1, u2, GLX_map2_size(target)*vorder, uorder, v1, v2, GLX_map2_size(target), vorder, points);
    }
    encode_nogen true
}
    {MapGrid1d 147 {
	{double u1}
	{double u2}
	{int un}
    }
    decode {
	glMapGrid1d(un, u1, u2);
    }
    encodeproto {
	void __glx_MapGrid1d(int un, double u1, double u2)
}   }
    {MapGrid1f 148 {
	{int un}
	{float u1}
	{float u2}
}   }
    {MapGrid2d 149 {
	{double u1}
	{double u2}
	{double v1}
	{double v2}
	{int un}
	{int vn}
    }
    decode {
	glMapGrid2d(un, u1, u2, vn, v1, v2);
    }
    encodeproto {
	void __glx_MapGrid2d(int un, double u1, double u2, int vn, double v1, double v2)
}   }
    {MapGrid2f 150 {
	{int un}
	{float u1}
	{float u2}
	{int vn}
	{float v1}
	{float v2}
}   }
    {EvalCoord1dv 151 {
	{double u 1}
}   }
    {EvalCoord1d 151 {
	{double u0}
}   }
    {EvalCoord1fv 152 {
	{float u 1}
}   }
    {EvalCoord1f 152 {
	{float u0}
}   }
    {EvalCoord2dv 153 {
	{double u 2}
}   }
    {EvalCoord2d 153 {
	{double u0}
	{double u1}
}   }
    {EvalCoord2fv 154 {
	{float u 2}
}   }
    {EvalCoord2f 154 {
	{float u0}
	{float u1}
}   }
    {EvalMesh1 155 {
	{enum mode}
	{int i1}
	{int i2}
}   }
    {EvalPoint1 156 {
	{int i}
}   }
    {EvalMesh2 157 {
	{enum mode}
	{int i1}
	{int i2}
	{int j1}
	{int j2}
}   }
    {EvalPoint2 158 {
	{int i}
	{int j}
}   }
    {AlphaFunc 159 {
	{enum func}
	{float ref}
}   }
    {BlendFunc 160 {
	{enum sfactor}
	{enum dfactor}
}   }
    {LogicOp 161 {
	{enum opcode}
}   }
    {StencilFunc 162 {
	{enum func}
	{int ref}
	{uint mask}
}   }
    {StencilOp 163 {
	{enum fail}
	{enum zfail}
	{enum zpass}
}   }
    {DepthFunc 164 {
	{enum func}
}   }
    {PixelZoom 165 {
	{float xfactor}
	{float yfactor}
}   }
    {PixelTransferf 166 {
	{enum pname}
	{float param}
}   }
    {PixelTransferi 167 {
	{enum pname}
	{int param}
}   }
    {PixelMapfv 168 {
	{enum map}
	{int mapsize}
	{float values mapsize}
    }
    encode_nogen true
}
    {PixelMapuiv 169 {
	{enum map}
	{int mapsize}
        {uint values mapsize}
    }  
    encode_nogen true
}
    {PixelMapusv 170 {
	{enum map}
	{int mapsize}
	{ushort values mapsize}
    }   
    encode_nogen true
}
    {ReadBuffer 171 {
	{enum mode}
}   }
    {CopyPixels 172 {
	{int x}
	{int y}
	{int width}
	{int height}
	{enum type}
}   }
    {DrawPixels 173 {
	{boolean swap_bytes}
	{boolean lsb_first}
	{byte unused1 2}
	{uint row_length}
	{uint skip_rows}
	{uint skip_pixels}
	{uint alignment}
	{int width}
	{int height}
	{enum format}
	{enum type}
	{ubyte pixels GLX_image_size(width,height,format,type)}
	{void* unused2 GLX_image_pad(width,height,format,type)}
    }
    decode {
	glPixelStorei(GL_UNPACK_SWAP_BYTES, swap_bytes);
	glPixelStorei(GL_UNPACK_LSB_FIRST, lsb_first);
	glPixelStorei(GL_UNPACK_ROW_LENGTH, row_length);
	glPixelStorei(GL_UNPACK_SKIP_PIXELS, skip_pixels);
	glPixelStorei(GL_UNPACK_SKIP_ROWS, skip_rows);
	glPixelStorei(GL_UNPACK_ALIGNMENT, alignment);
	glDrawPixels(width, height, format, type, pixels);
    }
    encode_nogen true
}
    {DepthRange 174 {
	{double near}
	{double far}
}   }
    {Frustum 175 {
	{double left}
	{double right}
	{double bottom}
	{double top}
	{double near}
	{double far}
}   }
    {LoadIdentity 176 {
}   }
    {LoadMatrixf 177 {
	{float m 16}
}   }
    {LoadMatrixd 178 {
	{double m 16}
}   }
    {MatrixMode 179 {
	{enum mode}
}   }
    {MultMatrixf 180 {
	{float m 16}
}   }
    {MultMatrixd 181 {
	{double m 16}
}   }
    {Ortho 182 {
	{double left}
	{double right}
	{double bottom}
	{double top}
	{double near}
	{double far}
}   }
    {PopMatrix 183 {
}   }
    {PushMatrix 184 {
}   }
    {Rotated 185 {
	{double angle}
	{double x}
	{double y}
	{double z}
}   }
    {Rotatef 186 {
	{float angle}
	{float x}
	{float y}
	{float z}
}   }
    {Scaled 187 {
	{double x}
	{double y}
	{double z}
}   }
    {Scalef 188 {
	{float x}
	{float y}
	{float z}
}   }
    {Translated 189 {
	{double x}
	{double y}
	{double z}
}   }
    {Translatef 190 {
	{float x}
	{float y}
	{float z}
}   }
    {Viewport 191 {
	{int x}
	{int y}
	{int width}
	{int height}
}   }
    {PolygonOffset 192 {
        {float factor}
        {float units}
}   }
    {DrawArrays 193 {
       {int n}
       {int m}
       {enum mode}
       {void* list GLX_array_info_size(m)}
       {int verts GLX_varray_size(n,m,list)}
    }
    decode {
      GLX_DrawArrays(n, m, mode, (struct array_info *) list, (void *) verts);
    }
    swap_decode {
      GLX_DrawArrays_swapped(n, m, mode, (struct array_info *) list, (void *) verts);
    }
    encode_nogen true
}
    {Indexubv 194 {
        {ubyte c 1}
        {byte unused 3}
}   }
    {ColorTable 2053 {
	{boolean swap_bytes}
	{boolean lsb_first}
	{byte unused1 2}
	{uint row_length}
	{uint skip_rows}
	{uint skip_pixels}
	{uint alignment}
	{enum target}
	{int internalformat}
	{int width}
	{enum format}
	{enum type}
	{ubyte table GLX_image_size(width,1,format,type)}
	{void* unused3 GLX_image_pad(width,1,format,type)}
    }
    decode {
	glPixelStorei(GL_UNPACK_SWAP_BYTES, swap_bytes);
	glPixelStorei(GL_UNPACK_LSB_FIRST, lsb_first);
	glPixelStorei(GL_UNPACK_ROW_LENGTH, row_length);
	glPixelStorei(GL_UNPACK_SKIP_PIXELS, skip_pixels);
	glPixelStorei(GL_UNPACK_SKIP_ROWS, skip_rows);
	glPixelStorei(GL_UNPACK_ALIGNMENT, alignment);
        glColorTableEXT(target, internalformat, width, format, type, (void *) table); 
    }
    encode_nogen true
}

    {BlendColorEXT 4096 {
        {float red}
        {float green}
        {float blue}
        {float alpha}
}   }
    {BlendEquationEXT 4097 {
        {enum mode}
}   }
    {BindTexture 4117 {
        {enum target}
        {uint texture}
}   }
    {DrawArrays 4116 {
       {int n}
       {int m}
       {enum mode}
       {int list GLX_array_info_size(m)}
       {int verts GLX_varray_size(n,m,list)}
    }
    decode_nogen true
    encode_nogen true
}
    {PrioritizeTextures 4118 {
        {int n}
        {uint textures 4*n}
        {float priorities 4*n}
    }
    encode_nogen true
}
    {CopyTexImage1D 4119 {
        {enum target}
        {int level}
        {enum internalFormat}
        {int x}
        {int y}
        {int width}
        {int border}
}   }
    {CopyTexImage2D 4120 {
        {enum target}
        {int level}
        {enum internalFormat}
        {int x}
        {int y}
        {int width}
        {int height}
        {int border}
}   }
    {CopyTexSubImage1D 4121 {
        {enum target}
        {int level}
        {int offset}
        {int x}
        {int y}
        {int width}
}   }
    {CopyTexSubImage2D 4122 {
        {enum target}
        {int level}
        {int xoffset}
        {int yoffset}
        {int x}
        {int y}
        {int width}
        {int height}
}   }
}



